/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parsed address components in the provided QueryText.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeocodeParsedQueryAddressComponents implements SdkPojo, Serializable,
        ToCopyableBuilder<GeocodeParsedQueryAddressComponents.Builder, GeocodeParsedQueryAddressComponents> {
    private static final SdkField<List<ParsedQueryComponent>> COUNTRY_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("Country")
            .getter(getter(GeocodeParsedQueryAddressComponents::country))
            .setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> REGION_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("Region")
            .getter(getter(GeocodeParsedQueryAddressComponents::region))
            .setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> SUB_REGION_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("SubRegion")
            .getter(getter(GeocodeParsedQueryAddressComponents::subRegion))
            .setter(setter(Builder::subRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> LOCALITY_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("Locality")
            .getter(getter(GeocodeParsedQueryAddressComponents::locality))
            .setter(setter(Builder::locality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> DISTRICT_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("District")
            .getter(getter(GeocodeParsedQueryAddressComponents::district))
            .setter(setter(Builder::district))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> SUB_DISTRICT_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("SubDistrict")
            .getter(getter(GeocodeParsedQueryAddressComponents::subDistrict))
            .setter(setter(Builder::subDistrict))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDistrict").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> POSTAL_CODE_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("PostalCode")
            .getter(getter(GeocodeParsedQueryAddressComponents::postalCode))
            .setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> BLOCK_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("Block")
            .getter(getter(GeocodeParsedQueryAddressComponents::block))
            .setter(setter(Builder::block))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> SUB_BLOCK_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("SubBlock")
            .getter(getter(GeocodeParsedQueryAddressComponents::subBlock))
            .setter(setter(Builder::subBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBlock").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> STREET_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("Street")
            .getter(getter(GeocodeParsedQueryAddressComponents::street))
            .setter(setter(Builder::street))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> ADDRESS_NUMBER_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("AddressNumber")
            .getter(getter(GeocodeParsedQueryAddressComponents::addressNumber))
            .setter(setter(Builder::addressNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQueryComponent>> BUILDING_FIELD = SdkField
            .<List<ParsedQueryComponent>> builder(MarshallingType.LIST)
            .memberName("Building")
            .getter(getter(GeocodeParsedQueryAddressComponents::building))
            .setter(setter(Builder::building))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Building").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQueryComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQueryComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParsedQuerySecondaryAddressComponent>> SECONDARY_ADDRESS_COMPONENTS_FIELD = SdkField
            .<List<ParsedQuerySecondaryAddressComponent>> builder(MarshallingType.LIST)
            .memberName("SecondaryAddressComponents")
            .getter(getter(GeocodeParsedQueryAddressComponents::secondaryAddressComponents))
            .setter(setter(Builder::secondaryAddressComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAddressComponents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParsedQuerySecondaryAddressComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParsedQuerySecondaryAddressComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, REGION_FIELD,
            SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, SUB_DISTRICT_FIELD, POSTAL_CODE_FIELD, BLOCK_FIELD,
            SUB_BLOCK_FIELD, STREET_FIELD, ADDRESS_NUMBER_FIELD, BUILDING_FIELD, SECONDARY_ADDRESS_COMPONENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ParsedQueryComponent> country;

    private final List<ParsedQueryComponent> region;

    private final List<ParsedQueryComponent> subRegion;

    private final List<ParsedQueryComponent> locality;

    private final List<ParsedQueryComponent> district;

    private final List<ParsedQueryComponent> subDistrict;

    private final List<ParsedQueryComponent> postalCode;

    private final List<ParsedQueryComponent> block;

    private final List<ParsedQueryComponent> subBlock;

    private final List<ParsedQueryComponent> street;

    private final List<ParsedQueryComponent> addressNumber;

    private final List<ParsedQueryComponent> building;

    private final List<ParsedQuerySecondaryAddressComponent> secondaryAddressComponents;

    private GeocodeParsedQueryAddressComponents(BuilderImpl builder) {
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.subDistrict = builder.subDistrict;
        this.postalCode = builder.postalCode;
        this.block = builder.block;
        this.subBlock = builder.subBlock;
        this.street = builder.street;
        this.addressNumber = builder.addressNumber;
        this.building = builder.building;
        this.secondaryAddressComponents = builder.secondaryAddressComponents;
    }

    /**
     * For responses, this returns true if the service returned a value for the Country property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCountry() {
        return country != null && !(country instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The alpha-2 or alpha-3 character code for the country that the results will be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCountry} method.
     * </p>
     * 
     * @return The alpha-2 or alpha-3 character code for the country that the results will be present in.
     */
    public final List<ParsedQueryComponent> country() {
        return country;
    }

    /**
     * For responses, this returns true if the service returned a value for the Region property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegion() {
        return region != null && !(region instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The region or state results should be present in.
     * </p>
     * <p>
     * Example: <code>North Rhine-Westphalia</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegion} method.
     * </p>
     * 
     * @return The region or state results should be present in. </p>
     *         <p>
     *         Example: <code>North Rhine-Westphalia</code>.
     */
    public final List<ParsedQueryComponent> region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubRegion property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubRegion() {
        return subRegion != null && !(subRegion instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sub-region or county for which results should be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubRegion} method.
     * </p>
     * 
     * @return The sub-region or county for which results should be present in.
     */
    public final List<ParsedQueryComponent> subRegion() {
        return subRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locality property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocality() {
        return locality != null && !(locality instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The city or locality of the address.
     * </p>
     * <p>
     * Example: <code>Vancouver</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocality} method.
     * </p>
     * 
     * @return The city or locality of the address.</p>
     *         <p>
     *         Example: <code>Vancouver</code>.
     */
    public final List<ParsedQueryComponent> locality() {
        return locality;
    }

    /**
     * For responses, this returns true if the service returned a value for the District property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDistrict() {
        return district != null && !(district instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The district or division of a city the results should be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDistrict} method.
     * </p>
     * 
     * @return The district or division of a city the results should be present in.
     */
    public final List<ParsedQueryComponent> district() {
        return district;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubDistrict property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubDistrict() {
        return subDistrict != null && !(subDistrict instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A subdivision of a district.
     * </p>
     * <p>
     * Example: <code>Minden-Lübbecke</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubDistrict} method.
     * </p>
     * 
     * @return A subdivision of a district. </p>
     *         <p>
     *         Example: <code>Minden-Lübbecke</code>.
     */
    public final List<ParsedQueryComponent> subDistrict() {
        return subDistrict;
    }

    /**
     * For responses, this returns true if the service returned a value for the PostalCode property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPostalCode() {
        return postalCode != null && !(postalCode instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode, or
     * ZIP code, for which the result should possess.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPostalCode} method.
     * </p>
     * 
     * @return An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
     *         postcode, or ZIP code, for which the result should possess.
     */
    public final List<ParsedQueryComponent> postalCode() {
        return postalCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Block property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasBlock() {
        return block != null && !(block instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the block.
     * </p>
     * <p>
     * Example: <code>Sunny Mansion 203 block: 2 Chome</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlock} method.
     * </p>
     * 
     * @return Name of the block. </p>
     *         <p>
     *         Example: <code>Sunny Mansion 203 block: 2 Chome</code>
     */
    public final List<ParsedQueryComponent> block() {
        return block;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubBlock property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubBlock() {
        return subBlock != null && !(subBlock instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of sub-block.
     * </p>
     * <p>
     * Example: <code>Sunny Mansion 203 sub-block: 4</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubBlock} method.
     * </p>
     * 
     * @return Name of sub-block. </p>
     *         <p>
     *         Example: <code>Sunny Mansion 203 sub-block: 4</code>
     */
    public final List<ParsedQueryComponent> subBlock() {
        return subBlock;
    }

    /**
     * For responses, this returns true if the service returned a value for the Street property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStreet() {
        return street != null && !(street instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the street results should be present in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreet} method.
     * </p>
     * 
     * @return The name of the street results should be present in.
     */
    public final List<ParsedQueryComponent> street() {
        return street;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddressNumber property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddressNumber() {
        return addressNumber != null && !(addressNumber instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number that identifies an address within a street.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddressNumber} method.
     * </p>
     * 
     * @return The number that identifies an address within a street.
     */
    public final List<ParsedQueryComponent> addressNumber() {
        return addressNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the Building property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBuilding() {
        return building != null && !(building instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the building at the address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuilding} method.
     * </p>
     * 
     * @return The name of the building at the address.
     */
    public final List<ParsedQueryComponent> building() {
        return building;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondaryAddressComponents property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecondaryAddressComponents() {
        return secondaryAddressComponents != null && !(secondaryAddressComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Parsed secondary address components from the provided query text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondaryAddressComponents} method.
     * </p>
     * 
     * @return Parsed secondary address components from the provided query text.
     */
    public final List<ParsedQuerySecondaryAddressComponent> secondaryAddressComponents() {
        return secondaryAddressComponents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCountry() ? country() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegion() ? region() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubRegion() ? subRegion() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLocality() ? locality() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDistrict() ? district() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubDistrict() ? subDistrict() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPostalCode() ? postalCode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlock() ? block() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubBlock() ? subBlock() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStreet() ? street() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddressNumber() ? addressNumber() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBuilding() ? building() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryAddressComponents() ? secondaryAddressComponents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeocodeParsedQueryAddressComponents)) {
            return false;
        }
        GeocodeParsedQueryAddressComponents other = (GeocodeParsedQueryAddressComponents) obj;
        return hasCountry() == other.hasCountry() && Objects.equals(country(), other.country())
                && hasRegion() == other.hasRegion() && Objects.equals(region(), other.region())
                && hasSubRegion() == other.hasSubRegion() && Objects.equals(subRegion(), other.subRegion())
                && hasLocality() == other.hasLocality() && Objects.equals(locality(), other.locality())
                && hasDistrict() == other.hasDistrict() && Objects.equals(district(), other.district())
                && hasSubDistrict() == other.hasSubDistrict() && Objects.equals(subDistrict(), other.subDistrict())
                && hasPostalCode() == other.hasPostalCode() && Objects.equals(postalCode(), other.postalCode())
                && hasBlock() == other.hasBlock() && Objects.equals(block(), other.block())
                && hasSubBlock() == other.hasSubBlock() && Objects.equals(subBlock(), other.subBlock())
                && hasStreet() == other.hasStreet() && Objects.equals(street(), other.street())
                && hasAddressNumber() == other.hasAddressNumber() && Objects.equals(addressNumber(), other.addressNumber())
                && hasBuilding() == other.hasBuilding() && Objects.equals(building(), other.building())
                && hasSecondaryAddressComponents() == other.hasSecondaryAddressComponents()
                && Objects.equals(secondaryAddressComponents(), other.secondaryAddressComponents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeocodeParsedQueryAddressComponents").add("Country", hasCountry() ? country() : null)
                .add("Region", hasRegion() ? region() : null).add("SubRegion", hasSubRegion() ? subRegion() : null)
                .add("Locality", hasLocality() ? locality() : null).add("District", hasDistrict() ? district() : null)
                .add("SubDistrict", hasSubDistrict() ? subDistrict() : null)
                .add("PostalCode", hasPostalCode() ? postalCode() : null).add("Block", hasBlock() ? block() : null)
                .add("SubBlock", hasSubBlock() ? subBlock() : null).add("Street", hasStreet() ? street() : null)
                .add("AddressNumber", hasAddressNumber() ? addressNumber() : null)
                .add("Building", hasBuilding() ? building() : null)
                .add("SecondaryAddressComponents", hasSecondaryAddressComponents() ? secondaryAddressComponents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "SubRegion":
            return Optional.ofNullable(clazz.cast(subRegion()));
        case "Locality":
            return Optional.ofNullable(clazz.cast(locality()));
        case "District":
            return Optional.ofNullable(clazz.cast(district()));
        case "SubDistrict":
            return Optional.ofNullable(clazz.cast(subDistrict()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "Block":
            return Optional.ofNullable(clazz.cast(block()));
        case "SubBlock":
            return Optional.ofNullable(clazz.cast(subBlock()));
        case "Street":
            return Optional.ofNullable(clazz.cast(street()));
        case "AddressNumber":
            return Optional.ofNullable(clazz.cast(addressNumber()));
        case "Building":
            return Optional.ofNullable(clazz.cast(building()));
        case "SecondaryAddressComponents":
            return Optional.ofNullable(clazz.cast(secondaryAddressComponents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Country", COUNTRY_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("SubRegion", SUB_REGION_FIELD);
        map.put("Locality", LOCALITY_FIELD);
        map.put("District", DISTRICT_FIELD);
        map.put("SubDistrict", SUB_DISTRICT_FIELD);
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("Block", BLOCK_FIELD);
        map.put("SubBlock", SUB_BLOCK_FIELD);
        map.put("Street", STREET_FIELD);
        map.put("AddressNumber", ADDRESS_NUMBER_FIELD);
        map.put("Building", BUILDING_FIELD);
        map.put("SecondaryAddressComponents", SECONDARY_ADDRESS_COMPONENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeocodeParsedQueryAddressComponents, T> g) {
        return obj -> g.apply((GeocodeParsedQueryAddressComponents) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeocodeParsedQueryAddressComponents> {
        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * 
         * @param country
         *        The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(Collection<ParsedQueryComponent> country);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * 
         * @param country
         *        The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(ParsedQueryComponent... country);

        /**
         * <p>
         * The alpha-2 or alpha-3 character code for the country that the results will be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #country(List<ParsedQueryComponent>)}.
         * 
         * @param country
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #country(java.util.Collection<ParsedQueryComponent>)
         */
        Builder country(Consumer<ParsedQueryComponent.Builder>... country);

        /**
         * <p>
         * The region or state results should be present in.
         * </p>
         * <p>
         * Example: <code>North Rhine-Westphalia</code>.
         * </p>
         * 
         * @param region
         *        The region or state results should be present in. </p>
         *        <p>
         *        Example: <code>North Rhine-Westphalia</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(Collection<ParsedQueryComponent> region);

        /**
         * <p>
         * The region or state results should be present in.
         * </p>
         * <p>
         * Example: <code>North Rhine-Westphalia</code>.
         * </p>
         * 
         * @param region
         *        The region or state results should be present in. </p>
         *        <p>
         *        Example: <code>North Rhine-Westphalia</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(ParsedQueryComponent... region);

        /**
         * <p>
         * The region or state results should be present in.
         * </p>
         * <p>
         * Example: <code>North Rhine-Westphalia</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #region(List<ParsedQueryComponent>)}.
         * 
         * @param region
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #region(java.util.Collection<ParsedQueryComponent>)
         */
        Builder region(Consumer<ParsedQueryComponent.Builder>... region);

        /**
         * <p>
         * The sub-region or county for which results should be present in.
         * </p>
         * 
         * @param subRegion
         *        The sub-region or county for which results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subRegion(Collection<ParsedQueryComponent> subRegion);

        /**
         * <p>
         * The sub-region or county for which results should be present in.
         * </p>
         * 
         * @param subRegion
         *        The sub-region or county for which results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subRegion(ParsedQueryComponent... subRegion);

        /**
         * <p>
         * The sub-region or county for which results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #subRegion(List<ParsedQueryComponent>)}.
         * 
         * @param subRegion
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subRegion(java.util.Collection<ParsedQueryComponent>)
         */
        Builder subRegion(Consumer<ParsedQueryComponent.Builder>... subRegion);

        /**
         * <p>
         * The city or locality of the address.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * 
         * @param locality
         *        The city or locality of the address.</p>
         *        <p>
         *        Example: <code>Vancouver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(Collection<ParsedQueryComponent> locality);

        /**
         * <p>
         * The city or locality of the address.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * 
         * @param locality
         *        The city or locality of the address.</p>
         *        <p>
         *        Example: <code>Vancouver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(ParsedQueryComponent... locality);

        /**
         * <p>
         * The city or locality of the address.
         * </p>
         * <p>
         * Example: <code>Vancouver</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #locality(List<ParsedQueryComponent>)}.
         * 
         * @param locality
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locality(java.util.Collection<ParsedQueryComponent>)
         */
        Builder locality(Consumer<ParsedQueryComponent.Builder>... locality);

        /**
         * <p>
         * The district or division of a city the results should be present in.
         * </p>
         * 
         * @param district
         *        The district or division of a city the results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder district(Collection<ParsedQueryComponent> district);

        /**
         * <p>
         * The district or division of a city the results should be present in.
         * </p>
         * 
         * @param district
         *        The district or division of a city the results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder district(ParsedQueryComponent... district);

        /**
         * <p>
         * The district or division of a city the results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #district(List<ParsedQueryComponent>)}.
         * 
         * @param district
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #district(java.util.Collection<ParsedQueryComponent>)
         */
        Builder district(Consumer<ParsedQueryComponent.Builder>... district);

        /**
         * <p>
         * A subdivision of a district.
         * </p>
         * <p>
         * Example: <code>Minden-Lübbecke</code>.
         * </p>
         * 
         * @param subDistrict
         *        A subdivision of a district. </p>
         *        <p>
         *        Example: <code>Minden-Lübbecke</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDistrict(Collection<ParsedQueryComponent> subDistrict);

        /**
         * <p>
         * A subdivision of a district.
         * </p>
         * <p>
         * Example: <code>Minden-Lübbecke</code>.
         * </p>
         * 
         * @param subDistrict
         *        A subdivision of a district. </p>
         *        <p>
         *        Example: <code>Minden-Lübbecke</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDistrict(ParsedQueryComponent... subDistrict);

        /**
         * <p>
         * A subdivision of a district.
         * </p>
         * <p>
         * Example: <code>Minden-Lübbecke</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #subDistrict(List<ParsedQueryComponent>)}.
         * 
         * @param subDistrict
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subDistrict(java.util.Collection<ParsedQueryComponent>)
         */
        Builder subDistrict(Consumer<ParsedQueryComponent.Builder>... subDistrict);

        /**
         * <p>
         * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode,
         * or ZIP code, for which the result should possess.
         * </p>
         * 
         * @param postalCode
         *        An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
         *        postcode, or ZIP code, for which the result should possess.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(Collection<ParsedQueryComponent> postalCode);

        /**
         * <p>
         * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode,
         * or ZIP code, for which the result should possess.
         * </p>
         * 
         * @param postalCode
         *        An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
         *        postcode, or ZIP code, for which the result should possess.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(ParsedQueryComponent... postalCode);

        /**
         * <p>
         * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode,
         * or ZIP code, for which the result should possess.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #postalCode(List<ParsedQueryComponent>)}.
         * 
         * @param postalCode
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postalCode(java.util.Collection<ParsedQueryComponent>)
         */
        Builder postalCode(Consumer<ParsedQueryComponent.Builder>... postalCode);

        /**
         * <p>
         * Name of the block.
         * </p>
         * <p>
         * Example: <code>Sunny Mansion 203 block: 2 Chome</code>
         * </p>
         * 
         * @param block
         *        Name of the block. </p>
         *        <p>
         *        Example: <code>Sunny Mansion 203 block: 2 Chome</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(Collection<ParsedQueryComponent> block);

        /**
         * <p>
         * Name of the block.
         * </p>
         * <p>
         * Example: <code>Sunny Mansion 203 block: 2 Chome</code>
         * </p>
         * 
         * @param block
         *        Name of the block. </p>
         *        <p>
         *        Example: <code>Sunny Mansion 203 block: 2 Chome</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder block(ParsedQueryComponent... block);

        /**
         * <p>
         * Name of the block.
         * </p>
         * <p>
         * Example: <code>Sunny Mansion 203 block: 2 Chome</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #block(List<ParsedQueryComponent>)}.
         * 
         * @param block
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #block(java.util.Collection<ParsedQueryComponent>)
         */
        Builder block(Consumer<ParsedQueryComponent.Builder>... block);

        /**
         * <p>
         * Name of sub-block.
         * </p>
         * <p>
         * Example: <code>Sunny Mansion 203 sub-block: 4</code>
         * </p>
         * 
         * @param subBlock
         *        Name of sub-block. </p>
         *        <p>
         *        Example: <code>Sunny Mansion 203 sub-block: 4</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subBlock(Collection<ParsedQueryComponent> subBlock);

        /**
         * <p>
         * Name of sub-block.
         * </p>
         * <p>
         * Example: <code>Sunny Mansion 203 sub-block: 4</code>
         * </p>
         * 
         * @param subBlock
         *        Name of sub-block. </p>
         *        <p>
         *        Example: <code>Sunny Mansion 203 sub-block: 4</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subBlock(ParsedQueryComponent... subBlock);

        /**
         * <p>
         * Name of sub-block.
         * </p>
         * <p>
         * Example: <code>Sunny Mansion 203 sub-block: 4</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #subBlock(List<ParsedQueryComponent>)}.
         * 
         * @param subBlock
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subBlock(java.util.Collection<ParsedQueryComponent>)
         */
        Builder subBlock(Consumer<ParsedQueryComponent.Builder>... subBlock);

        /**
         * <p>
         * The name of the street results should be present in.
         * </p>
         * 
         * @param street
         *        The name of the street results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street(Collection<ParsedQueryComponent> street);

        /**
         * <p>
         * The name of the street results should be present in.
         * </p>
         * 
         * @param street
         *        The name of the street results should be present in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street(ParsedQueryComponent... street);

        /**
         * <p>
         * The name of the street results should be present in.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #street(List<ParsedQueryComponent>)}.
         * 
         * @param street
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #street(java.util.Collection<ParsedQueryComponent>)
         */
        Builder street(Consumer<ParsedQueryComponent.Builder>... street);

        /**
         * <p>
         * The number that identifies an address within a street.
         * </p>
         * 
         * @param addressNumber
         *        The number that identifies an address within a street.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressNumber(Collection<ParsedQueryComponent> addressNumber);

        /**
         * <p>
         * The number that identifies an address within a street.
         * </p>
         * 
         * @param addressNumber
         *        The number that identifies an address within a street.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressNumber(ParsedQueryComponent... addressNumber);

        /**
         * <p>
         * The number that identifies an address within a street.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #addressNumber(List<ParsedQueryComponent>)}.
         * 
         * @param addressNumber
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addressNumber(java.util.Collection<ParsedQueryComponent>)
         */
        Builder addressNumber(Consumer<ParsedQueryComponent.Builder>... addressNumber);

        /**
         * <p>
         * The name of the building at the address.
         * </p>
         * 
         * @param building
         *        The name of the building at the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder building(Collection<ParsedQueryComponent> building);

        /**
         * <p>
         * The name of the building at the address.
         * </p>
         * 
         * @param building
         *        The name of the building at the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder building(ParsedQueryComponent... building);

        /**
         * <p>
         * The name of the building at the address.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #building(List<ParsedQueryComponent>)}.
         * 
         * @param building
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQueryComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #building(java.util.Collection<ParsedQueryComponent>)
         */
        Builder building(Consumer<ParsedQueryComponent.Builder>... building);

        /**
         * <p>
         * Parsed secondary address components from the provided query text.
         * </p>
         * 
         * @param secondaryAddressComponents
         *        Parsed secondary address components from the provided query text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAddressComponents(Collection<ParsedQuerySecondaryAddressComponent> secondaryAddressComponents);

        /**
         * <p>
         * Parsed secondary address components from the provided query text.
         * </p>
         * 
         * @param secondaryAddressComponents
         *        Parsed secondary address components from the provided query text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAddressComponents(ParsedQuerySecondaryAddressComponent... secondaryAddressComponents);

        /**
         * <p>
         * Parsed secondary address components from the provided query text.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQuerySecondaryAddressComponent.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQuerySecondaryAddressComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.ParsedQuerySecondaryAddressComponent.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #secondaryAddressComponents(List<ParsedQuerySecondaryAddressComponent>)}.
         * 
         * @param secondaryAddressComponents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.ParsedQuerySecondaryAddressComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryAddressComponents(java.util.Collection<ParsedQuerySecondaryAddressComponent>)
         */
        Builder secondaryAddressComponents(Consumer<ParsedQuerySecondaryAddressComponent.Builder>... secondaryAddressComponents);
    }

    static final class BuilderImpl implements Builder {
        private List<ParsedQueryComponent> country = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> region = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> subRegion = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> locality = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> district = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> subDistrict = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> postalCode = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> block = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> subBlock = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> street = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> addressNumber = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQueryComponent> building = DefaultSdkAutoConstructList.getInstance();

        private List<ParsedQuerySecondaryAddressComponent> secondaryAddressComponents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeocodeParsedQueryAddressComponents model) {
            country(model.country);
            region(model.region);
            subRegion(model.subRegion);
            locality(model.locality);
            district(model.district);
            subDistrict(model.subDistrict);
            postalCode(model.postalCode);
            block(model.block);
            subBlock(model.subBlock);
            street(model.street);
            addressNumber(model.addressNumber);
            building(model.building);
            secondaryAddressComponents(model.secondaryAddressComponents);
        }

        public final List<ParsedQueryComponent.Builder> getCountry() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.country);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCountry(Collection<ParsedQueryComponent.BuilderImpl> country) {
            this.country = ParsedQueryComponentListCopier.copyFromBuilder(country);
        }

        @Override
        public final Builder country(Collection<ParsedQueryComponent> country) {
            this.country = ParsedQueryComponentListCopier.copy(country);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder country(ParsedQueryComponent... country) {
            country(Arrays.asList(country));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder country(Consumer<ParsedQueryComponent.Builder>... country) {
            country(Stream.of(country).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getRegion() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.region);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegion(Collection<ParsedQueryComponent.BuilderImpl> region) {
            this.region = ParsedQueryComponentListCopier.copyFromBuilder(region);
        }

        @Override
        public final Builder region(Collection<ParsedQueryComponent> region) {
            this.region = ParsedQueryComponentListCopier.copy(region);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder region(ParsedQueryComponent... region) {
            region(Arrays.asList(region));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder region(Consumer<ParsedQueryComponent.Builder>... region) {
            region(Stream.of(region).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getSubRegion() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.subRegion);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubRegion(Collection<ParsedQueryComponent.BuilderImpl> subRegion) {
            this.subRegion = ParsedQueryComponentListCopier.copyFromBuilder(subRegion);
        }

        @Override
        public final Builder subRegion(Collection<ParsedQueryComponent> subRegion) {
            this.subRegion = ParsedQueryComponentListCopier.copy(subRegion);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subRegion(ParsedQueryComponent... subRegion) {
            subRegion(Arrays.asList(subRegion));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subRegion(Consumer<ParsedQueryComponent.Builder>... subRegion) {
            subRegion(Stream.of(subRegion).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getLocality() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.locality);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocality(Collection<ParsedQueryComponent.BuilderImpl> locality) {
            this.locality = ParsedQueryComponentListCopier.copyFromBuilder(locality);
        }

        @Override
        public final Builder locality(Collection<ParsedQueryComponent> locality) {
            this.locality = ParsedQueryComponentListCopier.copy(locality);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(ParsedQueryComponent... locality) {
            locality(Arrays.asList(locality));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(Consumer<ParsedQueryComponent.Builder>... locality) {
            locality(Stream.of(locality).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getDistrict() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.district);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistrict(Collection<ParsedQueryComponent.BuilderImpl> district) {
            this.district = ParsedQueryComponentListCopier.copyFromBuilder(district);
        }

        @Override
        public final Builder district(Collection<ParsedQueryComponent> district) {
            this.district = ParsedQueryComponentListCopier.copy(district);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(ParsedQueryComponent... district) {
            district(Arrays.asList(district));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(Consumer<ParsedQueryComponent.Builder>... district) {
            district(Stream.of(district).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getSubDistrict() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.subDistrict);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubDistrict(Collection<ParsedQueryComponent.BuilderImpl> subDistrict) {
            this.subDistrict = ParsedQueryComponentListCopier.copyFromBuilder(subDistrict);
        }

        @Override
        public final Builder subDistrict(Collection<ParsedQueryComponent> subDistrict) {
            this.subDistrict = ParsedQueryComponentListCopier.copy(subDistrict);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(ParsedQueryComponent... subDistrict) {
            subDistrict(Arrays.asList(subDistrict));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(Consumer<ParsedQueryComponent.Builder>... subDistrict) {
            subDistrict(Stream.of(subDistrict).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getPostalCode() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.postalCode);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPostalCode(Collection<ParsedQueryComponent.BuilderImpl> postalCode) {
            this.postalCode = ParsedQueryComponentListCopier.copyFromBuilder(postalCode);
        }

        @Override
        public final Builder postalCode(Collection<ParsedQueryComponent> postalCode) {
            this.postalCode = ParsedQueryComponentListCopier.copy(postalCode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCode(ParsedQueryComponent... postalCode) {
            postalCode(Arrays.asList(postalCode));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postalCode(Consumer<ParsedQueryComponent.Builder>... postalCode) {
            postalCode(Stream.of(postalCode).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getBlock() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.block);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlock(Collection<ParsedQueryComponent.BuilderImpl> block) {
            this.block = ParsedQueryComponentListCopier.copyFromBuilder(block);
        }

        @Override
        public final Builder block(Collection<ParsedQueryComponent> block) {
            this.block = ParsedQueryComponentListCopier.copy(block);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(ParsedQueryComponent... block) {
            block(Arrays.asList(block));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(Consumer<ParsedQueryComponent.Builder>... block) {
            block(Stream.of(block).map(c -> ParsedQueryComponent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getSubBlock() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.subBlock);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubBlock(Collection<ParsedQueryComponent.BuilderImpl> subBlock) {
            this.subBlock = ParsedQueryComponentListCopier.copyFromBuilder(subBlock);
        }

        @Override
        public final Builder subBlock(Collection<ParsedQueryComponent> subBlock) {
            this.subBlock = ParsedQueryComponentListCopier.copy(subBlock);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(ParsedQueryComponent... subBlock) {
            subBlock(Arrays.asList(subBlock));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(Consumer<ParsedQueryComponent.Builder>... subBlock) {
            subBlock(Stream.of(subBlock).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getStreet() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.street);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreet(Collection<ParsedQueryComponent.BuilderImpl> street) {
            this.street = ParsedQueryComponentListCopier.copyFromBuilder(street);
        }

        @Override
        public final Builder street(Collection<ParsedQueryComponent> street) {
            this.street = ParsedQueryComponentListCopier.copy(street);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(ParsedQueryComponent... street) {
            street(Arrays.asList(street));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(Consumer<ParsedQueryComponent.Builder>... street) {
            street(Stream.of(street).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getAddressNumber() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.addressNumber);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddressNumber(Collection<ParsedQueryComponent.BuilderImpl> addressNumber) {
            this.addressNumber = ParsedQueryComponentListCopier.copyFromBuilder(addressNumber);
        }

        @Override
        public final Builder addressNumber(Collection<ParsedQueryComponent> addressNumber) {
            this.addressNumber = ParsedQueryComponentListCopier.copy(addressNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressNumber(ParsedQueryComponent... addressNumber) {
            addressNumber(Arrays.asList(addressNumber));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressNumber(Consumer<ParsedQueryComponent.Builder>... addressNumber) {
            addressNumber(Stream.of(addressNumber).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQueryComponent.Builder> getBuilding() {
            List<ParsedQueryComponent.Builder> result = ParsedQueryComponentListCopier.copyToBuilder(this.building);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuilding(Collection<ParsedQueryComponent.BuilderImpl> building) {
            this.building = ParsedQueryComponentListCopier.copyFromBuilder(building);
        }

        @Override
        public final Builder building(Collection<ParsedQueryComponent> building) {
            this.building = ParsedQueryComponentListCopier.copy(building);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder building(ParsedQueryComponent... building) {
            building(Arrays.asList(building));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder building(Consumer<ParsedQueryComponent.Builder>... building) {
            building(Stream.of(building).map(c -> ParsedQueryComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParsedQuerySecondaryAddressComponent.Builder> getSecondaryAddressComponents() {
            List<ParsedQuerySecondaryAddressComponent.Builder> result = ParsedQuerySecondaryAddressComponentListCopier
                    .copyToBuilder(this.secondaryAddressComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryAddressComponents(
                Collection<ParsedQuerySecondaryAddressComponent.BuilderImpl> secondaryAddressComponents) {
            this.secondaryAddressComponents = ParsedQuerySecondaryAddressComponentListCopier
                    .copyFromBuilder(secondaryAddressComponents);
        }

        @Override
        public final Builder secondaryAddressComponents(
                Collection<ParsedQuerySecondaryAddressComponent> secondaryAddressComponents) {
            this.secondaryAddressComponents = ParsedQuerySecondaryAddressComponentListCopier.copy(secondaryAddressComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryAddressComponents(ParsedQuerySecondaryAddressComponent... secondaryAddressComponents) {
            secondaryAddressComponents(Arrays.asList(secondaryAddressComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryAddressComponents(
                Consumer<ParsedQuerySecondaryAddressComponent.Builder>... secondaryAddressComponents) {
            secondaryAddressComponents(Stream.of(secondaryAddressComponents)
                    .map(c -> ParsedQuerySecondaryAddressComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GeocodeParsedQueryAddressComponents build() {
            return new GeocodeParsedQueryAddressComponents(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
