/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeocodeResponse extends GeoPlacesResponse implements
        ToCopyableBuilder<GeocodeResponse.Builder, GeocodeResponse> {
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingBucket").getter(getter(GeocodeResponse::pricingBucket)).setter(setter(Builder::pricingBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build())
            .build();

    private static final SdkField<List<GeocodeResultItem>> RESULT_ITEMS_FIELD = SdkField
            .<List<GeocodeResultItem>> builder(MarshallingType.LIST)
            .memberName("ResultItems")
            .getter(getter(GeocodeResponse::resultItems))
            .setter(setter(Builder::resultItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeocodeResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeocodeResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_BUCKET_FIELD,
            RESULT_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pricingBucket;

    private final List<GeocodeResultItem> resultItems;

    private GeocodeResponse(BuilderImpl builder) {
        super(builder);
        this.pricingBucket = builder.pricingBucket;
        this.resultItems = builder.resultItems;
    }

    /**
     * <p>
     * The pricing bucket for which the query is charged at.
     * </p>
     * <p>
     * For more information on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon Location
     * Service Pricing</a>.
     * </p>
     * 
     * @return The pricing bucket for which the query is charged at.</p>
     *         <p>
     *         For more information on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon
     *         Location Service Pricing</a>.
     */
    public final String pricingBucket() {
        return pricingBucket;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultItems() {
        return resultItems != null && !(resultItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of places or results returned for a query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultItems} method.
     * </p>
     * 
     * @return List of places or results returned for a query.
     */
    public final List<GeocodeResultItem> resultItems() {
        return resultItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultItems() ? resultItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeocodeResponse)) {
            return false;
        }
        GeocodeResponse other = (GeocodeResponse) obj;
        return Objects.equals(pricingBucket(), other.pricingBucket()) && hasResultItems() == other.hasResultItems()
                && Objects.equals(resultItems(), other.resultItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeocodeResponse").add("PricingBucket", pricingBucket())
                .add("ResultItems", hasResultItems() ? resultItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PricingBucket":
            return Optional.ofNullable(clazz.cast(pricingBucket()));
        case "ResultItems":
            return Optional.ofNullable(clazz.cast(resultItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("ResultItems", RESULT_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeocodeResponse, T> g) {
        return obj -> g.apply((GeocodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoPlacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GeocodeResponse> {
        /**
         * <p>
         * The pricing bucket for which the query is charged at.
         * </p>
         * <p>
         * For more information on pricing, please visit <a href="https://aws.amazon.com/location/pricing/">Amazon
         * Location Service Pricing</a>.
         * </p>
         * 
         * @param pricingBucket
         *        The pricing bucket for which the query is charged at.</p>
         *        <p>
         *        For more information on pricing, please visit <a
         *        href="https://aws.amazon.com/location/pricing/">Amazon Location Service Pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingBucket(String pricingBucket);

        /**
         * <p>
         * List of places or results returned for a query.
         * </p>
         * 
         * @param resultItems
         *        List of places or results returned for a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(Collection<GeocodeResultItem> resultItems);

        /**
         * <p>
         * List of places or results returned for a query.
         * </p>
         * 
         * @param resultItems
         *        List of places or results returned for a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultItems(GeocodeResultItem... resultItems);

        /**
         * <p>
         * List of places or results returned for a query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.GeocodeResultItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.geoplaces.model.GeocodeResultItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.GeocodeResultItem.Builder#build()} is called
         * immediately and its result is passed to {@link #resultItems(List<GeocodeResultItem>)}.
         * 
         * @param resultItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.GeocodeResultItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultItems(java.util.Collection<GeocodeResultItem>)
         */
        Builder resultItems(Consumer<GeocodeResultItem.Builder>... resultItems);
    }

    static final class BuilderImpl extends GeoPlacesResponse.BuilderImpl implements Builder {
        private String pricingBucket;

        private List<GeocodeResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeocodeResponse model) {
            super(model);
            pricingBucket(model.pricingBucket);
            resultItems(model.resultItems);
        }

        public final String getPricingBucket() {
            return pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<GeocodeResultItem.Builder> getResultItems() {
            List<GeocodeResultItem.Builder> result = GeocodeResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<GeocodeResultItem.BuilderImpl> resultItems) {
            this.resultItems = GeocodeResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<GeocodeResultItem> resultItems) {
            this.resultItems = GeocodeResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(GeocodeResultItem... resultItems) {
            resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<GeocodeResultItem.Builder>... resultItems) {
            resultItems(Stream.of(resultItems).map(c -> GeocodeResultItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GeocodeResponse build() {
            return new GeocodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
