/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details related to the match score.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchScoreDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MatchScoreDetails.Builder, MatchScoreDetails> {
    private static final SdkField<Double> OVERALL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Overall")
            .getter(getter(MatchScoreDetails::overall)).setter(setter(Builder::overall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overall").build()).build();

    private static final SdkField<ComponentMatchScores> COMPONENTS_FIELD = SdkField
            .<ComponentMatchScores> builder(MarshallingType.SDK_POJO).memberName("Components")
            .getter(getter(MatchScoreDetails::components)).setter(setter(Builder::components))
            .constructor(ComponentMatchScores::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Components").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERALL_FIELD,
            COMPONENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double overall;

    private final ComponentMatchScores components;

    private MatchScoreDetails(BuilderImpl builder) {
        this.overall = builder.overall;
        this.components = builder.components;
    }

    /**
     * <p>
     * Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are recognized and
     * matched.
     * </p>
     * 
     * @return Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are
     *         recognized and matched.
     */
    public final Double overall() {
        return overall;
    }

    /**
     * <p>
     * Indicates how well the component input matches the returned. It is equal to 1 if all input tokens are recognized
     * and matched.
     * </p>
     * 
     * @return Indicates how well the component input matches the returned. It is equal to 1 if all input tokens are
     *         recognized and matched.
     */
    public final ComponentMatchScores components() {
        return components;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(overall());
        hashCode = 31 * hashCode + Objects.hashCode(components());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchScoreDetails)) {
            return false;
        }
        MatchScoreDetails other = (MatchScoreDetails) obj;
        return Objects.equals(overall(), other.overall()) && Objects.equals(components(), other.components());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchScoreDetails").add("Overall", overall()).add("Components", components()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Overall":
            return Optional.ofNullable(clazz.cast(overall()));
        case "Components":
            return Optional.ofNullable(clazz.cast(components()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Overall", OVERALL_FIELD);
        map.put("Components", COMPONENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchScoreDetails, T> g) {
        return obj -> g.apply((MatchScoreDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchScoreDetails> {
        /**
         * <p>
         * Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are recognized
         * and matched.
         * </p>
         * 
         * @param overall
         *        Indicates how well the entire input matches the returned. It is equal to 1 if all input tokens are
         *        recognized and matched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overall(Double overall);

        /**
         * <p>
         * Indicates how well the component input matches the returned. It is equal to 1 if all input tokens are
         * recognized and matched.
         * </p>
         * 
         * @param components
         *        Indicates how well the component input matches the returned. It is equal to 1 if all input tokens are
         *        recognized and matched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(ComponentMatchScores components);

        /**
         * <p>
         * Indicates how well the component input matches the returned. It is equal to 1 if all input tokens are
         * recognized and matched.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentMatchScores.Builder} avoiding
         * the need to create one manually via {@link ComponentMatchScores#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentMatchScores.Builder#build()} is called immediately and
         * its result is passed to {@link #components(ComponentMatchScores)}.
         * 
         * @param components
         *        a consumer that will call methods on {@link ComponentMatchScores.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #components(ComponentMatchScores)
         */
        default Builder components(Consumer<ComponentMatchScores.Builder> components) {
            return components(ComponentMatchScores.builder().applyMutation(components).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double overall;

        private ComponentMatchScores components;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchScoreDetails model) {
            overall(model.overall);
            components(model.components);
        }

        public final Double getOverall() {
            return overall;
        }

        public final void setOverall(Double overall) {
            this.overall = overall;
        }

        @Override
        public final Builder overall(Double overall) {
            this.overall = overall;
            return this;
        }

        public final ComponentMatchScores.Builder getComponents() {
            return components != null ? components.toBuilder() : null;
        }

        public final void setComponents(ComponentMatchScores.BuilderImpl components) {
            this.components = components != null ? components.build() : null;
        }

        @Override
        public final Builder components(ComponentMatchScores components) {
            this.components = components;
            return this;
        }

        @Override
        public MatchScoreDetails build() {
            return new MatchScoreDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
