/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a secondary address component parsed from the query text.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParsedQuerySecondaryAddressComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<ParsedQuerySecondaryAddressComponent.Builder, ParsedQuerySecondaryAddressComponent> {
    private static final SdkField<Integer> START_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartIndex").getter(getter(ParsedQuerySecondaryAddressComponent::startIndex))
            .setter(setter(Builder::startIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartIndex").build()).build();

    private static final SdkField<Integer> END_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndIndex").getter(getter(ParsedQuerySecondaryAddressComponent::endIndex))
            .setter(setter(Builder::endIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndIndex").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ParsedQuerySecondaryAddressComponent::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Number")
            .getter(getter(ParsedQuerySecondaryAddressComponent::number)).setter(setter(Builder::number))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Number").build()).build();

    private static final SdkField<String> DESIGNATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Designator").getter(getter(ParsedQuerySecondaryAddressComponent::designator))
            .setter(setter(Builder::designator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Designator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_INDEX_FIELD,
            END_INDEX_FIELD, VALUE_FIELD, NUMBER_FIELD, DESIGNATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer startIndex;

    private final Integer endIndex;

    private final String value;

    private final String number;

    private final String designator;

    private ParsedQuerySecondaryAddressComponent(BuilderImpl builder) {
        this.startIndex = builder.startIndex;
        this.endIndex = builder.endIndex;
        this.value = builder.value;
        this.number = builder.number;
        this.designator = builder.designator;
    }

    /**
     * <p>
     * Start index of the parsed secondary address component in the query text.
     * </p>
     * 
     * @return Start index of the parsed secondary address component in the query text.
     */
    public final Integer startIndex() {
        return startIndex;
    }

    /**
     * <p>
     * End index of the parsed secondary address component in the query text.
     * </p>
     * 
     * @return End index of the parsed secondary address component in the query text.
     */
    public final Integer endIndex() {
        return endIndex;
    }

    /**
     * <p>
     * Value of the parsed secondary address component.
     * </p>
     * 
     * @return Value of the parsed secondary address component.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * Secondary address number provided in the query.
     * </p>
     * 
     * @return Secondary address number provided in the query.
     */
    public final String number() {
        return number;
    }

    /**
     * <p>
     * Secondary address designator provided in the query.
     * </p>
     * 
     * @return Secondary address designator provided in the query.
     */
    public final String designator() {
        return designator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startIndex());
        hashCode = 31 * hashCode + Objects.hashCode(endIndex());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(number());
        hashCode = 31 * hashCode + Objects.hashCode(designator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParsedQuerySecondaryAddressComponent)) {
            return false;
        }
        ParsedQuerySecondaryAddressComponent other = (ParsedQuerySecondaryAddressComponent) obj;
        return Objects.equals(startIndex(), other.startIndex()) && Objects.equals(endIndex(), other.endIndex())
                && Objects.equals(value(), other.value()) && Objects.equals(number(), other.number())
                && Objects.equals(designator(), other.designator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParsedQuerySecondaryAddressComponent").add("StartIndex", startIndex())
                .add("EndIndex", endIndex()).add("Value", value() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Number", number() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Designator", designator() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartIndex":
            return Optional.ofNullable(clazz.cast(startIndex()));
        case "EndIndex":
            return Optional.ofNullable(clazz.cast(endIndex()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Number":
            return Optional.ofNullable(clazz.cast(number()));
        case "Designator":
            return Optional.ofNullable(clazz.cast(designator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartIndex", START_INDEX_FIELD);
        map.put("EndIndex", END_INDEX_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("Number", NUMBER_FIELD);
        map.put("Designator", DESIGNATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParsedQuerySecondaryAddressComponent, T> g) {
        return obj -> g.apply((ParsedQuerySecondaryAddressComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParsedQuerySecondaryAddressComponent> {
        /**
         * <p>
         * Start index of the parsed secondary address component in the query text.
         * </p>
         * 
         * @param startIndex
         *        Start index of the parsed secondary address component in the query text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startIndex(Integer startIndex);

        /**
         * <p>
         * End index of the parsed secondary address component in the query text.
         * </p>
         * 
         * @param endIndex
         *        End index of the parsed secondary address component in the query text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endIndex(Integer endIndex);

        /**
         * <p>
         * Value of the parsed secondary address component.
         * </p>
         * 
         * @param value
         *        Value of the parsed secondary address component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Secondary address number provided in the query.
         * </p>
         * 
         * @param number
         *        Secondary address number provided in the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder number(String number);

        /**
         * <p>
         * Secondary address designator provided in the query.
         * </p>
         * 
         * @param designator
         *        Secondary address designator provided in the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder designator(String designator);
    }

    static final class BuilderImpl implements Builder {
        private Integer startIndex;

        private Integer endIndex;

        private String value;

        private String number;

        private String designator;

        private BuilderImpl() {
        }

        private BuilderImpl(ParsedQuerySecondaryAddressComponent model) {
            startIndex(model.startIndex);
            endIndex(model.endIndex);
            value(model.value);
            number(model.number);
            designator(model.designator);
        }

        public final Integer getStartIndex() {
            return startIndex;
        }

        public final void setStartIndex(Integer startIndex) {
            this.startIndex = startIndex;
        }

        @Override
        public final Builder startIndex(Integer startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public final Integer getEndIndex() {
            return endIndex;
        }

        public final void setEndIndex(Integer endIndex) {
            this.endIndex = endIndex;
        }

        @Override
        public final Builder endIndex(Integer endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getNumber() {
            return number;
        }

        public final void setNumber(String number) {
            this.number = number;
        }

        @Override
        public final Builder number(String number) {
            this.number = number;
            return this;
        }

        public final String getDesignator() {
            return designator;
        }

        public final void setDesignator(String designator) {
            this.designator = designator;
        }

        @Override
        public final Builder designator(String designator) {
            this.designator = designator;
            return this;
        }

        @Override
        public ParsedQuerySecondaryAddressComponent build() {
            return new ParsedQuerySecondaryAddressComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
