/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The phoneme details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhonemeDetails implements SdkPojo, Serializable, ToCopyableBuilder<PhonemeDetails.Builder, PhonemeDetails> {
    private static final SdkField<List<PhonemeTranscription>> TITLE_FIELD = SdkField
            .<List<PhonemeTranscription>> builder(MarshallingType.LIST)
            .memberName("Title")
            .getter(getter(PhonemeDetails::title))
            .setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhonemeTranscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhonemeTranscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AddressComponentPhonemes> ADDRESS_FIELD = SdkField
            .<AddressComponentPhonemes> builder(MarshallingType.SDK_POJO).memberName("Address")
            .getter(getter(PhonemeDetails::address)).setter(setter(Builder::address))
            .constructor(AddressComponentPhonemes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PhonemeTranscription> title;

    private final AddressComponentPhonemes address;

    private PhonemeDetails(BuilderImpl builder) {
        this.title = builder.title;
        this.address = builder.address;
    }

    /**
     * For responses, this returns true if the service returned a value for the Title property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTitle() {
        return title != null && !(title instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>PhonemeTranscription</code>. See <code>PhonemeTranscription</code> for fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTitle} method.
     * </p>
     * 
     * @return List of <code>PhonemeTranscription</code>. See <code>PhonemeTranscription</code> for fields.
     */
    public final List<PhonemeTranscription> title() {
        return title;
    }

    /**
     * <p>
     * How to pronounce the address.
     * </p>
     * 
     * @return How to pronounce the address.
     */
    public final AddressComponentPhonemes address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTitle() ? title() : null);
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhonemeDetails)) {
            return false;
        }
        PhonemeDetails other = (PhonemeDetails) obj;
        return hasTitle() == other.hasTitle() && Objects.equals(title(), other.title())
                && Objects.equals(address(), other.address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhonemeDetails").add("Title", hasTitle() ? title() : null).add("Address", address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhonemeDetails, T> g) {
        return obj -> g.apply((PhonemeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhonemeDetails> {
        /**
         * <p>
         * List of <code>PhonemeTranscription</code>. See <code>PhonemeTranscription</code> for fields.
         * </p>
         * 
         * @param title
         *        List of <code>PhonemeTranscription</code>. See <code>PhonemeTranscription</code> for fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(Collection<PhonemeTranscription> title);

        /**
         * <p>
         * List of <code>PhonemeTranscription</code>. See <code>PhonemeTranscription</code> for fields.
         * </p>
         * 
         * @param title
         *        List of <code>PhonemeTranscription</code>. See <code>PhonemeTranscription</code> for fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(PhonemeTranscription... title);

        /**
         * <p>
         * List of <code>PhonemeTranscription</code>. See <code>PhonemeTranscription</code> for fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder#build()} is called
         * immediately and its result is passed to {@link #title(List<PhonemeTranscription>)}.
         * 
         * @param title
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(java.util.Collection<PhonemeTranscription>)
         */
        Builder title(Consumer<PhonemeTranscription.Builder>... title);

        /**
         * <p>
         * How to pronounce the address.
         * </p>
         * 
         * @param address
         *        How to pronounce the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(AddressComponentPhonemes address);

        /**
         * <p>
         * How to pronounce the address.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddressComponentPhonemes.Builder}
         * avoiding the need to create one manually via {@link AddressComponentPhonemes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddressComponentPhonemes.Builder#build()} is called immediately
         * and its result is passed to {@link #address(AddressComponentPhonemes)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link AddressComponentPhonemes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(AddressComponentPhonemes)
         */
        default Builder address(Consumer<AddressComponentPhonemes.Builder> address) {
            return address(AddressComponentPhonemes.builder().applyMutation(address).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<PhonemeTranscription> title = DefaultSdkAutoConstructList.getInstance();

        private AddressComponentPhonemes address;

        private BuilderImpl() {
        }

        private BuilderImpl(PhonemeDetails model) {
            title(model.title);
            address(model.address);
        }

        public final List<PhonemeTranscription.Builder> getTitle() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.title);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitle(Collection<PhonemeTranscription.BuilderImpl> title) {
            this.title = PhonemeTranscriptionListCopier.copyFromBuilder(title);
        }

        @Override
        public final Builder title(Collection<PhonemeTranscription> title) {
            this.title = PhonemeTranscriptionListCopier.copy(title);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(PhonemeTranscription... title) {
            title(Arrays.asList(title));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder title(Consumer<PhonemeTranscription.Builder>... title) {
            title(Stream.of(title).map(c -> PhonemeTranscription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AddressComponentPhonemes.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(AddressComponentPhonemes.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(AddressComponentPhonemes address) {
            this.address = address;
            return this;
        }

        @Override
        public PhonemeDetails build() {
            return new PhonemeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
