/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * How to pronounce the various components of the address or place.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhonemeTranscription implements SdkPojo, Serializable,
        ToCopyableBuilder<PhonemeTranscription.Builder, PhonemeTranscription> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(PhonemeTranscription::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(PhonemeTranscription::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<Boolean> PREFERRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Preferred").getter(getter(PhonemeTranscription::preferred)).setter(setter(Builder::preferred))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preferred").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, LANGUAGE_FIELD,
            PREFERRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String language;

    private final Boolean preferred;

    private PhonemeTranscription(BuilderImpl builder) {
        this.value = builder.value;
        this.language = builder.language;
        this.preferred = builder.preferred;
    }

    /**
     * <p>
     * Value which indicates how to pronounce the value.
     * </p>
     * 
     * @return Value which indicates how to pronounce the value.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for the
     * results to be rendered in. If there is no data for the result in the requested language, data will be returned in
     * the default language for the entry.
     * </p>
     * 
     * @return A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes
     *         for the results to be rendered in. If there is no data for the result in the requested language, data
     *         will be returned in the default language for the entry.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * Boolean which indicates if it the preferred pronunciation.
     * </p>
     * 
     * @return Boolean which indicates if it the preferred pronunciation.
     */
    public final Boolean preferred() {
        return preferred;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(preferred());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhonemeTranscription)) {
            return false;
        }
        PhonemeTranscription other = (PhonemeTranscription) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(language(), other.language())
                && Objects.equals(preferred(), other.preferred());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhonemeTranscription").add("Value", value() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Language", language()).add("Preferred", preferred() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "Preferred":
            return Optional.ofNullable(clazz.cast(preferred()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("Preferred", PREFERRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PhonemeTranscription, T> g) {
        return obj -> g.apply((PhonemeTranscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhonemeTranscription> {
        /**
         * <p>
         * Value which indicates how to pronounce the value.
         * </p>
         * 
         * @param value
         *        Value which indicates how to pronounce the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for
         * the results to be rendered in. If there is no data for the result in the requested language, data will be
         * returned in the default language for the entry.
         * </p>
         * 
         * @param language
         *        A list of <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language
         *        codes for the results to be rendered in. If there is no data for the result in the requested language,
         *        data will be returned in the default language for the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * Boolean which indicates if it the preferred pronunciation.
         * </p>
         * 
         * @param preferred
         *        Boolean which indicates if it the preferred pronunciation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferred(Boolean preferred);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String language;

        private Boolean preferred;

        private BuilderImpl() {
        }

        private BuilderImpl(PhonemeTranscription model) {
            value(model.value);
            language(model.language);
            preferred(model.preferred);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Boolean getPreferred() {
            return preferred;
        }

        public final void setPreferred(Boolean preferred) {
            this.preferred = preferred;
        }

        @Override
        public final Builder preferred(Boolean preferred) {
            this.preferred = preferred;
            return this;
        }

        @Override
        public PhonemeTranscription build() {
            return new PhonemeTranscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
