/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the postal code of the place or result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostalCodeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<PostalCodeDetails.Builder, PostalCodeDetails> {
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(PostalCodeDetails::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final SdkField<String> POSTAL_AUTHORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalAuthority").getter(getter(PostalCodeDetails::postalAuthorityAsString))
            .setter(setter(Builder::postalAuthority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalAuthority").build()).build();

    private static final SdkField<String> POSTAL_CODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCodeType").getter(getter(PostalCodeDetails::postalCodeTypeAsString))
            .setter(setter(Builder::postalCodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCodeType").build()).build();

    private static final SdkField<UspsZip> USPS_ZIP_FIELD = SdkField.<UspsZip> builder(MarshallingType.SDK_POJO)
            .memberName("UspsZip").getter(getter(PostalCodeDetails::uspsZip)).setter(setter(Builder::uspsZip))
            .constructor(UspsZip::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UspsZip").build()).build();

    private static final SdkField<UspsZipPlus4> USPS_ZIP_PLUS4_FIELD = SdkField.<UspsZipPlus4> builder(MarshallingType.SDK_POJO)
            .memberName("UspsZipPlus4").getter(getter(PostalCodeDetails::uspsZipPlus4)).setter(setter(Builder::uspsZipPlus4))
            .constructor(UspsZipPlus4::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UspsZipPlus4").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSTAL_CODE_FIELD,
            POSTAL_AUTHORITY_FIELD, POSTAL_CODE_TYPE_FIELD, USPS_ZIP_FIELD, USPS_ZIP_PLUS4_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String postalCode;

    private final String postalAuthority;

    private final String postalCodeType;

    private final UspsZip uspsZip;

    private final UspsZipPlus4 uspsZipPlus4;

    private PostalCodeDetails(BuilderImpl builder) {
        this.postalCode = builder.postalCode;
        this.postalAuthority = builder.postalAuthority;
        this.postalCodeType = builder.postalCodeType;
        this.uspsZip = builder.uspsZip;
        this.uspsZipPlus4 = builder.uspsZipPlus4;
    }

    /**
     * <p>
     * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode, or
     * ZIP code for which the result should possess.
     * </p>
     * 
     * @return An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
     *         postcode, or ZIP code for which the result should possess.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The postal authority or entity. This could be a governmental authority, a regulatory authority, or a designated
     * postal operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #postalAuthority}
     * will return {@link PostalAuthority#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #postalAuthorityAsString}.
     * </p>
     * 
     * @return The postal authority or entity. This could be a governmental authority, a regulatory authority, or a
     *         designated postal operator.
     * @see PostalAuthority
     */
    public final PostalAuthority postalAuthority() {
        return PostalAuthority.fromValue(postalAuthority);
    }

    /**
     * <p>
     * The postal authority or entity. This could be a governmental authority, a regulatory authority, or a designated
     * postal operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #postalAuthority}
     * will return {@link PostalAuthority#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #postalAuthorityAsString}.
     * </p>
     * 
     * @return The postal authority or entity. This could be a governmental authority, a regulatory authority, or a
     *         designated postal operator.
     * @see PostalAuthority
     */
    public final String postalAuthorityAsString() {
        return postalAuthority;
    }

    /**
     * <p>
     * The postal code type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #postalCodeType}
     * will return {@link PostalCodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #postalCodeTypeAsString}.
     * </p>
     * 
     * @return The postal code type.
     * @see PostalCodeType
     */
    public final PostalCodeType postalCodeType() {
        return PostalCodeType.fromValue(postalCodeType);
    }

    /**
     * <p>
     * The postal code type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #postalCodeType}
     * will return {@link PostalCodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #postalCodeTypeAsString}.
     * </p>
     * 
     * @return The postal code type.
     * @see PostalCodeType
     */
    public final String postalCodeTypeAsString() {
        return postalCodeType;
    }

    /**
     * <p>
     * The ZIP Classification Code, or in other words what type of postal code is it.
     * </p>
     * 
     * @return The ZIP Classification Code, or in other words what type of postal code is it.
     */
    public final UspsZip uspsZip() {
        return uspsZip;
    }

    /**
     * <p>
     * The USPS ZIP+4 Record Type Code.
     * </p>
     * 
     * @return The USPS ZIP+4 Record Type Code.
     */
    public final UspsZipPlus4 uspsZipPlus4() {
        return uspsZipPlus4;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(postalAuthorityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(postalCodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uspsZip());
        hashCode = 31 * hashCode + Objects.hashCode(uspsZipPlus4());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostalCodeDetails)) {
            return false;
        }
        PostalCodeDetails other = (PostalCodeDetails) obj;
        return Objects.equals(postalCode(), other.postalCode())
                && Objects.equals(postalAuthorityAsString(), other.postalAuthorityAsString())
                && Objects.equals(postalCodeTypeAsString(), other.postalCodeTypeAsString())
                && Objects.equals(uspsZip(), other.uspsZip()) && Objects.equals(uspsZipPlus4(), other.uspsZipPlus4());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostalCodeDetails")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalAuthority", postalAuthorityAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCodeType", postalCodeTypeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UspsZip", uspsZip()).add("UspsZipPlus4", uspsZipPlus4()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "PostalAuthority":
            return Optional.ofNullable(clazz.cast(postalAuthorityAsString()));
        case "PostalCodeType":
            return Optional.ofNullable(clazz.cast(postalCodeTypeAsString()));
        case "UspsZip":
            return Optional.ofNullable(clazz.cast(uspsZip()));
        case "UspsZipPlus4":
            return Optional.ofNullable(clazz.cast(uspsZipPlus4()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("PostalAuthority", POSTAL_AUTHORITY_FIELD);
        map.put("PostalCodeType", POSTAL_CODE_TYPE_FIELD);
        map.put("UspsZip", USPS_ZIP_FIELD);
        map.put("UspsZipPlus4", USPS_ZIP_PLUS4_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostalCodeDetails, T> g) {
        return obj -> g.apply((PostalCodeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostalCodeDetails> {
        /**
         * <p>
         * An alphanumeric string included in a postal address to facilitate mail sorting, such as post code, postcode,
         * or ZIP code for which the result should possess.
         * </p>
         * 
         * @param postalCode
         *        An alphanumeric string included in a postal address to facilitate mail sorting, such as post code,
         *        postcode, or ZIP code for which the result should possess.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The postal authority or entity. This could be a governmental authority, a regulatory authority, or a
         * designated postal operator.
         * </p>
         * 
         * @param postalAuthority
         *        The postal authority or entity. This could be a governmental authority, a regulatory authority, or a
         *        designated postal operator.
         * @see PostalAuthority
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostalAuthority
         */
        Builder postalAuthority(String postalAuthority);

        /**
         * <p>
         * The postal authority or entity. This could be a governmental authority, a regulatory authority, or a
         * designated postal operator.
         * </p>
         * 
         * @param postalAuthority
         *        The postal authority or entity. This could be a governmental authority, a regulatory authority, or a
         *        designated postal operator.
         * @see PostalAuthority
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostalAuthority
         */
        Builder postalAuthority(PostalAuthority postalAuthority);

        /**
         * <p>
         * The postal code type.
         * </p>
         * 
         * @param postalCodeType
         *        The postal code type.
         * @see PostalCodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostalCodeType
         */
        Builder postalCodeType(String postalCodeType);

        /**
         * <p>
         * The postal code type.
         * </p>
         * 
         * @param postalCodeType
         *        The postal code type.
         * @see PostalCodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PostalCodeType
         */
        Builder postalCodeType(PostalCodeType postalCodeType);

        /**
         * <p>
         * The ZIP Classification Code, or in other words what type of postal code is it.
         * </p>
         * 
         * @param uspsZip
         *        The ZIP Classification Code, or in other words what type of postal code is it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uspsZip(UspsZip uspsZip);

        /**
         * <p>
         * The ZIP Classification Code, or in other words what type of postal code is it.
         * </p>
         * This is a convenience method that creates an instance of the {@link UspsZip.Builder} avoiding the need to
         * create one manually via {@link UspsZip#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UspsZip.Builder#build()} is called immediately and its result is
         * passed to {@link #uspsZip(UspsZip)}.
         * 
         * @param uspsZip
         *        a consumer that will call methods on {@link UspsZip.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uspsZip(UspsZip)
         */
        default Builder uspsZip(Consumer<UspsZip.Builder> uspsZip) {
            return uspsZip(UspsZip.builder().applyMutation(uspsZip).build());
        }

        /**
         * <p>
         * The USPS ZIP+4 Record Type Code.
         * </p>
         * 
         * @param uspsZipPlus4
         *        The USPS ZIP+4 Record Type Code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uspsZipPlus4(UspsZipPlus4 uspsZipPlus4);

        /**
         * <p>
         * The USPS ZIP+4 Record Type Code.
         * </p>
         * This is a convenience method that creates an instance of the {@link UspsZipPlus4.Builder} avoiding the need
         * to create one manually via {@link UspsZipPlus4#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UspsZipPlus4.Builder#build()} is called immediately and its
         * result is passed to {@link #uspsZipPlus4(UspsZipPlus4)}.
         * 
         * @param uspsZipPlus4
         *        a consumer that will call methods on {@link UspsZipPlus4.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uspsZipPlus4(UspsZipPlus4)
         */
        default Builder uspsZipPlus4(Consumer<UspsZipPlus4.Builder> uspsZipPlus4) {
            return uspsZipPlus4(UspsZipPlus4.builder().applyMutation(uspsZipPlus4).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String postalCode;

        private String postalAuthority;

        private String postalCodeType;

        private UspsZip uspsZip;

        private UspsZipPlus4 uspsZipPlus4;

        private BuilderImpl() {
        }

        private BuilderImpl(PostalCodeDetails model) {
            postalCode(model.postalCode);
            postalAuthority(model.postalAuthority);
            postalCodeType(model.postalCodeType);
            uspsZip(model.uspsZip);
            uspsZipPlus4(model.uspsZipPlus4);
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getPostalAuthority() {
            return postalAuthority;
        }

        public final void setPostalAuthority(String postalAuthority) {
            this.postalAuthority = postalAuthority;
        }

        @Override
        public final Builder postalAuthority(String postalAuthority) {
            this.postalAuthority = postalAuthority;
            return this;
        }

        @Override
        public final Builder postalAuthority(PostalAuthority postalAuthority) {
            this.postalAuthority(postalAuthority == null ? null : postalAuthority.toString());
            return this;
        }

        public final String getPostalCodeType() {
            return postalCodeType;
        }

        public final void setPostalCodeType(String postalCodeType) {
            this.postalCodeType = postalCodeType;
        }

        @Override
        public final Builder postalCodeType(String postalCodeType) {
            this.postalCodeType = postalCodeType;
            return this;
        }

        @Override
        public final Builder postalCodeType(PostalCodeType postalCodeType) {
            this.postalCodeType(postalCodeType == null ? null : postalCodeType.toString());
            return this;
        }

        public final UspsZip.Builder getUspsZip() {
            return uspsZip != null ? uspsZip.toBuilder() : null;
        }

        public final void setUspsZip(UspsZip.BuilderImpl uspsZip) {
            this.uspsZip = uspsZip != null ? uspsZip.build() : null;
        }

        @Override
        public final Builder uspsZip(UspsZip uspsZip) {
            this.uspsZip = uspsZip;
            return this;
        }

        public final UspsZipPlus4.Builder getUspsZipPlus4() {
            return uspsZipPlus4 != null ? uspsZipPlus4.toBuilder() : null;
        }

        public final void setUspsZipPlus4(UspsZipPlus4.BuilderImpl uspsZipPlus4) {
            this.uspsZipPlus4 = uspsZipPlus4 != null ? uspsZipPlus4.build() : null;
        }

        @Override
        public final Builder uspsZipPlus4(UspsZipPlus4 uspsZipPlus4) {
            this.uspsZipPlus4 = uspsZipPlus4;
            return this;
        }

        @Override
        public PostalCodeDetails build() {
            return new PostalCodeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
