/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The included place types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReverseGeocodeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ReverseGeocodeFilter.Builder, ReverseGeocodeFilter> {
    private static final SdkField<List<String>> INCLUDE_PLACE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IncludePlaceTypes")
            .getter(getter(ReverseGeocodeFilter::includePlaceTypesAsStrings))
            .setter(setter(Builder::includePlaceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePlaceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_PLACE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> includePlaceTypes;

    private ReverseGeocodeFilter(BuilderImpl builder) {
        this.includePlaceTypes = builder.includePlaceTypes;
    }

    /**
     * <p>
     * The included place types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludePlaceTypes} method.
     * </p>
     * 
     * @return The included place types.
     */
    public final List<ReverseGeocodeFilterPlaceType> includePlaceTypes() {
        return ReverseGeocodeFilterPlaceTypeListCopier.copyStringToEnum(includePlaceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludePlaceTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludePlaceTypes() {
        return includePlaceTypes != null && !(includePlaceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The included place types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludePlaceTypes} method.
     * </p>
     * 
     * @return The included place types.
     */
    public final List<String> includePlaceTypesAsStrings() {
        return includePlaceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludePlaceTypes() ? includePlaceTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReverseGeocodeFilter)) {
            return false;
        }
        ReverseGeocodeFilter other = (ReverseGeocodeFilter) obj;
        return hasIncludePlaceTypes() == other.hasIncludePlaceTypes()
                && Objects.equals(includePlaceTypesAsStrings(), other.includePlaceTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReverseGeocodeFilter")
                .add("IncludePlaceTypes", hasIncludePlaceTypes() ? includePlaceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludePlaceTypes":
            return Optional.ofNullable(clazz.cast(includePlaceTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IncludePlaceTypes", INCLUDE_PLACE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReverseGeocodeFilter, T> g) {
        return obj -> g.apply((ReverseGeocodeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReverseGeocodeFilter> {
        /**
         * <p>
         * The included place types.
         * </p>
         * 
         * @param includePlaceTypes
         *        The included place types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includePlaceTypesWithStrings(Collection<String> includePlaceTypes);

        /**
         * <p>
         * The included place types.
         * </p>
         * 
         * @param includePlaceTypes
         *        The included place types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includePlaceTypesWithStrings(String... includePlaceTypes);

        /**
         * <p>
         * The included place types.
         * </p>
         * 
         * @param includePlaceTypes
         *        The included place types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includePlaceTypes(Collection<ReverseGeocodeFilterPlaceType> includePlaceTypes);

        /**
         * <p>
         * The included place types.
         * </p>
         * 
         * @param includePlaceTypes
         *        The included place types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includePlaceTypes(ReverseGeocodeFilterPlaceType... includePlaceTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> includePlaceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReverseGeocodeFilter model) {
            includePlaceTypesWithStrings(model.includePlaceTypes);
        }

        public final Collection<String> getIncludePlaceTypes() {
            if (includePlaceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return includePlaceTypes;
        }

        public final void setIncludePlaceTypes(Collection<String> includePlaceTypes) {
            this.includePlaceTypes = ReverseGeocodeFilterPlaceTypeListCopier.copy(includePlaceTypes);
        }

        @Override
        public final Builder includePlaceTypesWithStrings(Collection<String> includePlaceTypes) {
            this.includePlaceTypes = ReverseGeocodeFilterPlaceTypeListCopier.copy(includePlaceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includePlaceTypesWithStrings(String... includePlaceTypes) {
            includePlaceTypesWithStrings(Arrays.asList(includePlaceTypes));
            return this;
        }

        @Override
        public final Builder includePlaceTypes(Collection<ReverseGeocodeFilterPlaceType> includePlaceTypes) {
            this.includePlaceTypes = ReverseGeocodeFilterPlaceTypeListCopier.copyEnumToString(includePlaceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includePlaceTypes(ReverseGeocodeFilterPlaceType... includePlaceTypes) {
            includePlaceTypes(Arrays.asList(includePlaceTypes));
            return this;
        }

        @Override
        public ReverseGeocodeFilter build() {
            return new ReverseGeocodeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
