/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Components that correspond to secondary identifiers on an address. The only component type supported currently is
 * Unit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecondaryAddressComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<SecondaryAddressComponent.Builder, SecondaryAddressComponent> {
    private static final SdkField<String> NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Number")
            .getter(getter(SecondaryAddressComponent::number)).setter(setter(Builder::number))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Number").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String number;

    private SecondaryAddressComponent(BuilderImpl builder) {
        this.number = builder.number;
    }

    /**
     * <p>
     * Number that uniquely identifies a secondary address.
     * </p>
     * 
     * @return Number that uniquely identifies a secondary address.
     */
    public final String number() {
        return number;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(number());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondaryAddressComponent)) {
            return false;
        }
        SecondaryAddressComponent other = (SecondaryAddressComponent) obj;
        return Objects.equals(number(), other.number());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecondaryAddressComponent")
                .add("Number", number() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Number":
            return Optional.ofNullable(clazz.cast(number()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Number", NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondaryAddressComponent, T> g) {
        return obj -> g.apply((SecondaryAddressComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecondaryAddressComponent> {
        /**
         * <p>
         * Number that uniquely identifies a secondary address.
         * </p>
         * 
         * @param number
         *        Number that uniquely identifies a secondary address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder number(String number);
    }

    static final class BuilderImpl implements Builder {
        private String number;

        private BuilderImpl() {
        }

        private BuilderImpl(SecondaryAddressComponent model) {
            number(model.number);
        }

        public final String getNumber() {
            return number;
        }

        public final void setNumber(String number) {
            this.number = number;
        }

        @Override
        public final Builder number(String number) {
            this.number = number;
            return this;
        }

        @Override
        public SecondaryAddressComponent build() {
            return new SecondaryAddressComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
