/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Components of a street.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreetComponents implements SdkPojo, Serializable,
        ToCopyableBuilder<StreetComponents.Builder, StreetComponents> {
    private static final SdkField<String> BASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseName").getter(getter(StreetComponents::baseName)).setter(setter(Builder::baseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(StreetComponents::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> TYPE_PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypePlacement").getter(getter(StreetComponents::typePlacementAsString))
            .setter(setter(Builder::typePlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypePlacement").build()).build();

    private static final SdkField<String> TYPE_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeSeparator").getter(getter(StreetComponents::typeSeparator)).setter(setter(Builder::typeSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeSeparator").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(StreetComponents::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Suffix")
            .getter(getter(StreetComponents::suffix)).setter(setter(Builder::suffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suffix").build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(StreetComponents::direction)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(StreetComponents::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_NAME_FIELD, TYPE_FIELD,
            TYPE_PLACEMENT_FIELD, TYPE_SEPARATOR_FIELD, PREFIX_FIELD, SUFFIX_FIELD, DIRECTION_FIELD, LANGUAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String baseName;

    private final String type;

    private final String typePlacement;

    private final String typeSeparator;

    private final String prefix;

    private final String suffix;

    private final String direction;

    private final String language;

    private StreetComponents(BuilderImpl builder) {
        this.baseName = builder.baseName;
        this.type = builder.type;
        this.typePlacement = builder.typePlacement;
        this.typeSeparator = builder.typeSeparator;
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.direction = builder.direction;
        this.language = builder.language;
    }

    /**
     * <p>
     * Base name part of the street name.
     * </p>
     * <p>
     * Example: Younge from the "Younge street".
     * </p>
     * 
     * @return Base name part of the street name. </p>
     *         <p>
     *         Example: Younge from the "Younge street".
     */
    public final String baseName() {
        return baseName;
    }

    /**
     * <p>
     * Street type part of the street name.
     * </p>
     * <p>
     * Example: <code>"avenue"</code>.
     * </p>
     * 
     * @return Street type part of the street name. </p>
     *         <p>
     *         Example: <code>"avenue"</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * Defines if the street type is before or after the base name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typePlacement}
     * will return {@link TypePlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typePlacementAsString}.
     * </p>
     * 
     * @return Defines if the street type is before or after the base name.
     * @see TypePlacement
     */
    public final TypePlacement typePlacement() {
        return TypePlacement.fromValue(typePlacement);
    }

    /**
     * <p>
     * Defines if the street type is before or after the base name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typePlacement}
     * will return {@link TypePlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typePlacementAsString}.
     * </p>
     * 
     * @return Defines if the street type is before or after the base name.
     * @see TypePlacement
     */
    public final String typePlacementAsString() {
        return typePlacement;
    }

    /**
     * <p>
     * Defines a separator character such as <code>""</code> or <code>" "</code> between the base name and type.
     * </p>
     * 
     * @return Defines a separator character such as <code>""</code> or <code>" "</code> between the base name and type.
     */
    public final String typeSeparator() {
        return typeSeparator;
    }

    /**
     * <p>
     * A prefix is a directional identifier that precedes, but is not included in, the base name of a road.
     * </p>
     * <p>
     * Example: E for East.
     * </p>
     * 
     * @return A prefix is a directional identifier that precedes, but is not included in, the base name of a road. </p>
     *         <p>
     *         Example: E for East.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * A suffix is a directional identifier that follows, but is not included in, the base name of a road.
     * </p>
     * <p>
     * Example W for West.
     * </p>
     * 
     * @return A suffix is a directional identifier that follows, but is not included in, the base name of a road. </p>
     *         <p>
     *         Example W for West.
     */
    public final String suffix() {
        return suffix;
    }

    /**
     * <p>
     * Indicates the official directional identifiers assigned to highways.
     * </p>
     * 
     * @return Indicates the official directional identifiers assigned to highways.
     */
    public final String direction() {
        return direction;
    }

    /**
     * <p>
     * A <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for the results
     * to be rendered in. If there is no data for the result in the requested language, data will be returned in the
     * default language for the entry.
     * </p>
     * 
     * @return A <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for the
     *         results to be rendered in. If there is no data for the result in the requested language, data will be
     *         returned in the default language for the entry.
     */
    public final String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseName());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(typePlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(suffix());
        hashCode = 31 * hashCode + Objects.hashCode(direction());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreetComponents)) {
            return false;
        }
        StreetComponents other = (StreetComponents) obj;
        return Objects.equals(baseName(), other.baseName()) && Objects.equals(type(), other.type())
                && Objects.equals(typePlacementAsString(), other.typePlacementAsString())
                && Objects.equals(typeSeparator(), other.typeSeparator()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(suffix(), other.suffix()) && Objects.equals(direction(), other.direction())
                && Objects.equals(language(), other.language());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreetComponents")
                .add("BaseName", baseName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", type() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TypePlacement", typePlacementAsString()).add("TypeSeparator", typeSeparator())
                .add("Prefix", prefix() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Suffix", suffix() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Direction", direction() == null ? null : "*** Sensitive Data Redacted ***").add("Language", language())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseName":
            return Optional.ofNullable(clazz.cast(baseName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "TypePlacement":
            return Optional.ofNullable(clazz.cast(typePlacementAsString()));
        case "TypeSeparator":
            return Optional.ofNullable(clazz.cast(typeSeparator()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Suffix":
            return Optional.ofNullable(clazz.cast(suffix()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(direction()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseName", BASE_NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("TypePlacement", TYPE_PLACEMENT_FIELD);
        map.put("TypeSeparator", TYPE_SEPARATOR_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("Suffix", SUFFIX_FIELD);
        map.put("Direction", DIRECTION_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreetComponents, T> g) {
        return obj -> g.apply((StreetComponents) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreetComponents> {
        /**
         * <p>
         * Base name part of the street name.
         * </p>
         * <p>
         * Example: Younge from the "Younge street".
         * </p>
         * 
         * @param baseName
         *        Base name part of the street name. </p>
         *        <p>
         *        Example: Younge from the "Younge street".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseName(String baseName);

        /**
         * <p>
         * Street type part of the street name.
         * </p>
         * <p>
         * Example: <code>"avenue"</code>.
         * </p>
         * 
         * @param type
         *        Street type part of the street name. </p>
         *        <p>
         *        Example: <code>"avenue"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Defines if the street type is before or after the base name.
         * </p>
         * 
         * @param typePlacement
         *        Defines if the street type is before or after the base name.
         * @see TypePlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypePlacement
         */
        Builder typePlacement(String typePlacement);

        /**
         * <p>
         * Defines if the street type is before or after the base name.
         * </p>
         * 
         * @param typePlacement
         *        Defines if the street type is before or after the base name.
         * @see TypePlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TypePlacement
         */
        Builder typePlacement(TypePlacement typePlacement);

        /**
         * <p>
         * Defines a separator character such as <code>""</code> or <code>" "</code> between the base name and type.
         * </p>
         * 
         * @param typeSeparator
         *        Defines a separator character such as <code>""</code> or <code>" "</code> between the base name and
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeSeparator(String typeSeparator);

        /**
         * <p>
         * A prefix is a directional identifier that precedes, but is not included in, the base name of a road.
         * </p>
         * <p>
         * Example: E for East.
         * </p>
         * 
         * @param prefix
         *        A prefix is a directional identifier that precedes, but is not included in, the base name of a road.
         *        </p>
         *        <p>
         *        Example: E for East.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * A suffix is a directional identifier that follows, but is not included in, the base name of a road.
         * </p>
         * <p>
         * Example W for West.
         * </p>
         * 
         * @param suffix
         *        A suffix is a directional identifier that follows, but is not included in, the base name of a road.
         *        </p>
         *        <p>
         *        Example W for West.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suffix(String suffix);

        /**
         * <p>
         * Indicates the official directional identifiers assigned to highways.
         * </p>
         * 
         * @param direction
         *        Indicates the official directional identifiers assigned to highways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder direction(String direction);

        /**
         * <p>
         * A <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for the
         * results to be rendered in. If there is no data for the result in the requested language, data will be
         * returned in the default language for the entry.
         * </p>
         * 
         * @param language
         *        A <a href="https://en.wikipedia.org/wiki/IETF_language_tag">BCP 47</a> compliant language codes for
         *        the results to be rendered in. If there is no data for the result in the requested language, data will
         *        be returned in the default language for the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);
    }

    static final class BuilderImpl implements Builder {
        private String baseName;

        private String type;

        private String typePlacement;

        private String typeSeparator;

        private String prefix;

        private String suffix;

        private String direction;

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(StreetComponents model) {
            baseName(model.baseName);
            type(model.type);
            typePlacement(model.typePlacement);
            typeSeparator(model.typeSeparator);
            prefix(model.prefix);
            suffix(model.suffix);
            direction(model.direction);
            language(model.language);
        }

        public final String getBaseName() {
            return baseName;
        }

        public final void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        @Override
        public final Builder baseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getTypePlacement() {
            return typePlacement;
        }

        public final void setTypePlacement(String typePlacement) {
            this.typePlacement = typePlacement;
        }

        @Override
        public final Builder typePlacement(String typePlacement) {
            this.typePlacement = typePlacement;
            return this;
        }

        @Override
        public final Builder typePlacement(TypePlacement typePlacement) {
            this.typePlacement(typePlacement == null ? null : typePlacement.toString());
            return this;
        }

        public final String getTypeSeparator() {
            return typeSeparator;
        }

        public final void setTypeSeparator(String typeSeparator) {
            this.typeSeparator = typeSeparator;
        }

        @Override
        public final Builder typeSeparator(String typeSeparator) {
            this.typeSeparator = typeSeparator;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getSuffix() {
            return suffix;
        }

        public final void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public final Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public StreetComponents build() {
            return new StreetComponents(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
