/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoadSnapTracePoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoadSnapTracePoint> {
    private static final SdkField<Double> HEADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Heading").getter(RoadSnapTracePoint.getter(RoadSnapTracePoint::heading)).setter(RoadSnapTracePoint.setter(Builder::heading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(RoadSnapTracePoint.getter(RoadSnapTracePoint::position)).setter(RoadSnapTracePoint.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> SPEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Speed").getter(RoadSnapTracePoint.getter(RoadSnapTracePoint::speed)).setter(RoadSnapTracePoint.setter(Builder::speed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Speed").build()}).build();
    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timestamp").getter(RoadSnapTracePoint.getter(RoadSnapTracePoint::timestamp)).setter(RoadSnapTracePoint.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADING_FIELD, POSITION_FIELD, SPEED_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Heading", HEADING_FIELD);
            this.put("Position", POSITION_FIELD);
            this.put("Speed", SPEED_FIELD);
            this.put("Timestamp", TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double heading;
    private final List<Double> position;
    private final Double speed;
    private final String timestamp;

    private RoadSnapTracePoint(BuilderImpl builder) {
        this.heading = builder.heading;
        this.position = builder.position;
        this.speed = builder.speed;
        this.timestamp = builder.timestamp;
    }

    public final Double heading() {
        return this.heading;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final Double speed() {
        return this.speed;
    }

    public final String timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.heading());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.speed());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoadSnapTracePoint)) {
            return false;
        }
        RoadSnapTracePoint other = (RoadSnapTracePoint)obj;
        return Objects.equals(this.heading(), other.heading()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.speed(), other.speed()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"RoadSnapTracePoint").add("Heading", (Object)this.heading()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("Speed", (Object)this.speed()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Heading": {
                return Optional.ofNullable(clazz.cast(this.heading()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "Speed": {
                return Optional.ofNullable(clazz.cast(this.speed()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RoadSnapTracePoint, T> g) {
        return obj -> g.apply((RoadSnapTracePoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double heading;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private Double speed;
        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RoadSnapTracePoint model) {
            this.heading(model.heading);
            this.position(model.position);
            this.speed(model.speed);
            this.timestamp(model.timestamp);
        }

        public final Double getHeading() {
            return this.heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Double getSpeed() {
            return this.speed;
        }

        public final void setSpeed(Double speed) {
            this.speed = speed;
        }

        @Override
        public final Builder speed(Double speed) {
            this.speed = speed;
            return this;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public RoadSnapTracePoint build() {
            return new RoadSnapTracePoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoadSnapTracePoint> {
        public Builder heading(Double var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder speed(Double var1);

        public Builder timestamp(String var1);
    }
}

