/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.RouteAvoidanceArea;
import software.amazon.awssdk.services.georoutes.model.RouteAvoidanceAreaListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteAvoidanceZoneCategory;
import software.amazon.awssdk.services.georoutes.model.RouteAvoidanceZoneCategoryListCopier;
import software.amazon.awssdk.services.georoutes.model.TruckRoadTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteAvoidanceOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteAvoidanceOptions> {
    private static final SdkField<List<RouteAvoidanceArea>> AREAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Areas").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::areas)).setter(RouteAvoidanceOptions.setter(Builder::areas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Areas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteAvoidanceArea::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CAR_SHUTTLE_TRAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CarShuttleTrains").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::carShuttleTrains)).setter(RouteAvoidanceOptions.setter(Builder::carShuttleTrains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarShuttleTrains").build()}).build();
    private static final SdkField<Boolean> CONTROLLED_ACCESS_HIGHWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ControlledAccessHighways").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::controlledAccessHighways)).setter(RouteAvoidanceOptions.setter(Builder::controlledAccessHighways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlledAccessHighways").build()}).build();
    private static final SdkField<Boolean> DIRT_ROADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DirtRoads").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::dirtRoads)).setter(RouteAvoidanceOptions.setter(Builder::dirtRoads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirtRoads").build()}).build();
    private static final SdkField<Boolean> FERRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Ferries").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::ferries)).setter(RouteAvoidanceOptions.setter(Builder::ferries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ferries").build()}).build();
    private static final SdkField<Boolean> SEASONAL_CLOSURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SeasonalClosure").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::seasonalClosure)).setter(RouteAvoidanceOptions.setter(Builder::seasonalClosure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeasonalClosure").build()}).build();
    private static final SdkField<Boolean> TOLL_ROADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TollRoads").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::tollRoads)).setter(RouteAvoidanceOptions.setter(Builder::tollRoads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollRoads").build()}).build();
    private static final SdkField<Boolean> TOLL_TRANSPONDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TollTransponders").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::tollTransponders)).setter(RouteAvoidanceOptions.setter(Builder::tollTransponders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollTransponders").build()}).build();
    private static final SdkField<List<String>> TRUCK_ROAD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TruckRoadTypes").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::truckRoadTypes)).setter(RouteAvoidanceOptions.setter(Builder::truckRoadTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckRoadTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> TUNNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Tunnels").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::tunnels)).setter(RouteAvoidanceOptions.setter(Builder::tunnels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tunnels").build()}).build();
    private static final SdkField<Boolean> U_TURNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UTurns").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::uTurns)).setter(RouteAvoidanceOptions.setter(Builder::uTurns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UTurns").build()}).build();
    private static final SdkField<List<RouteAvoidanceZoneCategory>> ZONE_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ZoneCategories").getter(RouteAvoidanceOptions.getter(RouteAvoidanceOptions::zoneCategories)).setter(RouteAvoidanceOptions.setter(Builder::zoneCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteAvoidanceZoneCategory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREAS_FIELD, CAR_SHUTTLE_TRAINS_FIELD, CONTROLLED_ACCESS_HIGHWAYS_FIELD, DIRT_ROADS_FIELD, FERRIES_FIELD, SEASONAL_CLOSURE_FIELD, TOLL_ROADS_FIELD, TOLL_TRANSPONDERS_FIELD, TRUCK_ROAD_TYPES_FIELD, TUNNELS_FIELD, U_TURNS_FIELD, ZONE_CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Areas", AREAS_FIELD);
            this.put("CarShuttleTrains", CAR_SHUTTLE_TRAINS_FIELD);
            this.put("ControlledAccessHighways", CONTROLLED_ACCESS_HIGHWAYS_FIELD);
            this.put("DirtRoads", DIRT_ROADS_FIELD);
            this.put("Ferries", FERRIES_FIELD);
            this.put("SeasonalClosure", SEASONAL_CLOSURE_FIELD);
            this.put("TollRoads", TOLL_ROADS_FIELD);
            this.put("TollTransponders", TOLL_TRANSPONDERS_FIELD);
            this.put("TruckRoadTypes", TRUCK_ROAD_TYPES_FIELD);
            this.put("Tunnels", TUNNELS_FIELD);
            this.put("UTurns", U_TURNS_FIELD);
            this.put("ZoneCategories", ZONE_CATEGORIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<RouteAvoidanceArea> areas;
    private final Boolean carShuttleTrains;
    private final Boolean controlledAccessHighways;
    private final Boolean dirtRoads;
    private final Boolean ferries;
    private final Boolean seasonalClosure;
    private final Boolean tollRoads;
    private final Boolean tollTransponders;
    private final List<String> truckRoadTypes;
    private final Boolean tunnels;
    private final Boolean uTurns;
    private final List<RouteAvoidanceZoneCategory> zoneCategories;

    private RouteAvoidanceOptions(BuilderImpl builder) {
        this.areas = builder.areas;
        this.carShuttleTrains = builder.carShuttleTrains;
        this.controlledAccessHighways = builder.controlledAccessHighways;
        this.dirtRoads = builder.dirtRoads;
        this.ferries = builder.ferries;
        this.seasonalClosure = builder.seasonalClosure;
        this.tollRoads = builder.tollRoads;
        this.tollTransponders = builder.tollTransponders;
        this.truckRoadTypes = builder.truckRoadTypes;
        this.tunnels = builder.tunnels;
        this.uTurns = builder.uTurns;
        this.zoneCategories = builder.zoneCategories;
    }

    public final boolean hasAreas() {
        return this.areas != null && !(this.areas instanceof SdkAutoConstructList);
    }

    public final List<RouteAvoidanceArea> areas() {
        return this.areas;
    }

    public final Boolean carShuttleTrains() {
        return this.carShuttleTrains;
    }

    public final Boolean controlledAccessHighways() {
        return this.controlledAccessHighways;
    }

    public final Boolean dirtRoads() {
        return this.dirtRoads;
    }

    public final Boolean ferries() {
        return this.ferries;
    }

    public final Boolean seasonalClosure() {
        return this.seasonalClosure;
    }

    public final Boolean tollRoads() {
        return this.tollRoads;
    }

    public final Boolean tollTransponders() {
        return this.tollTransponders;
    }

    public final boolean hasTruckRoadTypes() {
        return this.truckRoadTypes != null && !(this.truckRoadTypes instanceof SdkAutoConstructList);
    }

    public final List<String> truckRoadTypes() {
        return this.truckRoadTypes;
    }

    public final Boolean tunnels() {
        return this.tunnels;
    }

    public final Boolean uTurns() {
        return this.uTurns;
    }

    public final boolean hasZoneCategories() {
        return this.zoneCategories != null && !(this.zoneCategories instanceof SdkAutoConstructList);
    }

    public final List<RouteAvoidanceZoneCategory> zoneCategories() {
        return this.zoneCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAreas() ? this.areas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.carShuttleTrains());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlledAccessHighways());
        hashCode = 31 * hashCode + Objects.hashCode(this.dirtRoads());
        hashCode = 31 * hashCode + Objects.hashCode(this.ferries());
        hashCode = 31 * hashCode + Objects.hashCode(this.seasonalClosure());
        hashCode = 31 * hashCode + Objects.hashCode(this.tollRoads());
        hashCode = 31 * hashCode + Objects.hashCode(this.tollTransponders());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTruckRoadTypes() ? this.truckRoadTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnels());
        hashCode = 31 * hashCode + Objects.hashCode(this.uTurns());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasZoneCategories() ? this.zoneCategories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAvoidanceOptions)) {
            return false;
        }
        RouteAvoidanceOptions other = (RouteAvoidanceOptions)obj;
        return this.hasAreas() == other.hasAreas() && Objects.equals(this.areas(), other.areas()) && Objects.equals(this.carShuttleTrains(), other.carShuttleTrains()) && Objects.equals(this.controlledAccessHighways(), other.controlledAccessHighways()) && Objects.equals(this.dirtRoads(), other.dirtRoads()) && Objects.equals(this.ferries(), other.ferries()) && Objects.equals(this.seasonalClosure(), other.seasonalClosure()) && Objects.equals(this.tollRoads(), other.tollRoads()) && Objects.equals(this.tollTransponders(), other.tollTransponders()) && this.hasTruckRoadTypes() == other.hasTruckRoadTypes() && Objects.equals(this.truckRoadTypes(), other.truckRoadTypes()) && Objects.equals(this.tunnels(), other.tunnels()) && Objects.equals(this.uTurns(), other.uTurns()) && this.hasZoneCategories() == other.hasZoneCategories() && Objects.equals(this.zoneCategories(), other.zoneCategories());
    }

    public final String toString() {
        return ToString.builder((String)"RouteAvoidanceOptions").add("Areas", this.hasAreas() ? this.areas() : null).add("CarShuttleTrains", (Object)this.carShuttleTrains()).add("ControlledAccessHighways", (Object)this.controlledAccessHighways()).add("DirtRoads", (Object)this.dirtRoads()).add("Ferries", (Object)this.ferries()).add("SeasonalClosure", (Object)this.seasonalClosure()).add("TollRoads", (Object)this.tollRoads()).add("TollTransponders", (Object)this.tollTransponders()).add("TruckRoadTypes", this.hasTruckRoadTypes() ? this.truckRoadTypes() : null).add("Tunnels", (Object)this.tunnels()).add("UTurns", (Object)this.uTurns()).add("ZoneCategories", this.hasZoneCategories() ? this.zoneCategories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Areas": {
                return Optional.ofNullable(clazz.cast(this.areas()));
            }
            case "CarShuttleTrains": {
                return Optional.ofNullable(clazz.cast(this.carShuttleTrains()));
            }
            case "ControlledAccessHighways": {
                return Optional.ofNullable(clazz.cast(this.controlledAccessHighways()));
            }
            case "DirtRoads": {
                return Optional.ofNullable(clazz.cast(this.dirtRoads()));
            }
            case "Ferries": {
                return Optional.ofNullable(clazz.cast(this.ferries()));
            }
            case "SeasonalClosure": {
                return Optional.ofNullable(clazz.cast(this.seasonalClosure()));
            }
            case "TollRoads": {
                return Optional.ofNullable(clazz.cast(this.tollRoads()));
            }
            case "TollTransponders": {
                return Optional.ofNullable(clazz.cast(this.tollTransponders()));
            }
            case "TruckRoadTypes": {
                return Optional.ofNullable(clazz.cast(this.truckRoadTypes()));
            }
            case "Tunnels": {
                return Optional.ofNullable(clazz.cast(this.tunnels()));
            }
            case "UTurns": {
                return Optional.ofNullable(clazz.cast(this.uTurns()));
            }
            case "ZoneCategories": {
                return Optional.ofNullable(clazz.cast(this.zoneCategories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RouteAvoidanceOptions, T> g) {
        return obj -> g.apply((RouteAvoidanceOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RouteAvoidanceArea> areas = DefaultSdkAutoConstructList.getInstance();
        private Boolean carShuttleTrains;
        private Boolean controlledAccessHighways;
        private Boolean dirtRoads;
        private Boolean ferries;
        private Boolean seasonalClosure;
        private Boolean tollRoads;
        private Boolean tollTransponders;
        private List<String> truckRoadTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean tunnels;
        private Boolean uTurns;
        private List<RouteAvoidanceZoneCategory> zoneCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAvoidanceOptions model) {
            this.areas(model.areas);
            this.carShuttleTrains(model.carShuttleTrains);
            this.controlledAccessHighways(model.controlledAccessHighways);
            this.dirtRoads(model.dirtRoads);
            this.ferries(model.ferries);
            this.seasonalClosure(model.seasonalClosure);
            this.tollRoads(model.tollRoads);
            this.tollTransponders(model.tollTransponders);
            this.truckRoadTypes(model.truckRoadTypes);
            this.tunnels(model.tunnels);
            this.uTurns(model.uTurns);
            this.zoneCategories(model.zoneCategories);
        }

        public final List<RouteAvoidanceArea.Builder> getAreas() {
            List<RouteAvoidanceArea.Builder> result = RouteAvoidanceAreaListCopier.copyToBuilder(this.areas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAreas(Collection<RouteAvoidanceArea.BuilderImpl> areas) {
            this.areas = RouteAvoidanceAreaListCopier.copyFromBuilder(areas);
        }

        @Override
        public final Builder areas(Collection<RouteAvoidanceArea> areas) {
            this.areas = RouteAvoidanceAreaListCopier.copy(areas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder areas(RouteAvoidanceArea ... areas) {
            this.areas(Arrays.asList(areas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder areas(Consumer<RouteAvoidanceArea.Builder> ... areas) {
            this.areas(Stream.of(areas).map(c -> (RouteAvoidanceArea)((RouteAvoidanceArea.Builder)RouteAvoidanceArea.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCarShuttleTrains() {
            return this.carShuttleTrains;
        }

        public final void setCarShuttleTrains(Boolean carShuttleTrains) {
            this.carShuttleTrains = carShuttleTrains;
        }

        @Override
        public final Builder carShuttleTrains(Boolean carShuttleTrains) {
            this.carShuttleTrains = carShuttleTrains;
            return this;
        }

        public final Boolean getControlledAccessHighways() {
            return this.controlledAccessHighways;
        }

        public final void setControlledAccessHighways(Boolean controlledAccessHighways) {
            this.controlledAccessHighways = controlledAccessHighways;
        }

        @Override
        public final Builder controlledAccessHighways(Boolean controlledAccessHighways) {
            this.controlledAccessHighways = controlledAccessHighways;
            return this;
        }

        public final Boolean getDirtRoads() {
            return this.dirtRoads;
        }

        public final void setDirtRoads(Boolean dirtRoads) {
            this.dirtRoads = dirtRoads;
        }

        @Override
        public final Builder dirtRoads(Boolean dirtRoads) {
            this.dirtRoads = dirtRoads;
            return this;
        }

        public final Boolean getFerries() {
            return this.ferries;
        }

        public final void setFerries(Boolean ferries) {
            this.ferries = ferries;
        }

        @Override
        public final Builder ferries(Boolean ferries) {
            this.ferries = ferries;
            return this;
        }

        public final Boolean getSeasonalClosure() {
            return this.seasonalClosure;
        }

        public final void setSeasonalClosure(Boolean seasonalClosure) {
            this.seasonalClosure = seasonalClosure;
        }

        @Override
        public final Builder seasonalClosure(Boolean seasonalClosure) {
            this.seasonalClosure = seasonalClosure;
            return this;
        }

        public final Boolean getTollRoads() {
            return this.tollRoads;
        }

        public final void setTollRoads(Boolean tollRoads) {
            this.tollRoads = tollRoads;
        }

        @Override
        public final Builder tollRoads(Boolean tollRoads) {
            this.tollRoads = tollRoads;
            return this;
        }

        public final Boolean getTollTransponders() {
            return this.tollTransponders;
        }

        public final void setTollTransponders(Boolean tollTransponders) {
            this.tollTransponders = tollTransponders;
        }

        @Override
        public final Builder tollTransponders(Boolean tollTransponders) {
            this.tollTransponders = tollTransponders;
            return this;
        }

        public final Collection<String> getTruckRoadTypes() {
            if (this.truckRoadTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.truckRoadTypes;
        }

        public final void setTruckRoadTypes(Collection<String> truckRoadTypes) {
            this.truckRoadTypes = TruckRoadTypeListCopier.copy(truckRoadTypes);
        }

        @Override
        public final Builder truckRoadTypes(Collection<String> truckRoadTypes) {
            this.truckRoadTypes = TruckRoadTypeListCopier.copy(truckRoadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckRoadTypes(String ... truckRoadTypes) {
            this.truckRoadTypes(Arrays.asList(truckRoadTypes));
            return this;
        }

        public final Boolean getTunnels() {
            return this.tunnels;
        }

        public final void setTunnels(Boolean tunnels) {
            this.tunnels = tunnels;
        }

        @Override
        public final Builder tunnels(Boolean tunnels) {
            this.tunnels = tunnels;
            return this;
        }

        public final Boolean getUTurns() {
            return this.uTurns;
        }

        public final void setUTurns(Boolean uTurns) {
            this.uTurns = uTurns;
        }

        @Override
        public final Builder uTurns(Boolean uTurns) {
            this.uTurns = uTurns;
            return this;
        }

        public final List<RouteAvoidanceZoneCategory.Builder> getZoneCategories() {
            List<RouteAvoidanceZoneCategory.Builder> result = RouteAvoidanceZoneCategoryListCopier.copyToBuilder(this.zoneCategories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setZoneCategories(Collection<RouteAvoidanceZoneCategory.BuilderImpl> zoneCategories) {
            this.zoneCategories = RouteAvoidanceZoneCategoryListCopier.copyFromBuilder(zoneCategories);
        }

        @Override
        public final Builder zoneCategories(Collection<RouteAvoidanceZoneCategory> zoneCategories) {
            this.zoneCategories = RouteAvoidanceZoneCategoryListCopier.copy(zoneCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zoneCategories(RouteAvoidanceZoneCategory ... zoneCategories) {
            this.zoneCategories(Arrays.asList(zoneCategories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zoneCategories(Consumer<RouteAvoidanceZoneCategory.Builder> ... zoneCategories) {
            this.zoneCategories(Stream.of(zoneCategories).map(c -> (RouteAvoidanceZoneCategory)((RouteAvoidanceZoneCategory.Builder)RouteAvoidanceZoneCategory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RouteAvoidanceOptions build() {
            return new RouteAvoidanceOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteAvoidanceOptions> {
        public Builder areas(Collection<RouteAvoidanceArea> var1);

        public Builder areas(RouteAvoidanceArea ... var1);

        public Builder areas(Consumer<RouteAvoidanceArea.Builder> ... var1);

        public Builder carShuttleTrains(Boolean var1);

        public Builder controlledAccessHighways(Boolean var1);

        public Builder dirtRoads(Boolean var1);

        public Builder ferries(Boolean var1);

        public Builder seasonalClosure(Boolean var1);

        public Builder tollRoads(Boolean var1);

        public Builder tollTransponders(Boolean var1);

        public Builder truckRoadTypes(Collection<String> var1);

        public Builder truckRoadTypes(String ... var1);

        public Builder tunnels(Boolean var1);

        public Builder uTurns(Boolean var1);

        public Builder zoneCategories(Collection<RouteAvoidanceZoneCategory> var1);

        public Builder zoneCategories(RouteAvoidanceZoneCategory ... var1);

        public Builder zoneCategories(Consumer<RouteAvoidanceZoneCategory.Builder> ... var1);
    }
}

