/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.TrafficUsage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteMatrixTrafficOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteMatrixTrafficOptions> {
    private static final SdkField<Long> FLOW_EVENT_THRESHOLD_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FlowEventThresholdOverride").getter(RouteMatrixTrafficOptions.getter(RouteMatrixTrafficOptions::flowEventThresholdOverride)).setter(RouteMatrixTrafficOptions.setter(Builder::flowEventThresholdOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowEventThresholdOverride").build()}).build();
    private static final SdkField<String> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Usage").getter(RouteMatrixTrafficOptions.getter(RouteMatrixTrafficOptions::usageAsString)).setter(RouteMatrixTrafficOptions.setter(Builder::usage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_EVENT_THRESHOLD_OVERRIDE_FIELD, USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FlowEventThresholdOverride", FLOW_EVENT_THRESHOLD_OVERRIDE_FIELD);
            this.put("Usage", USAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long flowEventThresholdOverride;
    private final String usage;

    private RouteMatrixTrafficOptions(BuilderImpl builder) {
        this.flowEventThresholdOverride = builder.flowEventThresholdOverride;
        this.usage = builder.usage;
    }

    public final Long flowEventThresholdOverride() {
        return this.flowEventThresholdOverride;
    }

    public final TrafficUsage usage() {
        return TrafficUsage.fromValue(this.usage);
    }

    public final String usageAsString() {
        return this.usage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowEventThresholdOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixTrafficOptions)) {
            return false;
        }
        RouteMatrixTrafficOptions other = (RouteMatrixTrafficOptions)obj;
        return Objects.equals(this.flowEventThresholdOverride(), other.flowEventThresholdOverride()) && Objects.equals(this.usageAsString(), other.usageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteMatrixTrafficOptions").add("FlowEventThresholdOverride", (Object)this.flowEventThresholdOverride()).add("Usage", (Object)this.usageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowEventThresholdOverride": {
                return Optional.ofNullable(clazz.cast(this.flowEventThresholdOverride()));
            }
            case "Usage": {
                return Optional.ofNullable(clazz.cast(this.usageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixTrafficOptions, T> g) {
        return obj -> g.apply((RouteMatrixTrafficOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long flowEventThresholdOverride;
        private String usage;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixTrafficOptions model) {
            this.flowEventThresholdOverride(model.flowEventThresholdOverride);
            this.usage(model.usage);
        }

        public final Long getFlowEventThresholdOverride() {
            return this.flowEventThresholdOverride;
        }

        public final void setFlowEventThresholdOverride(Long flowEventThresholdOverride) {
            this.flowEventThresholdOverride = flowEventThresholdOverride;
        }

        @Override
        public final Builder flowEventThresholdOverride(Long flowEventThresholdOverride) {
            this.flowEventThresholdOverride = flowEventThresholdOverride;
            return this;
        }

        public final String getUsage() {
            return this.usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public final Builder usage(TrafficUsage usage) {
            this.usage(usage == null ? null : usage.toString());
            return this;
        }

        public RouteMatrixTrafficOptions build() {
            return new RouteMatrixTrafficOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteMatrixTrafficOptions> {
        public Builder flowEventThresholdOverride(Long var1);

        public Builder usage(String var1);

        public Builder usage(TrafficUsage var1);
    }
}

