/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteLegAdditionalFeature {
    ELEVATION("Elevation"),
    INCIDENTS("Incidents"),
    PASS_THROUGH_WAYPOINTS("PassThroughWaypoints"),
    SUMMARY("Summary"),
    TOLLS("Tolls"),
    TRAVEL_STEP_INSTRUCTIONS("TravelStepInstructions"),
    TRUCK_ROAD_TYPES("TruckRoadTypes"),
    TYPICAL_DURATION("TypicalDuration"),
    ZONES("Zones"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteLegAdditionalFeature> VALUE_MAP;
    private final String value;

    private RouteLegAdditionalFeature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteLegAdditionalFeature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteLegAdditionalFeature> knownValues() {
        EnumSet<RouteLegAdditionalFeature> knownValues = EnumSet.allOf(RouteLegAdditionalFeature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteLegAdditionalFeature.class, RouteLegAdditionalFeature::toString);
    }
}

