/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesRequest;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationAvoidanceOptions;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationDestinationOptions;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationDriverOptions;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationExclusionOptions;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationOriginOptions;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationSequencingObjective;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationTrafficOptions;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationTravelMode;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationTravelModeOptions;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationWaypoint;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationWaypointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizeWaypointsRequest
extends GeoRoutesRequest
implements ToCopyableBuilder<Builder, OptimizeWaypointsRequest> {
    private static final SdkField<WaypointOptimizationAvoidanceOptions> AVOID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Avoid").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::avoid)).setter(OptimizeWaypointsRequest.setter(Builder::avoid)).constructor(WaypointOptimizationAvoidanceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avoid").build()}).build();
    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DepartureTime").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::departureTime)).setter(OptimizeWaypointsRequest.setter(Builder::departureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()}).build();
    private static final SdkField<List<Double>> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destination").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::destination)).setter(OptimizeWaypointsRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WaypointOptimizationDestinationOptions> DESTINATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationOptions").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::destinationOptions)).setter(OptimizeWaypointsRequest.setter(Builder::destinationOptions)).constructor(WaypointOptimizationDestinationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationOptions").build()}).build();
    private static final SdkField<WaypointOptimizationDriverOptions> DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Driver").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::driver)).setter(OptimizeWaypointsRequest.setter(Builder::driver)).constructor(WaypointOptimizationDriverOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Driver").build()}).build();
    private static final SdkField<WaypointOptimizationExclusionOptions> EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Exclude").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::exclude)).setter(OptimizeWaypointsRequest.setter(Builder::exclude)).constructor(WaypointOptimizationExclusionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::key)).setter(OptimizeWaypointsRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()}).build();
    private static final SdkField<String> OPTIMIZE_SEQUENCING_FOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizeSequencingFor").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::optimizeSequencingForAsString)).setter(OptimizeWaypointsRequest.setter(Builder::optimizeSequencingFor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeSequencingFor").build()}).build();
    private static final SdkField<List<Double>> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Origin").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::origin)).setter(OptimizeWaypointsRequest.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WaypointOptimizationOriginOptions> ORIGIN_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginOptions").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::originOptions)).setter(OptimizeWaypointsRequest.setter(Builder::originOptions)).constructor(WaypointOptimizationOriginOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginOptions").build()}).build();
    private static final SdkField<WaypointOptimizationTrafficOptions> TRAFFIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Traffic").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::traffic)).setter(OptimizeWaypointsRequest.setter(Builder::traffic)).constructor(WaypointOptimizationTrafficOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traffic").build()}).build();
    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TravelMode").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::travelModeAsString)).setter(OptimizeWaypointsRequest.setter(Builder::travelMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()}).build();
    private static final SdkField<WaypointOptimizationTravelModeOptions> TRAVEL_MODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TravelModeOptions").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::travelModeOptions)).setter(OptimizeWaypointsRequest.setter(Builder::travelModeOptions)).constructor(WaypointOptimizationTravelModeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelModeOptions").build()}).build();
    private static final SdkField<List<WaypointOptimizationWaypoint>> WAYPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Waypoints").getter(OptimizeWaypointsRequest.getter(OptimizeWaypointsRequest::waypoints)).setter(OptimizeWaypointsRequest.setter(Builder::waypoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Waypoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WaypointOptimizationWaypoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVOID_FIELD, DEPARTURE_TIME_FIELD, DESTINATION_FIELD, DESTINATION_OPTIONS_FIELD, DRIVER_FIELD, EXCLUDE_FIELD, KEY_FIELD, OPTIMIZE_SEQUENCING_FOR_FIELD, ORIGIN_FIELD, ORIGIN_OPTIONS_FIELD, TRAFFIC_FIELD, TRAVEL_MODE_FIELD, TRAVEL_MODE_OPTIONS_FIELD, WAYPOINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptimizeWaypointsRequest.memberNameToFieldInitializer();
    private final WaypointOptimizationAvoidanceOptions avoid;
    private final String departureTime;
    private final List<Double> destination;
    private final WaypointOptimizationDestinationOptions destinationOptions;
    private final WaypointOptimizationDriverOptions driver;
    private final WaypointOptimizationExclusionOptions exclude;
    private final String key;
    private final String optimizeSequencingFor;
    private final List<Double> origin;
    private final WaypointOptimizationOriginOptions originOptions;
    private final WaypointOptimizationTrafficOptions traffic;
    private final String travelMode;
    private final WaypointOptimizationTravelModeOptions travelModeOptions;
    private final List<WaypointOptimizationWaypoint> waypoints;

    private OptimizeWaypointsRequest(BuilderImpl builder) {
        super(builder);
        this.avoid = builder.avoid;
        this.departureTime = builder.departureTime;
        this.destination = builder.destination;
        this.destinationOptions = builder.destinationOptions;
        this.driver = builder.driver;
        this.exclude = builder.exclude;
        this.key = builder.key;
        this.optimizeSequencingFor = builder.optimizeSequencingFor;
        this.origin = builder.origin;
        this.originOptions = builder.originOptions;
        this.traffic = builder.traffic;
        this.travelMode = builder.travelMode;
        this.travelModeOptions = builder.travelModeOptions;
        this.waypoints = builder.waypoints;
    }

    public final WaypointOptimizationAvoidanceOptions avoid() {
        return this.avoid;
    }

    public final String departureTime() {
        return this.departureTime;
    }

    public final boolean hasDestination() {
        return this.destination != null && !(this.destination instanceof SdkAutoConstructList);
    }

    public final List<Double> destination() {
        return this.destination;
    }

    public final WaypointOptimizationDestinationOptions destinationOptions() {
        return this.destinationOptions;
    }

    public final WaypointOptimizationDriverOptions driver() {
        return this.driver;
    }

    public final WaypointOptimizationExclusionOptions exclude() {
        return this.exclude;
    }

    public final String key() {
        return this.key;
    }

    public final WaypointOptimizationSequencingObjective optimizeSequencingFor() {
        return WaypointOptimizationSequencingObjective.fromValue(this.optimizeSequencingFor);
    }

    public final String optimizeSequencingForAsString() {
        return this.optimizeSequencingFor;
    }

    public final boolean hasOrigin() {
        return this.origin != null && !(this.origin instanceof SdkAutoConstructList);
    }

    public final List<Double> origin() {
        return this.origin;
    }

    public final WaypointOptimizationOriginOptions originOptions() {
        return this.originOptions;
    }

    public final WaypointOptimizationTrafficOptions traffic() {
        return this.traffic;
    }

    public final WaypointOptimizationTravelMode travelMode() {
        return WaypointOptimizationTravelMode.fromValue(this.travelMode);
    }

    public final String travelModeAsString() {
        return this.travelMode;
    }

    public final WaypointOptimizationTravelModeOptions travelModeOptions() {
        return this.travelModeOptions;
    }

    public final boolean hasWaypoints() {
        return this.waypoints != null && !(this.waypoints instanceof SdkAutoConstructList);
    }

    public final List<WaypointOptimizationWaypoint> waypoints() {
        return this.waypoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.avoid());
        hashCode = 31 * hashCode + Objects.hashCode(this.departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestination() ? this.destination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.driver());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclude());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizeSequencingForAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrigin() ? this.origin() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.traffic());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWaypoints() ? this.waypoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizeWaypointsRequest)) {
            return false;
        }
        OptimizeWaypointsRequest other = (OptimizeWaypointsRequest)((Object)obj);
        return Objects.equals(this.avoid(), other.avoid()) && Objects.equals(this.departureTime(), other.departureTime()) && this.hasDestination() == other.hasDestination() && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationOptions(), other.destinationOptions()) && Objects.equals(this.driver(), other.driver()) && Objects.equals(this.exclude(), other.exclude()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.optimizeSequencingForAsString(), other.optimizeSequencingForAsString()) && this.hasOrigin() == other.hasOrigin() && Objects.equals(this.origin(), other.origin()) && Objects.equals(this.originOptions(), other.originOptions()) && Objects.equals(this.traffic(), other.traffic()) && Objects.equals(this.travelModeAsString(), other.travelModeAsString()) && Objects.equals(this.travelModeOptions(), other.travelModeOptions()) && this.hasWaypoints() == other.hasWaypoints() && Objects.equals(this.waypoints(), other.waypoints());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizeWaypointsRequest").add("Avoid", (Object)this.avoid()).add("DepartureTime", (Object)this.departureTime()).add("Destination", (Object)(this.destination() == null ? null : "*** Sensitive Data Redacted ***")).add("DestinationOptions", (Object)this.destinationOptions()).add("Driver", (Object)this.driver()).add("Exclude", (Object)this.exclude()).add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("OptimizeSequencingFor", (Object)this.optimizeSequencingForAsString()).add("Origin", (Object)(this.origin() == null ? null : "*** Sensitive Data Redacted ***")).add("OriginOptions", (Object)this.originOptions()).add("Traffic", (Object)this.traffic()).add("TravelMode", (Object)this.travelModeAsString()).add("TravelModeOptions", (Object)this.travelModeOptions()).add("Waypoints", this.hasWaypoints() ? this.waypoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Avoid": {
                return Optional.ofNullable(clazz.cast(this.avoid()));
            }
            case "DepartureTime": {
                return Optional.ofNullable(clazz.cast(this.departureTime()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationOptions": {
                return Optional.ofNullable(clazz.cast(this.destinationOptions()));
            }
            case "Driver": {
                return Optional.ofNullable(clazz.cast(this.driver()));
            }
            case "Exclude": {
                return Optional.ofNullable(clazz.cast(this.exclude()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "OptimizeSequencingFor": {
                return Optional.ofNullable(clazz.cast(this.optimizeSequencingForAsString()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.origin()));
            }
            case "OriginOptions": {
                return Optional.ofNullable(clazz.cast(this.originOptions()));
            }
            case "Traffic": {
                return Optional.ofNullable(clazz.cast(this.traffic()));
            }
            case "TravelMode": {
                return Optional.ofNullable(clazz.cast(this.travelModeAsString()));
            }
            case "TravelModeOptions": {
                return Optional.ofNullable(clazz.cast(this.travelModeOptions()));
            }
            case "Waypoints": {
                return Optional.ofNullable(clazz.cast(this.waypoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Avoid", AVOID_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("DestinationOptions", DESTINATION_OPTIONS_FIELD);
        map.put("Driver", DRIVER_FIELD);
        map.put("Exclude", EXCLUDE_FIELD);
        map.put("key", KEY_FIELD);
        map.put("OptimizeSequencingFor", OPTIMIZE_SEQUENCING_FOR_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("OriginOptions", ORIGIN_OPTIONS_FIELD);
        map.put("Traffic", TRAFFIC_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("TravelModeOptions", TRAVEL_MODE_OPTIONS_FIELD);
        map.put("Waypoints", WAYPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizeWaypointsRequest, T> g) {
        return obj -> g.apply((OptimizeWaypointsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesRequest.BuilderImpl
    implements Builder {
        private WaypointOptimizationAvoidanceOptions avoid;
        private String departureTime;
        private List<Double> destination = DefaultSdkAutoConstructList.getInstance();
        private WaypointOptimizationDestinationOptions destinationOptions;
        private WaypointOptimizationDriverOptions driver;
        private WaypointOptimizationExclusionOptions exclude;
        private String key;
        private String optimizeSequencingFor;
        private List<Double> origin = DefaultSdkAutoConstructList.getInstance();
        private WaypointOptimizationOriginOptions originOptions;
        private WaypointOptimizationTrafficOptions traffic;
        private String travelMode;
        private WaypointOptimizationTravelModeOptions travelModeOptions;
        private List<WaypointOptimizationWaypoint> waypoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizeWaypointsRequest model) {
            super(model);
            this.avoid(model.avoid);
            this.departureTime(model.departureTime);
            this.destination(model.destination);
            this.destinationOptions(model.destinationOptions);
            this.driver(model.driver);
            this.exclude(model.exclude);
            this.key(model.key);
            this.optimizeSequencingFor(model.optimizeSequencingFor);
            this.origin(model.origin);
            this.originOptions(model.originOptions);
            this.traffic(model.traffic);
            this.travelMode(model.travelMode);
            this.travelModeOptions(model.travelModeOptions);
            this.waypoints(model.waypoints);
        }

        public final WaypointOptimizationAvoidanceOptions.Builder getAvoid() {
            return this.avoid != null ? this.avoid.toBuilder() : null;
        }

        public final void setAvoid(WaypointOptimizationAvoidanceOptions.BuilderImpl avoid) {
            this.avoid = avoid != null ? avoid.build() : null;
        }

        @Override
        public final Builder avoid(WaypointOptimizationAvoidanceOptions avoid) {
            this.avoid = avoid;
            return this;
        }

        public final String getDepartureTime() {
            return this.departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final Collection<Double> getDestination() {
            if (this.destination instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destination;
        }

        public final void setDestination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
        }

        @Override
        public final Builder destination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destination(Double ... destination) {
            this.destination(Arrays.asList(destination));
            return this;
        }

        public final WaypointOptimizationDestinationOptions.Builder getDestinationOptions() {
            return this.destinationOptions != null ? this.destinationOptions.toBuilder() : null;
        }

        public final void setDestinationOptions(WaypointOptimizationDestinationOptions.BuilderImpl destinationOptions) {
            this.destinationOptions = destinationOptions != null ? destinationOptions.build() : null;
        }

        @Override
        public final Builder destinationOptions(WaypointOptimizationDestinationOptions destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        public final WaypointOptimizationDriverOptions.Builder getDriver() {
            return this.driver != null ? this.driver.toBuilder() : null;
        }

        public final void setDriver(WaypointOptimizationDriverOptions.BuilderImpl driver) {
            this.driver = driver != null ? driver.build() : null;
        }

        @Override
        public final Builder driver(WaypointOptimizationDriverOptions driver) {
            this.driver = driver;
            return this;
        }

        public final WaypointOptimizationExclusionOptions.Builder getExclude() {
            return this.exclude != null ? this.exclude.toBuilder() : null;
        }

        public final void setExclude(WaypointOptimizationExclusionOptions.BuilderImpl exclude) {
            this.exclude = exclude != null ? exclude.build() : null;
        }

        @Override
        public final Builder exclude(WaypointOptimizationExclusionOptions exclude) {
            this.exclude = exclude;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getOptimizeSequencingFor() {
            return this.optimizeSequencingFor;
        }

        public final void setOptimizeSequencingFor(String optimizeSequencingFor) {
            this.optimizeSequencingFor = optimizeSequencingFor;
        }

        @Override
        public final Builder optimizeSequencingFor(String optimizeSequencingFor) {
            this.optimizeSequencingFor = optimizeSequencingFor;
            return this;
        }

        @Override
        public final Builder optimizeSequencingFor(WaypointOptimizationSequencingObjective optimizeSequencingFor) {
            this.optimizeSequencingFor(optimizeSequencingFor == null ? null : optimizeSequencingFor.toString());
            return this;
        }

        public final Collection<Double> getOrigin() {
            if (this.origin instanceof SdkAutoConstructList) {
                return null;
            }
            return this.origin;
        }

        public final void setOrigin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
        }

        @Override
        public final Builder origin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origin(Double ... origin) {
            this.origin(Arrays.asList(origin));
            return this;
        }

        public final WaypointOptimizationOriginOptions.Builder getOriginOptions() {
            return this.originOptions != null ? this.originOptions.toBuilder() : null;
        }

        public final void setOriginOptions(WaypointOptimizationOriginOptions.BuilderImpl originOptions) {
            this.originOptions = originOptions != null ? originOptions.build() : null;
        }

        @Override
        public final Builder originOptions(WaypointOptimizationOriginOptions originOptions) {
            this.originOptions = originOptions;
            return this;
        }

        public final WaypointOptimizationTrafficOptions.Builder getTraffic() {
            return this.traffic != null ? this.traffic.toBuilder() : null;
        }

        public final void setTraffic(WaypointOptimizationTrafficOptions.BuilderImpl traffic) {
            this.traffic = traffic != null ? traffic.build() : null;
        }

        @Override
        public final Builder traffic(WaypointOptimizationTrafficOptions traffic) {
            this.traffic = traffic;
            return this;
        }

        public final String getTravelMode() {
            return this.travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(WaypointOptimizationTravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final WaypointOptimizationTravelModeOptions.Builder getTravelModeOptions() {
            return this.travelModeOptions != null ? this.travelModeOptions.toBuilder() : null;
        }

        public final void setTravelModeOptions(WaypointOptimizationTravelModeOptions.BuilderImpl travelModeOptions) {
            this.travelModeOptions = travelModeOptions != null ? travelModeOptions.build() : null;
        }

        @Override
        public final Builder travelModeOptions(WaypointOptimizationTravelModeOptions travelModeOptions) {
            this.travelModeOptions = travelModeOptions;
            return this;
        }

        public final List<WaypointOptimizationWaypoint.Builder> getWaypoints() {
            List<WaypointOptimizationWaypoint.Builder> result = WaypointOptimizationWaypointListCopier.copyToBuilder(this.waypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWaypoints(Collection<WaypointOptimizationWaypoint.BuilderImpl> waypoints) {
            this.waypoints = WaypointOptimizationWaypointListCopier.copyFromBuilder(waypoints);
        }

        @Override
        public final Builder waypoints(Collection<WaypointOptimizationWaypoint> waypoints) {
            this.waypoints = WaypointOptimizationWaypointListCopier.copy(waypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waypoints(WaypointOptimizationWaypoint ... waypoints) {
            this.waypoints(Arrays.asList(waypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waypoints(Consumer<WaypointOptimizationWaypoint.Builder> ... waypoints) {
            this.waypoints(Stream.of(waypoints).map(c -> (WaypointOptimizationWaypoint)((WaypointOptimizationWaypoint.Builder)WaypointOptimizationWaypoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OptimizeWaypointsRequest build() {
            return new OptimizeWaypointsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoRoutesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, OptimizeWaypointsRequest> {
        public Builder avoid(WaypointOptimizationAvoidanceOptions var1);

        default public Builder avoid(Consumer<WaypointOptimizationAvoidanceOptions.Builder> avoid) {
            return this.avoid((WaypointOptimizationAvoidanceOptions)((WaypointOptimizationAvoidanceOptions.Builder)WaypointOptimizationAvoidanceOptions.builder().applyMutation(avoid)).build());
        }

        public Builder departureTime(String var1);

        public Builder destination(Collection<Double> var1);

        public Builder destination(Double ... var1);

        public Builder destinationOptions(WaypointOptimizationDestinationOptions var1);

        default public Builder destinationOptions(Consumer<WaypointOptimizationDestinationOptions.Builder> destinationOptions) {
            return this.destinationOptions((WaypointOptimizationDestinationOptions)((WaypointOptimizationDestinationOptions.Builder)WaypointOptimizationDestinationOptions.builder().applyMutation(destinationOptions)).build());
        }

        public Builder driver(WaypointOptimizationDriverOptions var1);

        default public Builder driver(Consumer<WaypointOptimizationDriverOptions.Builder> driver) {
            return this.driver((WaypointOptimizationDriverOptions)((WaypointOptimizationDriverOptions.Builder)WaypointOptimizationDriverOptions.builder().applyMutation(driver)).build());
        }

        public Builder exclude(WaypointOptimizationExclusionOptions var1);

        default public Builder exclude(Consumer<WaypointOptimizationExclusionOptions.Builder> exclude) {
            return this.exclude((WaypointOptimizationExclusionOptions)((WaypointOptimizationExclusionOptions.Builder)WaypointOptimizationExclusionOptions.builder().applyMutation(exclude)).build());
        }

        public Builder key(String var1);

        public Builder optimizeSequencingFor(String var1);

        public Builder optimizeSequencingFor(WaypointOptimizationSequencingObjective var1);

        public Builder origin(Collection<Double> var1);

        public Builder origin(Double ... var1);

        public Builder originOptions(WaypointOptimizationOriginOptions var1);

        default public Builder originOptions(Consumer<WaypointOptimizationOriginOptions.Builder> originOptions) {
            return this.originOptions((WaypointOptimizationOriginOptions)((WaypointOptimizationOriginOptions.Builder)WaypointOptimizationOriginOptions.builder().applyMutation(originOptions)).build());
        }

        public Builder traffic(WaypointOptimizationTrafficOptions var1);

        default public Builder traffic(Consumer<WaypointOptimizationTrafficOptions.Builder> traffic) {
            return this.traffic((WaypointOptimizationTrafficOptions)((WaypointOptimizationTrafficOptions.Builder)WaypointOptimizationTrafficOptions.builder().applyMutation(traffic)).build());
        }

        public Builder travelMode(String var1);

        public Builder travelMode(WaypointOptimizationTravelMode var1);

        public Builder travelModeOptions(WaypointOptimizationTravelModeOptions var1);

        default public Builder travelModeOptions(Consumer<WaypointOptimizationTravelModeOptions.Builder> travelModeOptions) {
            return this.travelModeOptions((WaypointOptimizationTravelModeOptions)((WaypointOptimizationTravelModeOptions.Builder)WaypointOptimizationTravelModeOptions.builder().applyMutation(travelModeOptions)).build());
        }

        public Builder waypoints(Collection<WaypointOptimizationWaypoint> var1);

        public Builder waypoints(WaypointOptimizationWaypoint ... var1);

        public Builder waypoints(Consumer<WaypointOptimizationWaypoint.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

