/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.LocalizedString;
import software.amazon.awssdk.services.georoutes.model.LocalizedStringListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteNumber;
import software.amazon.awssdk.services.georoutes.model.RouteNumberListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteRoadType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteRoad
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteRoad> {
    private static final SdkField<List<LocalizedString>> ROAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RoadName").getter(RouteRoad.getter(RouteRoad::roadName)).setter(RouteRoad.setter(Builder::roadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoadName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteNumber>> ROUTE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteNumber").getter(RouteRoad.getter(RouteRoad::routeNumber)).setter(RouteRoad.setter(Builder::routeNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteNumber").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LocalizedString>> TOWARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Towards").getter(RouteRoad.getter(RouteRoad::towards)).setter(RouteRoad.setter(Builder::towards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Towards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RouteRoad.getter(RouteRoad::typeAsString)).setter(RouteRoad.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROAD_NAME_FIELD, ROUTE_NUMBER_FIELD, TOWARDS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteRoad.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<LocalizedString> roadName;
    private final List<RouteNumber> routeNumber;
    private final List<LocalizedString> towards;
    private final String type;

    private RouteRoad(BuilderImpl builder) {
        this.roadName = builder.roadName;
        this.routeNumber = builder.routeNumber;
        this.towards = builder.towards;
        this.type = builder.type;
    }

    public final boolean hasRoadName() {
        return this.roadName != null && !(this.roadName instanceof SdkAutoConstructList);
    }

    public final List<LocalizedString> roadName() {
        return this.roadName;
    }

    public final boolean hasRouteNumber() {
        return this.routeNumber != null && !(this.routeNumber instanceof SdkAutoConstructList);
    }

    public final List<RouteNumber> routeNumber() {
        return this.routeNumber;
    }

    public final boolean hasTowards() {
        return this.towards != null && !(this.towards instanceof SdkAutoConstructList);
    }

    public final List<LocalizedString> towards() {
        return this.towards;
    }

    public final RouteRoadType type() {
        return RouteRoadType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoadName() ? this.roadName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteNumber() ? this.routeNumber() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTowards() ? this.towards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteRoad)) {
            return false;
        }
        RouteRoad other = (RouteRoad)obj;
        return this.hasRoadName() == other.hasRoadName() && Objects.equals(this.roadName(), other.roadName()) && this.hasRouteNumber() == other.hasRouteNumber() && Objects.equals(this.routeNumber(), other.routeNumber()) && this.hasTowards() == other.hasTowards() && Objects.equals(this.towards(), other.towards()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteRoad").add("RoadName", this.hasRoadName() ? this.roadName() : null).add("RouteNumber", this.hasRouteNumber() ? this.routeNumber() : null).add("Towards", this.hasTowards() ? this.towards() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoadName": {
                return Optional.ofNullable(clazz.cast(this.roadName()));
            }
            case "RouteNumber": {
                return Optional.ofNullable(clazz.cast(this.routeNumber()));
            }
            case "Towards": {
                return Optional.ofNullable(clazz.cast(this.towards()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoadName", ROAD_NAME_FIELD);
        map.put("RouteNumber", ROUTE_NUMBER_FIELD);
        map.put("Towards", TOWARDS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteRoad, T> g) {
        return obj -> g.apply((RouteRoad)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LocalizedString> roadName = DefaultSdkAutoConstructList.getInstance();
        private List<RouteNumber> routeNumber = DefaultSdkAutoConstructList.getInstance();
        private List<LocalizedString> towards = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteRoad model) {
            this.roadName(model.roadName);
            this.routeNumber(model.routeNumber);
            this.towards(model.towards);
            this.type(model.type);
        }

        public final List<LocalizedString.Builder> getRoadName() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.roadName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoadName(Collection<LocalizedString.BuilderImpl> roadName) {
            this.roadName = LocalizedStringListCopier.copyFromBuilder(roadName);
        }

        @Override
        public final Builder roadName(Collection<LocalizedString> roadName) {
            this.roadName = LocalizedStringListCopier.copy(roadName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadName(LocalizedString ... roadName) {
            this.roadName(Arrays.asList(roadName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadName(Consumer<LocalizedString.Builder> ... roadName) {
            this.roadName(Stream.of(roadName).map(c -> (LocalizedString)((LocalizedString.Builder)LocalizedString.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteNumber.Builder> getRouteNumber() {
            List<RouteNumber.Builder> result = RouteNumberListCopier.copyToBuilder(this.routeNumber);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteNumber(Collection<RouteNumber.BuilderImpl> routeNumber) {
            this.routeNumber = RouteNumberListCopier.copyFromBuilder(routeNumber);
        }

        @Override
        public final Builder routeNumber(Collection<RouteNumber> routeNumber) {
            this.routeNumber = RouteNumberListCopier.copy(routeNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumber(RouteNumber ... routeNumber) {
            this.routeNumber(Arrays.asList(routeNumber));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumber(Consumer<RouteNumber.Builder> ... routeNumber) {
            this.routeNumber(Stream.of(routeNumber).map(c -> (RouteNumber)((RouteNumber.Builder)RouteNumber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LocalizedString.Builder> getTowards() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.towards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTowards(Collection<LocalizedString.BuilderImpl> towards) {
            this.towards = LocalizedStringListCopier.copyFromBuilder(towards);
        }

        @Override
        public final Builder towards(Collection<LocalizedString> towards) {
            this.towards = LocalizedStringListCopier.copy(towards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder towards(LocalizedString ... towards) {
            this.towards(Arrays.asList(towards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder towards(Consumer<LocalizedString.Builder> ... towards) {
            this.towards(Stream.of(towards).map(c -> (LocalizedString)((LocalizedString.Builder)LocalizedString.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RouteRoadType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RouteRoad build() {
            return new RouteRoad(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteRoad> {
        public Builder roadName(Collection<LocalizedString> var1);

        public Builder roadName(LocalizedString ... var1);

        public Builder roadName(Consumer<LocalizedString.Builder> ... var1);

        public Builder routeNumber(Collection<RouteNumber> var1);

        public Builder routeNumber(RouteNumber ... var1);

        public Builder routeNumber(Consumer<RouteNumber.Builder> ... var1);

        public Builder towards(Collection<LocalizedString> var1);

        public Builder towards(LocalizedString ... var1);

        public Builder towards(Consumer<LocalizedString.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(RouteRoadType var1);
    }
}

