/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteTollPaymentMethod {
    BANK_CARD("BankCard"),
    CASH("Cash"),
    CASH_EXACT("CashExact"),
    CREDIT_CARD("CreditCard"),
    PASS_SUBSCRIPTION("PassSubscription"),
    TRAVEL_CARD("TravelCard"),
    TRANSPONDER("Transponder"),
    VIDEO_TOLL("VideoToll"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteTollPaymentMethod> VALUE_MAP;
    private final String value;

    private RouteTollPaymentMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteTollPaymentMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteTollPaymentMethod> knownValues() {
        EnumSet<RouteTollPaymentMethod> knownValues = EnumSet.allOf(RouteTollPaymentMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteTollPaymentMethod.class, RouteTollPaymentMethod::toString);
    }
}

