/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.RouteNoticeImpact;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleNoticeCode;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleNoticeDetail;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleNoticeDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteVehicleNotice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteVehicleNotice> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(RouteVehicleNotice.getter(RouteVehicleNotice::codeAsString)).setter(RouteVehicleNotice.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<List<RouteVehicleNoticeDetail>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Details").getter(RouteVehicleNotice.getter(RouteVehicleNotice::details)).setter(RouteVehicleNotice.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteVehicleNoticeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Impact").getter(RouteVehicleNotice.getter(RouteVehicleNotice::impactAsString)).setter(RouteVehicleNotice.setter(Builder::impact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Impact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, DETAILS_FIELD, IMPACT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteVehicleNotice.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String code;
    private final List<RouteVehicleNoticeDetail> details;
    private final String impact;

    private RouteVehicleNotice(BuilderImpl builder) {
        this.code = builder.code;
        this.details = builder.details;
        this.impact = builder.impact;
    }

    public final RouteVehicleNoticeCode code() {
        return RouteVehicleNoticeCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructList);
    }

    public final List<RouteVehicleNoticeDetail> details() {
        return this.details;
    }

    public final RouteNoticeImpact impact() {
        return RouteNoticeImpact.fromValue(this.impact);
    }

    public final String impactAsString() {
        return this.impact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetails() ? this.details() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.impactAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleNotice)) {
            return false;
        }
        RouteVehicleNotice other = (RouteVehicleNotice)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString()) && this.hasDetails() == other.hasDetails() && Objects.equals(this.details(), other.details()) && Objects.equals(this.impactAsString(), other.impactAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteVehicleNotice").add("Code", (Object)this.codeAsString()).add("Details", this.hasDetails() ? this.details() : null).add("Impact", (Object)this.impactAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "Impact": {
                return Optional.ofNullable(clazz.cast(this.impactAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Code", CODE_FIELD);
        map.put("Details", DETAILS_FIELD);
        map.put("Impact", IMPACT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleNotice, T> g) {
        return obj -> g.apply((RouteVehicleNotice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private List<RouteVehicleNoticeDetail> details = DefaultSdkAutoConstructList.getInstance();
        private String impact;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleNotice model) {
            this.code(model.code);
            this.details(model.details);
            this.impact(model.impact);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(RouteVehicleNoticeCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final List<RouteVehicleNoticeDetail.Builder> getDetails() {
            List<RouteVehicleNoticeDetail.Builder> result = RouteVehicleNoticeDetailListCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<RouteVehicleNoticeDetail.BuilderImpl> details) {
            this.details = RouteVehicleNoticeDetailListCopier.copyFromBuilder(details);
        }

        @Override
        public final Builder details(Collection<RouteVehicleNoticeDetail> details) {
            this.details = RouteVehicleNoticeDetailListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(RouteVehicleNoticeDetail ... details) {
            this.details(Arrays.asList(details));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(Consumer<RouteVehicleNoticeDetail.Builder> ... details) {
            this.details(Stream.of(details).map(c -> (RouteVehicleNoticeDetail)((RouteVehicleNoticeDetail.Builder)RouteVehicleNoticeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImpact() {
            return this.impact;
        }

        public final void setImpact(String impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(String impact) {
            this.impact = impact;
            return this;
        }

        @Override
        public final Builder impact(RouteNoticeImpact impact) {
            this.impact(impact == null ? null : impact.toString());
            return this;
        }

        public RouteVehicleNotice build() {
            return new RouteVehicleNotice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteVehicleNotice> {
        public Builder code(String var1);

        public Builder code(RouteVehicleNoticeCode var1);

        public Builder details(Collection<RouteVehicleNoticeDetail> var1);

        public Builder details(RouteVehicleNoticeDetail ... var1);

        public Builder details(Consumer<RouteVehicleNoticeDetail.Builder> ... var1);

        public Builder impact(String var1);

        public Builder impact(RouteNoticeImpact var1);
    }
}

