/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesResponse;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixBoundary;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixCopier;
import software.amazon.awssdk.services.georoutes.model.RouteMatrixEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CalculateRouteMatrixResponse
extends GeoRoutesResponse
implements ToCopyableBuilder<Builder, CalculateRouteMatrixResponse> {
    private static final SdkField<Integer> ERROR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ErrorCount").getter(CalculateRouteMatrixResponse.getter(CalculateRouteMatrixResponse::errorCount)).setter(CalculateRouteMatrixResponse.setter(Builder::errorCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCount").build()}).build();
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingBucket").getter(CalculateRouteMatrixResponse.getter(CalculateRouteMatrixResponse::pricingBucket)).setter(CalculateRouteMatrixResponse.setter(Builder::pricingBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build()}).build();
    private static final SdkField<List<List<RouteMatrixEntry>>> ROUTE_MATRIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteMatrix").getter(CalculateRouteMatrixResponse.getter(CalculateRouteMatrixResponse::routeMatrix)).setter(CalculateRouteMatrixResponse.setter(Builder::routeMatrix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteMatrix").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteMatrixEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<RouteMatrixBoundary> ROUTING_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingBoundary").getter(CalculateRouteMatrixResponse.getter(CalculateRouteMatrixResponse::routingBoundary)).setter(CalculateRouteMatrixResponse.setter(Builder::routingBoundary)).constructor(RouteMatrixBoundary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingBoundary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_COUNT_FIELD, PRICING_BUCKET_FIELD, ROUTE_MATRIX_FIELD, ROUTING_BOUNDARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CalculateRouteMatrixResponse.memberNameToFieldInitializer();
    private final Integer errorCount;
    private final String pricingBucket;
    private final List<List<RouteMatrixEntry>> routeMatrix;
    private final RouteMatrixBoundary routingBoundary;

    private CalculateRouteMatrixResponse(BuilderImpl builder) {
        super(builder);
        this.errorCount = builder.errorCount;
        this.pricingBucket = builder.pricingBucket;
        this.routeMatrix = builder.routeMatrix;
        this.routingBoundary = builder.routingBoundary;
    }

    public final Integer errorCount() {
        return this.errorCount;
    }

    public final String pricingBucket() {
        return this.pricingBucket;
    }

    public final boolean hasRouteMatrix() {
        return this.routeMatrix != null && !(this.routeMatrix instanceof SdkAutoConstructList);
    }

    public final List<List<RouteMatrixEntry>> routeMatrix() {
        return this.routeMatrix;
    }

    public final RouteMatrixBoundary routingBoundary() {
        return this.routingBoundary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteMatrix() ? this.routeMatrix() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routingBoundary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRouteMatrixResponse)) {
            return false;
        }
        CalculateRouteMatrixResponse other = (CalculateRouteMatrixResponse)((Object)obj);
        return Objects.equals(this.errorCount(), other.errorCount()) && Objects.equals(this.pricingBucket(), other.pricingBucket()) && this.hasRouteMatrix() == other.hasRouteMatrix() && Objects.equals(this.routeMatrix(), other.routeMatrix()) && Objects.equals(this.routingBoundary(), other.routingBoundary());
    }

    public final String toString() {
        return ToString.builder((String)"CalculateRouteMatrixResponse").add("ErrorCount", (Object)this.errorCount()).add("PricingBucket", (Object)this.pricingBucket()).add("RouteMatrix", this.hasRouteMatrix() ? this.routeMatrix() : null).add("RoutingBoundary", (Object)this.routingBoundary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCount": {
                return Optional.ofNullable(clazz.cast(this.errorCount()));
            }
            case "PricingBucket": {
                return Optional.ofNullable(clazz.cast(this.pricingBucket()));
            }
            case "RouteMatrix": {
                return Optional.ofNullable(clazz.cast(this.routeMatrix()));
            }
            case "RoutingBoundary": {
                return Optional.ofNullable(clazz.cast(this.routingBoundary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ErrorCount", ERROR_COUNT_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("RouteMatrix", ROUTE_MATRIX_FIELD);
        map.put("RoutingBoundary", ROUTING_BOUNDARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRouteMatrixResponse, T> g) {
        return obj -> g.apply((CalculateRouteMatrixResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesResponse.BuilderImpl
    implements Builder {
        private Integer errorCount;
        private String pricingBucket;
        private List<List<RouteMatrixEntry>> routeMatrix = DefaultSdkAutoConstructList.getInstance();
        private RouteMatrixBoundary routingBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRouteMatrixResponse model) {
            super(model);
            this.errorCount(model.errorCount);
            this.pricingBucket(model.pricingBucket);
            this.routeMatrix(model.routeMatrix);
            this.routingBoundary(model.routingBoundary);
        }

        public final Integer getErrorCount() {
            return this.errorCount;
        }

        public final void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        @Override
        public final Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final String getPricingBucket() {
            return this.pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<List<RouteMatrixEntry.Builder>> getRouteMatrix() {
            List<List<RouteMatrixEntry.Builder>> result = RouteMatrixCopier.copyToBuilder(this.routeMatrix);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteMatrix(Collection<? extends Collection<RouteMatrixEntry.BuilderImpl>> routeMatrix) {
            this.routeMatrix = RouteMatrixCopier.copyFromBuilder(routeMatrix);
        }

        @Override
        public final Builder routeMatrix(Collection<? extends Collection<RouteMatrixEntry>> routeMatrix) {
            this.routeMatrix = RouteMatrixCopier.copy(routeMatrix);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeMatrix(Collection<RouteMatrixEntry> ... routeMatrix) {
            this.routeMatrix((Collection<? extends Collection<RouteMatrixEntry>>)Arrays.asList(routeMatrix));
            return this;
        }

        public final RouteMatrixBoundary.Builder getRoutingBoundary() {
            return this.routingBoundary != null ? this.routingBoundary.toBuilder() : null;
        }

        public final void setRoutingBoundary(RouteMatrixBoundary.BuilderImpl routingBoundary) {
            this.routingBoundary = routingBoundary != null ? routingBoundary.build() : null;
        }

        @Override
        public final Builder routingBoundary(RouteMatrixBoundary routingBoundary) {
            this.routingBoundary = routingBoundary;
            return this;
        }

        @Override
        public CalculateRouteMatrixResponse build() {
            return new CalculateRouteMatrixResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoRoutesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CalculateRouteMatrixResponse> {
        public Builder errorCount(Integer var1);

        public Builder pricingBucket(String var1);

        public Builder routeMatrix(Collection<? extends Collection<RouteMatrixEntry>> var1);

        public Builder routeMatrix(Collection<RouteMatrixEntry> ... var1);

        public Builder routingBoundary(RouteMatrixBoundary var1);

        default public Builder routingBoundary(Consumer<RouteMatrixBoundary.Builder> routingBoundary) {
            return this.routingBoundary((RouteMatrixBoundary)((RouteMatrixBoundary.Builder)RouteMatrixBoundary.builder().applyMutation(routingBoundary)).build());
        }
    }
}

