/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.PositionCopier;
import software.amazon.awssdk.services.georoutes.model.RouteMatchingOptions;
import software.amazon.awssdk.services.georoutes.model.RouteSideOfStreetOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteWaypoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteWaypoint> {
    private static final SdkField<Long> AVOID_ACTIONS_FOR_DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AvoidActionsForDistance").getter(RouteWaypoint.getter(RouteWaypoint::avoidActionsForDistance)).setter(RouteWaypoint.setter(Builder::avoidActionsForDistance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidActionsForDistance").build()}).build();
    private static final SdkField<Boolean> AVOID_U_TURNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AvoidUTurns").getter(RouteWaypoint.getter(RouteWaypoint::avoidUTurns)).setter(RouteWaypoint.setter(Builder::avoidUTurns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvoidUTurns").build()}).build();
    private static final SdkField<Double> HEADING_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Heading").getter(RouteWaypoint.getter(RouteWaypoint::heading)).setter(RouteWaypoint.setter(Builder::heading)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()}).build();
    private static final SdkField<RouteMatchingOptions> MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Matching").getter(RouteWaypoint.getter(RouteWaypoint::matching)).setter(RouteWaypoint.setter(Builder::matching)).constructor(RouteMatchingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matching").build()}).build();
    private static final SdkField<Boolean> PASS_THROUGH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PassThrough").getter(RouteWaypoint.getter(RouteWaypoint::passThrough)).setter(RouteWaypoint.setter(Builder::passThrough)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PassThrough").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(RouteWaypoint.getter(RouteWaypoint::position)).setter(RouteWaypoint.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteSideOfStreetOptions> SIDE_OF_STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SideOfStreet").getter(RouteWaypoint.getter(RouteWaypoint::sideOfStreet)).setter(RouteWaypoint.setter(Builder::sideOfStreet)).constructor(RouteSideOfStreetOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SideOfStreet").build()}).build();
    private static final SdkField<Long> STOP_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StopDuration").getter(RouteWaypoint.getter(RouteWaypoint::stopDuration)).setter(RouteWaypoint.setter(Builder::stopDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVOID_ACTIONS_FOR_DISTANCE_FIELD, AVOID_U_TURNS_FIELD, HEADING_FIELD, MATCHING_FIELD, PASS_THROUGH_FIELD, POSITION_FIELD, SIDE_OF_STREET_FIELD, STOP_DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteWaypoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long avoidActionsForDistance;
    private final Boolean avoidUTurns;
    private final Double heading;
    private final RouteMatchingOptions matching;
    private final Boolean passThrough;
    private final List<Double> position;
    private final RouteSideOfStreetOptions sideOfStreet;
    private final Long stopDuration;

    private RouteWaypoint(BuilderImpl builder) {
        this.avoidActionsForDistance = builder.avoidActionsForDistance;
        this.avoidUTurns = builder.avoidUTurns;
        this.heading = builder.heading;
        this.matching = builder.matching;
        this.passThrough = builder.passThrough;
        this.position = builder.position;
        this.sideOfStreet = builder.sideOfStreet;
        this.stopDuration = builder.stopDuration;
    }

    public final Long avoidActionsForDistance() {
        return this.avoidActionsForDistance;
    }

    public final Boolean avoidUTurns() {
        return this.avoidUTurns;
    }

    public final Double heading() {
        return this.heading;
    }

    public final RouteMatchingOptions matching() {
        return this.matching;
    }

    public final Boolean passThrough() {
        return this.passThrough;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final RouteSideOfStreetOptions sideOfStreet() {
        return this.sideOfStreet;
    }

    public final Long stopDuration() {
        return this.stopDuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.avoidActionsForDistance());
        hashCode = 31 * hashCode + Objects.hashCode(this.avoidUTurns());
        hashCode = 31 * hashCode + Objects.hashCode(this.heading());
        hashCode = 31 * hashCode + Objects.hashCode(this.matching());
        hashCode = 31 * hashCode + Objects.hashCode(this.passThrough());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sideOfStreet());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopDuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteWaypoint)) {
            return false;
        }
        RouteWaypoint other = (RouteWaypoint)obj;
        return Objects.equals(this.avoidActionsForDistance(), other.avoidActionsForDistance()) && Objects.equals(this.avoidUTurns(), other.avoidUTurns()) && Objects.equals(this.heading(), other.heading()) && Objects.equals(this.matching(), other.matching()) && Objects.equals(this.passThrough(), other.passThrough()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.sideOfStreet(), other.sideOfStreet()) && Objects.equals(this.stopDuration(), other.stopDuration());
    }

    public final String toString() {
        return ToString.builder((String)"RouteWaypoint").add("AvoidActionsForDistance", (Object)this.avoidActionsForDistance()).add("AvoidUTurns", (Object)this.avoidUTurns()).add("Heading", (Object)this.heading()).add("Matching", (Object)this.matching()).add("PassThrough", (Object)this.passThrough()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("SideOfStreet", (Object)this.sideOfStreet()).add("StopDuration", (Object)this.stopDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvoidActionsForDistance": {
                return Optional.ofNullable(clazz.cast(this.avoidActionsForDistance()));
            }
            case "AvoidUTurns": {
                return Optional.ofNullable(clazz.cast(this.avoidUTurns()));
            }
            case "Heading": {
                return Optional.ofNullable(clazz.cast(this.heading()));
            }
            case "Matching": {
                return Optional.ofNullable(clazz.cast(this.matching()));
            }
            case "PassThrough": {
                return Optional.ofNullable(clazz.cast(this.passThrough()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "SideOfStreet": {
                return Optional.ofNullable(clazz.cast(this.sideOfStreet()));
            }
            case "StopDuration": {
                return Optional.ofNullable(clazz.cast(this.stopDuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvoidActionsForDistance", AVOID_ACTIONS_FOR_DISTANCE_FIELD);
        map.put("AvoidUTurns", AVOID_U_TURNS_FIELD);
        map.put("Heading", HEADING_FIELD);
        map.put("Matching", MATCHING_FIELD);
        map.put("PassThrough", PASS_THROUGH_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("SideOfStreet", SIDE_OF_STREET_FIELD);
        map.put("StopDuration", STOP_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteWaypoint, T> g) {
        return obj -> g.apply((RouteWaypoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long avoidActionsForDistance;
        private Boolean avoidUTurns;
        private Double heading;
        private RouteMatchingOptions matching;
        private Boolean passThrough;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private RouteSideOfStreetOptions sideOfStreet;
        private Long stopDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteWaypoint model) {
            this.avoidActionsForDistance(model.avoidActionsForDistance);
            this.avoidUTurns(model.avoidUTurns);
            this.heading(model.heading);
            this.matching(model.matching);
            this.passThrough(model.passThrough);
            this.position(model.position);
            this.sideOfStreet(model.sideOfStreet);
            this.stopDuration(model.stopDuration);
        }

        public final Long getAvoidActionsForDistance() {
            return this.avoidActionsForDistance;
        }

        public final void setAvoidActionsForDistance(Long avoidActionsForDistance) {
            this.avoidActionsForDistance = avoidActionsForDistance;
        }

        @Override
        public final Builder avoidActionsForDistance(Long avoidActionsForDistance) {
            this.avoidActionsForDistance = avoidActionsForDistance;
            return this;
        }

        public final Boolean getAvoidUTurns() {
            return this.avoidUTurns;
        }

        public final void setAvoidUTurns(Boolean avoidUTurns) {
            this.avoidUTurns = avoidUTurns;
        }

        @Override
        public final Builder avoidUTurns(Boolean avoidUTurns) {
            this.avoidUTurns = avoidUTurns;
            return this;
        }

        public final Double getHeading() {
            return this.heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final RouteMatchingOptions.Builder getMatching() {
            return this.matching != null ? this.matching.toBuilder() : null;
        }

        public final void setMatching(RouteMatchingOptions.BuilderImpl matching) {
            this.matching = matching != null ? matching.build() : null;
        }

        @Override
        public final Builder matching(RouteMatchingOptions matching) {
            this.matching = matching;
            return this;
        }

        public final Boolean getPassThrough() {
            return this.passThrough;
        }

        public final void setPassThrough(Boolean passThrough) {
            this.passThrough = passThrough;
        }

        @Override
        public final Builder passThrough(Boolean passThrough) {
            this.passThrough = passThrough;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final RouteSideOfStreetOptions.Builder getSideOfStreet() {
            return this.sideOfStreet != null ? this.sideOfStreet.toBuilder() : null;
        }

        public final void setSideOfStreet(RouteSideOfStreetOptions.BuilderImpl sideOfStreet) {
            this.sideOfStreet = sideOfStreet != null ? sideOfStreet.build() : null;
        }

        @Override
        public final Builder sideOfStreet(RouteSideOfStreetOptions sideOfStreet) {
            this.sideOfStreet = sideOfStreet;
            return this;
        }

        public final Long getStopDuration() {
            return this.stopDuration;
        }

        public final void setStopDuration(Long stopDuration) {
            this.stopDuration = stopDuration;
        }

        @Override
        public final Builder stopDuration(Long stopDuration) {
            this.stopDuration = stopDuration;
            return this;
        }

        public RouteWaypoint build() {
            return new RouteWaypoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteWaypoint> {
        public Builder avoidActionsForDistance(Long var1);

        public Builder avoidUTurns(Boolean var1);

        public Builder heading(Double var1);

        public Builder matching(RouteMatchingOptions var1);

        default public Builder matching(Consumer<RouteMatchingOptions.Builder> matching) {
            return this.matching((RouteMatchingOptions)((RouteMatchingOptions.Builder)RouteMatchingOptions.builder().applyMutation(matching)).build());
        }

        public Builder passThrough(Boolean var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder sideOfStreet(RouteSideOfStreetOptions var1);

        default public Builder sideOfStreet(Consumer<RouteSideOfStreetOptions.Builder> sideOfStreet) {
            return this.sideOfStreet((RouteSideOfStreetOptions)((RouteSideOfStreetOptions.Builder)RouteSideOfStreetOptions.builder().applyMutation(sideOfStreet)).build());
        }

        public Builder stopDuration(Long var1);
    }
}

