/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.CountryCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteMatrixExclusionOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteMatrixExclusionOptions> {
    private static final SdkField<List<String>> COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Countries").getter(RouteMatrixExclusionOptions.getter(RouteMatrixExclusionOptions::countries)).setter(RouteMatrixExclusionOptions.setter(Builder::countries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Countries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteMatrixExclusionOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> countries;

    private RouteMatrixExclusionOptions(BuilderImpl builder) {
        this.countries = builder.countries;
    }

    public final boolean hasCountries() {
        return this.countries != null && !(this.countries instanceof SdkAutoConstructList);
    }

    public final List<String> countries() {
        return this.countries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountries() ? this.countries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixExclusionOptions)) {
            return false;
        }
        RouteMatrixExclusionOptions other = (RouteMatrixExclusionOptions)obj;
        return this.hasCountries() == other.hasCountries() && Objects.equals(this.countries(), other.countries());
    }

    public final String toString() {
        return ToString.builder((String)"RouteMatrixExclusionOptions").add("Countries", this.hasCountries() ? this.countries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Countries": {
                return Optional.ofNullable(clazz.cast(this.countries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("Countries", COUNTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixExclusionOptions, T> g) {
        return obj -> g.apply((RouteMatrixExclusionOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> countries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixExclusionOptions model) {
            this.countries(model.countries);
        }

        public final Collection<String> getCountries() {
            if (this.countries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.countries;
        }

        public final void setCountries(Collection<String> countries) {
            this.countries = CountryCodeListCopier.copy(countries);
        }

        @Override
        public final Builder countries(Collection<String> countries) {
            this.countries = CountryCodeListCopier.copy(countries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countries(String ... countries) {
            this.countries(Arrays.asList(countries));
            return this;
        }

        public RouteMatrixExclusionOptions build() {
            return new RouteMatrixExclusionOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteMatrixExclusionOptions> {
        public Builder countries(Collection<String> var1);

        public Builder countries(String ... var1);
    }
}

