/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.LocalizedString;
import software.amazon.awssdk.services.georoutes.model.LocalizedStringListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSteeringDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteRoundaboutExitStepDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteRoundaboutExitStepDetails> {
    private static final SdkField<List<LocalizedString>> INTERSECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Intersection").getter(RouteRoundaboutExitStepDetails.getter(RouteRoundaboutExitStepDetails::intersection)).setter(RouteRoundaboutExitStepDetails.setter(Builder::intersection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intersection").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalizedString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RELATIVE_EXIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RelativeExit").getter(RouteRoundaboutExitStepDetails.getter(RouteRoundaboutExitStepDetails::relativeExit)).setter(RouteRoundaboutExitStepDetails.setter(Builder::relativeExit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeExit").build()}).build();
    private static final SdkField<Double> ROUNDABOUT_ANGLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("RoundaboutAngle").getter(RouteRoundaboutExitStepDetails.getter(RouteRoundaboutExitStepDetails::roundaboutAngle)).setter(RouteRoundaboutExitStepDetails.setter(Builder::roundaboutAngle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoundaboutAngle").build()}).build();
    private static final SdkField<String> STEERING_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SteeringDirection").getter(RouteRoundaboutExitStepDetails.getter(RouteRoundaboutExitStepDetails::steeringDirectionAsString)).setter(RouteRoundaboutExitStepDetails.setter(Builder::steeringDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SteeringDirection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERSECTION_FIELD, RELATIVE_EXIT_FIELD, ROUNDABOUT_ANGLE_FIELD, STEERING_DIRECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteRoundaboutExitStepDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<LocalizedString> intersection;
    private final Integer relativeExit;
    private final Double roundaboutAngle;
    private final String steeringDirection;

    private RouteRoundaboutExitStepDetails(BuilderImpl builder) {
        this.intersection = builder.intersection;
        this.relativeExit = builder.relativeExit;
        this.roundaboutAngle = builder.roundaboutAngle;
        this.steeringDirection = builder.steeringDirection;
    }

    public final boolean hasIntersection() {
        return this.intersection != null && !(this.intersection instanceof SdkAutoConstructList);
    }

    public final List<LocalizedString> intersection() {
        return this.intersection;
    }

    public final Integer relativeExit() {
        return this.relativeExit;
    }

    public final Double roundaboutAngle() {
        return this.roundaboutAngle;
    }

    public final RouteSteeringDirection steeringDirection() {
        return RouteSteeringDirection.fromValue(this.steeringDirection);
    }

    public final String steeringDirectionAsString() {
        return this.steeringDirection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntersection() ? this.intersection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeExit());
        hashCode = 31 * hashCode + Objects.hashCode(this.roundaboutAngle());
        hashCode = 31 * hashCode + Objects.hashCode(this.steeringDirectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteRoundaboutExitStepDetails)) {
            return false;
        }
        RouteRoundaboutExitStepDetails other = (RouteRoundaboutExitStepDetails)obj;
        return this.hasIntersection() == other.hasIntersection() && Objects.equals(this.intersection(), other.intersection()) && Objects.equals(this.relativeExit(), other.relativeExit()) && Objects.equals(this.roundaboutAngle(), other.roundaboutAngle()) && Objects.equals(this.steeringDirectionAsString(), other.steeringDirectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RouteRoundaboutExitStepDetails").add("Intersection", this.hasIntersection() ? this.intersection() : null).add("RelativeExit", (Object)this.relativeExit()).add("RoundaboutAngle", (Object)this.roundaboutAngle()).add("SteeringDirection", (Object)this.steeringDirectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Intersection": {
                return Optional.ofNullable(clazz.cast(this.intersection()));
            }
            case "RelativeExit": {
                return Optional.ofNullable(clazz.cast(this.relativeExit()));
            }
            case "RoundaboutAngle": {
                return Optional.ofNullable(clazz.cast(this.roundaboutAngle()));
            }
            case "SteeringDirection": {
                return Optional.ofNullable(clazz.cast(this.steeringDirectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Intersection", INTERSECTION_FIELD);
        map.put("RelativeExit", RELATIVE_EXIT_FIELD);
        map.put("RoundaboutAngle", ROUNDABOUT_ANGLE_FIELD);
        map.put("SteeringDirection", STEERING_DIRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteRoundaboutExitStepDetails, T> g) {
        return obj -> g.apply((RouteRoundaboutExitStepDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LocalizedString> intersection = DefaultSdkAutoConstructList.getInstance();
        private Integer relativeExit;
        private Double roundaboutAngle;
        private String steeringDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteRoundaboutExitStepDetails model) {
            this.intersection(model.intersection);
            this.relativeExit(model.relativeExit);
            this.roundaboutAngle(model.roundaboutAngle);
            this.steeringDirection(model.steeringDirection);
        }

        public final List<LocalizedString.Builder> getIntersection() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.intersection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntersection(Collection<LocalizedString.BuilderImpl> intersection) {
            this.intersection = LocalizedStringListCopier.copyFromBuilder(intersection);
        }

        @Override
        public final Builder intersection(Collection<LocalizedString> intersection) {
            this.intersection = LocalizedStringListCopier.copy(intersection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(LocalizedString ... intersection) {
            this.intersection(Arrays.asList(intersection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(Consumer<LocalizedString.Builder> ... intersection) {
            this.intersection(Stream.of(intersection).map(c -> (LocalizedString)((LocalizedString.Builder)LocalizedString.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getRelativeExit() {
            return this.relativeExit;
        }

        public final void setRelativeExit(Integer relativeExit) {
            this.relativeExit = relativeExit;
        }

        @Override
        public final Builder relativeExit(Integer relativeExit) {
            this.relativeExit = relativeExit;
            return this;
        }

        public final Double getRoundaboutAngle() {
            return this.roundaboutAngle;
        }

        public final void setRoundaboutAngle(Double roundaboutAngle) {
            this.roundaboutAngle = roundaboutAngle;
        }

        @Override
        public final Builder roundaboutAngle(Double roundaboutAngle) {
            this.roundaboutAngle = roundaboutAngle;
            return this;
        }

        public final String getSteeringDirection() {
            return this.steeringDirection;
        }

        public final void setSteeringDirection(String steeringDirection) {
            this.steeringDirection = steeringDirection;
        }

        @Override
        public final Builder steeringDirection(String steeringDirection) {
            this.steeringDirection = steeringDirection;
            return this;
        }

        @Override
        public final Builder steeringDirection(RouteSteeringDirection steeringDirection) {
            this.steeringDirection(steeringDirection == null ? null : steeringDirection.toString());
            return this;
        }

        public RouteRoundaboutExitStepDetails build() {
            return new RouteRoundaboutExitStepDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteRoundaboutExitStepDetails> {
        public Builder intersection(Collection<LocalizedString> var1);

        public Builder intersection(LocalizedString ... var1);

        public Builder intersection(Consumer<LocalizedString.Builder> ... var1);

        public Builder relativeExit(Integer var1);

        public Builder roundaboutAngle(Double var1);

        public Builder steeringDirection(String var1);

        public Builder steeringDirection(RouteSteeringDirection var1);
    }
}

