/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.RouteLeg;
import software.amazon.awssdk.services.georoutes.model.RouteLegListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteMajorRoadLabel;
import software.amazon.awssdk.services.georoutes.model.RouteMajorRoadLabelsListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Route
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Route> {
    private static final SdkField<List<RouteLeg>> LEGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Legs").getter(Route.getter(Route::legs)).setter(Route.setter(Builder::legs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteLeg::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteMajorRoadLabel>> MAJOR_ROAD_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MajorRoadLabels").getter(Route.getter(Route::majorRoadLabels)).setter(Route.setter(Builder::majorRoadLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorRoadLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteMajorRoadLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(Route.getter(Route::summary)).setter(Route.setter(Builder::summary)).constructor(RouteSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEGS_FIELD, MAJOR_ROAD_LABELS_FIELD, SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Route.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RouteLeg> legs;
    private final List<RouteMajorRoadLabel> majorRoadLabels;
    private final RouteSummary summary;

    private Route(BuilderImpl builder) {
        this.legs = builder.legs;
        this.majorRoadLabels = builder.majorRoadLabels;
        this.summary = builder.summary;
    }

    public final boolean hasLegs() {
        return this.legs != null && !(this.legs instanceof SdkAutoConstructList);
    }

    public final List<RouteLeg> legs() {
        return this.legs;
    }

    public final boolean hasMajorRoadLabels() {
        return this.majorRoadLabels != null && !(this.majorRoadLabels instanceof SdkAutoConstructList);
    }

    public final List<RouteMajorRoadLabel> majorRoadLabels() {
        return this.majorRoadLabels;
    }

    public final RouteSummary summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLegs() ? this.legs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMajorRoadLabels() ? this.majorRoadLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route)obj;
        return this.hasLegs() == other.hasLegs() && Objects.equals(this.legs(), other.legs()) && this.hasMajorRoadLabels() == other.hasMajorRoadLabels() && Objects.equals(this.majorRoadLabels(), other.majorRoadLabels()) && Objects.equals(this.summary(), other.summary());
    }

    public final String toString() {
        return ToString.builder((String)"Route").add("Legs", this.hasLegs() ? this.legs() : null).add("MajorRoadLabels", this.hasMajorRoadLabels() ? this.majorRoadLabels() : null).add("Summary", (Object)this.summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Legs": {
                return Optional.ofNullable(clazz.cast(this.legs()));
            }
            case "MajorRoadLabels": {
                return Optional.ofNullable(clazz.cast(this.majorRoadLabels()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Legs", LEGS_FIELD);
        map.put("MajorRoadLabels", MAJOR_ROAD_LABELS_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route, T> g) {
        return obj -> g.apply((Route)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RouteLeg> legs = DefaultSdkAutoConstructList.getInstance();
        private List<RouteMajorRoadLabel> majorRoadLabels = DefaultSdkAutoConstructList.getInstance();
        private RouteSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            this.legs(model.legs);
            this.majorRoadLabels(model.majorRoadLabels);
            this.summary(model.summary);
        }

        public final List<RouteLeg.Builder> getLegs() {
            List<RouteLeg.Builder> result = RouteLegListCopier.copyToBuilder(this.legs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLegs(Collection<RouteLeg.BuilderImpl> legs) {
            this.legs = RouteLegListCopier.copyFromBuilder(legs);
        }

        @Override
        public final Builder legs(Collection<RouteLeg> legs) {
            this.legs = RouteLegListCopier.copy(legs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legs(RouteLeg ... legs) {
            this.legs(Arrays.asList(legs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legs(Consumer<RouteLeg.Builder> ... legs) {
            this.legs(Stream.of(legs).map(c -> (RouteLeg)((RouteLeg.Builder)RouteLeg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteMajorRoadLabel.Builder> getMajorRoadLabels() {
            List<RouteMajorRoadLabel.Builder> result = RouteMajorRoadLabelsListCopier.copyToBuilder(this.majorRoadLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMajorRoadLabels(Collection<RouteMajorRoadLabel.BuilderImpl> majorRoadLabels) {
            this.majorRoadLabels = RouteMajorRoadLabelsListCopier.copyFromBuilder(majorRoadLabels);
        }

        @Override
        public final Builder majorRoadLabels(Collection<RouteMajorRoadLabel> majorRoadLabels) {
            this.majorRoadLabels = RouteMajorRoadLabelsListCopier.copy(majorRoadLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder majorRoadLabels(RouteMajorRoadLabel ... majorRoadLabels) {
            this.majorRoadLabels(Arrays.asList(majorRoadLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder majorRoadLabels(Consumer<RouteMajorRoadLabel.Builder> ... majorRoadLabels) {
            this.majorRoadLabels(Stream.of(majorRoadLabels).map(c -> (RouteMajorRoadLabel)((RouteMajorRoadLabel.Builder)RouteMajorRoadLabel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RouteSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(RouteSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(RouteSummary summary) {
            this.summary = summary;
            return this;
        }

        public Route build() {
            return new Route(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Route> {
        public Builder legs(Collection<RouteLeg> var1);

        public Builder legs(RouteLeg ... var1);

        public Builder legs(Consumer<RouteLeg.Builder> ... var1);

        public Builder majorRoadLabels(Collection<RouteMajorRoadLabel> var1);

        public Builder majorRoadLabels(RouteMajorRoadLabel ... var1);

        public Builder majorRoadLabels(Consumer<RouteMajorRoadLabel.Builder> ... var1);

        public Builder summary(RouteSummary var1);

        default public Builder summary(Consumer<RouteSummary.Builder> summary) {
            return this.summary((RouteSummary)((RouteSummary.Builder)RouteSummary.builder().applyMutation(summary)).build());
        }
    }
}

