/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.Position23Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutePassThroughPlace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutePassThroughPlace> {
    private static final SdkField<List<Double>> ORIGINAL_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OriginalPosition").getter(RoutePassThroughPlace.getter(RoutePassThroughPlace::originalPosition)).setter(RoutePassThroughPlace.setter(Builder::originalPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(RoutePassThroughPlace.getter(RoutePassThroughPlace::position)).setter(RoutePassThroughPlace.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> WAYPOINT_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaypointIndex").getter(RoutePassThroughPlace.getter(RoutePassThroughPlace::waypointIndex)).setter(RoutePassThroughPlace.setter(Builder::waypointIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaypointIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINAL_POSITION_FIELD, POSITION_FIELD, WAYPOINT_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoutePassThroughPlace.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Double> originalPosition;
    private final List<Double> position;
    private final Integer waypointIndex;

    private RoutePassThroughPlace(BuilderImpl builder) {
        this.originalPosition = builder.originalPosition;
        this.position = builder.position;
        this.waypointIndex = builder.waypointIndex;
    }

    public final boolean hasOriginalPosition() {
        return this.originalPosition != null && !(this.originalPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> originalPosition() {
        return this.originalPosition;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final Integer waypointIndex() {
        return this.waypointIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOriginalPosition() ? this.originalPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.waypointIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutePassThroughPlace)) {
            return false;
        }
        RoutePassThroughPlace other = (RoutePassThroughPlace)obj;
        return this.hasOriginalPosition() == other.hasOriginalPosition() && Objects.equals(this.originalPosition(), other.originalPosition()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.waypointIndex(), other.waypointIndex());
    }

    public final String toString() {
        return ToString.builder((String)"RoutePassThroughPlace").add("OriginalPosition", (Object)(this.originalPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("WaypointIndex", (Object)this.waypointIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginalPosition": {
                return Optional.ofNullable(clazz.cast(this.originalPosition()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "WaypointIndex": {
                return Optional.ofNullable(clazz.cast(this.waypointIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OriginalPosition", ORIGINAL_POSITION_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("WaypointIndex", WAYPOINT_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutePassThroughPlace, T> g) {
        return obj -> g.apply((RoutePassThroughPlace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Double> originalPosition = DefaultSdkAutoConstructList.getInstance();
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private Integer waypointIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutePassThroughPlace model) {
            this.originalPosition(model.originalPosition);
            this.position(model.position);
            this.waypointIndex(model.waypointIndex);
        }

        public final Collection<Double> getOriginalPosition() {
            if (this.originalPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.originalPosition;
        }

        public final void setOriginalPosition(Collection<Double> originalPosition) {
            this.originalPosition = Position23Copier.copy(originalPosition);
        }

        @Override
        public final Builder originalPosition(Collection<Double> originalPosition) {
            this.originalPosition = Position23Copier.copy(originalPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originalPosition(Double ... originalPosition) {
            this.originalPosition(Arrays.asList(originalPosition));
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = Position23Copier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = Position23Copier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Integer getWaypointIndex() {
            return this.waypointIndex;
        }

        public final void setWaypointIndex(Integer waypointIndex) {
            this.waypointIndex = waypointIndex;
        }

        @Override
        public final Builder waypointIndex(Integer waypointIndex) {
            this.waypointIndex = waypointIndex;
            return this;
        }

        public RoutePassThroughPlace build() {
            return new RoutePassThroughPlace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutePassThroughPlace> {
        public Builder originalPosition(Collection<Double> var1);

        public Builder originalPosition(Double ... var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder waypointIndex(Integer var1);
    }
}

