/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.RouteHazardousCargoType;
import software.amazon.awssdk.services.georoutes.model.RouteHazardousCargoTypeListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteNoticeDetailRange;
import software.amazon.awssdk.services.georoutes.model.RouteTruckType;
import software.amazon.awssdk.services.georoutes.model.RouteWeightConstraint;
import software.amazon.awssdk.services.georoutes.model.WeightPerAxleGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteViolatedConstraints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteViolatedConstraints> {
    private static final SdkField<Boolean> ALL_HAZARDS_RESTRICTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllHazardsRestricted").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::allHazardsRestricted)).setter(RouteViolatedConstraints.setter(Builder::allHazardsRestricted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllHazardsRestricted").build()}).build();
    private static final SdkField<RouteNoticeDetailRange> AXLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AxleCount").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::axleCount)).setter(RouteViolatedConstraints.setter(Builder::axleCount)).constructor(RouteNoticeDetailRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxleCount").build()}).build();
    private static final SdkField<List<String>> HAZARDOUS_CARGOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HazardousCargos").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::hazardousCargosAsStrings)).setter(RouteViolatedConstraints.setter(Builder::hazardousCargosWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HazardousCargos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> MAX_HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxHeight").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::maxHeight)).setter(RouteViolatedConstraints.setter(Builder::maxHeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHeight").build()}).build();
    private static final SdkField<Long> MAX_KPRA_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxKpraLength").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::maxKpraLength)).setter(RouteViolatedConstraints.setter(Builder::maxKpraLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxKpraLength").build()}).build();
    private static final SdkField<Long> MAX_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxLength").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::maxLength)).setter(RouteViolatedConstraints.setter(Builder::maxLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLength").build()}).build();
    private static final SdkField<Long> MAX_PAYLOAD_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxPayloadCapacity").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::maxPayloadCapacity)).setter(RouteViolatedConstraints.setter(Builder::maxPayloadCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPayloadCapacity").build()}).build();
    private static final SdkField<RouteWeightConstraint> MAX_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaxWeight").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::maxWeight)).setter(RouteViolatedConstraints.setter(Builder::maxWeight)).constructor(RouteWeightConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWeight").build()}).build();
    private static final SdkField<Long> MAX_WEIGHT_PER_AXLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxWeightPerAxle").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::maxWeightPerAxle)).setter(RouteViolatedConstraints.setter(Builder::maxWeightPerAxle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWeightPerAxle").build()}).build();
    private static final SdkField<WeightPerAxleGroup> MAX_WEIGHT_PER_AXLE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaxWeightPerAxleGroup").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::maxWeightPerAxleGroup)).setter(RouteViolatedConstraints.setter(Builder::maxWeightPerAxleGroup)).constructor(WeightPerAxleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWeightPerAxleGroup").build()}).build();
    private static final SdkField<Long> MAX_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxWidth").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::maxWidth)).setter(RouteViolatedConstraints.setter(Builder::maxWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWidth").build()}).build();
    private static final SdkField<RouteNoticeDetailRange> OCCUPANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Occupancy").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::occupancy)).setter(RouteViolatedConstraints.setter(Builder::occupancy)).constructor(RouteNoticeDetailRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Occupancy").build()}).build();
    private static final SdkField<String> RESTRICTED_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestrictedTimes").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::restrictedTimes)).setter(RouteViolatedConstraints.setter(Builder::restrictedTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictedTimes").build()}).build();
    private static final SdkField<Boolean> TIME_DEPENDENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TimeDependent").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::timeDependent)).setter(RouteViolatedConstraints.setter(Builder::timeDependent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeDependent").build()}).build();
    private static final SdkField<RouteNoticeDetailRange> TRAILER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrailerCount").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::trailerCount)).setter(RouteViolatedConstraints.setter(Builder::trailerCount)).constructor(RouteNoticeDetailRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailerCount").build()}).build();
    private static final SdkField<Boolean> TRAVEL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TravelMode").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::travelMode)).setter(RouteViolatedConstraints.setter(Builder::travelMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()}).build();
    private static final SdkField<String> TRUCK_ROAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TruckRoadType").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::truckRoadType)).setter(RouteViolatedConstraints.setter(Builder::truckRoadType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckRoadType").build()}).build();
    private static final SdkField<String> TRUCK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TruckType").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::truckTypeAsString)).setter(RouteViolatedConstraints.setter(Builder::truckType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckType").build()}).build();
    private static final SdkField<String> TUNNEL_RESTRICTION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelRestrictionCode").getter(RouteViolatedConstraints.getter(RouteViolatedConstraints::tunnelRestrictionCode)).setter(RouteViolatedConstraints.setter(Builder::tunnelRestrictionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelRestrictionCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_HAZARDS_RESTRICTED_FIELD, AXLE_COUNT_FIELD, HAZARDOUS_CARGOS_FIELD, MAX_HEIGHT_FIELD, MAX_KPRA_LENGTH_FIELD, MAX_LENGTH_FIELD, MAX_PAYLOAD_CAPACITY_FIELD, MAX_WEIGHT_FIELD, MAX_WEIGHT_PER_AXLE_FIELD, MAX_WEIGHT_PER_AXLE_GROUP_FIELD, MAX_WIDTH_FIELD, OCCUPANCY_FIELD, RESTRICTED_TIMES_FIELD, TIME_DEPENDENT_FIELD, TRAILER_COUNT_FIELD, TRAVEL_MODE_FIELD, TRUCK_ROAD_TYPE_FIELD, TRUCK_TYPE_FIELD, TUNNEL_RESTRICTION_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteViolatedConstraints.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean allHazardsRestricted;
    private final RouteNoticeDetailRange axleCount;
    private final List<String> hazardousCargos;
    private final Long maxHeight;
    private final Long maxKpraLength;
    private final Long maxLength;
    private final Long maxPayloadCapacity;
    private final RouteWeightConstraint maxWeight;
    private final Long maxWeightPerAxle;
    private final WeightPerAxleGroup maxWeightPerAxleGroup;
    private final Long maxWidth;
    private final RouteNoticeDetailRange occupancy;
    private final String restrictedTimes;
    private final Boolean timeDependent;
    private final RouteNoticeDetailRange trailerCount;
    private final Boolean travelMode;
    private final String truckRoadType;
    private final String truckType;
    private final String tunnelRestrictionCode;

    private RouteViolatedConstraints(BuilderImpl builder) {
        this.allHazardsRestricted = builder.allHazardsRestricted;
        this.axleCount = builder.axleCount;
        this.hazardousCargos = builder.hazardousCargos;
        this.maxHeight = builder.maxHeight;
        this.maxKpraLength = builder.maxKpraLength;
        this.maxLength = builder.maxLength;
        this.maxPayloadCapacity = builder.maxPayloadCapacity;
        this.maxWeight = builder.maxWeight;
        this.maxWeightPerAxle = builder.maxWeightPerAxle;
        this.maxWeightPerAxleGroup = builder.maxWeightPerAxleGroup;
        this.maxWidth = builder.maxWidth;
        this.occupancy = builder.occupancy;
        this.restrictedTimes = builder.restrictedTimes;
        this.timeDependent = builder.timeDependent;
        this.trailerCount = builder.trailerCount;
        this.travelMode = builder.travelMode;
        this.truckRoadType = builder.truckRoadType;
        this.truckType = builder.truckType;
        this.tunnelRestrictionCode = builder.tunnelRestrictionCode;
    }

    public final Boolean allHazardsRestricted() {
        return this.allHazardsRestricted;
    }

    public final RouteNoticeDetailRange axleCount() {
        return this.axleCount;
    }

    public final List<RouteHazardousCargoType> hazardousCargos() {
        return RouteHazardousCargoTypeListCopier.copyStringToEnum(this.hazardousCargos);
    }

    public final boolean hasHazardousCargos() {
        return this.hazardousCargos != null && !(this.hazardousCargos instanceof SdkAutoConstructList);
    }

    public final List<String> hazardousCargosAsStrings() {
        return this.hazardousCargos;
    }

    public final Long maxHeight() {
        return this.maxHeight;
    }

    public final Long maxKpraLength() {
        return this.maxKpraLength;
    }

    public final Long maxLength() {
        return this.maxLength;
    }

    public final Long maxPayloadCapacity() {
        return this.maxPayloadCapacity;
    }

    public final RouteWeightConstraint maxWeight() {
        return this.maxWeight;
    }

    public final Long maxWeightPerAxle() {
        return this.maxWeightPerAxle;
    }

    public final WeightPerAxleGroup maxWeightPerAxleGroup() {
        return this.maxWeightPerAxleGroup;
    }

    public final Long maxWidth() {
        return this.maxWidth;
    }

    public final RouteNoticeDetailRange occupancy() {
        return this.occupancy;
    }

    public final String restrictedTimes() {
        return this.restrictedTimes;
    }

    public final Boolean timeDependent() {
        return this.timeDependent;
    }

    public final RouteNoticeDetailRange trailerCount() {
        return this.trailerCount;
    }

    public final Boolean travelMode() {
        return this.travelMode;
    }

    public final String truckRoadType() {
        return this.truckRoadType;
    }

    public final RouteTruckType truckType() {
        return RouteTruckType.fromValue(this.truckType);
    }

    public final String truckTypeAsString() {
        return this.truckType;
    }

    public final String tunnelRestrictionCode() {
        return this.tunnelRestrictionCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allHazardsRestricted());
        hashCode = 31 * hashCode + Objects.hashCode(this.axleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHazardousCargos() ? this.hazardousCargosAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxKpraLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPayloadCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWeightPerAxle());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWeightPerAxleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.occupancy());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictedTimes());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeDependent());
        hashCode = 31 * hashCode + Objects.hashCode(this.trailerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.travelMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.truckRoadType());
        hashCode = 31 * hashCode + Objects.hashCode(this.truckTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelRestrictionCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteViolatedConstraints)) {
            return false;
        }
        RouteViolatedConstraints other = (RouteViolatedConstraints)obj;
        return Objects.equals(this.allHazardsRestricted(), other.allHazardsRestricted()) && Objects.equals(this.axleCount(), other.axleCount()) && this.hasHazardousCargos() == other.hasHazardousCargos() && Objects.equals(this.hazardousCargosAsStrings(), other.hazardousCargosAsStrings()) && Objects.equals(this.maxHeight(), other.maxHeight()) && Objects.equals(this.maxKpraLength(), other.maxKpraLength()) && Objects.equals(this.maxLength(), other.maxLength()) && Objects.equals(this.maxPayloadCapacity(), other.maxPayloadCapacity()) && Objects.equals(this.maxWeight(), other.maxWeight()) && Objects.equals(this.maxWeightPerAxle(), other.maxWeightPerAxle()) && Objects.equals(this.maxWeightPerAxleGroup(), other.maxWeightPerAxleGroup()) && Objects.equals(this.maxWidth(), other.maxWidth()) && Objects.equals(this.occupancy(), other.occupancy()) && Objects.equals(this.restrictedTimes(), other.restrictedTimes()) && Objects.equals(this.timeDependent(), other.timeDependent()) && Objects.equals(this.trailerCount(), other.trailerCount()) && Objects.equals(this.travelMode(), other.travelMode()) && Objects.equals(this.truckRoadType(), other.truckRoadType()) && Objects.equals(this.truckTypeAsString(), other.truckTypeAsString()) && Objects.equals(this.tunnelRestrictionCode(), other.tunnelRestrictionCode());
    }

    public final String toString() {
        return ToString.builder((String)"RouteViolatedConstraints").add("AllHazardsRestricted", (Object)this.allHazardsRestricted()).add("AxleCount", (Object)this.axleCount()).add("HazardousCargos", this.hasHazardousCargos() ? this.hazardousCargosAsStrings() : null).add("MaxHeight", (Object)this.maxHeight()).add("MaxKpraLength", (Object)this.maxKpraLength()).add("MaxLength", (Object)this.maxLength()).add("MaxPayloadCapacity", (Object)this.maxPayloadCapacity()).add("MaxWeight", (Object)this.maxWeight()).add("MaxWeightPerAxle", (Object)this.maxWeightPerAxle()).add("MaxWeightPerAxleGroup", (Object)this.maxWeightPerAxleGroup()).add("MaxWidth", (Object)this.maxWidth()).add("Occupancy", (Object)this.occupancy()).add("RestrictedTimes", (Object)this.restrictedTimes()).add("TimeDependent", (Object)this.timeDependent()).add("TrailerCount", (Object)this.trailerCount()).add("TravelMode", (Object)this.travelMode()).add("TruckRoadType", (Object)this.truckRoadType()).add("TruckType", (Object)this.truckTypeAsString()).add("TunnelRestrictionCode", (Object)this.tunnelRestrictionCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllHazardsRestricted": {
                return Optional.ofNullable(clazz.cast(this.allHazardsRestricted()));
            }
            case "AxleCount": {
                return Optional.ofNullable(clazz.cast(this.axleCount()));
            }
            case "HazardousCargos": {
                return Optional.ofNullable(clazz.cast(this.hazardousCargosAsStrings()));
            }
            case "MaxHeight": {
                return Optional.ofNullable(clazz.cast(this.maxHeight()));
            }
            case "MaxKpraLength": {
                return Optional.ofNullable(clazz.cast(this.maxKpraLength()));
            }
            case "MaxLength": {
                return Optional.ofNullable(clazz.cast(this.maxLength()));
            }
            case "MaxPayloadCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxPayloadCapacity()));
            }
            case "MaxWeight": {
                return Optional.ofNullable(clazz.cast(this.maxWeight()));
            }
            case "MaxWeightPerAxle": {
                return Optional.ofNullable(clazz.cast(this.maxWeightPerAxle()));
            }
            case "MaxWeightPerAxleGroup": {
                return Optional.ofNullable(clazz.cast(this.maxWeightPerAxleGroup()));
            }
            case "MaxWidth": {
                return Optional.ofNullable(clazz.cast(this.maxWidth()));
            }
            case "Occupancy": {
                return Optional.ofNullable(clazz.cast(this.occupancy()));
            }
            case "RestrictedTimes": {
                return Optional.ofNullable(clazz.cast(this.restrictedTimes()));
            }
            case "TimeDependent": {
                return Optional.ofNullable(clazz.cast(this.timeDependent()));
            }
            case "TrailerCount": {
                return Optional.ofNullable(clazz.cast(this.trailerCount()));
            }
            case "TravelMode": {
                return Optional.ofNullable(clazz.cast(this.travelMode()));
            }
            case "TruckRoadType": {
                return Optional.ofNullable(clazz.cast(this.truckRoadType()));
            }
            case "TruckType": {
                return Optional.ofNullable(clazz.cast(this.truckTypeAsString()));
            }
            case "TunnelRestrictionCode": {
                return Optional.ofNullable(clazz.cast(this.tunnelRestrictionCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AllHazardsRestricted", ALL_HAZARDS_RESTRICTED_FIELD);
        map.put("AxleCount", AXLE_COUNT_FIELD);
        map.put("HazardousCargos", HAZARDOUS_CARGOS_FIELD);
        map.put("MaxHeight", MAX_HEIGHT_FIELD);
        map.put("MaxKpraLength", MAX_KPRA_LENGTH_FIELD);
        map.put("MaxLength", MAX_LENGTH_FIELD);
        map.put("MaxPayloadCapacity", MAX_PAYLOAD_CAPACITY_FIELD);
        map.put("MaxWeight", MAX_WEIGHT_FIELD);
        map.put("MaxWeightPerAxle", MAX_WEIGHT_PER_AXLE_FIELD);
        map.put("MaxWeightPerAxleGroup", MAX_WEIGHT_PER_AXLE_GROUP_FIELD);
        map.put("MaxWidth", MAX_WIDTH_FIELD);
        map.put("Occupancy", OCCUPANCY_FIELD);
        map.put("RestrictedTimes", RESTRICTED_TIMES_FIELD);
        map.put("TimeDependent", TIME_DEPENDENT_FIELD);
        map.put("TrailerCount", TRAILER_COUNT_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("TruckRoadType", TRUCK_ROAD_TYPE_FIELD);
        map.put("TruckType", TRUCK_TYPE_FIELD);
        map.put("TunnelRestrictionCode", TUNNEL_RESTRICTION_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteViolatedConstraints, T> g) {
        return obj -> g.apply((RouteViolatedConstraints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allHazardsRestricted;
        private RouteNoticeDetailRange axleCount;
        private List<String> hazardousCargos = DefaultSdkAutoConstructList.getInstance();
        private Long maxHeight;
        private Long maxKpraLength;
        private Long maxLength;
        private Long maxPayloadCapacity;
        private RouteWeightConstraint maxWeight;
        private Long maxWeightPerAxle;
        private WeightPerAxleGroup maxWeightPerAxleGroup;
        private Long maxWidth;
        private RouteNoticeDetailRange occupancy;
        private String restrictedTimes;
        private Boolean timeDependent;
        private RouteNoticeDetailRange trailerCount;
        private Boolean travelMode;
        private String truckRoadType;
        private String truckType;
        private String tunnelRestrictionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteViolatedConstraints model) {
            this.allHazardsRestricted(model.allHazardsRestricted);
            this.axleCount(model.axleCount);
            this.hazardousCargosWithStrings(model.hazardousCargos);
            this.maxHeight(model.maxHeight);
            this.maxKpraLength(model.maxKpraLength);
            this.maxLength(model.maxLength);
            this.maxPayloadCapacity(model.maxPayloadCapacity);
            this.maxWeight(model.maxWeight);
            this.maxWeightPerAxle(model.maxWeightPerAxle);
            this.maxWeightPerAxleGroup(model.maxWeightPerAxleGroup);
            this.maxWidth(model.maxWidth);
            this.occupancy(model.occupancy);
            this.restrictedTimes(model.restrictedTimes);
            this.timeDependent(model.timeDependent);
            this.trailerCount(model.trailerCount);
            this.travelMode(model.travelMode);
            this.truckRoadType(model.truckRoadType);
            this.truckType(model.truckType);
            this.tunnelRestrictionCode(model.tunnelRestrictionCode);
        }

        public final Boolean getAllHazardsRestricted() {
            return this.allHazardsRestricted;
        }

        public final void setAllHazardsRestricted(Boolean allHazardsRestricted) {
            this.allHazardsRestricted = allHazardsRestricted;
        }

        @Override
        public final Builder allHazardsRestricted(Boolean allHazardsRestricted) {
            this.allHazardsRestricted = allHazardsRestricted;
            return this;
        }

        public final RouteNoticeDetailRange.Builder getAxleCount() {
            return this.axleCount != null ? this.axleCount.toBuilder() : null;
        }

        public final void setAxleCount(RouteNoticeDetailRange.BuilderImpl axleCount) {
            this.axleCount = axleCount != null ? axleCount.build() : null;
        }

        @Override
        public final Builder axleCount(RouteNoticeDetailRange axleCount) {
            this.axleCount = axleCount;
            return this;
        }

        public final Collection<String> getHazardousCargos() {
            if (this.hazardousCargos instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hazardousCargos;
        }

        public final void setHazardousCargos(Collection<String> hazardousCargos) {
            this.hazardousCargos = RouteHazardousCargoTypeListCopier.copy(hazardousCargos);
        }

        @Override
        public final Builder hazardousCargosWithStrings(Collection<String> hazardousCargos) {
            this.hazardousCargos = RouteHazardousCargoTypeListCopier.copy(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargosWithStrings(String ... hazardousCargos) {
            this.hazardousCargosWithStrings(Arrays.asList(hazardousCargos));
            return this;
        }

        @Override
        public final Builder hazardousCargos(Collection<RouteHazardousCargoType> hazardousCargos) {
            this.hazardousCargos = RouteHazardousCargoTypeListCopier.copyEnumToString(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargos(RouteHazardousCargoType ... hazardousCargos) {
            this.hazardousCargos(Arrays.asList(hazardousCargos));
            return this;
        }

        public final Long getMaxHeight() {
            return this.maxHeight;
        }

        public final void setMaxHeight(Long maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public final Builder maxHeight(Long maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public final Long getMaxKpraLength() {
            return this.maxKpraLength;
        }

        public final void setMaxKpraLength(Long maxKpraLength) {
            this.maxKpraLength = maxKpraLength;
        }

        @Override
        public final Builder maxKpraLength(Long maxKpraLength) {
            this.maxKpraLength = maxKpraLength;
            return this;
        }

        public final Long getMaxLength() {
            return this.maxLength;
        }

        public final void setMaxLength(Long maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public final Builder maxLength(Long maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final Long getMaxPayloadCapacity() {
            return this.maxPayloadCapacity;
        }

        public final void setMaxPayloadCapacity(Long maxPayloadCapacity) {
            this.maxPayloadCapacity = maxPayloadCapacity;
        }

        @Override
        public final Builder maxPayloadCapacity(Long maxPayloadCapacity) {
            this.maxPayloadCapacity = maxPayloadCapacity;
            return this;
        }

        public final RouteWeightConstraint.Builder getMaxWeight() {
            return this.maxWeight != null ? this.maxWeight.toBuilder() : null;
        }

        public final void setMaxWeight(RouteWeightConstraint.BuilderImpl maxWeight) {
            this.maxWeight = maxWeight != null ? maxWeight.build() : null;
        }

        @Override
        public final Builder maxWeight(RouteWeightConstraint maxWeight) {
            this.maxWeight = maxWeight;
            return this;
        }

        public final Long getMaxWeightPerAxle() {
            return this.maxWeightPerAxle;
        }

        public final void setMaxWeightPerAxle(Long maxWeightPerAxle) {
            this.maxWeightPerAxle = maxWeightPerAxle;
        }

        @Override
        public final Builder maxWeightPerAxle(Long maxWeightPerAxle) {
            this.maxWeightPerAxle = maxWeightPerAxle;
            return this;
        }

        public final WeightPerAxleGroup.Builder getMaxWeightPerAxleGroup() {
            return this.maxWeightPerAxleGroup != null ? this.maxWeightPerAxleGroup.toBuilder() : null;
        }

        public final void setMaxWeightPerAxleGroup(WeightPerAxleGroup.BuilderImpl maxWeightPerAxleGroup) {
            this.maxWeightPerAxleGroup = maxWeightPerAxleGroup != null ? maxWeightPerAxleGroup.build() : null;
        }

        @Override
        public final Builder maxWeightPerAxleGroup(WeightPerAxleGroup maxWeightPerAxleGroup) {
            this.maxWeightPerAxleGroup = maxWeightPerAxleGroup;
            return this;
        }

        public final Long getMaxWidth() {
            return this.maxWidth;
        }

        public final void setMaxWidth(Long maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public final Builder maxWidth(Long maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public final RouteNoticeDetailRange.Builder getOccupancy() {
            return this.occupancy != null ? this.occupancy.toBuilder() : null;
        }

        public final void setOccupancy(RouteNoticeDetailRange.BuilderImpl occupancy) {
            this.occupancy = occupancy != null ? occupancy.build() : null;
        }

        @Override
        public final Builder occupancy(RouteNoticeDetailRange occupancy) {
            this.occupancy = occupancy;
            return this;
        }

        public final String getRestrictedTimes() {
            return this.restrictedTimes;
        }

        public final void setRestrictedTimes(String restrictedTimes) {
            this.restrictedTimes = restrictedTimes;
        }

        @Override
        public final Builder restrictedTimes(String restrictedTimes) {
            this.restrictedTimes = restrictedTimes;
            return this;
        }

        public final Boolean getTimeDependent() {
            return this.timeDependent;
        }

        public final void setTimeDependent(Boolean timeDependent) {
            this.timeDependent = timeDependent;
        }

        @Override
        public final Builder timeDependent(Boolean timeDependent) {
            this.timeDependent = timeDependent;
            return this;
        }

        public final RouteNoticeDetailRange.Builder getTrailerCount() {
            return this.trailerCount != null ? this.trailerCount.toBuilder() : null;
        }

        public final void setTrailerCount(RouteNoticeDetailRange.BuilderImpl trailerCount) {
            this.trailerCount = trailerCount != null ? trailerCount.build() : null;
        }

        @Override
        public final Builder trailerCount(RouteNoticeDetailRange trailerCount) {
            this.trailerCount = trailerCount;
            return this;
        }

        public final Boolean getTravelMode() {
            return this.travelMode;
        }

        public final void setTravelMode(Boolean travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(Boolean travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        public final String getTruckRoadType() {
            return this.truckRoadType;
        }

        public final void setTruckRoadType(String truckRoadType) {
            this.truckRoadType = truckRoadType;
        }

        @Override
        public final Builder truckRoadType(String truckRoadType) {
            this.truckRoadType = truckRoadType;
            return this;
        }

        public final String getTruckType() {
            return this.truckType;
        }

        public final void setTruckType(String truckType) {
            this.truckType = truckType;
        }

        @Override
        public final Builder truckType(String truckType) {
            this.truckType = truckType;
            return this;
        }

        @Override
        public final Builder truckType(RouteTruckType truckType) {
            this.truckType(truckType == null ? null : truckType.toString());
            return this;
        }

        public final String getTunnelRestrictionCode() {
            return this.tunnelRestrictionCode;
        }

        public final void setTunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
        }

        @Override
        public final Builder tunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
            return this;
        }

        public RouteViolatedConstraints build() {
            return new RouteViolatedConstraints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteViolatedConstraints> {
        public Builder allHazardsRestricted(Boolean var1);

        public Builder axleCount(RouteNoticeDetailRange var1);

        default public Builder axleCount(Consumer<RouteNoticeDetailRange.Builder> axleCount) {
            return this.axleCount((RouteNoticeDetailRange)((RouteNoticeDetailRange.Builder)RouteNoticeDetailRange.builder().applyMutation(axleCount)).build());
        }

        public Builder hazardousCargosWithStrings(Collection<String> var1);

        public Builder hazardousCargosWithStrings(String ... var1);

        public Builder hazardousCargos(Collection<RouteHazardousCargoType> var1);

        public Builder hazardousCargos(RouteHazardousCargoType ... var1);

        public Builder maxHeight(Long var1);

        public Builder maxKpraLength(Long var1);

        public Builder maxLength(Long var1);

        public Builder maxPayloadCapacity(Long var1);

        public Builder maxWeight(RouteWeightConstraint var1);

        default public Builder maxWeight(Consumer<RouteWeightConstraint.Builder> maxWeight) {
            return this.maxWeight((RouteWeightConstraint)((RouteWeightConstraint.Builder)RouteWeightConstraint.builder().applyMutation(maxWeight)).build());
        }

        public Builder maxWeightPerAxle(Long var1);

        public Builder maxWeightPerAxleGroup(WeightPerAxleGroup var1);

        default public Builder maxWeightPerAxleGroup(Consumer<WeightPerAxleGroup.Builder> maxWeightPerAxleGroup) {
            return this.maxWeightPerAxleGroup((WeightPerAxleGroup)((WeightPerAxleGroup.Builder)WeightPerAxleGroup.builder().applyMutation(maxWeightPerAxleGroup)).build());
        }

        public Builder maxWidth(Long var1);

        public Builder occupancy(RouteNoticeDetailRange var1);

        default public Builder occupancy(Consumer<RouteNoticeDetailRange.Builder> occupancy) {
            return this.occupancy((RouteNoticeDetailRange)((RouteNoticeDetailRange.Builder)RouteNoticeDetailRange.builder().applyMutation(occupancy)).build());
        }

        public Builder restrictedTimes(String var1);

        public Builder timeDependent(Boolean var1);

        public Builder trailerCount(RouteNoticeDetailRange var1);

        default public Builder trailerCount(Consumer<RouteNoticeDetailRange.Builder> trailerCount) {
            return this.trailerCount((RouteNoticeDetailRange)((RouteNoticeDetailRange.Builder)RouteNoticeDetailRange.builder().applyMutation(trailerCount)).build());
        }

        public Builder travelMode(Boolean var1);

        public Builder truckRoadType(String var1);

        public Builder truckType(String var1);

        public Builder truckType(RouteTruckType var1);

        public Builder tunnelRestrictionCode(String var1);
    }
}

