/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint;
import software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypointListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteToll;
import software.amazon.awssdk.services.georoutes.model.RouteTollListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteTollSystem;
import software.amazon.awssdk.services.georoutes.model.RouteTollSystemListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleArrival;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleDeparture;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleIncident;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleIncidentListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleNotice;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleNoticeListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleSpan;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleSpanListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleSummary;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleTravelStep;
import software.amazon.awssdk.services.georoutes.model.RouteVehicleTravelStepListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteZone;
import software.amazon.awssdk.services.georoutes.model.RouteZoneListCopier;
import software.amazon.awssdk.services.georoutes.model.TruckRoadTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteVehicleLegDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteVehicleLegDetails> {
    private static final SdkField<RouteVehicleArrival> ARRIVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Arrival").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::arrival)).setter(RouteVehicleLegDetails.setter(Builder::arrival)).constructor(RouteVehicleArrival::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arrival").build()}).build();
    private static final SdkField<RouteVehicleDeparture> DEPARTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Departure").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::departure)).setter(RouteVehicleLegDetails.setter(Builder::departure)).constructor(RouteVehicleDeparture::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Departure").build()}).build();
    private static final SdkField<List<RouteVehicleIncident>> INCIDENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Incidents").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::incidents)).setter(RouteVehicleLegDetails.setter(Builder::incidents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Incidents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteVehicleIncident::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteVehicleNotice>> NOTICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Notices").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::notices)).setter(RouteVehicleLegDetails.setter(Builder::notices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteVehicleNotice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RoutePassThroughWaypoint>> PASS_THROUGH_WAYPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PassThroughWaypoints").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::passThroughWaypoints)).setter(RouteVehicleLegDetails.setter(Builder::passThroughWaypoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PassThroughWaypoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutePassThroughWaypoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteVehicleSpan>> SPANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Spans").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::spans)).setter(RouteVehicleLegDetails.setter(Builder::spans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteVehicleSpan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RouteVehicleSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::summary)).setter(RouteVehicleLegDetails.setter(Builder::summary)).constructor(RouteVehicleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final SdkField<List<RouteToll>> TOLLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tolls").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::tolls)).setter(RouteVehicleLegDetails.setter(Builder::tolls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tolls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteToll::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteTollSystem>> TOLL_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TollSystems").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::tollSystems)).setter(RouteVehicleLegDetails.setter(Builder::tollSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteTollSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteVehicleTravelStep>> TRAVEL_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TravelSteps").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::travelSteps)).setter(RouteVehicleLegDetails.setter(Builder::travelSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteVehicleTravelStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TRUCK_ROAD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TruckRoadTypes").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::truckRoadTypes)).setter(RouteVehicleLegDetails.setter(Builder::truckRoadTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckRoadTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteZone>> ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Zones").getter(RouteVehicleLegDetails.getter(RouteVehicleLegDetails::zones)).setter(RouteVehicleLegDetails.setter(Builder::zones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRIVAL_FIELD, DEPARTURE_FIELD, INCIDENTS_FIELD, NOTICES_FIELD, PASS_THROUGH_WAYPOINTS_FIELD, SPANS_FIELD, SUMMARY_FIELD, TOLLS_FIELD, TOLL_SYSTEMS_FIELD, TRAVEL_STEPS_FIELD, TRUCK_ROAD_TYPES_FIELD, ZONES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteVehicleLegDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RouteVehicleArrival arrival;
    private final RouteVehicleDeparture departure;
    private final List<RouteVehicleIncident> incidents;
    private final List<RouteVehicleNotice> notices;
    private final List<RoutePassThroughWaypoint> passThroughWaypoints;
    private final List<RouteVehicleSpan> spans;
    private final RouteVehicleSummary summary;
    private final List<RouteToll> tolls;
    private final List<RouteTollSystem> tollSystems;
    private final List<RouteVehicleTravelStep> travelSteps;
    private final List<String> truckRoadTypes;
    private final List<RouteZone> zones;

    private RouteVehicleLegDetails(BuilderImpl builder) {
        this.arrival = builder.arrival;
        this.departure = builder.departure;
        this.incidents = builder.incidents;
        this.notices = builder.notices;
        this.passThroughWaypoints = builder.passThroughWaypoints;
        this.spans = builder.spans;
        this.summary = builder.summary;
        this.tolls = builder.tolls;
        this.tollSystems = builder.tollSystems;
        this.travelSteps = builder.travelSteps;
        this.truckRoadTypes = builder.truckRoadTypes;
        this.zones = builder.zones;
    }

    public final RouteVehicleArrival arrival() {
        return this.arrival;
    }

    public final RouteVehicleDeparture departure() {
        return this.departure;
    }

    public final boolean hasIncidents() {
        return this.incidents != null && !(this.incidents instanceof SdkAutoConstructList);
    }

    public final List<RouteVehicleIncident> incidents() {
        return this.incidents;
    }

    public final boolean hasNotices() {
        return this.notices != null && !(this.notices instanceof SdkAutoConstructList);
    }

    public final List<RouteVehicleNotice> notices() {
        return this.notices;
    }

    public final boolean hasPassThroughWaypoints() {
        return this.passThroughWaypoints != null && !(this.passThroughWaypoints instanceof SdkAutoConstructList);
    }

    public final List<RoutePassThroughWaypoint> passThroughWaypoints() {
        return this.passThroughWaypoints;
    }

    public final boolean hasSpans() {
        return this.spans != null && !(this.spans instanceof SdkAutoConstructList);
    }

    public final List<RouteVehicleSpan> spans() {
        return this.spans;
    }

    public final RouteVehicleSummary summary() {
        return this.summary;
    }

    public final boolean hasTolls() {
        return this.tolls != null && !(this.tolls instanceof SdkAutoConstructList);
    }

    public final List<RouteToll> tolls() {
        return this.tolls;
    }

    public final boolean hasTollSystems() {
        return this.tollSystems != null && !(this.tollSystems instanceof SdkAutoConstructList);
    }

    public final List<RouteTollSystem> tollSystems() {
        return this.tollSystems;
    }

    public final boolean hasTravelSteps() {
        return this.travelSteps != null && !(this.travelSteps instanceof SdkAutoConstructList);
    }

    public final List<RouteVehicleTravelStep> travelSteps() {
        return this.travelSteps;
    }

    public final boolean hasTruckRoadTypes() {
        return this.truckRoadTypes != null && !(this.truckRoadTypes instanceof SdkAutoConstructList);
    }

    public final List<String> truckRoadTypes() {
        return this.truckRoadTypes;
    }

    public final boolean hasZones() {
        return this.zones != null && !(this.zones instanceof SdkAutoConstructList);
    }

    public final List<RouteZone> zones() {
        return this.zones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arrival());
        hashCode = 31 * hashCode + Objects.hashCode(this.departure());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncidents() ? this.incidents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotices() ? this.notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPassThroughWaypoints() ? this.passThroughWaypoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpans() ? this.spans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTolls() ? this.tolls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTollSystems() ? this.tollSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTravelSteps() ? this.travelSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTruckRoadTypes() ? this.truckRoadTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasZones() ? this.zones() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleLegDetails)) {
            return false;
        }
        RouteVehicleLegDetails other = (RouteVehicleLegDetails)obj;
        return Objects.equals(this.arrival(), other.arrival()) && Objects.equals(this.departure(), other.departure()) && this.hasIncidents() == other.hasIncidents() && Objects.equals(this.incidents(), other.incidents()) && this.hasNotices() == other.hasNotices() && Objects.equals(this.notices(), other.notices()) && this.hasPassThroughWaypoints() == other.hasPassThroughWaypoints() && Objects.equals(this.passThroughWaypoints(), other.passThroughWaypoints()) && this.hasSpans() == other.hasSpans() && Objects.equals(this.spans(), other.spans()) && Objects.equals(this.summary(), other.summary()) && this.hasTolls() == other.hasTolls() && Objects.equals(this.tolls(), other.tolls()) && this.hasTollSystems() == other.hasTollSystems() && Objects.equals(this.tollSystems(), other.tollSystems()) && this.hasTravelSteps() == other.hasTravelSteps() && Objects.equals(this.travelSteps(), other.travelSteps()) && this.hasTruckRoadTypes() == other.hasTruckRoadTypes() && Objects.equals(this.truckRoadTypes(), other.truckRoadTypes()) && this.hasZones() == other.hasZones() && Objects.equals(this.zones(), other.zones());
    }

    public final String toString() {
        return ToString.builder((String)"RouteVehicleLegDetails").add("Arrival", (Object)this.arrival()).add("Departure", (Object)this.departure()).add("Incidents", this.hasIncidents() ? this.incidents() : null).add("Notices", this.hasNotices() ? this.notices() : null).add("PassThroughWaypoints", this.hasPassThroughWaypoints() ? this.passThroughWaypoints() : null).add("Spans", this.hasSpans() ? this.spans() : null).add("Summary", (Object)this.summary()).add("Tolls", this.hasTolls() ? this.tolls() : null).add("TollSystems", this.hasTollSystems() ? this.tollSystems() : null).add("TravelSteps", this.hasTravelSteps() ? this.travelSteps() : null).add("TruckRoadTypes", this.hasTruckRoadTypes() ? this.truckRoadTypes() : null).add("Zones", this.hasZones() ? this.zones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arrival": {
                return Optional.ofNullable(clazz.cast(this.arrival()));
            }
            case "Departure": {
                return Optional.ofNullable(clazz.cast(this.departure()));
            }
            case "Incidents": {
                return Optional.ofNullable(clazz.cast(this.incidents()));
            }
            case "Notices": {
                return Optional.ofNullable(clazz.cast(this.notices()));
            }
            case "PassThroughWaypoints": {
                return Optional.ofNullable(clazz.cast(this.passThroughWaypoints()));
            }
            case "Spans": {
                return Optional.ofNullable(clazz.cast(this.spans()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "Tolls": {
                return Optional.ofNullable(clazz.cast(this.tolls()));
            }
            case "TollSystems": {
                return Optional.ofNullable(clazz.cast(this.tollSystems()));
            }
            case "TravelSteps": {
                return Optional.ofNullable(clazz.cast(this.travelSteps()));
            }
            case "TruckRoadTypes": {
                return Optional.ofNullable(clazz.cast(this.truckRoadTypes()));
            }
            case "Zones": {
                return Optional.ofNullable(clazz.cast(this.zones()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arrival", ARRIVAL_FIELD);
        map.put("Departure", DEPARTURE_FIELD);
        map.put("Incidents", INCIDENTS_FIELD);
        map.put("Notices", NOTICES_FIELD);
        map.put("PassThroughWaypoints", PASS_THROUGH_WAYPOINTS_FIELD);
        map.put("Spans", SPANS_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        map.put("Tolls", TOLLS_FIELD);
        map.put("TollSystems", TOLL_SYSTEMS_FIELD);
        map.put("TravelSteps", TRAVEL_STEPS_FIELD);
        map.put("TruckRoadTypes", TRUCK_ROAD_TYPES_FIELD);
        map.put("Zones", ZONES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleLegDetails, T> g) {
        return obj -> g.apply((RouteVehicleLegDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RouteVehicleArrival arrival;
        private RouteVehicleDeparture departure;
        private List<RouteVehicleIncident> incidents = DefaultSdkAutoConstructList.getInstance();
        private List<RouteVehicleNotice> notices = DefaultSdkAutoConstructList.getInstance();
        private List<RoutePassThroughWaypoint> passThroughWaypoints = DefaultSdkAutoConstructList.getInstance();
        private List<RouteVehicleSpan> spans = DefaultSdkAutoConstructList.getInstance();
        private RouteVehicleSummary summary;
        private List<RouteToll> tolls = DefaultSdkAutoConstructList.getInstance();
        private List<RouteTollSystem> tollSystems = DefaultSdkAutoConstructList.getInstance();
        private List<RouteVehicleTravelStep> travelSteps = DefaultSdkAutoConstructList.getInstance();
        private List<String> truckRoadTypes = DefaultSdkAutoConstructList.getInstance();
        private List<RouteZone> zones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleLegDetails model) {
            this.arrival(model.arrival);
            this.departure(model.departure);
            this.incidents(model.incidents);
            this.notices(model.notices);
            this.passThroughWaypoints(model.passThroughWaypoints);
            this.spans(model.spans);
            this.summary(model.summary);
            this.tolls(model.tolls);
            this.tollSystems(model.tollSystems);
            this.travelSteps(model.travelSteps);
            this.truckRoadTypes(model.truckRoadTypes);
            this.zones(model.zones);
        }

        public final RouteVehicleArrival.Builder getArrival() {
            return this.arrival != null ? this.arrival.toBuilder() : null;
        }

        public final void setArrival(RouteVehicleArrival.BuilderImpl arrival) {
            this.arrival = arrival != null ? arrival.build() : null;
        }

        @Override
        public final Builder arrival(RouteVehicleArrival arrival) {
            this.arrival = arrival;
            return this;
        }

        public final RouteVehicleDeparture.Builder getDeparture() {
            return this.departure != null ? this.departure.toBuilder() : null;
        }

        public final void setDeparture(RouteVehicleDeparture.BuilderImpl departure) {
            this.departure = departure != null ? departure.build() : null;
        }

        @Override
        public final Builder departure(RouteVehicleDeparture departure) {
            this.departure = departure;
            return this;
        }

        public final List<RouteVehicleIncident.Builder> getIncidents() {
            List<RouteVehicleIncident.Builder> result = RouteVehicleIncidentListCopier.copyToBuilder(this.incidents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncidents(Collection<RouteVehicleIncident.BuilderImpl> incidents) {
            this.incidents = RouteVehicleIncidentListCopier.copyFromBuilder(incidents);
        }

        @Override
        public final Builder incidents(Collection<RouteVehicleIncident> incidents) {
            this.incidents = RouteVehicleIncidentListCopier.copy(incidents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidents(RouteVehicleIncident ... incidents) {
            this.incidents(Arrays.asList(incidents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidents(Consumer<RouteVehicleIncident.Builder> ... incidents) {
            this.incidents(Stream.of(incidents).map(c -> (RouteVehicleIncident)((RouteVehicleIncident.Builder)RouteVehicleIncident.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteVehicleNotice.Builder> getNotices() {
            List<RouteVehicleNotice.Builder> result = RouteVehicleNoticeListCopier.copyToBuilder(this.notices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotices(Collection<RouteVehicleNotice.BuilderImpl> notices) {
            this.notices = RouteVehicleNoticeListCopier.copyFromBuilder(notices);
        }

        @Override
        public final Builder notices(Collection<RouteVehicleNotice> notices) {
            this.notices = RouteVehicleNoticeListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(RouteVehicleNotice ... notices) {
            this.notices(Arrays.asList(notices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Consumer<RouteVehicleNotice.Builder> ... notices) {
            this.notices(Stream.of(notices).map(c -> (RouteVehicleNotice)((RouteVehicleNotice.Builder)RouteVehicleNotice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RoutePassThroughWaypoint.Builder> getPassThroughWaypoints() {
            List<RoutePassThroughWaypoint.Builder> result = RoutePassThroughWaypointListCopier.copyToBuilder(this.passThroughWaypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPassThroughWaypoints(Collection<RoutePassThroughWaypoint.BuilderImpl> passThroughWaypoints) {
            this.passThroughWaypoints = RoutePassThroughWaypointListCopier.copyFromBuilder(passThroughWaypoints);
        }

        @Override
        public final Builder passThroughWaypoints(Collection<RoutePassThroughWaypoint> passThroughWaypoints) {
            this.passThroughWaypoints = RoutePassThroughWaypointListCopier.copy(passThroughWaypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passThroughWaypoints(RoutePassThroughWaypoint ... passThroughWaypoints) {
            this.passThroughWaypoints(Arrays.asList(passThroughWaypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passThroughWaypoints(Consumer<RoutePassThroughWaypoint.Builder> ... passThroughWaypoints) {
            this.passThroughWaypoints(Stream.of(passThroughWaypoints).map(c -> (RoutePassThroughWaypoint)((RoutePassThroughWaypoint.Builder)RoutePassThroughWaypoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteVehicleSpan.Builder> getSpans() {
            List<RouteVehicleSpan.Builder> result = RouteVehicleSpanListCopier.copyToBuilder(this.spans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpans(Collection<RouteVehicleSpan.BuilderImpl> spans) {
            this.spans = RouteVehicleSpanListCopier.copyFromBuilder(spans);
        }

        @Override
        public final Builder spans(Collection<RouteVehicleSpan> spans) {
            this.spans = RouteVehicleSpanListCopier.copy(spans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(RouteVehicleSpan ... spans) {
            this.spans(Arrays.asList(spans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(Consumer<RouteVehicleSpan.Builder> ... spans) {
            this.spans(Stream.of(spans).map(c -> (RouteVehicleSpan)((RouteVehicleSpan.Builder)RouteVehicleSpan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RouteVehicleSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(RouteVehicleSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(RouteVehicleSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<RouteToll.Builder> getTolls() {
            List<RouteToll.Builder> result = RouteTollListCopier.copyToBuilder(this.tolls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTolls(Collection<RouteToll.BuilderImpl> tolls) {
            this.tolls = RouteTollListCopier.copyFromBuilder(tolls);
        }

        @Override
        public final Builder tolls(Collection<RouteToll> tolls) {
            this.tolls = RouteTollListCopier.copy(tolls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tolls(RouteToll ... tolls) {
            this.tolls(Arrays.asList(tolls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tolls(Consumer<RouteToll.Builder> ... tolls) {
            this.tolls(Stream.of(tolls).map(c -> (RouteToll)((RouteToll.Builder)RouteToll.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteTollSystem.Builder> getTollSystems() {
            List<RouteTollSystem.Builder> result = RouteTollSystemListCopier.copyToBuilder(this.tollSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTollSystems(Collection<RouteTollSystem.BuilderImpl> tollSystems) {
            this.tollSystems = RouteTollSystemListCopier.copyFromBuilder(tollSystems);
        }

        @Override
        public final Builder tollSystems(Collection<RouteTollSystem> tollSystems) {
            this.tollSystems = RouteTollSystemListCopier.copy(tollSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tollSystems(RouteTollSystem ... tollSystems) {
            this.tollSystems(Arrays.asList(tollSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tollSystems(Consumer<RouteTollSystem.Builder> ... tollSystems) {
            this.tollSystems(Stream.of(tollSystems).map(c -> (RouteTollSystem)((RouteTollSystem.Builder)RouteTollSystem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteVehicleTravelStep.Builder> getTravelSteps() {
            List<RouteVehicleTravelStep.Builder> result = RouteVehicleTravelStepListCopier.copyToBuilder(this.travelSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTravelSteps(Collection<RouteVehicleTravelStep.BuilderImpl> travelSteps) {
            this.travelSteps = RouteVehicleTravelStepListCopier.copyFromBuilder(travelSteps);
        }

        @Override
        public final Builder travelSteps(Collection<RouteVehicleTravelStep> travelSteps) {
            this.travelSteps = RouteVehicleTravelStepListCopier.copy(travelSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelSteps(RouteVehicleTravelStep ... travelSteps) {
            this.travelSteps(Arrays.asList(travelSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelSteps(Consumer<RouteVehicleTravelStep.Builder> ... travelSteps) {
            this.travelSteps(Stream.of(travelSteps).map(c -> (RouteVehicleTravelStep)((RouteVehicleTravelStep.Builder)RouteVehicleTravelStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getTruckRoadTypes() {
            if (this.truckRoadTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.truckRoadTypes;
        }

        public final void setTruckRoadTypes(Collection<String> truckRoadTypes) {
            this.truckRoadTypes = TruckRoadTypeListCopier.copy(truckRoadTypes);
        }

        @Override
        public final Builder truckRoadTypes(Collection<String> truckRoadTypes) {
            this.truckRoadTypes = TruckRoadTypeListCopier.copy(truckRoadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckRoadTypes(String ... truckRoadTypes) {
            this.truckRoadTypes(Arrays.asList(truckRoadTypes));
            return this;
        }

        public final List<RouteZone.Builder> getZones() {
            List<RouteZone.Builder> result = RouteZoneListCopier.copyToBuilder(this.zones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setZones(Collection<RouteZone.BuilderImpl> zones) {
            this.zones = RouteZoneListCopier.copyFromBuilder(zones);
        }

        @Override
        public final Builder zones(Collection<RouteZone> zones) {
            this.zones = RouteZoneListCopier.copy(zones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zones(RouteZone ... zones) {
            this.zones(Arrays.asList(zones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zones(Consumer<RouteZone.Builder> ... zones) {
            this.zones(Stream.of(zones).map(c -> (RouteZone)((RouteZone.Builder)RouteZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RouteVehicleLegDetails build() {
            return new RouteVehicleLegDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteVehicleLegDetails> {
        public Builder arrival(RouteVehicleArrival var1);

        default public Builder arrival(Consumer<RouteVehicleArrival.Builder> arrival) {
            return this.arrival((RouteVehicleArrival)((RouteVehicleArrival.Builder)RouteVehicleArrival.builder().applyMutation(arrival)).build());
        }

        public Builder departure(RouteVehicleDeparture var1);

        default public Builder departure(Consumer<RouteVehicleDeparture.Builder> departure) {
            return this.departure((RouteVehicleDeparture)((RouteVehicleDeparture.Builder)RouteVehicleDeparture.builder().applyMutation(departure)).build());
        }

        public Builder incidents(Collection<RouteVehicleIncident> var1);

        public Builder incidents(RouteVehicleIncident ... var1);

        public Builder incidents(Consumer<RouteVehicleIncident.Builder> ... var1);

        public Builder notices(Collection<RouteVehicleNotice> var1);

        public Builder notices(RouteVehicleNotice ... var1);

        public Builder notices(Consumer<RouteVehicleNotice.Builder> ... var1);

        public Builder passThroughWaypoints(Collection<RoutePassThroughWaypoint> var1);

        public Builder passThroughWaypoints(RoutePassThroughWaypoint ... var1);

        public Builder passThroughWaypoints(Consumer<RoutePassThroughWaypoint.Builder> ... var1);

        public Builder spans(Collection<RouteVehicleSpan> var1);

        public Builder spans(RouteVehicleSpan ... var1);

        public Builder spans(Consumer<RouteVehicleSpan.Builder> ... var1);

        public Builder summary(RouteVehicleSummary var1);

        default public Builder summary(Consumer<RouteVehicleSummary.Builder> summary) {
            return this.summary((RouteVehicleSummary)((RouteVehicleSummary.Builder)RouteVehicleSummary.builder().applyMutation(summary)).build());
        }

        public Builder tolls(Collection<RouteToll> var1);

        public Builder tolls(RouteToll ... var1);

        public Builder tolls(Consumer<RouteToll.Builder> ... var1);

        public Builder tollSystems(Collection<RouteTollSystem> var1);

        public Builder tollSystems(RouteTollSystem ... var1);

        public Builder tollSystems(Consumer<RouteTollSystem.Builder> ... var1);

        public Builder travelSteps(Collection<RouteVehicleTravelStep> var1);

        public Builder travelSteps(RouteVehicleTravelStep ... var1);

        public Builder travelSteps(Consumer<RouteVehicleTravelStep.Builder> ... var1);

        public Builder truckRoadTypes(Collection<String> var1);

        public Builder truckRoadTypes(String ... var1);

        public Builder zones(Collection<RouteZone> var1);

        public Builder zones(RouteZone ... var1);

        public Builder zones(Consumer<RouteZone.Builder> ... var1);
    }
}

