/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.georoutes.model.CalculateIsolinesRequest;
import software.amazon.awssdk.services.georoutes.model.CalculateIsolinesResponse;
import software.amazon.awssdk.services.georoutes.model.CalculateRouteMatrixRequest;
import software.amazon.awssdk.services.georoutes.model.CalculateRouteMatrixResponse;
import software.amazon.awssdk.services.georoutes.model.CalculateRoutesRequest;
import software.amazon.awssdk.services.georoutes.model.CalculateRoutesResponse;
import software.amazon.awssdk.services.georoutes.model.OptimizeWaypointsRequest;
import software.amazon.awssdk.services.georoutes.model.OptimizeWaypointsResponse;
import software.amazon.awssdk.services.georoutes.model.SnapToRoadsRequest;
import software.amazon.awssdk.services.georoutes.model.SnapToRoadsResponse;

/**
 * Service client for accessing Amazon Location Service Routes V2 asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * With the Amazon Location Routes API you can calculate routes and estimate travel time based on up-to-date road
 * network and live traffic information.
 * </p>
 * <p>
 * Calculate optimal travel routes and estimate travel times using up-to-date road network and traffic data. Key
 * features include:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Point-to-point routing with estimated travel time, distance, and turn-by-turn directions
 * </p>
 * </li>
 * <li>
 * <p>
 * Multi-point route optimization to minimize travel time or distance
 * </p>
 * </li>
 * <li>
 * <p>
 * Route matrices for efficient multi-destination planning
 * </p>
 * </li>
 * <li>
 * <p>
 * Isoline calculations to determine reachable areas within specified time or distance thresholds
 * </p>
 * </li>
 * <li>
 * <p>
 * Map-matching to align GPS traces with the road network
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GeoRoutesAsyncClient extends AwsClient {
    String SERVICE_NAME = "geo-routes";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "geo-routes";

    /**
     * <p>
     * Use the <code>CalculateIsolines</code> action to find service areas that can be reached in a given threshold of
     * time, distance.
     * </p>
     *
     * @param calculateIsolinesRequest
     * @return A Java Future containing the result of the CalculateIsolines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.CalculateIsolines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/CalculateIsolines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CalculateIsolinesResponse> calculateIsolines(CalculateIsolinesRequest calculateIsolinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use the <code>CalculateIsolines</code> action to find service areas that can be reached in a given threshold of
     * time, distance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CalculateIsolinesRequest.Builder} avoiding the need
     * to create one manually via {@link CalculateIsolinesRequest#builder()}
     * </p>
     *
     * @param calculateIsolinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.georoutes.model.CalculateIsolinesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CalculateIsolines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.CalculateIsolines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/CalculateIsolines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CalculateIsolinesResponse> calculateIsolines(
            Consumer<CalculateIsolinesRequest.Builder> calculateIsolinesRequest) {
        return calculateIsolines(CalculateIsolinesRequest.builder().applyMutation(calculateIsolinesRequest).build());
    }

    /**
     * <p>
     * Use <code>CalculateRouteMatrix</code> to compute results for all pairs of Origins to Destinations. Each row
     * corresponds to one entry in Origins. Each entry in the row corresponds to the route from that entry in Origins to
     * an entry in Destinations positions.
     * </p>
     *
     * @param calculateRouteMatrixRequest
     * @return A Java Future containing the result of the CalculateRouteMatrix operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.CalculateRouteMatrix
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/CalculateRouteMatrix"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CalculateRouteMatrixResponse> calculateRouteMatrix(
            CalculateRouteMatrixRequest calculateRouteMatrixRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use <code>CalculateRouteMatrix</code> to compute results for all pairs of Origins to Destinations. Each row
     * corresponds to one entry in Origins. Each entry in the row corresponds to the route from that entry in Origins to
     * an entry in Destinations positions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CalculateRouteMatrixRequest.Builder} avoiding the
     * need to create one manually via {@link CalculateRouteMatrixRequest#builder()}
     * </p>
     *
     * @param calculateRouteMatrixRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.georoutes.model.CalculateRouteMatrixRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CalculateRouteMatrix operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.CalculateRouteMatrix
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/CalculateRouteMatrix"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CalculateRouteMatrixResponse> calculateRouteMatrix(
            Consumer<CalculateRouteMatrixRequest.Builder> calculateRouteMatrixRequest) {
        return calculateRouteMatrix(CalculateRouteMatrixRequest.builder().applyMutation(calculateRouteMatrixRequest).build());
    }

    /**
     * <p>
     * <code>CalculateRoutes</code> computes routes given the following required parameters: <code>Origin</code> and
     * <code>Destination</code>.
     * </p>
     *
     * @param calculateRoutesRequest
     * @return A Java Future containing the result of the CalculateRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.CalculateRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/CalculateRoutes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CalculateRoutesResponse> calculateRoutes(CalculateRoutesRequest calculateRoutesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>CalculateRoutes</code> computes routes given the following required parameters: <code>Origin</code> and
     * <code>Destination</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CalculateRoutesRequest.Builder} avoiding the need
     * to create one manually via {@link CalculateRoutesRequest#builder()}
     * </p>
     *
     * @param calculateRoutesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.georoutes.model.CalculateRoutesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CalculateRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.CalculateRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/CalculateRoutes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CalculateRoutesResponse> calculateRoutes(
            Consumer<CalculateRoutesRequest.Builder> calculateRoutesRequest) {
        return calculateRoutes(CalculateRoutesRequest.builder().applyMutation(calculateRoutesRequest).build());
    }

    /**
     * <p>
     * <code>OptimizeWaypoints</code> calculates the optimal order to travel between a set of waypoints to minimize
     * either the travel time or the distance travelled during the journey, based on road network restrictions and the
     * traffic pattern data.
     * </p>
     *
     * @param optimizeWaypointsRequest
     * @return A Java Future containing the result of the OptimizeWaypoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.OptimizeWaypoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/OptimizeWaypoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<OptimizeWaypointsResponse> optimizeWaypoints(OptimizeWaypointsRequest optimizeWaypointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>OptimizeWaypoints</code> calculates the optimal order to travel between a set of waypoints to minimize
     * either the travel time or the distance travelled during the journey, based on road network restrictions and the
     * traffic pattern data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OptimizeWaypointsRequest.Builder} avoiding the need
     * to create one manually via {@link OptimizeWaypointsRequest#builder()}
     * </p>
     *
     * @param optimizeWaypointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.georoutes.model.OptimizeWaypointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the OptimizeWaypoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.OptimizeWaypoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/OptimizeWaypoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<OptimizeWaypointsResponse> optimizeWaypoints(
            Consumer<OptimizeWaypointsRequest.Builder> optimizeWaypointsRequest) {
        return optimizeWaypoints(OptimizeWaypointsRequest.builder().applyMutation(optimizeWaypointsRequest).build());
    }

    /**
     * <p>
     * <code>SnapToRoads</code> matches GPS trace to roads most likely traveled on.
     * </p>
     *
     * @param snapToRoadsRequest
     * @return A Java Future containing the result of the SnapToRoads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.SnapToRoads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/SnapToRoads" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SnapToRoadsResponse> snapToRoads(SnapToRoadsRequest snapToRoadsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>SnapToRoads</code> matches GPS trace to roads most likely traveled on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SnapToRoadsRequest.Builder} avoiding the need to
     * create one manually via {@link SnapToRoadsRequest#builder()}
     * </p>
     *
     * @param snapToRoadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.georoutes.model.SnapToRoadsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SnapToRoads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException The request processing has failed because of an unknown error, exception or
     *         failure.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GeoRoutesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GeoRoutesAsyncClient.SnapToRoads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/SnapToRoads" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SnapToRoadsResponse> snapToRoads(Consumer<SnapToRoadsRequest.Builder> snapToRoadsRequest) {
        return snapToRoads(SnapToRoadsRequest.builder().applyMutation(snapToRoadsRequest).build());
    }

    @Override
    default GeoRoutesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link GeoRoutesAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GeoRoutesAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GeoRoutesAsyncClient}.
     */
    static GeoRoutesAsyncClientBuilder builder() {
        return new DefaultGeoRoutesAsyncClientBuilder();
    }
}
