/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateRoutesRequest extends GeoRoutesRequest implements
        ToCopyableBuilder<CalculateRoutesRequest.Builder, CalculateRoutesRequest> {
    private static final SdkField<RouteAllowOptions> ALLOW_FIELD = SdkField.<RouteAllowOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Allow").getter(getter(CalculateRoutesRequest::allow)).setter(setter(Builder::allow))
            .constructor(RouteAllowOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Allow").build()).build();

    private static final SdkField<String> ARRIVAL_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArrivalTime").getter(getter(CalculateRoutesRequest::arrivalTime)).setter(setter(Builder::arrivalTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrivalTime").build()).build();

    private static final SdkField<RouteAvoidanceOptions> AVOID_FIELD = SdkField
            .<RouteAvoidanceOptions> builder(MarshallingType.SDK_POJO).memberName("Avoid")
            .getter(getter(CalculateRoutesRequest::avoid)).setter(setter(Builder::avoid))
            .constructor(RouteAvoidanceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Avoid").build()).build();

    private static final SdkField<Boolean> DEPART_NOW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DepartNow").getter(getter(CalculateRoutesRequest::departNow)).setter(setter(Builder::departNow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartNow").build()).build();

    private static final SdkField<String> DEPARTURE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DepartureTime").getter(getter(CalculateRoutesRequest::departureTime))
            .setter(setter(Builder::departureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DepartureTime").build()).build();

    private static final SdkField<List<Double>> DESTINATION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Destination")
            .getter(getter(CalculateRoutesRequest::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteDestinationOptions> DESTINATION_OPTIONS_FIELD = SdkField
            .<RouteDestinationOptions> builder(MarshallingType.SDK_POJO).memberName("DestinationOptions")
            .getter(getter(CalculateRoutesRequest::destinationOptions)).setter(setter(Builder::destinationOptions))
            .constructor(RouteDestinationOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationOptions").build())
            .build();

    private static final SdkField<RouteDriverOptions> DRIVER_FIELD = SdkField
            .<RouteDriverOptions> builder(MarshallingType.SDK_POJO).memberName("Driver")
            .getter(getter(CalculateRoutesRequest::driver)).setter(setter(Builder::driver))
            .constructor(RouteDriverOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Driver").build()).build();

    private static final SdkField<RouteExclusionOptions> EXCLUDE_FIELD = SdkField
            .<RouteExclusionOptions> builder(MarshallingType.SDK_POJO).memberName("Exclude")
            .getter(getter(CalculateRoutesRequest::exclude)).setter(setter(Builder::exclude))
            .constructor(RouteExclusionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build()).build();

    private static final SdkField<String> INSTRUCTIONS_MEASUREMENT_SYSTEM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstructionsMeasurementSystem")
            .getter(getter(CalculateRoutesRequest::instructionsMeasurementSystemAsString))
            .setter(setter(Builder::instructionsMeasurementSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstructionsMeasurementSystem")
                    .build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(CalculateRoutesRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("key").build()).build();

    private static final SdkField<List<String>> LANGUAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Languages")
            .getter(getter(CalculateRoutesRequest::languages))
            .setter(setter(Builder::languages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Languages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LEG_ADDITIONAL_FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LegAdditionalFeatures")
            .getter(getter(CalculateRoutesRequest::legAdditionalFeaturesAsStrings))
            .setter(setter(Builder::legAdditionalFeaturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegAdditionalFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LEG_GEOMETRY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LegGeometryFormat").getter(getter(CalculateRoutesRequest::legGeometryFormatAsString))
            .setter(setter(Builder::legGeometryFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegGeometryFormat").build()).build();

    private static final SdkField<Integer> MAX_ALTERNATIVES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAlternatives").getter(getter(CalculateRoutesRequest::maxAlternatives))
            .setter(setter(Builder::maxAlternatives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAlternatives").build()).build();

    private static final SdkField<String> OPTIMIZE_ROUTING_FOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizeRoutingFor").getter(getter(CalculateRoutesRequest::optimizeRoutingForAsString))
            .setter(setter(Builder::optimizeRoutingFor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeRoutingFor").build())
            .build();

    private static final SdkField<List<Double>> ORIGIN_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Origin")
            .getter(getter(CalculateRoutesRequest::origin))
            .setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteOriginOptions> ORIGIN_OPTIONS_FIELD = SdkField
            .<RouteOriginOptions> builder(MarshallingType.SDK_POJO).memberName("OriginOptions")
            .getter(getter(CalculateRoutesRequest::originOptions)).setter(setter(Builder::originOptions))
            .constructor(RouteOriginOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginOptions").build()).build();

    private static final SdkField<List<String>> SPAN_ADDITIONAL_FEATURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SpanAdditionalFeatures")
            .getter(getter(CalculateRoutesRequest::spanAdditionalFeaturesAsStrings))
            .setter(setter(Builder::spanAdditionalFeaturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpanAdditionalFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteTollOptions> TOLLS_FIELD = SdkField.<RouteTollOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tolls").getter(getter(CalculateRoutesRequest::tolls)).setter(setter(Builder::tolls))
            .constructor(RouteTollOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tolls").build()).build();

    private static final SdkField<RouteTrafficOptions> TRAFFIC_FIELD = SdkField
            .<RouteTrafficOptions> builder(MarshallingType.SDK_POJO).memberName("Traffic")
            .getter(getter(CalculateRoutesRequest::traffic)).setter(setter(Builder::traffic))
            .constructor(RouteTrafficOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Traffic").build()).build();

    private static final SdkField<String> TRAVEL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TravelMode").getter(getter(CalculateRoutesRequest::travelModeAsString))
            .setter(setter(Builder::travelMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelMode").build()).build();

    private static final SdkField<RouteTravelModeOptions> TRAVEL_MODE_OPTIONS_FIELD = SdkField
            .<RouteTravelModeOptions> builder(MarshallingType.SDK_POJO).memberName("TravelModeOptions")
            .getter(getter(CalculateRoutesRequest::travelModeOptions)).setter(setter(Builder::travelModeOptions))
            .constructor(RouteTravelModeOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelModeOptions").build()).build();

    private static final SdkField<String> TRAVEL_STEP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TravelStepType").getter(getter(CalculateRoutesRequest::travelStepTypeAsString))
            .setter(setter(Builder::travelStepType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelStepType").build()).build();

    private static final SdkField<List<RouteWaypoint>> WAYPOINTS_FIELD = SdkField
            .<List<RouteWaypoint>> builder(MarshallingType.LIST)
            .memberName("Waypoints")
            .getter(getter(CalculateRoutesRequest::waypoints))
            .setter(setter(Builder::waypoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Waypoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteWaypoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteWaypoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_FIELD,
            ARRIVAL_TIME_FIELD, AVOID_FIELD, DEPART_NOW_FIELD, DEPARTURE_TIME_FIELD, DESTINATION_FIELD,
            DESTINATION_OPTIONS_FIELD, DRIVER_FIELD, EXCLUDE_FIELD, INSTRUCTIONS_MEASUREMENT_SYSTEM_FIELD, KEY_FIELD,
            LANGUAGES_FIELD, LEG_ADDITIONAL_FEATURES_FIELD, LEG_GEOMETRY_FORMAT_FIELD, MAX_ALTERNATIVES_FIELD,
            OPTIMIZE_ROUTING_FOR_FIELD, ORIGIN_FIELD, ORIGIN_OPTIONS_FIELD, SPAN_ADDITIONAL_FEATURES_FIELD, TOLLS_FIELD,
            TRAFFIC_FIELD, TRAVEL_MODE_FIELD, TRAVEL_MODE_OPTIONS_FIELD, TRAVEL_STEP_TYPE_FIELD, WAYPOINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RouteAllowOptions allow;

    private final String arrivalTime;

    private final RouteAvoidanceOptions avoid;

    private final Boolean departNow;

    private final String departureTime;

    private final List<Double> destination;

    private final RouteDestinationOptions destinationOptions;

    private final RouteDriverOptions driver;

    private final RouteExclusionOptions exclude;

    private final String instructionsMeasurementSystem;

    private final String key;

    private final List<String> languages;

    private final List<String> legAdditionalFeatures;

    private final String legGeometryFormat;

    private final Integer maxAlternatives;

    private final String optimizeRoutingFor;

    private final List<Double> origin;

    private final RouteOriginOptions originOptions;

    private final List<String> spanAdditionalFeatures;

    private final RouteTollOptions tolls;

    private final RouteTrafficOptions traffic;

    private final String travelMode;

    private final RouteTravelModeOptions travelModeOptions;

    private final String travelStepType;

    private final List<RouteWaypoint> waypoints;

    private CalculateRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.allow = builder.allow;
        this.arrivalTime = builder.arrivalTime;
        this.avoid = builder.avoid;
        this.departNow = builder.departNow;
        this.departureTime = builder.departureTime;
        this.destination = builder.destination;
        this.destinationOptions = builder.destinationOptions;
        this.driver = builder.driver;
        this.exclude = builder.exclude;
        this.instructionsMeasurementSystem = builder.instructionsMeasurementSystem;
        this.key = builder.key;
        this.languages = builder.languages;
        this.legAdditionalFeatures = builder.legAdditionalFeatures;
        this.legGeometryFormat = builder.legGeometryFormat;
        this.maxAlternatives = builder.maxAlternatives;
        this.optimizeRoutingFor = builder.optimizeRoutingFor;
        this.origin = builder.origin;
        this.originOptions = builder.originOptions;
        this.spanAdditionalFeatures = builder.spanAdditionalFeatures;
        this.tolls = builder.tolls;
        this.traffic = builder.traffic;
        this.travelMode = builder.travelMode;
        this.travelModeOptions = builder.travelModeOptions;
        this.travelStepType = builder.travelStepType;
        this.waypoints = builder.waypoints;
    }

    /**
     * <p>
     * Features that are allowed while calculating a route.
     * </p>
     * 
     * @return Features that are allowed while calculating a route.
     */
    public final RouteAllowOptions allow() {
        return allow;
    }

    /**
     * <p>
     * Time of arrival at the destination.
     * </p>
     * <p>
     * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     * </p>
     * <p>
     * Examples:
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24Z</code>
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24+02:00</code>
     * </p>
     * 
     * @return Time of arrival at the destination.</p>
     *         <p>
     *         Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24Z</code>
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24+02:00</code>
     */
    public final String arrivalTime() {
        return arrivalTime;
    }

    /**
     * <p>
     * Features that are avoided while calculating a route. Avoidance is on a best-case basis. If an avoidance can't be
     * satisfied for a particular case, it violates the avoidance and the returned response produces a notice for the
     * violation.
     * </p>
     * 
     * @return Features that are avoided while calculating a route. Avoidance is on a best-case basis. If an avoidance
     *         can't be satisfied for a particular case, it violates the avoidance and the returned response produces a
     *         notice for the violation.
     */
    public final RouteAvoidanceOptions avoid() {
        return avoid;
    }

    /**
     * <p>
     * Uses the current time as the time of departure.
     * </p>
     * 
     * @return Uses the current time as the time of departure.
     */
    public final Boolean departNow() {
        return departNow;
    }

    /**
     * <p>
     * Time of departure from thr origin.
     * </p>
     * <p>
     * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     * </p>
     * <p>
     * Examples:
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24Z</code>
     * </p>
     * <p>
     * <code>2020-04-22T17:57:24+02:00</code>
     * </p>
     * 
     * @return Time of departure from thr origin.</p>
     *         <p>
     *         Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24Z</code>
     *         </p>
     *         <p>
     *         <code>2020-04-22T17:57:24+02:00</code>
     */
    public final String departureTime() {
        return departureTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destination property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestination() {
        return destination != null && !(destination instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The final position for the route. In the World Geodetic System (WGS 84) format:
     * <code>[longitude, latitude]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestination} method.
     * </p>
     * 
     * @return The final position for the route. In the World Geodetic System (WGS 84) format:
     *         <code>[longitude, latitude]</code>.
     */
    public final List<Double> destination() {
        return destination;
    }

    /**
     * <p>
     * Destination related options.
     * </p>
     * 
     * @return Destination related options.
     */
    public final RouteDestinationOptions destinationOptions() {
        return destinationOptions;
    }

    /**
     * <p>
     * Driver related options.
     * </p>
     * 
     * @return Driver related options.
     */
    public final RouteDriverOptions driver() {
        return driver;
    }

    /**
     * <p>
     * Features to be strictly excluded while calculating the route.
     * </p>
     * 
     * @return Features to be strictly excluded while calculating the route.
     */
    public final RouteExclusionOptions exclude() {
        return exclude;
    }

    /**
     * <p>
     * Measurement system to be used for instructions within steps in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instructionsMeasurementSystem} will return {@link MeasurementSystem#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instructionsMeasurementSystemAsString}.
     * </p>
     * 
     * @return Measurement system to be used for instructions within steps in the response.
     * @see MeasurementSystem
     */
    public final MeasurementSystem instructionsMeasurementSystem() {
        return MeasurementSystem.fromValue(instructionsMeasurementSystem);
    }

    /**
     * <p>
     * Measurement system to be used for instructions within steps in the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instructionsMeasurementSystem} will return {@link MeasurementSystem#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instructionsMeasurementSystemAsString}.
     * </p>
     * 
     * @return Measurement system to be used for instructions within steps in the response.
     * @see MeasurementSystem
     */
    public final String instructionsMeasurementSystemAsString() {
        return instructionsMeasurementSystem;
    }

    /**
     * <p>
     * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be provided
     * when making a request.
     * </p>
     * 
     * @return Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
     *         provided when making a request.
     */
    public final String key() {
        return key;
    }

    /**
     * For responses, this returns true if the service returned a value for the Languages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLanguages() {
        return languages != null && !(languages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of languages for instructions within steps in the response.
     * </p>
     * <note>
     * <p>
     * Instructions in the requested language are returned only if they are available.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLanguages} method.
     * </p>
     * 
     * @return List of languages for instructions within steps in the response.</p> <note>
     *         <p>
     *         Instructions in the requested language are returned only if they are available.
     *         </p>
     */
    public final List<String> languages() {
        return languages;
    }

    /**
     * <p>
     * A list of optional additional parameters such as timezone that can be requested for each result.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Elevation</code>: Retrieves the elevation information for each location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Incidents</code>: Provides information on traffic incidents along the route.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Summary</code>: Returns a summary of the route, including distance and duration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Tolls</code>: Supplies toll cost information along the route.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Zones</code>: Specifies the time zone information for each waypoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLegAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional additional parameters such as timezone that can be requested for each result.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Elevation</code>: Retrieves the elevation information for each location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Incidents</code>: Provides information on traffic incidents along the route.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Summary</code>: Returns a summary of the route, including distance and duration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Tolls</code>: Supplies toll cost information along the route.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Zones</code>: Specifies the time zone information for each waypoint.
     *         </p>
     *         </li>
     */
    public final List<RouteLegAdditionalFeature> legAdditionalFeatures() {
        return RouteLegAdditionalFeatureListCopier.copyStringToEnum(legAdditionalFeatures);
    }

    /**
     * For responses, this returns true if the service returned a value for the LegAdditionalFeatures property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLegAdditionalFeatures() {
        return legAdditionalFeatures != null && !(legAdditionalFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of optional additional parameters such as timezone that can be requested for each result.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Elevation</code>: Retrieves the elevation information for each location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Incidents</code>: Provides information on traffic incidents along the route.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Summary</code>: Returns a summary of the route, including distance and duration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Tolls</code>: Supplies toll cost information along the route.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Zones</code>: Specifies the time zone information for each waypoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLegAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional additional parameters such as timezone that can be requested for each result.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Elevation</code>: Retrieves the elevation information for each location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Incidents</code>: Provides information on traffic incidents along the route.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Summary</code>: Returns a summary of the route, including distance and duration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Tolls</code>: Supplies toll cost information along the route.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Zones</code>: Specifies the time zone information for each waypoint.
     *         </p>
     *         </li>
     */
    public final List<String> legAdditionalFeaturesAsStrings() {
        return legAdditionalFeatures;
    }

    /**
     * <p>
     * Specifies the format of the geometry returned for each leg of the route. You can choose between two different
     * geometry encoding formats.
     * </p>
     * <p>
     * <code>FlexiblePolyline</code>: A compact and precise encoding format for the leg geometry. For more information
     * on the format, see the GitHub repository for <a href="https://github.com/heremaps/flexible-polyline">
     * <code>FlexiblePolyline</code> </a>.
     * </p>
     * <p>
     * <code>Simple</code>: A less compact encoding, which is easier to decode but may be less precise and result in
     * larger payloads.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #legGeometryFormat}
     * will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #legGeometryFormatAsString}.
     * </p>
     * 
     * @return Specifies the format of the geometry returned for each leg of the route. You can choose between two
     *         different geometry encoding formats.</p>
     *         <p>
     *         <code>FlexiblePolyline</code>: A compact and precise encoding format for the leg geometry. For more
     *         information on the format, see the GitHub repository for <a
     *         href="https://github.com/heremaps/flexible-polyline"> <code>FlexiblePolyline</code> </a>.
     *         </p>
     *         <p>
     *         <code>Simple</code>: A less compact encoding, which is easier to decode but may be less precise and
     *         result in larger payloads.
     * @see GeometryFormat
     */
    public final GeometryFormat legGeometryFormat() {
        return GeometryFormat.fromValue(legGeometryFormat);
    }

    /**
     * <p>
     * Specifies the format of the geometry returned for each leg of the route. You can choose between two different
     * geometry encoding formats.
     * </p>
     * <p>
     * <code>FlexiblePolyline</code>: A compact and precise encoding format for the leg geometry. For more information
     * on the format, see the GitHub repository for <a href="https://github.com/heremaps/flexible-polyline">
     * <code>FlexiblePolyline</code> </a>.
     * </p>
     * <p>
     * <code>Simple</code>: A less compact encoding, which is easier to decode but may be less precise and result in
     * larger payloads.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #legGeometryFormat}
     * will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #legGeometryFormatAsString}.
     * </p>
     * 
     * @return Specifies the format of the geometry returned for each leg of the route. You can choose between two
     *         different geometry encoding formats.</p>
     *         <p>
     *         <code>FlexiblePolyline</code>: A compact and precise encoding format for the leg geometry. For more
     *         information on the format, see the GitHub repository for <a
     *         href="https://github.com/heremaps/flexible-polyline"> <code>FlexiblePolyline</code> </a>.
     *         </p>
     *         <p>
     *         <code>Simple</code>: A less compact encoding, which is easier to decode but may be less precise and
     *         result in larger payloads.
     * @see GeometryFormat
     */
    public final String legGeometryFormatAsString() {
        return legGeometryFormat;
    }

    /**
     * <p>
     * Maximum number of alternative routes to be provided in the response, if available.
     * </p>
     * 
     * @return Maximum number of alternative routes to be provided in the response, if available.
     */
    public final Integer maxAlternatives() {
        return maxAlternatives;
    }

    /**
     * <p>
     * Specifies the optimization criteria for calculating a route.
     * </p>
     * <p>
     * Default Value: <code>FastestRoute</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizeRoutingFor} will return {@link RoutingObjective#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizeRoutingForAsString}.
     * </p>
     * 
     * @return Specifies the optimization criteria for calculating a route.</p>
     *         <p>
     *         Default Value: <code>FastestRoute</code>
     * @see RoutingObjective
     */
    public final RoutingObjective optimizeRoutingFor() {
        return RoutingObjective.fromValue(optimizeRoutingFor);
    }

    /**
     * <p>
     * Specifies the optimization criteria for calculating a route.
     * </p>
     * <p>
     * Default Value: <code>FastestRoute</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #optimizeRoutingFor} will return {@link RoutingObjective#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #optimizeRoutingForAsString}.
     * </p>
     * 
     * @return Specifies the optimization criteria for calculating a route.</p>
     *         <p>
     *         Default Value: <code>FastestRoute</code>
     * @see RoutingObjective
     */
    public final String optimizeRoutingForAsString() {
        return optimizeRoutingFor;
    }

    /**
     * For responses, this returns true if the service returned a value for the Origin property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOrigin() {
        return origin != null && !(origin instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The start position for the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrigin} method.
     * </p>
     * 
     * @return The start position for the route.
     */
    public final List<Double> origin() {
        return origin;
    }

    /**
     * <p>
     * Origin related options.
     * </p>
     * 
     * @return Origin related options.
     */
    public final RouteOriginOptions originOptions() {
        return originOptions;
    }

    /**
     * <p>
     * A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section of a Leg for
     * which the requested features have the same values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpanAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section of a
     *         Leg for which the requested features have the same values.
     */
    public final List<RouteSpanAdditionalFeature> spanAdditionalFeatures() {
        return RouteSpanAdditionalFeatureListCopier.copyStringToEnum(spanAdditionalFeatures);
    }

    /**
     * For responses, this returns true if the service returned a value for the SpanAdditionalFeatures property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSpanAdditionalFeatures() {
        return spanAdditionalFeatures != null && !(spanAdditionalFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section of a Leg for
     * which the requested features have the same values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpanAdditionalFeatures} method.
     * </p>
     * 
     * @return A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section of a
     *         Leg for which the requested features have the same values.
     */
    public final List<String> spanAdditionalFeaturesAsStrings() {
        return spanAdditionalFeatures;
    }

    /**
     * <p>
     * Toll related options.
     * </p>
     * 
     * @return Toll related options.
     */
    public final RouteTollOptions tolls() {
        return tolls;
    }

    /**
     * <p>
     * Traffic related options.
     * </p>
     * 
     * @return Traffic related options.
     */
    public final RouteTrafficOptions traffic() {
        return traffic;
    }

    /**
     * <p>
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     * compatibility.
     * </p>
     * <p>
     * Default Value: <code>Car</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelMode} will
     * return {@link RouteTravelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #travelModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     *         compatibility.</p>
     *         <p>
     *         Default Value: <code>Car</code>
     * @see RouteTravelMode
     */
    public final RouteTravelMode travelMode() {
        return RouteTravelMode.fromValue(travelMode);
    }

    /**
     * <p>
     * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     * compatibility.
     * </p>
     * <p>
     * Default Value: <code>Car</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelMode} will
     * return {@link RouteTravelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #travelModeAsString}.
     * </p>
     * 
     * @return Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
     *         compatibility.</p>
     *         <p>
     *         Default Value: <code>Car</code>
     * @see RouteTravelMode
     */
    public final String travelModeAsString() {
        return travelMode;
    }

    /**
     * <p>
     * Travel mode related options for the provided travel mode.
     * </p>
     * 
     * @return Travel mode related options for the provided travel mode.
     */
    public final RouteTravelModeOptions travelModeOptions() {
        return travelModeOptions;
    }

    /**
     * <p>
     * Type of step returned by the response. Default provides basic steps intended for web based applications.
     * TurnByTurn provides detailed instructions with more granularity intended for a turn based navigation system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelStepType}
     * will return {@link RouteTravelStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #travelStepTypeAsString}.
     * </p>
     * 
     * @return Type of step returned by the response. Default provides basic steps intended for web based applications.
     *         TurnByTurn provides detailed instructions with more granularity intended for a turn based navigation
     *         system.
     * @see RouteTravelStepType
     */
    public final RouteTravelStepType travelStepType() {
        return RouteTravelStepType.fromValue(travelStepType);
    }

    /**
     * <p>
     * Type of step returned by the response. Default provides basic steps intended for web based applications.
     * TurnByTurn provides detailed instructions with more granularity intended for a turn based navigation system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #travelStepType}
     * will return {@link RouteTravelStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #travelStepTypeAsString}.
     * </p>
     * 
     * @return Type of step returned by the response. Default provides basic steps intended for web based applications.
     *         TurnByTurn provides detailed instructions with more granularity intended for a turn based navigation
     *         system.
     * @see RouteTravelStepType
     */
    public final String travelStepTypeAsString() {
        return travelStepType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Waypoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWaypoints() {
        return waypoints != null && !(waypoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of waypoints between the Origin and Destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWaypoints} method.
     * </p>
     * 
     * @return List of waypoints between the Origin and Destination.
     */
    public final List<RouteWaypoint> waypoints() {
        return waypoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allow());
        hashCode = 31 * hashCode + Objects.hashCode(arrivalTime());
        hashCode = 31 * hashCode + Objects.hashCode(avoid());
        hashCode = 31 * hashCode + Objects.hashCode(departNow());
        hashCode = 31 * hashCode + Objects.hashCode(departureTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestination() ? destination() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destinationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(driver());
        hashCode = 31 * hashCode + Objects.hashCode(exclude());
        hashCode = 31 * hashCode + Objects.hashCode(instructionsMeasurementSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(hasLanguages() ? languages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLegAdditionalFeatures() ? legAdditionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(legGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxAlternatives());
        hashCode = 31 * hashCode + Objects.hashCode(optimizeRoutingForAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrigin() ? origin() : null);
        hashCode = 31 * hashCode + Objects.hashCode(originOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpanAdditionalFeatures() ? spanAdditionalFeaturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tolls());
        hashCode = 31 * hashCode + Objects.hashCode(traffic());
        hashCode = 31 * hashCode + Objects.hashCode(travelModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(travelModeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(travelStepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasWaypoints() ? waypoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRoutesRequest)) {
            return false;
        }
        CalculateRoutesRequest other = (CalculateRoutesRequest) obj;
        return Objects.equals(allow(), other.allow()) && Objects.equals(arrivalTime(), other.arrivalTime())
                && Objects.equals(avoid(), other.avoid()) && Objects.equals(departNow(), other.departNow())
                && Objects.equals(departureTime(), other.departureTime()) && hasDestination() == other.hasDestination()
                && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationOptions(), other.destinationOptions()) && Objects.equals(driver(), other.driver())
                && Objects.equals(exclude(), other.exclude())
                && Objects.equals(instructionsMeasurementSystemAsString(), other.instructionsMeasurementSystemAsString())
                && Objects.equals(key(), other.key()) && hasLanguages() == other.hasLanguages()
                && Objects.equals(languages(), other.languages())
                && hasLegAdditionalFeatures() == other.hasLegAdditionalFeatures()
                && Objects.equals(legAdditionalFeaturesAsStrings(), other.legAdditionalFeaturesAsStrings())
                && Objects.equals(legGeometryFormatAsString(), other.legGeometryFormatAsString())
                && Objects.equals(maxAlternatives(), other.maxAlternatives())
                && Objects.equals(optimizeRoutingForAsString(), other.optimizeRoutingForAsString())
                && hasOrigin() == other.hasOrigin() && Objects.equals(origin(), other.origin())
                && Objects.equals(originOptions(), other.originOptions())
                && hasSpanAdditionalFeatures() == other.hasSpanAdditionalFeatures()
                && Objects.equals(spanAdditionalFeaturesAsStrings(), other.spanAdditionalFeaturesAsStrings())
                && Objects.equals(tolls(), other.tolls()) && Objects.equals(traffic(), other.traffic())
                && Objects.equals(travelModeAsString(), other.travelModeAsString())
                && Objects.equals(travelModeOptions(), other.travelModeOptions())
                && Objects.equals(travelStepTypeAsString(), other.travelStepTypeAsString())
                && hasWaypoints() == other.hasWaypoints() && Objects.equals(waypoints(), other.waypoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CalculateRoutesRequest")
                .add("Allow", allow())
                .add("ArrivalTime", arrivalTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Avoid", avoid())
                .add("DepartNow", departNow() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DepartureTime", departureTime() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Destination", destination() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DestinationOptions", destinationOptions())
                .add("Driver", driver())
                .add("Exclude", exclude())
                .add("InstructionsMeasurementSystem", instructionsMeasurementSystemAsString())
                .add("Key", key() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Languages", hasLanguages() ? languages() : null)
                .add("LegAdditionalFeatures", legAdditionalFeaturesAsStrings() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LegGeometryFormat", legGeometryFormatAsString()).add("MaxAlternatives", maxAlternatives())
                .add("OptimizeRoutingFor", optimizeRoutingForAsString())
                .add("Origin", origin() == null ? null : "*** Sensitive Data Redacted ***").add("OriginOptions", originOptions())
                .add("SpanAdditionalFeatures", hasSpanAdditionalFeatures() ? spanAdditionalFeaturesAsStrings() : null)
                .add("Tolls", tolls()).add("Traffic", traffic()).add("TravelMode", travelModeAsString())
                .add("TravelModeOptions", travelModeOptions()).add("TravelStepType", travelStepTypeAsString())
                .add("Waypoints", hasWaypoints() ? waypoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Allow":
            return Optional.ofNullable(clazz.cast(allow()));
        case "ArrivalTime":
            return Optional.ofNullable(clazz.cast(arrivalTime()));
        case "Avoid":
            return Optional.ofNullable(clazz.cast(avoid()));
        case "DepartNow":
            return Optional.ofNullable(clazz.cast(departNow()));
        case "DepartureTime":
            return Optional.ofNullable(clazz.cast(departureTime()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationOptions":
            return Optional.ofNullable(clazz.cast(destinationOptions()));
        case "Driver":
            return Optional.ofNullable(clazz.cast(driver()));
        case "Exclude":
            return Optional.ofNullable(clazz.cast(exclude()));
        case "InstructionsMeasurementSystem":
            return Optional.ofNullable(clazz.cast(instructionsMeasurementSystemAsString()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Languages":
            return Optional.ofNullable(clazz.cast(languages()));
        case "LegAdditionalFeatures":
            return Optional.ofNullable(clazz.cast(legAdditionalFeaturesAsStrings()));
        case "LegGeometryFormat":
            return Optional.ofNullable(clazz.cast(legGeometryFormatAsString()));
        case "MaxAlternatives":
            return Optional.ofNullable(clazz.cast(maxAlternatives()));
        case "OptimizeRoutingFor":
            return Optional.ofNullable(clazz.cast(optimizeRoutingForAsString()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(origin()));
        case "OriginOptions":
            return Optional.ofNullable(clazz.cast(originOptions()));
        case "SpanAdditionalFeatures":
            return Optional.ofNullable(clazz.cast(spanAdditionalFeaturesAsStrings()));
        case "Tolls":
            return Optional.ofNullable(clazz.cast(tolls()));
        case "Traffic":
            return Optional.ofNullable(clazz.cast(traffic()));
        case "TravelMode":
            return Optional.ofNullable(clazz.cast(travelModeAsString()));
        case "TravelModeOptions":
            return Optional.ofNullable(clazz.cast(travelModeOptions()));
        case "TravelStepType":
            return Optional.ofNullable(clazz.cast(travelStepTypeAsString()));
        case "Waypoints":
            return Optional.ofNullable(clazz.cast(waypoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Allow", ALLOW_FIELD);
        map.put("ArrivalTime", ARRIVAL_TIME_FIELD);
        map.put("Avoid", AVOID_FIELD);
        map.put("DepartNow", DEPART_NOW_FIELD);
        map.put("DepartureTime", DEPARTURE_TIME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("DestinationOptions", DESTINATION_OPTIONS_FIELD);
        map.put("Driver", DRIVER_FIELD);
        map.put("Exclude", EXCLUDE_FIELD);
        map.put("InstructionsMeasurementSystem", INSTRUCTIONS_MEASUREMENT_SYSTEM_FIELD);
        map.put("key", KEY_FIELD);
        map.put("Languages", LANGUAGES_FIELD);
        map.put("LegAdditionalFeatures", LEG_ADDITIONAL_FEATURES_FIELD);
        map.put("LegGeometryFormat", LEG_GEOMETRY_FORMAT_FIELD);
        map.put("MaxAlternatives", MAX_ALTERNATIVES_FIELD);
        map.put("OptimizeRoutingFor", OPTIMIZE_ROUTING_FOR_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("OriginOptions", ORIGIN_OPTIONS_FIELD);
        map.put("SpanAdditionalFeatures", SPAN_ADDITIONAL_FEATURES_FIELD);
        map.put("Tolls", TOLLS_FIELD);
        map.put("Traffic", TRAFFIC_FIELD);
        map.put("TravelMode", TRAVEL_MODE_FIELD);
        map.put("TravelModeOptions", TRAVEL_MODE_OPTIONS_FIELD);
        map.put("TravelStepType", TRAVEL_STEP_TYPE_FIELD);
        map.put("Waypoints", WAYPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRoutesRequest, T> g) {
        return obj -> g.apply((CalculateRoutesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoRoutesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CalculateRoutesRequest> {
        /**
         * <p>
         * Features that are allowed while calculating a route.
         * </p>
         * 
         * @param allow
         *        Features that are allowed while calculating a route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allow(RouteAllowOptions allow);

        /**
         * <p>
         * Features that are allowed while calculating a route.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteAllowOptions.Builder} avoiding the
         * need to create one manually via {@link RouteAllowOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteAllowOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #allow(RouteAllowOptions)}.
         * 
         * @param allow
         *        a consumer that will call methods on {@link RouteAllowOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allow(RouteAllowOptions)
         */
        default Builder allow(Consumer<RouteAllowOptions.Builder> allow) {
            return allow(RouteAllowOptions.builder().applyMutation(allow).build());
        }

        /**
         * <p>
         * Time of arrival at the destination.
         * </p>
         * <p>
         * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         * </p>
         * <p>
         * Examples:
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24Z</code>
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24+02:00</code>
         * </p>
         * 
         * @param arrivalTime
         *        Time of arrival at the destination.</p>
         *        <p>
         *        Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24Z</code>
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24+02:00</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrivalTime(String arrivalTime);

        /**
         * <p>
         * Features that are avoided while calculating a route. Avoidance is on a best-case basis. If an avoidance can't
         * be satisfied for a particular case, it violates the avoidance and the returned response produces a notice for
         * the violation.
         * </p>
         * 
         * @param avoid
         *        Features that are avoided while calculating a route. Avoidance is on a best-case basis. If an
         *        avoidance can't be satisfied for a particular case, it violates the avoidance and the returned
         *        response produces a notice for the violation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avoid(RouteAvoidanceOptions avoid);

        /**
         * <p>
         * Features that are avoided while calculating a route. Avoidance is on a best-case basis. If an avoidance can't
         * be satisfied for a particular case, it violates the avoidance and the returned response produces a notice for
         * the violation.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteAvoidanceOptions.Builder} avoiding
         * the need to create one manually via {@link RouteAvoidanceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteAvoidanceOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #avoid(RouteAvoidanceOptions)}.
         * 
         * @param avoid
         *        a consumer that will call methods on {@link RouteAvoidanceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #avoid(RouteAvoidanceOptions)
         */
        default Builder avoid(Consumer<RouteAvoidanceOptions.Builder> avoid) {
            return avoid(RouteAvoidanceOptions.builder().applyMutation(avoid).build());
        }

        /**
         * <p>
         * Uses the current time as the time of departure.
         * </p>
         * 
         * @param departNow
         *        Uses the current time as the time of departure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder departNow(Boolean departNow);

        /**
         * <p>
         * Time of departure from thr origin.
         * </p>
         * <p>
         * Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         * </p>
         * <p>
         * Examples:
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24Z</code>
         * </p>
         * <p>
         * <code>2020-04-22T17:57:24+02:00</code>
         * </p>
         * 
         * @param departureTime
         *        Time of departure from thr origin.</p>
         *        <p>
         *        Time format:<code>YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm</code>
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24Z</code>
         *        </p>
         *        <p>
         *        <code>2020-04-22T17:57:24+02:00</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder departureTime(String departureTime);

        /**
         * <p>
         * The final position for the route. In the World Geodetic System (WGS 84) format:
         * <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param destination
         *        The final position for the route. In the World Geodetic System (WGS 84) format:
         *        <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Collection<Double> destination);

        /**
         * <p>
         * The final position for the route. In the World Geodetic System (WGS 84) format:
         * <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param destination
         *        The final position for the route. In the World Geodetic System (WGS 84) format:
         *        <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Double... destination);

        /**
         * <p>
         * Destination related options.
         * </p>
         * 
         * @param destinationOptions
         *        Destination related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationOptions(RouteDestinationOptions destinationOptions);

        /**
         * <p>
         * Destination related options.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteDestinationOptions.Builder} avoiding
         * the need to create one manually via {@link RouteDestinationOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteDestinationOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationOptions(RouteDestinationOptions)}.
         * 
         * @param destinationOptions
         *        a consumer that will call methods on {@link RouteDestinationOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationOptions(RouteDestinationOptions)
         */
        default Builder destinationOptions(Consumer<RouteDestinationOptions.Builder> destinationOptions) {
            return destinationOptions(RouteDestinationOptions.builder().applyMutation(destinationOptions).build());
        }

        /**
         * <p>
         * Driver related options.
         * </p>
         * 
         * @param driver
         *        Driver related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driver(RouteDriverOptions driver);

        /**
         * <p>
         * Driver related options.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteDriverOptions.Builder} avoiding the
         * need to create one manually via {@link RouteDriverOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteDriverOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #driver(RouteDriverOptions)}.
         * 
         * @param driver
         *        a consumer that will call methods on {@link RouteDriverOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driver(RouteDriverOptions)
         */
        default Builder driver(Consumer<RouteDriverOptions.Builder> driver) {
            return driver(RouteDriverOptions.builder().applyMutation(driver).build());
        }

        /**
         * <p>
         * Features to be strictly excluded while calculating the route.
         * </p>
         * 
         * @param exclude
         *        Features to be strictly excluded while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclude(RouteExclusionOptions exclude);

        /**
         * <p>
         * Features to be strictly excluded while calculating the route.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteExclusionOptions.Builder} avoiding
         * the need to create one manually via {@link RouteExclusionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteExclusionOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #exclude(RouteExclusionOptions)}.
         * 
         * @param exclude
         *        a consumer that will call methods on {@link RouteExclusionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exclude(RouteExclusionOptions)
         */
        default Builder exclude(Consumer<RouteExclusionOptions.Builder> exclude) {
            return exclude(RouteExclusionOptions.builder().applyMutation(exclude).build());
        }

        /**
         * <p>
         * Measurement system to be used for instructions within steps in the response.
         * </p>
         * 
         * @param instructionsMeasurementSystem
         *        Measurement system to be used for instructions within steps in the response.
         * @see MeasurementSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeasurementSystem
         */
        Builder instructionsMeasurementSystem(String instructionsMeasurementSystem);

        /**
         * <p>
         * Measurement system to be used for instructions within steps in the response.
         * </p>
         * 
         * @param instructionsMeasurementSystem
         *        Measurement system to be used for instructions within steps in the response.
         * @see MeasurementSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeasurementSystem
         */
        Builder instructionsMeasurementSystem(MeasurementSystem instructionsMeasurementSystem);

        /**
         * <p>
         * Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         * provided when making a request.
         * </p>
         * 
         * @param key
         *        Optional: The API key to be used for authorization. Either an API key or valid SigV4 signature must be
         *        provided when making a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * List of languages for instructions within steps in the response.
         * </p>
         * <note>
         * <p>
         * Instructions in the requested language are returned only if they are available.
         * </p>
         * </note>
         * 
         * @param languages
         *        List of languages for instructions within steps in the response.</p> <note>
         *        <p>
         *        Instructions in the requested language are returned only if they are available.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(Collection<String> languages);

        /**
         * <p>
         * List of languages for instructions within steps in the response.
         * </p>
         * <note>
         * <p>
         * Instructions in the requested language are returned only if they are available.
         * </p>
         * </note>
         * 
         * @param languages
         *        List of languages for instructions within steps in the response.</p> <note>
         *        <p>
         *        Instructions in the requested language are returned only if they are available.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(String... languages);

        /**
         * <p>
         * A list of optional additional parameters such as timezone that can be requested for each result.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Elevation</code>: Retrieves the elevation information for each location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Incidents</code>: Provides information on traffic incidents along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Summary</code>: Returns a summary of the route, including distance and duration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Tolls</code>: Supplies toll cost information along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Zones</code>: Specifies the time zone information for each waypoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param legAdditionalFeatures
         *        A list of optional additional parameters such as timezone that can be requested for each result.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Elevation</code>: Retrieves the elevation information for each location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Incidents</code>: Provides information on traffic incidents along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Summary</code>: Returns a summary of the route, including distance and duration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Tolls</code>: Supplies toll cost information along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Zones</code>: Specifies the time zone information for each waypoint.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legAdditionalFeaturesWithStrings(Collection<String> legAdditionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters such as timezone that can be requested for each result.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Elevation</code>: Retrieves the elevation information for each location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Incidents</code>: Provides information on traffic incidents along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Summary</code>: Returns a summary of the route, including distance and duration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Tolls</code>: Supplies toll cost information along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Zones</code>: Specifies the time zone information for each waypoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param legAdditionalFeatures
         *        A list of optional additional parameters such as timezone that can be requested for each result.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Elevation</code>: Retrieves the elevation information for each location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Incidents</code>: Provides information on traffic incidents along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Summary</code>: Returns a summary of the route, including distance and duration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Tolls</code>: Supplies toll cost information along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Zones</code>: Specifies the time zone information for each waypoint.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legAdditionalFeaturesWithStrings(String... legAdditionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters such as timezone that can be requested for each result.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Elevation</code>: Retrieves the elevation information for each location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Incidents</code>: Provides information on traffic incidents along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Summary</code>: Returns a summary of the route, including distance and duration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Tolls</code>: Supplies toll cost information along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Zones</code>: Specifies the time zone information for each waypoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param legAdditionalFeatures
         *        A list of optional additional parameters such as timezone that can be requested for each result.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Elevation</code>: Retrieves the elevation information for each location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Incidents</code>: Provides information on traffic incidents along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Summary</code>: Returns a summary of the route, including distance and duration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Tolls</code>: Supplies toll cost information along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Zones</code>: Specifies the time zone information for each waypoint.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legAdditionalFeatures(Collection<RouteLegAdditionalFeature> legAdditionalFeatures);

        /**
         * <p>
         * A list of optional additional parameters such as timezone that can be requested for each result.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Elevation</code>: Retrieves the elevation information for each location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Incidents</code>: Provides information on traffic incidents along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Summary</code>: Returns a summary of the route, including distance and duration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Tolls</code>: Supplies toll cost information along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Zones</code>: Specifies the time zone information for each waypoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param legAdditionalFeatures
         *        A list of optional additional parameters such as timezone that can be requested for each result.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Elevation</code>: Retrieves the elevation information for each location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Incidents</code>: Provides information on traffic incidents along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PassThroughWaypoints</code>: Indicates waypoints that are passed through without stopping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Summary</code>: Returns a summary of the route, including distance and duration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Tolls</code>: Supplies toll cost information along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TravelStepInstructions</code>: Provides step-by-step instructions for travel along the route.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TruckRoadTypes</code>: Returns information about road types suitable for trucks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TypicalDuration</code>: Gives typical travel duration based on historical data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Zones</code>: Specifies the time zone information for each waypoint.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legAdditionalFeatures(RouteLegAdditionalFeature... legAdditionalFeatures);

        /**
         * <p>
         * Specifies the format of the geometry returned for each leg of the route. You can choose between two different
         * geometry encoding formats.
         * </p>
         * <p>
         * <code>FlexiblePolyline</code>: A compact and precise encoding format for the leg geometry. For more
         * information on the format, see the GitHub repository for <a
         * href="https://github.com/heremaps/flexible-polyline"> <code>FlexiblePolyline</code> </a>.
         * </p>
         * <p>
         * <code>Simple</code>: A less compact encoding, which is easier to decode but may be less precise and result in
         * larger payloads.
         * </p>
         * 
         * @param legGeometryFormat
         *        Specifies the format of the geometry returned for each leg of the route. You can choose between two
         *        different geometry encoding formats.</p>
         *        <p>
         *        <code>FlexiblePolyline</code>: A compact and precise encoding format for the leg geometry. For more
         *        information on the format, see the GitHub repository for <a
         *        href="https://github.com/heremaps/flexible-polyline"> <code>FlexiblePolyline</code> </a>.
         *        </p>
         *        <p>
         *        <code>Simple</code>: A less compact encoding, which is easier to decode but may be less precise and
         *        result in larger payloads.
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder legGeometryFormat(String legGeometryFormat);

        /**
         * <p>
         * Specifies the format of the geometry returned for each leg of the route. You can choose between two different
         * geometry encoding formats.
         * </p>
         * <p>
         * <code>FlexiblePolyline</code>: A compact and precise encoding format for the leg geometry. For more
         * information on the format, see the GitHub repository for <a
         * href="https://github.com/heremaps/flexible-polyline"> <code>FlexiblePolyline</code> </a>.
         * </p>
         * <p>
         * <code>Simple</code>: A less compact encoding, which is easier to decode but may be less precise and result in
         * larger payloads.
         * </p>
         * 
         * @param legGeometryFormat
         *        Specifies the format of the geometry returned for each leg of the route. You can choose between two
         *        different geometry encoding formats.</p>
         *        <p>
         *        <code>FlexiblePolyline</code>: A compact and precise encoding format for the leg geometry. For more
         *        information on the format, see the GitHub repository for <a
         *        href="https://github.com/heremaps/flexible-polyline"> <code>FlexiblePolyline</code> </a>.
         *        </p>
         *        <p>
         *        <code>Simple</code>: A less compact encoding, which is easier to decode but may be less precise and
         *        result in larger payloads.
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder legGeometryFormat(GeometryFormat legGeometryFormat);

        /**
         * <p>
         * Maximum number of alternative routes to be provided in the response, if available.
         * </p>
         * 
         * @param maxAlternatives
         *        Maximum number of alternative routes to be provided in the response, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAlternatives(Integer maxAlternatives);

        /**
         * <p>
         * Specifies the optimization criteria for calculating a route.
         * </p>
         * <p>
         * Default Value: <code>FastestRoute</code>
         * </p>
         * 
         * @param optimizeRoutingFor
         *        Specifies the optimization criteria for calculating a route.</p>
         *        <p>
         *        Default Value: <code>FastestRoute</code>
         * @see RoutingObjective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingObjective
         */
        Builder optimizeRoutingFor(String optimizeRoutingFor);

        /**
         * <p>
         * Specifies the optimization criteria for calculating a route.
         * </p>
         * <p>
         * Default Value: <code>FastestRoute</code>
         * </p>
         * 
         * @param optimizeRoutingFor
         *        Specifies the optimization criteria for calculating a route.</p>
         *        <p>
         *        Default Value: <code>FastestRoute</code>
         * @see RoutingObjective
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoutingObjective
         */
        Builder optimizeRoutingFor(RoutingObjective optimizeRoutingFor);

        /**
         * <p>
         * The start position for the route.
         * </p>
         * 
         * @param origin
         *        The start position for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(Collection<Double> origin);

        /**
         * <p>
         * The start position for the route.
         * </p>
         * 
         * @param origin
         *        The start position for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origin(Double... origin);

        /**
         * <p>
         * Origin related options.
         * </p>
         * 
         * @param originOptions
         *        Origin related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originOptions(RouteOriginOptions originOptions);

        /**
         * <p>
         * Origin related options.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteOriginOptions.Builder} avoiding the
         * need to create one manually via {@link RouteOriginOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteOriginOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #originOptions(RouteOriginOptions)}.
         * 
         * @param originOptions
         *        a consumer that will call methods on {@link RouteOriginOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originOptions(RouteOriginOptions)
         */
        default Builder originOptions(Consumer<RouteOriginOptions.Builder> originOptions) {
            return originOptions(RouteOriginOptions.builder().applyMutation(originOptions).build());
        }

        /**
         * <p>
         * A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section of a Leg
         * for which the requested features have the same values.
         * </p>
         * 
         * @param spanAdditionalFeatures
         *        A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section
         *        of a Leg for which the requested features have the same values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spanAdditionalFeaturesWithStrings(Collection<String> spanAdditionalFeatures);

        /**
         * <p>
         * A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section of a Leg
         * for which the requested features have the same values.
         * </p>
         * 
         * @param spanAdditionalFeatures
         *        A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section
         *        of a Leg for which the requested features have the same values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spanAdditionalFeaturesWithStrings(String... spanAdditionalFeatures);

        /**
         * <p>
         * A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section of a Leg
         * for which the requested features have the same values.
         * </p>
         * 
         * @param spanAdditionalFeatures
         *        A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section
         *        of a Leg for which the requested features have the same values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spanAdditionalFeatures(Collection<RouteSpanAdditionalFeature> spanAdditionalFeatures);

        /**
         * <p>
         * A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section of a Leg
         * for which the requested features have the same values.
         * </p>
         * 
         * @param spanAdditionalFeatures
         *        A list of optional features such as SpeedLimit that can be requested for a Span. A span is a section
         *        of a Leg for which the requested features have the same values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spanAdditionalFeatures(RouteSpanAdditionalFeature... spanAdditionalFeatures);

        /**
         * <p>
         * Toll related options.
         * </p>
         * 
         * @param tolls
         *        Toll related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tolls(RouteTollOptions tolls);

        /**
         * <p>
         * Toll related options.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTollOptions.Builder} avoiding the
         * need to create one manually via {@link RouteTollOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTollOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tolls(RouteTollOptions)}.
         * 
         * @param tolls
         *        a consumer that will call methods on {@link RouteTollOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tolls(RouteTollOptions)
         */
        default Builder tolls(Consumer<RouteTollOptions.Builder> tolls) {
            return tolls(RouteTollOptions.builder().applyMutation(tolls).build());
        }

        /**
         * <p>
         * Traffic related options.
         * </p>
         * 
         * @param traffic
         *        Traffic related options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traffic(RouteTrafficOptions traffic);

        /**
         * <p>
         * Traffic related options.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTrafficOptions.Builder} avoiding the
         * need to create one manually via {@link RouteTrafficOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTrafficOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #traffic(RouteTrafficOptions)}.
         * 
         * @param traffic
         *        a consumer that will call methods on {@link RouteTrafficOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traffic(RouteTrafficOptions)
         */
        default Builder traffic(Consumer<RouteTrafficOptions.Builder> traffic) {
            return traffic(RouteTrafficOptions.builder().applyMutation(traffic).build());
        }

        /**
         * <p>
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
         * compatibility.
         * </p>
         * <p>
         * Default Value: <code>Car</code>
         * </p>
         * 
         * @param travelMode
         *        Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and
         *        road compatibility.</p>
         *        <p>
         *        Default Value: <code>Car</code>
         * @see RouteTravelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTravelMode
         */
        Builder travelMode(String travelMode);

        /**
         * <p>
         * Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road
         * compatibility.
         * </p>
         * <p>
         * Default Value: <code>Car</code>
         * </p>
         * 
         * @param travelMode
         *        Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and
         *        road compatibility.</p>
         *        <p>
         *        Default Value: <code>Car</code>
         * @see RouteTravelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTravelMode
         */
        Builder travelMode(RouteTravelMode travelMode);

        /**
         * <p>
         * Travel mode related options for the provided travel mode.
         * </p>
         * 
         * @param travelModeOptions
         *        Travel mode related options for the provided travel mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelModeOptions(RouteTravelModeOptions travelModeOptions);

        /**
         * <p>
         * Travel mode related options for the provided travel mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTravelModeOptions.Builder} avoiding
         * the need to create one manually via {@link RouteTravelModeOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTravelModeOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #travelModeOptions(RouteTravelModeOptions)}.
         * 
         * @param travelModeOptions
         *        a consumer that will call methods on {@link RouteTravelModeOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #travelModeOptions(RouteTravelModeOptions)
         */
        default Builder travelModeOptions(Consumer<RouteTravelModeOptions.Builder> travelModeOptions) {
            return travelModeOptions(RouteTravelModeOptions.builder().applyMutation(travelModeOptions).build());
        }

        /**
         * <p>
         * Type of step returned by the response. Default provides basic steps intended for web based applications.
         * TurnByTurn provides detailed instructions with more granularity intended for a turn based navigation system.
         * </p>
         * 
         * @param travelStepType
         *        Type of step returned by the response. Default provides basic steps intended for web based
         *        applications. TurnByTurn provides detailed instructions with more granularity intended for a turn
         *        based navigation system.
         * @see RouteTravelStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTravelStepType
         */
        Builder travelStepType(String travelStepType);

        /**
         * <p>
         * Type of step returned by the response. Default provides basic steps intended for web based applications.
         * TurnByTurn provides detailed instructions with more granularity intended for a turn based navigation system.
         * </p>
         * 
         * @param travelStepType
         *        Type of step returned by the response. Default provides basic steps intended for web based
         *        applications. TurnByTurn provides detailed instructions with more granularity intended for a turn
         *        based navigation system.
         * @see RouteTravelStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTravelStepType
         */
        Builder travelStepType(RouteTravelStepType travelStepType);

        /**
         * <p>
         * List of waypoints between the Origin and Destination.
         * </p>
         * 
         * @param waypoints
         *        List of waypoints between the Origin and Destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waypoints(Collection<RouteWaypoint> waypoints);

        /**
         * <p>
         * List of waypoints between the Origin and Destination.
         * </p>
         * 
         * @param waypoints
         *        List of waypoints between the Origin and Destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waypoints(RouteWaypoint... waypoints);

        /**
         * <p>
         * List of waypoints between the Origin and Destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteWaypoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.georoutes.model.RouteWaypoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteWaypoint.Builder#build()} is called immediately
         * and its result is passed to {@link #waypoints(List<RouteWaypoint>)}.
         * 
         * @param waypoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteWaypoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waypoints(java.util.Collection<RouteWaypoint>)
         */
        Builder waypoints(Consumer<RouteWaypoint.Builder>... waypoints);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GeoRoutesRequest.BuilderImpl implements Builder {
        private RouteAllowOptions allow;

        private String arrivalTime;

        private RouteAvoidanceOptions avoid;

        private Boolean departNow;

        private String departureTime;

        private List<Double> destination = DefaultSdkAutoConstructList.getInstance();

        private RouteDestinationOptions destinationOptions;

        private RouteDriverOptions driver;

        private RouteExclusionOptions exclude;

        private String instructionsMeasurementSystem;

        private String key;

        private List<String> languages = DefaultSdkAutoConstructList.getInstance();

        private List<String> legAdditionalFeatures = DefaultSdkAutoConstructList.getInstance();

        private String legGeometryFormat;

        private Integer maxAlternatives;

        private String optimizeRoutingFor;

        private List<Double> origin = DefaultSdkAutoConstructList.getInstance();

        private RouteOriginOptions originOptions;

        private List<String> spanAdditionalFeatures = DefaultSdkAutoConstructList.getInstance();

        private RouteTollOptions tolls;

        private RouteTrafficOptions traffic;

        private String travelMode;

        private RouteTravelModeOptions travelModeOptions;

        private String travelStepType;

        private List<RouteWaypoint> waypoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRoutesRequest model) {
            super(model);
            allow(model.allow);
            arrivalTime(model.arrivalTime);
            avoid(model.avoid);
            departNow(model.departNow);
            departureTime(model.departureTime);
            destination(model.destination);
            destinationOptions(model.destinationOptions);
            driver(model.driver);
            exclude(model.exclude);
            instructionsMeasurementSystem(model.instructionsMeasurementSystem);
            key(model.key);
            languages(model.languages);
            legAdditionalFeaturesWithStrings(model.legAdditionalFeatures);
            legGeometryFormat(model.legGeometryFormat);
            maxAlternatives(model.maxAlternatives);
            optimizeRoutingFor(model.optimizeRoutingFor);
            origin(model.origin);
            originOptions(model.originOptions);
            spanAdditionalFeaturesWithStrings(model.spanAdditionalFeatures);
            tolls(model.tolls);
            traffic(model.traffic);
            travelMode(model.travelMode);
            travelModeOptions(model.travelModeOptions);
            travelStepType(model.travelStepType);
            waypoints(model.waypoints);
        }

        public final RouteAllowOptions.Builder getAllow() {
            return allow != null ? allow.toBuilder() : null;
        }

        public final void setAllow(RouteAllowOptions.BuilderImpl allow) {
            this.allow = allow != null ? allow.build() : null;
        }

        @Override
        public final Builder allow(RouteAllowOptions allow) {
            this.allow = allow;
            return this;
        }

        public final String getArrivalTime() {
            return arrivalTime;
        }

        public final void setArrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
        }

        @Override
        public final Builder arrivalTime(String arrivalTime) {
            this.arrivalTime = arrivalTime;
            return this;
        }

        public final RouteAvoidanceOptions.Builder getAvoid() {
            return avoid != null ? avoid.toBuilder() : null;
        }

        public final void setAvoid(RouteAvoidanceOptions.BuilderImpl avoid) {
            this.avoid = avoid != null ? avoid.build() : null;
        }

        @Override
        public final Builder avoid(RouteAvoidanceOptions avoid) {
            this.avoid = avoid;
            return this;
        }

        public final Boolean getDepartNow() {
            return departNow;
        }

        public final void setDepartNow(Boolean departNow) {
            this.departNow = departNow;
        }

        @Override
        public final Builder departNow(Boolean departNow) {
            this.departNow = departNow;
            return this;
        }

        public final String getDepartureTime() {
            return departureTime;
        }

        public final void setDepartureTime(String departureTime) {
            this.departureTime = departureTime;
        }

        @Override
        public final Builder departureTime(String departureTime) {
            this.departureTime = departureTime;
            return this;
        }

        public final Collection<Double> getDestination() {
            if (destination instanceof SdkAutoConstructList) {
                return null;
            }
            return destination;
        }

        public final void setDestination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
        }

        @Override
        public final Builder destination(Collection<Double> destination) {
            this.destination = PositionCopier.copy(destination);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destination(Double... destination) {
            destination(Arrays.asList(destination));
            return this;
        }

        public final RouteDestinationOptions.Builder getDestinationOptions() {
            return destinationOptions != null ? destinationOptions.toBuilder() : null;
        }

        public final void setDestinationOptions(RouteDestinationOptions.BuilderImpl destinationOptions) {
            this.destinationOptions = destinationOptions != null ? destinationOptions.build() : null;
        }

        @Override
        public final Builder destinationOptions(RouteDestinationOptions destinationOptions) {
            this.destinationOptions = destinationOptions;
            return this;
        }

        public final RouteDriverOptions.Builder getDriver() {
            return driver != null ? driver.toBuilder() : null;
        }

        public final void setDriver(RouteDriverOptions.BuilderImpl driver) {
            this.driver = driver != null ? driver.build() : null;
        }

        @Override
        public final Builder driver(RouteDriverOptions driver) {
            this.driver = driver;
            return this;
        }

        public final RouteExclusionOptions.Builder getExclude() {
            return exclude != null ? exclude.toBuilder() : null;
        }

        public final void setExclude(RouteExclusionOptions.BuilderImpl exclude) {
            this.exclude = exclude != null ? exclude.build() : null;
        }

        @Override
        public final Builder exclude(RouteExclusionOptions exclude) {
            this.exclude = exclude;
            return this;
        }

        public final String getInstructionsMeasurementSystem() {
            return instructionsMeasurementSystem;
        }

        public final void setInstructionsMeasurementSystem(String instructionsMeasurementSystem) {
            this.instructionsMeasurementSystem = instructionsMeasurementSystem;
        }

        @Override
        public final Builder instructionsMeasurementSystem(String instructionsMeasurementSystem) {
            this.instructionsMeasurementSystem = instructionsMeasurementSystem;
            return this;
        }

        @Override
        public final Builder instructionsMeasurementSystem(MeasurementSystem instructionsMeasurementSystem) {
            this.instructionsMeasurementSystem(instructionsMeasurementSystem == null ? null : instructionsMeasurementSystem
                    .toString());
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Collection<String> getLanguages() {
            if (languages instanceof SdkAutoConstructList) {
                return null;
            }
            return languages;
        }

        public final void setLanguages(Collection<String> languages) {
            this.languages = CalculateRoutesRequestLanguagesListCopier.copy(languages);
        }

        @Override
        public final Builder languages(Collection<String> languages) {
            this.languages = CalculateRoutesRequestLanguagesListCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(String... languages) {
            languages(Arrays.asList(languages));
            return this;
        }

        public final Collection<String> getLegAdditionalFeatures() {
            if (legAdditionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return legAdditionalFeatures;
        }

        public final void setLegAdditionalFeatures(Collection<String> legAdditionalFeatures) {
            this.legAdditionalFeatures = RouteLegAdditionalFeatureListCopier.copy(legAdditionalFeatures);
        }

        @Override
        public final Builder legAdditionalFeaturesWithStrings(Collection<String> legAdditionalFeatures) {
            this.legAdditionalFeatures = RouteLegAdditionalFeatureListCopier.copy(legAdditionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legAdditionalFeaturesWithStrings(String... legAdditionalFeatures) {
            legAdditionalFeaturesWithStrings(Arrays.asList(legAdditionalFeatures));
            return this;
        }

        @Override
        public final Builder legAdditionalFeatures(Collection<RouteLegAdditionalFeature> legAdditionalFeatures) {
            this.legAdditionalFeatures = RouteLegAdditionalFeatureListCopier.copyEnumToString(legAdditionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legAdditionalFeatures(RouteLegAdditionalFeature... legAdditionalFeatures) {
            legAdditionalFeatures(Arrays.asList(legAdditionalFeatures));
            return this;
        }

        public final String getLegGeometryFormat() {
            return legGeometryFormat;
        }

        public final void setLegGeometryFormat(String legGeometryFormat) {
            this.legGeometryFormat = legGeometryFormat;
        }

        @Override
        public final Builder legGeometryFormat(String legGeometryFormat) {
            this.legGeometryFormat = legGeometryFormat;
            return this;
        }

        @Override
        public final Builder legGeometryFormat(GeometryFormat legGeometryFormat) {
            this.legGeometryFormat(legGeometryFormat == null ? null : legGeometryFormat.toString());
            return this;
        }

        public final Integer getMaxAlternatives() {
            return maxAlternatives;
        }

        public final void setMaxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
        }

        @Override
        public final Builder maxAlternatives(Integer maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public final String getOptimizeRoutingFor() {
            return optimizeRoutingFor;
        }

        public final void setOptimizeRoutingFor(String optimizeRoutingFor) {
            this.optimizeRoutingFor = optimizeRoutingFor;
        }

        @Override
        public final Builder optimizeRoutingFor(String optimizeRoutingFor) {
            this.optimizeRoutingFor = optimizeRoutingFor;
            return this;
        }

        @Override
        public final Builder optimizeRoutingFor(RoutingObjective optimizeRoutingFor) {
            this.optimizeRoutingFor(optimizeRoutingFor == null ? null : optimizeRoutingFor.toString());
            return this;
        }

        public final Collection<Double> getOrigin() {
            if (origin instanceof SdkAutoConstructList) {
                return null;
            }
            return origin;
        }

        public final void setOrigin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
        }

        @Override
        public final Builder origin(Collection<Double> origin) {
            this.origin = PositionCopier.copy(origin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder origin(Double... origin) {
            origin(Arrays.asList(origin));
            return this;
        }

        public final RouteOriginOptions.Builder getOriginOptions() {
            return originOptions != null ? originOptions.toBuilder() : null;
        }

        public final void setOriginOptions(RouteOriginOptions.BuilderImpl originOptions) {
            this.originOptions = originOptions != null ? originOptions.build() : null;
        }

        @Override
        public final Builder originOptions(RouteOriginOptions originOptions) {
            this.originOptions = originOptions;
            return this;
        }

        public final Collection<String> getSpanAdditionalFeatures() {
            if (spanAdditionalFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return spanAdditionalFeatures;
        }

        public final void setSpanAdditionalFeatures(Collection<String> spanAdditionalFeatures) {
            this.spanAdditionalFeatures = RouteSpanAdditionalFeatureListCopier.copy(spanAdditionalFeatures);
        }

        @Override
        public final Builder spanAdditionalFeaturesWithStrings(Collection<String> spanAdditionalFeatures) {
            this.spanAdditionalFeatures = RouteSpanAdditionalFeatureListCopier.copy(spanAdditionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spanAdditionalFeaturesWithStrings(String... spanAdditionalFeatures) {
            spanAdditionalFeaturesWithStrings(Arrays.asList(spanAdditionalFeatures));
            return this;
        }

        @Override
        public final Builder spanAdditionalFeatures(Collection<RouteSpanAdditionalFeature> spanAdditionalFeatures) {
            this.spanAdditionalFeatures = RouteSpanAdditionalFeatureListCopier.copyEnumToString(spanAdditionalFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spanAdditionalFeatures(RouteSpanAdditionalFeature... spanAdditionalFeatures) {
            spanAdditionalFeatures(Arrays.asList(spanAdditionalFeatures));
            return this;
        }

        public final RouteTollOptions.Builder getTolls() {
            return tolls != null ? tolls.toBuilder() : null;
        }

        public final void setTolls(RouteTollOptions.BuilderImpl tolls) {
            this.tolls = tolls != null ? tolls.build() : null;
        }

        @Override
        public final Builder tolls(RouteTollOptions tolls) {
            this.tolls = tolls;
            return this;
        }

        public final RouteTrafficOptions.Builder getTraffic() {
            return traffic != null ? traffic.toBuilder() : null;
        }

        public final void setTraffic(RouteTrafficOptions.BuilderImpl traffic) {
            this.traffic = traffic != null ? traffic.build() : null;
        }

        @Override
        public final Builder traffic(RouteTrafficOptions traffic) {
            this.traffic = traffic;
            return this;
        }

        public final String getTravelMode() {
            return travelMode;
        }

        public final void setTravelMode(String travelMode) {
            this.travelMode = travelMode;
        }

        @Override
        public final Builder travelMode(String travelMode) {
            this.travelMode = travelMode;
            return this;
        }

        @Override
        public final Builder travelMode(RouteTravelMode travelMode) {
            this.travelMode(travelMode == null ? null : travelMode.toString());
            return this;
        }

        public final RouteTravelModeOptions.Builder getTravelModeOptions() {
            return travelModeOptions != null ? travelModeOptions.toBuilder() : null;
        }

        public final void setTravelModeOptions(RouteTravelModeOptions.BuilderImpl travelModeOptions) {
            this.travelModeOptions = travelModeOptions != null ? travelModeOptions.build() : null;
        }

        @Override
        public final Builder travelModeOptions(RouteTravelModeOptions travelModeOptions) {
            this.travelModeOptions = travelModeOptions;
            return this;
        }

        public final String getTravelStepType() {
            return travelStepType;
        }

        public final void setTravelStepType(String travelStepType) {
            this.travelStepType = travelStepType;
        }

        @Override
        public final Builder travelStepType(String travelStepType) {
            this.travelStepType = travelStepType;
            return this;
        }

        @Override
        public final Builder travelStepType(RouteTravelStepType travelStepType) {
            this.travelStepType(travelStepType == null ? null : travelStepType.toString());
            return this;
        }

        public final List<RouteWaypoint.Builder> getWaypoints() {
            List<RouteWaypoint.Builder> result = RouteWaypointListCopier.copyToBuilder(this.waypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWaypoints(Collection<RouteWaypoint.BuilderImpl> waypoints) {
            this.waypoints = RouteWaypointListCopier.copyFromBuilder(waypoints);
        }

        @Override
        public final Builder waypoints(Collection<RouteWaypoint> waypoints) {
            this.waypoints = RouteWaypointListCopier.copy(waypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waypoints(RouteWaypoint... waypoints) {
            waypoints(Arrays.asList(waypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder waypoints(Consumer<RouteWaypoint.Builder>... waypoints) {
            waypoints(Stream.of(waypoints).map(c -> RouteWaypoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CalculateRoutesRequest build() {
            return new CalculateRoutesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
