/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Isolines may contain multiple components, if these components are connected by ferry links. These components are
 * returned as separate polygons while the ferry links are returned as connections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsolineConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<IsolineConnection.Builder, IsolineConnection> {
    private static final SdkField<Integer> FROM_POLYGON_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPolygonIndex").getter(getter(IsolineConnection::fromPolygonIndex))
            .setter(setter(Builder::fromPolygonIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPolygonIndex").build()).build();

    private static final SdkField<IsolineConnectionGeometry> GEOMETRY_FIELD = SdkField
            .<IsolineConnectionGeometry> builder(MarshallingType.SDK_POJO).memberName("Geometry")
            .getter(getter(IsolineConnection::geometry)).setter(setter(Builder::geometry))
            .constructor(IsolineConnectionGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final SdkField<Integer> TO_POLYGON_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPolygonIndex").getter(getter(IsolineConnection::toPolygonIndex))
            .setter(setter(Builder::toPolygonIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPolygonIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_POLYGON_INDEX_FIELD,
            GEOMETRY_FIELD, TO_POLYGON_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer fromPolygonIndex;

    private final IsolineConnectionGeometry geometry;

    private final Integer toPolygonIndex;

    private IsolineConnection(BuilderImpl builder) {
        this.fromPolygonIndex = builder.fromPolygonIndex;
        this.geometry = builder.geometry;
        this.toPolygonIndex = builder.toPolygonIndex;
    }

    /**
     * <p>
     * Index of the polygon corresponding to the "from" component of the connection. The polygon is available from
     * <code>Isoline[].Geometries</code>.
     * </p>
     * 
     * @return Index of the polygon corresponding to the "from" component of the connection. The polygon is available
     *         from <code>Isoline[].Geometries</code>.
     */
    public final Integer fromPolygonIndex() {
        return fromPolygonIndex;
    }

    /**
     * <p>
     * The isoline geometry.
     * </p>
     * 
     * @return The isoline geometry.
     */
    public final IsolineConnectionGeometry geometry() {
        return geometry;
    }

    /**
     * <p>
     * Index of the polygon corresponding to the "to" component of the connection. The polygon is available from
     * <code>Isoline[].Geometries</code>.
     * </p>
     * 
     * @return Index of the polygon corresponding to the "to" component of the connection. The polygon is available from
     *         <code>Isoline[].Geometries</code>.
     */
    public final Integer toPolygonIndex() {
        return toPolygonIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromPolygonIndex());
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        hashCode = 31 * hashCode + Objects.hashCode(toPolygonIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineConnection)) {
            return false;
        }
        IsolineConnection other = (IsolineConnection) obj;
        return Objects.equals(fromPolygonIndex(), other.fromPolygonIndex()) && Objects.equals(geometry(), other.geometry())
                && Objects.equals(toPolygonIndex(), other.toPolygonIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IsolineConnection").add("FromPolygonIndex", fromPolygonIndex()).add("Geometry", geometry())
                .add("ToPolygonIndex", toPolygonIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromPolygonIndex":
            return Optional.ofNullable(clazz.cast(fromPolygonIndex()));
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        case "ToPolygonIndex":
            return Optional.ofNullable(clazz.cast(toPolygonIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FromPolygonIndex", FROM_POLYGON_INDEX_FIELD);
        map.put("Geometry", GEOMETRY_FIELD);
        map.put("ToPolygonIndex", TO_POLYGON_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IsolineConnection, T> g) {
        return obj -> g.apply((IsolineConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IsolineConnection> {
        /**
         * <p>
         * Index of the polygon corresponding to the "from" component of the connection. The polygon is available from
         * <code>Isoline[].Geometries</code>.
         * </p>
         * 
         * @param fromPolygonIndex
         *        Index of the polygon corresponding to the "from" component of the connection. The polygon is available
         *        from <code>Isoline[].Geometries</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPolygonIndex(Integer fromPolygonIndex);

        /**
         * <p>
         * The isoline geometry.
         * </p>
         * 
         * @param geometry
         *        The isoline geometry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(IsolineConnectionGeometry geometry);

        /**
         * <p>
         * The isoline geometry.
         * </p>
         * This is a convenience method that creates an instance of the {@link IsolineConnectionGeometry.Builder}
         * avoiding the need to create one manually via {@link IsolineConnectionGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IsolineConnectionGeometry.Builder#build()} is called immediately
         * and its result is passed to {@link #geometry(IsolineConnectionGeometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link IsolineConnectionGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(IsolineConnectionGeometry)
         */
        default Builder geometry(Consumer<IsolineConnectionGeometry.Builder> geometry) {
            return geometry(IsolineConnectionGeometry.builder().applyMutation(geometry).build());
        }

        /**
         * <p>
         * Index of the polygon corresponding to the "to" component of the connection. The polygon is available from
         * <code>Isoline[].Geometries</code>.
         * </p>
         * 
         * @param toPolygonIndex
         *        Index of the polygon corresponding to the "to" component of the connection. The polygon is available
         *        from <code>Isoline[].Geometries</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPolygonIndex(Integer toPolygonIndex);
    }

    static final class BuilderImpl implements Builder {
        private Integer fromPolygonIndex;

        private IsolineConnectionGeometry geometry;

        private Integer toPolygonIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineConnection model) {
            fromPolygonIndex(model.fromPolygonIndex);
            geometry(model.geometry);
            toPolygonIndex(model.toPolygonIndex);
        }

        public final Integer getFromPolygonIndex() {
            return fromPolygonIndex;
        }

        public final void setFromPolygonIndex(Integer fromPolygonIndex) {
            this.fromPolygonIndex = fromPolygonIndex;
        }

        @Override
        public final Builder fromPolygonIndex(Integer fromPolygonIndex) {
            this.fromPolygonIndex = fromPolygonIndex;
            return this;
        }

        public final IsolineConnectionGeometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(IsolineConnectionGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(IsolineConnectionGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final Integer getToPolygonIndex() {
            return toPolygonIndex;
        }

        public final void setToPolygonIndex(Integer toPolygonIndex) {
            this.toPolygonIndex = toPolygonIndex;
        }

        @Override
        public final Builder toPolygonIndex(Integer toPolygonIndex) {
            this.toPolygonIndex = toPolygonIndex;
            return this;
        }

        @Override
        public IsolineConnection build() {
            return new IsolineConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
