/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizeWaypointsResponse extends GeoRoutesResponse implements
        ToCopyableBuilder<OptimizeWaypointsResponse.Builder, OptimizeWaypointsResponse> {
    private static final SdkField<List<WaypointOptimizationConnection>> CONNECTIONS_FIELD = SdkField
            .<List<WaypointOptimizationConnection>> builder(MarshallingType.LIST)
            .memberName("Connections")
            .getter(getter(OptimizeWaypointsResponse::connections))
            .setter(setter(Builder::connections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WaypointOptimizationConnection> builder(MarshallingType.SDK_POJO)
                                            .constructor(WaypointOptimizationConnection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Distance")
            .getter(getter(OptimizeWaypointsResponse::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(OptimizeWaypointsResponse::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<List<WaypointOptimizationImpedingWaypoint>> IMPEDING_WAYPOINTS_FIELD = SdkField
            .<List<WaypointOptimizationImpedingWaypoint>> builder(MarshallingType.LIST)
            .memberName("ImpedingWaypoints")
            .getter(getter(OptimizeWaypointsResponse::impedingWaypoints))
            .setter(setter(Builder::impedingWaypoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpedingWaypoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WaypointOptimizationImpedingWaypoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(WaypointOptimizationImpedingWaypoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WaypointOptimizationOptimizedWaypoint>> OPTIMIZED_WAYPOINTS_FIELD = SdkField
            .<List<WaypointOptimizationOptimizedWaypoint>> builder(MarshallingType.LIST)
            .memberName("OptimizedWaypoints")
            .getter(getter(OptimizeWaypointsResponse::optimizedWaypoints))
            .setter(setter(Builder::optimizedWaypoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizedWaypoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WaypointOptimizationOptimizedWaypoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(WaypointOptimizationOptimizedWaypoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingBucket").getter(getter(OptimizeWaypointsResponse::pricingBucket))
            .setter(setter(Builder::pricingBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build())
            .build();

    private static final SdkField<WaypointOptimizationTimeBreakdown> TIME_BREAKDOWN_FIELD = SdkField
            .<WaypointOptimizationTimeBreakdown> builder(MarshallingType.SDK_POJO).memberName("TimeBreakdown")
            .getter(getter(OptimizeWaypointsResponse::timeBreakdown)).setter(setter(Builder::timeBreakdown))
            .constructor(WaypointOptimizationTimeBreakdown::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeBreakdown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_FIELD,
            DISTANCE_FIELD, DURATION_FIELD, IMPEDING_WAYPOINTS_FIELD, OPTIMIZED_WAYPOINTS_FIELD, PRICING_BUCKET_FIELD,
            TIME_BREAKDOWN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<WaypointOptimizationConnection> connections;

    private final Long distance;

    private final Long duration;

    private final List<WaypointOptimizationImpedingWaypoint> impedingWaypoints;

    private final List<WaypointOptimizationOptimizedWaypoint> optimizedWaypoints;

    private final String pricingBucket;

    private final WaypointOptimizationTimeBreakdown timeBreakdown;

    private OptimizeWaypointsResponse(BuilderImpl builder) {
        super(builder);
        this.connections = builder.connections;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.impedingWaypoints = builder.impedingWaypoints;
        this.optimizedWaypoints = builder.optimizedWaypoints;
        this.pricingBucket = builder.pricingBucket;
        this.timeBreakdown = builder.timeBreakdown;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnections() {
        return connections != null && !(connections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the connection from one waypoint to the next, within the optimized sequence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnections} method.
     * </p>
     * 
     * @return Details about the connection from one waypoint to the next, within the optimized sequence.
     */
    public final List<WaypointOptimizationConnection> connections() {
        return connections;
    }

    /**
     * <p>
     * Overall distance to travel the whole sequence.
     * </p>
     * 
     * @return Overall distance to travel the whole sequence.
     */
    public final Long distance() {
        return distance;
    }

    /**
     * <p>
     * Overall duration to travel the whole sequence.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Overall duration to travel the whole sequence.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long duration() {
        return duration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpedingWaypoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImpedingWaypoints() {
        return impedingWaypoints != null && !(impedingWaypoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns waypoints that caused the optimization problem to fail, and the constraints that were unsatisfied leading
     * to the failure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpedingWaypoints} method.
     * </p>
     * 
     * @return Returns waypoints that caused the optimization problem to fail, and the constraints that were unsatisfied
     *         leading to the failure.
     */
    public final List<WaypointOptimizationImpedingWaypoint> impedingWaypoints() {
        return impedingWaypoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptimizedWaypoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptimizedWaypoints() {
        return optimizedWaypoints != null && !(optimizedWaypoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Waypoints in the order of the optimized sequence.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptimizedWaypoints} method.
     * </p>
     * 
     * @return Waypoints in the order of the optimized sequence.
     */
    public final List<WaypointOptimizationOptimizedWaypoint> optimizedWaypoints() {
        return optimizedWaypoints;
    }

    /**
     * <p>
     * The pricing bucket for which the query is charged at.
     * </p>
     * 
     * @return The pricing bucket for which the query is charged at.
     */
    public final String pricingBucket() {
        return pricingBucket;
    }

    /**
     * <p>
     * Time breakdown for the sequence.
     * </p>
     * 
     * @return Time breakdown for the sequence.
     */
    public final WaypointOptimizationTimeBreakdown timeBreakdown() {
        return timeBreakdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConnections() ? connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(hasImpedingWaypoints() ? impedingWaypoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptimizedWaypoints() ? optimizedWaypoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(timeBreakdown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizeWaypointsResponse)) {
            return false;
        }
        OptimizeWaypointsResponse other = (OptimizeWaypointsResponse) obj;
        return hasConnections() == other.hasConnections() && Objects.equals(connections(), other.connections())
                && Objects.equals(distance(), other.distance()) && Objects.equals(duration(), other.duration())
                && hasImpedingWaypoints() == other.hasImpedingWaypoints()
                && Objects.equals(impedingWaypoints(), other.impedingWaypoints())
                && hasOptimizedWaypoints() == other.hasOptimizedWaypoints()
                && Objects.equals(optimizedWaypoints(), other.optimizedWaypoints())
                && Objects.equals(pricingBucket(), other.pricingBucket())
                && Objects.equals(timeBreakdown(), other.timeBreakdown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizeWaypointsResponse").add("Connections", hasConnections() ? connections() : null)
                .add("Distance", distance() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Duration", duration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ImpedingWaypoints", hasImpedingWaypoints() ? impedingWaypoints() : null)
                .add("OptimizedWaypoints", hasOptimizedWaypoints() ? optimizedWaypoints() : null)
                .add("PricingBucket", pricingBucket()).add("TimeBreakdown", timeBreakdown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Connections":
            return Optional.ofNullable(clazz.cast(connections()));
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "ImpedingWaypoints":
            return Optional.ofNullable(clazz.cast(impedingWaypoints()));
        case "OptimizedWaypoints":
            return Optional.ofNullable(clazz.cast(optimizedWaypoints()));
        case "PricingBucket":
            return Optional.ofNullable(clazz.cast(pricingBucket()));
        case "TimeBreakdown":
            return Optional.ofNullable(clazz.cast(timeBreakdown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Connections", CONNECTIONS_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("ImpedingWaypoints", IMPEDING_WAYPOINTS_FIELD);
        map.put("OptimizedWaypoints", OPTIMIZED_WAYPOINTS_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("TimeBreakdown", TIME_BREAKDOWN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizeWaypointsResponse, T> g) {
        return obj -> g.apply((OptimizeWaypointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GeoRoutesResponse.Builder, SdkPojo, CopyableBuilder<Builder, OptimizeWaypointsResponse> {
        /**
         * <p>
         * Details about the connection from one waypoint to the next, within the optimized sequence.
         * </p>
         * 
         * @param connections
         *        Details about the connection from one waypoint to the next, within the optimized sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(Collection<WaypointOptimizationConnection> connections);

        /**
         * <p>
         * Details about the connection from one waypoint to the next, within the optimized sequence.
         * </p>
         * 
         * @param connections
         *        Details about the connection from one waypoint to the next, within the optimized sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(WaypointOptimizationConnection... connections);

        /**
         * <p>
         * Details about the connection from one waypoint to the next, within the optimized sequence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationConnection.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationConnection.Builder#build()} is
         * called immediately and its result is passed to {@link #connections(List<WaypointOptimizationConnection>)}.
         * 
         * @param connections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connections(java.util.Collection<WaypointOptimizationConnection>)
         */
        Builder connections(Consumer<WaypointOptimizationConnection.Builder>... connections);

        /**
         * <p>
         * Overall distance to travel the whole sequence.
         * </p>
         * 
         * @param distance
         *        Overall distance to travel the whole sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Long distance);

        /**
         * <p>
         * Overall duration to travel the whole sequence.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param duration
         *        Overall duration to travel the whole sequence.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * Returns waypoints that caused the optimization problem to fail, and the constraints that were unsatisfied
         * leading to the failure.
         * </p>
         * 
         * @param impedingWaypoints
         *        Returns waypoints that caused the optimization problem to fail, and the constraints that were
         *        unsatisfied leading to the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impedingWaypoints(Collection<WaypointOptimizationImpedingWaypoint> impedingWaypoints);

        /**
         * <p>
         * Returns waypoints that caused the optimization problem to fail, and the constraints that were unsatisfied
         * leading to the failure.
         * </p>
         * 
         * @param impedingWaypoints
         *        Returns waypoints that caused the optimization problem to fail, and the constraints that were
         *        unsatisfied leading to the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impedingWaypoints(WaypointOptimizationImpedingWaypoint... impedingWaypoints);

        /**
         * <p>
         * Returns waypoints that caused the optimization problem to fail, and the constraints that were unsatisfied
         * leading to the failure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationImpedingWaypoint.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationImpedingWaypoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationImpedingWaypoint.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #impedingWaypoints(List<WaypointOptimizationImpedingWaypoint>)}.
         * 
         * @param impedingWaypoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationImpedingWaypoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #impedingWaypoints(java.util.Collection<WaypointOptimizationImpedingWaypoint>)
         */
        Builder impedingWaypoints(Consumer<WaypointOptimizationImpedingWaypoint.Builder>... impedingWaypoints);

        /**
         * <p>
         * Waypoints in the order of the optimized sequence.
         * </p>
         * 
         * @param optimizedWaypoints
         *        Waypoints in the order of the optimized sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizedWaypoints(Collection<WaypointOptimizationOptimizedWaypoint> optimizedWaypoints);

        /**
         * <p>
         * Waypoints in the order of the optimized sequence.
         * </p>
         * 
         * @param optimizedWaypoints
         *        Waypoints in the order of the optimized sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizedWaypoints(WaypointOptimizationOptimizedWaypoint... optimizedWaypoints);

        /**
         * <p>
         * Waypoints in the order of the optimized sequence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationOptimizedWaypoint.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationOptimizedWaypoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationOptimizedWaypoint.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #optimizedWaypoints(List<WaypointOptimizationOptimizedWaypoint>)}.
         * 
         * @param optimizedWaypoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.WaypointOptimizationOptimizedWaypoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optimizedWaypoints(java.util.Collection<WaypointOptimizationOptimizedWaypoint>)
         */
        Builder optimizedWaypoints(Consumer<WaypointOptimizationOptimizedWaypoint.Builder>... optimizedWaypoints);

        /**
         * <p>
         * The pricing bucket for which the query is charged at.
         * </p>
         * 
         * @param pricingBucket
         *        The pricing bucket for which the query is charged at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingBucket(String pricingBucket);

        /**
         * <p>
         * Time breakdown for the sequence.
         * </p>
         * 
         * @param timeBreakdown
         *        Time breakdown for the sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeBreakdown(WaypointOptimizationTimeBreakdown timeBreakdown);

        /**
         * <p>
         * Time breakdown for the sequence.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WaypointOptimizationTimeBreakdown.Builder} avoiding the need to create one manually via
         * {@link WaypointOptimizationTimeBreakdown#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaypointOptimizationTimeBreakdown.Builder#build()} is called
         * immediately and its result is passed to {@link #timeBreakdown(WaypointOptimizationTimeBreakdown)}.
         * 
         * @param timeBreakdown
         *        a consumer that will call methods on {@link WaypointOptimizationTimeBreakdown.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeBreakdown(WaypointOptimizationTimeBreakdown)
         */
        default Builder timeBreakdown(Consumer<WaypointOptimizationTimeBreakdown.Builder> timeBreakdown) {
            return timeBreakdown(WaypointOptimizationTimeBreakdown.builder().applyMutation(timeBreakdown).build());
        }
    }

    static final class BuilderImpl extends GeoRoutesResponse.BuilderImpl implements Builder {
        private List<WaypointOptimizationConnection> connections = DefaultSdkAutoConstructList.getInstance();

        private Long distance;

        private Long duration;

        private List<WaypointOptimizationImpedingWaypoint> impedingWaypoints = DefaultSdkAutoConstructList.getInstance();

        private List<WaypointOptimizationOptimizedWaypoint> optimizedWaypoints = DefaultSdkAutoConstructList.getInstance();

        private String pricingBucket;

        private WaypointOptimizationTimeBreakdown timeBreakdown;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizeWaypointsResponse model) {
            super(model);
            connections(model.connections);
            distance(model.distance);
            duration(model.duration);
            impedingWaypoints(model.impedingWaypoints);
            optimizedWaypoints(model.optimizedWaypoints);
            pricingBucket(model.pricingBucket);
            timeBreakdown(model.timeBreakdown);
        }

        public final List<WaypointOptimizationConnection.Builder> getConnections() {
            List<WaypointOptimizationConnection.Builder> result = WaypointOptimizationConnectionListCopier
                    .copyToBuilder(this.connections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnections(Collection<WaypointOptimizationConnection.BuilderImpl> connections) {
            this.connections = WaypointOptimizationConnectionListCopier.copyFromBuilder(connections);
        }

        @Override
        public final Builder connections(Collection<WaypointOptimizationConnection> connections) {
            this.connections = WaypointOptimizationConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(WaypointOptimizationConnection... connections) {
            connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<WaypointOptimizationConnection.Builder>... connections) {
            connections(Stream.of(connections).map(c -> WaypointOptimizationConnection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getDistance() {
            return distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final List<WaypointOptimizationImpedingWaypoint.Builder> getImpedingWaypoints() {
            List<WaypointOptimizationImpedingWaypoint.Builder> result = WaypointOptimizationImpedingWaypointListCopier
                    .copyToBuilder(this.impedingWaypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpedingWaypoints(Collection<WaypointOptimizationImpedingWaypoint.BuilderImpl> impedingWaypoints) {
            this.impedingWaypoints = WaypointOptimizationImpedingWaypointListCopier.copyFromBuilder(impedingWaypoints);
        }

        @Override
        public final Builder impedingWaypoints(Collection<WaypointOptimizationImpedingWaypoint> impedingWaypoints) {
            this.impedingWaypoints = WaypointOptimizationImpedingWaypointListCopier.copy(impedingWaypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impedingWaypoints(WaypointOptimizationImpedingWaypoint... impedingWaypoints) {
            impedingWaypoints(Arrays.asList(impedingWaypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impedingWaypoints(Consumer<WaypointOptimizationImpedingWaypoint.Builder>... impedingWaypoints) {
            impedingWaypoints(Stream.of(impedingWaypoints)
                    .map(c -> WaypointOptimizationImpedingWaypoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<WaypointOptimizationOptimizedWaypoint.Builder> getOptimizedWaypoints() {
            List<WaypointOptimizationOptimizedWaypoint.Builder> result = WaypointOptimizationOptimizedWaypointListCopier
                    .copyToBuilder(this.optimizedWaypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptimizedWaypoints(Collection<WaypointOptimizationOptimizedWaypoint.BuilderImpl> optimizedWaypoints) {
            this.optimizedWaypoints = WaypointOptimizationOptimizedWaypointListCopier.copyFromBuilder(optimizedWaypoints);
        }

        @Override
        public final Builder optimizedWaypoints(Collection<WaypointOptimizationOptimizedWaypoint> optimizedWaypoints) {
            this.optimizedWaypoints = WaypointOptimizationOptimizedWaypointListCopier.copy(optimizedWaypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizedWaypoints(WaypointOptimizationOptimizedWaypoint... optimizedWaypoints) {
            optimizedWaypoints(Arrays.asList(optimizedWaypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizedWaypoints(Consumer<WaypointOptimizationOptimizedWaypoint.Builder>... optimizedWaypoints) {
            optimizedWaypoints(Stream.of(optimizedWaypoints)
                    .map(c -> WaypointOptimizationOptimizedWaypoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPricingBucket() {
            return pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final WaypointOptimizationTimeBreakdown.Builder getTimeBreakdown() {
            return timeBreakdown != null ? timeBreakdown.toBuilder() : null;
        }

        public final void setTimeBreakdown(WaypointOptimizationTimeBreakdown.BuilderImpl timeBreakdown) {
            this.timeBreakdown = timeBreakdown != null ? timeBreakdown.build() : null;
        }

        @Override
        public final Builder timeBreakdown(WaypointOptimizationTimeBreakdown timeBreakdown) {
            this.timeBreakdown = timeBreakdown;
            return this;
        }

        @Override
        public OptimizeWaypointsResponse build() {
            return new OptimizeWaypointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
