/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Geometry defined as an encoded corridor - an encoded polyline with a radius that defines the width of the corridor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolylineCorridor implements SdkPojo, Serializable,
        ToCopyableBuilder<PolylineCorridor.Builder, PolylineCorridor> {
    private static final SdkField<String> POLYLINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Polyline").getter(getter(PolylineCorridor::polyline)).setter(setter(Builder::polyline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Polyline").build()).build();

    private static final SdkField<Integer> RADIUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Radius").getter(getter(PolylineCorridor::radius)).setter(setter(Builder::radius))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Radius").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLYLINE_FIELD, RADIUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String polyline;

    private final Integer radius;

    private PolylineCorridor(BuilderImpl builder) {
        this.polyline = builder.polyline;
        this.radius = builder.radius;
    }

    /**
     * <p>
     * An ordered list of positions used to plot a route on a map in a lossy compression format.
     * </p>
     * <note>
     * <p>
     * LineString and Polyline are mutually exclusive properties.
     * </p>
     * </note>
     * 
     * @return An ordered list of positions used to plot a route on a map in a lossy compression format.</p> <note>
     *         <p>
     *         LineString and Polyline are mutually exclusive properties.
     *         </p>
     */
    public final String polyline() {
        return polyline;
    }

    /**
     * <p>
     * Considers all roads within the provided radius to match the provided destination to. The roads that are
     * considered are determined by the provided Strategy.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Meters</code>
     * </p>
     * 
     * @return Considers all roads within the provided radius to match the provided destination to. The roads that are
     *         considered are determined by the provided Strategy.</p>
     *         <p>
     *         <b>Unit</b>: <code>Meters</code>
     */
    public final Integer radius() {
        return radius;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(polyline());
        hashCode = 31 * hashCode + Objects.hashCode(radius());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolylineCorridor)) {
            return false;
        }
        PolylineCorridor other = (PolylineCorridor) obj;
        return Objects.equals(polyline(), other.polyline()) && Objects.equals(radius(), other.radius());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolylineCorridor")
                .add("Polyline", polyline() == null ? null : "*** Sensitive Data Redacted ***").add("Radius", radius()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Polyline":
            return Optional.ofNullable(clazz.cast(polyline()));
        case "Radius":
            return Optional.ofNullable(clazz.cast(radius()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Polyline", POLYLINE_FIELD);
        map.put("Radius", RADIUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolylineCorridor, T> g) {
        return obj -> g.apply((PolylineCorridor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolylineCorridor> {
        /**
         * <p>
         * An ordered list of positions used to plot a route on a map in a lossy compression format.
         * </p>
         * <note>
         * <p>
         * LineString and Polyline are mutually exclusive properties.
         * </p>
         * </note>
         * 
         * @param polyline
         *        An ordered list of positions used to plot a route on a map in a lossy compression format.</p> <note>
         *        <p>
         *        LineString and Polyline are mutually exclusive properties.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polyline(String polyline);

        /**
         * <p>
         * Considers all roads within the provided radius to match the provided destination to. The roads that are
         * considered are determined by the provided Strategy.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Meters</code>
         * </p>
         * 
         * @param radius
         *        Considers all roads within the provided radius to match the provided destination to. The roads that
         *        are considered are determined by the provided Strategy.</p>
         *        <p>
         *        <b>Unit</b>: <code>Meters</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder radius(Integer radius);
    }

    static final class BuilderImpl implements Builder {
        private String polyline;

        private Integer radius;

        private BuilderImpl() {
        }

        private BuilderImpl(PolylineCorridor model) {
            polyline(model.polyline);
            radius(model.radius);
        }

        public final String getPolyline() {
            return polyline;
        }

        public final void setPolyline(String polyline) {
            this.polyline = polyline;
        }

        @Override
        public final Builder polyline(String polyline) {
            this.polyline = polyline;
            return this;
        }

        public final Integer getRadius() {
            return radius;
        }

        public final void setRadius(Integer radius) {
            this.radius = radius;
        }

        @Override
        public final Builder radius(Integer radius) {
            this.radius = radius;
            return this;
        }

        @Override
        public PolylineCorridor build() {
            return new PolylineCorridor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
