/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Travel mode related options for the provided travel mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoadSnapTravelModeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RoadSnapTravelModeOptions.Builder, RoadSnapTravelModeOptions> {
    private static final SdkField<RoadSnapTruckOptions> TRUCK_FIELD = SdkField
            .<RoadSnapTruckOptions> builder(MarshallingType.SDK_POJO).memberName("Truck")
            .getter(getter(RoadSnapTravelModeOptions::truck)).setter(setter(Builder::truck))
            .constructor(RoadSnapTruckOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RoadSnapTruckOptions truck;

    private RoadSnapTravelModeOptions(BuilderImpl builder) {
        this.truck = builder.truck;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Truck".
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Truck".
     */
    public final RoadSnapTruckOptions truck() {
        return truck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(truck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoadSnapTravelModeOptions)) {
            return false;
        }
        RoadSnapTravelModeOptions other = (RoadSnapTravelModeOptions) obj;
        return Objects.equals(truck(), other.truck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoadSnapTravelModeOptions").add("Truck", truck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Truck":
            return Optional.ofNullable(clazz.cast(truck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Truck", TRUCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoadSnapTravelModeOptions, T> g) {
        return obj -> g.apply((RoadSnapTravelModeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoadSnapTravelModeOptions> {
        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck".
         * </p>
         * 
         * @param truck
         *        Travel mode options when the provided travel mode is "Truck".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truck(RoadSnapTruckOptions truck);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck".
         * </p>
         * This is a convenience method that creates an instance of the {@link RoadSnapTruckOptions.Builder} avoiding
         * the need to create one manually via {@link RoadSnapTruckOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoadSnapTruckOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #truck(RoadSnapTruckOptions)}.
         * 
         * @param truck
         *        a consumer that will call methods on {@link RoadSnapTruckOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #truck(RoadSnapTruckOptions)
         */
        default Builder truck(Consumer<RoadSnapTruckOptions.Builder> truck) {
            return truck(RoadSnapTruckOptions.builder().applyMutation(truck).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RoadSnapTruckOptions truck;

        private BuilderImpl() {
        }

        private BuilderImpl(RoadSnapTravelModeOptions model) {
            truck(model.truck);
        }

        public final RoadSnapTruckOptions.Builder getTruck() {
            return truck != null ? truck.toBuilder() : null;
        }

        public final void setTruck(RoadSnapTruckOptions.BuilderImpl truck) {
            this.truck = truck != null ? truck.build() : null;
        }

        @Override
        public final Builder truck(RoadSnapTruckOptions truck) {
            this.truck = truck;
            return this;
        }

        @Override
        public RoadSnapTravelModeOptions build() {
            return new RoadSnapTravelModeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
