/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Areas to be avoided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteAvoidanceArea implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteAvoidanceArea.Builder, RouteAvoidanceArea> {
    private static final SdkField<List<RouteAvoidanceAreaGeometry>> EXCEPT_FIELD = SdkField
            .<List<RouteAvoidanceAreaGeometry>> builder(MarshallingType.LIST)
            .memberName("Except")
            .getter(getter(RouteAvoidanceArea::except))
            .setter(setter(Builder::except))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Except").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteAvoidanceAreaGeometry> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteAvoidanceAreaGeometry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteAvoidanceAreaGeometry> GEOMETRY_FIELD = SdkField
            .<RouteAvoidanceAreaGeometry> builder(MarshallingType.SDK_POJO).memberName("Geometry")
            .getter(getter(RouteAvoidanceArea::geometry)).setter(setter(Builder::geometry))
            .constructor(RouteAvoidanceAreaGeometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPT_FIELD, GEOMETRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RouteAvoidanceAreaGeometry> except;

    private final RouteAvoidanceAreaGeometry geometry;

    private RouteAvoidanceArea(BuilderImpl builder) {
        this.except = builder.except;
        this.geometry = builder.geometry;
    }

    /**
     * For responses, this returns true if the service returned a value for the Except property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExcept() {
        return except != null && !(except instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Exceptions to the provided avoidance geometry, to be included while calculating the route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcept} method.
     * </p>
     * 
     * @return Exceptions to the provided avoidance geometry, to be included while calculating the route.
     */
    public final List<RouteAvoidanceAreaGeometry> except() {
        return except;
    }

    /**
     * Returns the value of the Geometry property for this object.
     * 
     * @return The value of the Geometry property for this object.
     */
    public final RouteAvoidanceAreaGeometry geometry() {
        return geometry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExcept() ? except() : null);
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAvoidanceArea)) {
            return false;
        }
        RouteAvoidanceArea other = (RouteAvoidanceArea) obj;
        return hasExcept() == other.hasExcept() && Objects.equals(except(), other.except())
                && Objects.equals(geometry(), other.geometry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteAvoidanceArea").add("Except", hasExcept() ? except() : null).add("Geometry", geometry())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Except":
            return Optional.ofNullable(clazz.cast(except()));
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Except", EXCEPT_FIELD);
        map.put("Geometry", GEOMETRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteAvoidanceArea, T> g) {
        return obj -> g.apply((RouteAvoidanceArea) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteAvoidanceArea> {
        /**
         * <p>
         * Exceptions to the provided avoidance geometry, to be included while calculating the route.
         * </p>
         * 
         * @param except
         *        Exceptions to the provided avoidance geometry, to be included while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder except(Collection<RouteAvoidanceAreaGeometry> except);

        /**
         * <p>
         * Exceptions to the provided avoidance geometry, to be included while calculating the route.
         * </p>
         * 
         * @param except
         *        Exceptions to the provided avoidance geometry, to be included while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder except(RouteAvoidanceAreaGeometry... except);

        /**
         * <p>
         * Exceptions to the provided avoidance geometry, to be included while calculating the route.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceAreaGeometry.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceAreaGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceAreaGeometry.Builder#build()} is called
         * immediately and its result is passed to {@link #except(List<RouteAvoidanceAreaGeometry>)}.
         * 
         * @param except
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceAreaGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #except(java.util.Collection<RouteAvoidanceAreaGeometry>)
         */
        Builder except(Consumer<RouteAvoidanceAreaGeometry.Builder>... except);

        /**
         * Sets the value of the Geometry property for this object.
         *
         * @param geometry
         *        The new value for the Geometry property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(RouteAvoidanceAreaGeometry geometry);

        /**
         * Sets the value of the Geometry property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RouteAvoidanceAreaGeometry.Builder}
         * avoiding the need to create one manually via {@link RouteAvoidanceAreaGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteAvoidanceAreaGeometry.Builder#build()} is called immediately
         * and its result is passed to {@link #geometry(RouteAvoidanceAreaGeometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link RouteAvoidanceAreaGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(RouteAvoidanceAreaGeometry)
         */
        default Builder geometry(Consumer<RouteAvoidanceAreaGeometry.Builder> geometry) {
            return geometry(RouteAvoidanceAreaGeometry.builder().applyMutation(geometry).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<RouteAvoidanceAreaGeometry> except = DefaultSdkAutoConstructList.getInstance();

        private RouteAvoidanceAreaGeometry geometry;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAvoidanceArea model) {
            except(model.except);
            geometry(model.geometry);
        }

        public final List<RouteAvoidanceAreaGeometry.Builder> getExcept() {
            List<RouteAvoidanceAreaGeometry.Builder> result = RouteAvoidanceAreaGeometryListCopier.copyToBuilder(this.except);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcept(Collection<RouteAvoidanceAreaGeometry.BuilderImpl> except) {
            this.except = RouteAvoidanceAreaGeometryListCopier.copyFromBuilder(except);
        }

        @Override
        public final Builder except(Collection<RouteAvoidanceAreaGeometry> except) {
            this.except = RouteAvoidanceAreaGeometryListCopier.copy(except);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder except(RouteAvoidanceAreaGeometry... except) {
            except(Arrays.asList(except));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder except(Consumer<RouteAvoidanceAreaGeometry.Builder>... except) {
            except(Stream.of(except).map(c -> RouteAvoidanceAreaGeometry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RouteAvoidanceAreaGeometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(RouteAvoidanceAreaGeometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(RouteAvoidanceAreaGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        @Override
        public RouteAvoidanceArea build() {
            return new RouteAvoidanceArea(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
