/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Interval of the driver work-rest schedule. Stops are added to fulfil the provided rest schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteDriverScheduleInterval implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteDriverScheduleInterval.Builder, RouteDriverScheduleInterval> {
    private static final SdkField<Long> DRIVE_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DriveDuration").getter(getter(RouteDriverScheduleInterval::driveDuration))
            .setter(setter(Builder::driveDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriveDuration").build()).build();

    private static final SdkField<Long> REST_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RestDuration").getter(getter(RouteDriverScheduleInterval::restDuration))
            .setter(setter(Builder::restDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRIVE_DURATION_FIELD,
            REST_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long driveDuration;

    private final Long restDuration;

    private RouteDriverScheduleInterval(BuilderImpl builder) {
        this.driveDuration = builder.driveDuration;
        this.restDuration = builder.restDuration;
    }

    /**
     * <p>
     * Maximum allowed driving time before stopping to rest.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Maximum allowed driving time before stopping to rest.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long driveDuration() {
        return driveDuration;
    }

    /**
     * <p>
     * Resting time before the driver can continue driving.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Resting time before the driver can continue driving.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long restDuration() {
        return restDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(driveDuration());
        hashCode = 31 * hashCode + Objects.hashCode(restDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteDriverScheduleInterval)) {
            return false;
        }
        RouteDriverScheduleInterval other = (RouteDriverScheduleInterval) obj;
        return Objects.equals(driveDuration(), other.driveDuration()) && Objects.equals(restDuration(), other.restDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteDriverScheduleInterval")
                .add("DriveDuration", driveDuration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RestDuration", restDuration() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DriveDuration":
            return Optional.ofNullable(clazz.cast(driveDuration()));
        case "RestDuration":
            return Optional.ofNullable(clazz.cast(restDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DriveDuration", DRIVE_DURATION_FIELD);
        map.put("RestDuration", REST_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteDriverScheduleInterval, T> g) {
        return obj -> g.apply((RouteDriverScheduleInterval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteDriverScheduleInterval> {
        /**
         * <p>
         * Maximum allowed driving time before stopping to rest.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param driveDuration
         *        Maximum allowed driving time before stopping to rest.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driveDuration(Long driveDuration);

        /**
         * <p>
         * Resting time before the driver can continue driving.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param restDuration
         *        Resting time before the driver can continue driving.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restDuration(Long restDuration);
    }

    static final class BuilderImpl implements Builder {
        private Long driveDuration;

        private Long restDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteDriverScheduleInterval model) {
            driveDuration(model.driveDuration);
            restDuration(model.restDuration);
        }

        public final Long getDriveDuration() {
            return driveDuration;
        }

        public final void setDriveDuration(Long driveDuration) {
            this.driveDuration = driveDuration;
        }

        @Override
        public final Builder driveDuration(Long driveDuration) {
            this.driveDuration = driveDuration;
            return this;
        }

        public final Long getRestDuration() {
            return restDuration;
        }

        public final void setRestDuration(Long restDuration) {
            this.restDuration = restDuration;
        }

        @Override
        public final Builder restDuration(Long restDuration) {
            this.restDuration = restDuration;
            return this;
        }

        @Override
        public RouteDriverScheduleInterval build() {
            return new RouteDriverScheduleInterval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
