/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * FerryLegDetails is populated when the Leg type is Ferry, and provides additional information that is specific
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteFerryLegDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteFerryLegDetails.Builder, RouteFerryLegDetails> {
    private static final SdkField<List<RouteFerryAfterTravelStep>> AFTER_TRAVEL_STEPS_FIELD = SdkField
            .<List<RouteFerryAfterTravelStep>> builder(MarshallingType.LIST)
            .memberName("AfterTravelSteps")
            .getter(getter(RouteFerryLegDetails::afterTravelSteps))
            .setter(setter(Builder::afterTravelSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterTravelSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFerryAfterTravelStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFerryAfterTravelStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteFerryArrival> ARRIVAL_FIELD = SdkField
            .<RouteFerryArrival> builder(MarshallingType.SDK_POJO).memberName("Arrival")
            .getter(getter(RouteFerryLegDetails::arrival)).setter(setter(Builder::arrival))
            .constructor(RouteFerryArrival::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arrival").build()).build();

    private static final SdkField<List<RouteFerryBeforeTravelStep>> BEFORE_TRAVEL_STEPS_FIELD = SdkField
            .<List<RouteFerryBeforeTravelStep>> builder(MarshallingType.LIST)
            .memberName("BeforeTravelSteps")
            .getter(getter(RouteFerryLegDetails::beforeTravelSteps))
            .setter(setter(Builder::beforeTravelSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeforeTravelSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFerryBeforeTravelStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFerryBeforeTravelStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteFerryDeparture> DEPARTURE_FIELD = SdkField
            .<RouteFerryDeparture> builder(MarshallingType.SDK_POJO).memberName("Departure")
            .getter(getter(RouteFerryLegDetails::departure)).setter(setter(Builder::departure))
            .constructor(RouteFerryDeparture::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Departure").build()).build();

    private static final SdkField<List<RouteFerryNotice>> NOTICES_FIELD = SdkField
            .<List<RouteFerryNotice>> builder(MarshallingType.LIST)
            .memberName("Notices")
            .getter(getter(RouteFerryLegDetails::notices))
            .setter(setter(Builder::notices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFerryNotice> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFerryNotice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RoutePassThroughWaypoint>> PASS_THROUGH_WAYPOINTS_FIELD = SdkField
            .<List<RoutePassThroughWaypoint>> builder(MarshallingType.LIST)
            .memberName("PassThroughWaypoints")
            .getter(getter(RouteFerryLegDetails::passThroughWaypoints))
            .setter(setter(Builder::passThroughWaypoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PassThroughWaypoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutePassThroughWaypoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutePassThroughWaypoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteName").getter(getter(RouteFerryLegDetails::routeName)).setter(setter(Builder::routeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteName").build()).build();

    private static final SdkField<List<RouteFerrySpan>> SPANS_FIELD = SdkField
            .<List<RouteFerrySpan>> builder(MarshallingType.LIST)
            .memberName("Spans")
            .getter(getter(RouteFerryLegDetails::spans))
            .setter(setter(Builder::spans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFerrySpan> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFerrySpan::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteFerrySummary> SUMMARY_FIELD = SdkField
            .<RouteFerrySummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(RouteFerryLegDetails::summary)).setter(setter(Builder::summary))
            .constructor(RouteFerrySummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final SdkField<List<RouteFerryTravelStep>> TRAVEL_STEPS_FIELD = SdkField
            .<List<RouteFerryTravelStep>> builder(MarshallingType.LIST)
            .memberName("TravelSteps")
            .getter(getter(RouteFerryLegDetails::travelSteps))
            .setter(setter(Builder::travelSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFerryTravelStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFerryTravelStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_TRAVEL_STEPS_FIELD,
            ARRIVAL_FIELD, BEFORE_TRAVEL_STEPS_FIELD, DEPARTURE_FIELD, NOTICES_FIELD, PASS_THROUGH_WAYPOINTS_FIELD,
            ROUTE_NAME_FIELD, SPANS_FIELD, SUMMARY_FIELD, TRAVEL_STEPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RouteFerryAfterTravelStep> afterTravelSteps;

    private final RouteFerryArrival arrival;

    private final List<RouteFerryBeforeTravelStep> beforeTravelSteps;

    private final RouteFerryDeparture departure;

    private final List<RouteFerryNotice> notices;

    private final List<RoutePassThroughWaypoint> passThroughWaypoints;

    private final String routeName;

    private final List<RouteFerrySpan> spans;

    private final RouteFerrySummary summary;

    private final List<RouteFerryTravelStep> travelSteps;

    private RouteFerryLegDetails(BuilderImpl builder) {
        this.afterTravelSteps = builder.afterTravelSteps;
        this.arrival = builder.arrival;
        this.beforeTravelSteps = builder.beforeTravelSteps;
        this.departure = builder.departure;
        this.notices = builder.notices;
        this.passThroughWaypoints = builder.passThroughWaypoints;
        this.routeName = builder.routeName;
        this.spans = builder.spans;
        this.summary = builder.summary;
        this.travelSteps = builder.travelSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the AfterTravelSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAfterTravelSteps() {
        return afterTravelSteps != null && !(afterTravelSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Steps of a leg that must be performed after the travel portion of the leg.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAfterTravelSteps} method.
     * </p>
     * 
     * @return Steps of a leg that must be performed after the travel portion of the leg.
     */
    public final List<RouteFerryAfterTravelStep> afterTravelSteps() {
        return afterTravelSteps;
    }

    /**
     * <p>
     * Details corresponding to the arrival for the leg.
     * </p>
     * 
     * @return Details corresponding to the arrival for the leg.
     */
    public final RouteFerryArrival arrival() {
        return arrival;
    }

    /**
     * For responses, this returns true if the service returned a value for the BeforeTravelSteps property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBeforeTravelSteps() {
        return beforeTravelSteps != null && !(beforeTravelSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Steps of a leg that must be performed before the travel portion of the leg.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBeforeTravelSteps} method.
     * </p>
     * 
     * @return Steps of a leg that must be performed before the travel portion of the leg.
     */
    public final List<RouteFerryBeforeTravelStep> beforeTravelSteps() {
        return beforeTravelSteps;
    }

    /**
     * <p>
     * Details corresponding to the departure for the leg.
     * </p>
     * 
     * @return Details corresponding to the departure for the leg.
     */
    public final RouteFerryDeparture departure() {
        return departure;
    }

    /**
     * For responses, this returns true if the service returned a value for the Notices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotices() {
        return notices != null && !(notices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Notices are additional information returned that indicate issues that occurred during route calculation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotices} method.
     * </p>
     * 
     * @return Notices are additional information returned that indicate issues that occurred during route calculation.
     */
    public final List<RouteFerryNotice> notices() {
        return notices;
    }

    /**
     * For responses, this returns true if the service returned a value for the PassThroughWaypoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPassThroughWaypoints() {
        return passThroughWaypoints != null && !(passThroughWaypoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
     * PassThrough option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPassThroughWaypoints} method.
     * </p>
     * 
     * @return Waypoints that were passed through during the leg. This includes the waypoints that were configured with
     *         the PassThrough option.
     */
    public final List<RoutePassThroughWaypoint> passThroughWaypoints() {
        return passThroughWaypoints;
    }

    /**
     * <p>
     * Route name of the ferry line.
     * </p>
     * 
     * @return Route name of the ferry line.
     */
    public final String routeName() {
        return routeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Spans property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSpans() {
        return spans != null && !(spans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Spans that were computed for the requested SpanAdditionalFeatures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpans} method.
     * </p>
     * 
     * @return Spans that were computed for the requested SpanAdditionalFeatures.
     */
    public final List<RouteFerrySpan> spans() {
        return spans;
    }

    /**
     * <p>
     * Summarized details of the leg.
     * </p>
     * 
     * @return Summarized details of the leg.
     */
    public final RouteFerrySummary summary() {
        return summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the TravelSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTravelSteps() {
        return travelSteps != null && !(travelSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Steps of a leg that must be performed before the travel portion of the leg.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTravelSteps} method.
     * </p>
     * 
     * @return Steps of a leg that must be performed before the travel portion of the leg.
     */
    public final List<RouteFerryTravelStep> travelSteps() {
        return travelSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAfterTravelSteps() ? afterTravelSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arrival());
        hashCode = 31 * hashCode + Objects.hashCode(hasBeforeTravelSteps() ? beforeTravelSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(departure());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotices() ? notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPassThroughWaypoints() ? passThroughWaypoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpans() ? spans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(hasTravelSteps() ? travelSteps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteFerryLegDetails)) {
            return false;
        }
        RouteFerryLegDetails other = (RouteFerryLegDetails) obj;
        return hasAfterTravelSteps() == other.hasAfterTravelSteps()
                && Objects.equals(afterTravelSteps(), other.afterTravelSteps()) && Objects.equals(arrival(), other.arrival())
                && hasBeforeTravelSteps() == other.hasBeforeTravelSteps()
                && Objects.equals(beforeTravelSteps(), other.beforeTravelSteps())
                && Objects.equals(departure(), other.departure()) && hasNotices() == other.hasNotices()
                && Objects.equals(notices(), other.notices()) && hasPassThroughWaypoints() == other.hasPassThroughWaypoints()
                && Objects.equals(passThroughWaypoints(), other.passThroughWaypoints())
                && Objects.equals(routeName(), other.routeName()) && hasSpans() == other.hasSpans()
                && Objects.equals(spans(), other.spans()) && Objects.equals(summary(), other.summary())
                && hasTravelSteps() == other.hasTravelSteps() && Objects.equals(travelSteps(), other.travelSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteFerryLegDetails")
                .add("AfterTravelSteps", hasAfterTravelSteps() ? afterTravelSteps() : null).add("Arrival", arrival())
                .add("BeforeTravelSteps", hasBeforeTravelSteps() ? beforeTravelSteps() : null).add("Departure", departure())
                .add("Notices", hasNotices() ? notices() : null)
                .add("PassThroughWaypoints", hasPassThroughWaypoints() ? passThroughWaypoints() : null)
                .add("RouteName", routeName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Spans", hasSpans() ? spans() : null).add("Summary", summary())
                .add("TravelSteps", hasTravelSteps() ? travelSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AfterTravelSteps":
            return Optional.ofNullable(clazz.cast(afterTravelSteps()));
        case "Arrival":
            return Optional.ofNullable(clazz.cast(arrival()));
        case "BeforeTravelSteps":
            return Optional.ofNullable(clazz.cast(beforeTravelSteps()));
        case "Departure":
            return Optional.ofNullable(clazz.cast(departure()));
        case "Notices":
            return Optional.ofNullable(clazz.cast(notices()));
        case "PassThroughWaypoints":
            return Optional.ofNullable(clazz.cast(passThroughWaypoints()));
        case "RouteName":
            return Optional.ofNullable(clazz.cast(routeName()));
        case "Spans":
            return Optional.ofNullable(clazz.cast(spans()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "TravelSteps":
            return Optional.ofNullable(clazz.cast(travelSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AfterTravelSteps", AFTER_TRAVEL_STEPS_FIELD);
        map.put("Arrival", ARRIVAL_FIELD);
        map.put("BeforeTravelSteps", BEFORE_TRAVEL_STEPS_FIELD);
        map.put("Departure", DEPARTURE_FIELD);
        map.put("Notices", NOTICES_FIELD);
        map.put("PassThroughWaypoints", PASS_THROUGH_WAYPOINTS_FIELD);
        map.put("RouteName", ROUTE_NAME_FIELD);
        map.put("Spans", SPANS_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        map.put("TravelSteps", TRAVEL_STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteFerryLegDetails, T> g) {
        return obj -> g.apply((RouteFerryLegDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteFerryLegDetails> {
        /**
         * <p>
         * Steps of a leg that must be performed after the travel portion of the leg.
         * </p>
         * 
         * @param afterTravelSteps
         *        Steps of a leg that must be performed after the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterTravelSteps(Collection<RouteFerryAfterTravelStep> afterTravelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed after the travel portion of the leg.
         * </p>
         * 
         * @param afterTravelSteps
         *        Steps of a leg that must be performed after the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterTravelSteps(RouteFerryAfterTravelStep... afterTravelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed after the travel portion of the leg.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryAfterTravelStep.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryAfterTravelStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryAfterTravelStep.Builder#build()} is called
         * immediately and its result is passed to {@link #afterTravelSteps(List<RouteFerryAfterTravelStep>)}.
         * 
         * @param afterTravelSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteFerryAfterTravelStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #afterTravelSteps(java.util.Collection<RouteFerryAfterTravelStep>)
         */
        Builder afterTravelSteps(Consumer<RouteFerryAfterTravelStep.Builder>... afterTravelSteps);

        /**
         * <p>
         * Details corresponding to the arrival for the leg.
         * </p>
         * 
         * @param arrival
         *        Details corresponding to the arrival for the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrival(RouteFerryArrival arrival);

        /**
         * <p>
         * Details corresponding to the arrival for the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteFerryArrival.Builder} avoiding the
         * need to create one manually via {@link RouteFerryArrival#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteFerryArrival.Builder#build()} is called immediately and its
         * result is passed to {@link #arrival(RouteFerryArrival)}.
         * 
         * @param arrival
         *        a consumer that will call methods on {@link RouteFerryArrival.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrival(RouteFerryArrival)
         */
        default Builder arrival(Consumer<RouteFerryArrival.Builder> arrival) {
            return arrival(RouteFerryArrival.builder().applyMutation(arrival).build());
        }

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * 
         * @param beforeTravelSteps
         *        Steps of a leg that must be performed before the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeTravelSteps(Collection<RouteFerryBeforeTravelStep> beforeTravelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * 
         * @param beforeTravelSteps
         *        Steps of a leg that must be performed before the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeTravelSteps(RouteFerryBeforeTravelStep... beforeTravelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryBeforeTravelStep.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryBeforeTravelStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryBeforeTravelStep.Builder#build()} is called
         * immediately and its result is passed to {@link #beforeTravelSteps(List<RouteFerryBeforeTravelStep>)}.
         * 
         * @param beforeTravelSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteFerryBeforeTravelStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #beforeTravelSteps(java.util.Collection<RouteFerryBeforeTravelStep>)
         */
        Builder beforeTravelSteps(Consumer<RouteFerryBeforeTravelStep.Builder>... beforeTravelSteps);

        /**
         * <p>
         * Details corresponding to the departure for the leg.
         * </p>
         * 
         * @param departure
         *        Details corresponding to the departure for the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder departure(RouteFerryDeparture departure);

        /**
         * <p>
         * Details corresponding to the departure for the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteFerryDeparture.Builder} avoiding the
         * need to create one manually via {@link RouteFerryDeparture#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteFerryDeparture.Builder#build()} is called immediately and
         * its result is passed to {@link #departure(RouteFerryDeparture)}.
         * 
         * @param departure
         *        a consumer that will call methods on {@link RouteFerryDeparture.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #departure(RouteFerryDeparture)
         */
        default Builder departure(Consumer<RouteFerryDeparture.Builder> departure) {
            return departure(RouteFerryDeparture.builder().applyMutation(departure).build());
        }

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(Collection<RouteFerryNotice> notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(RouteFerryNotice... notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryNotice.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.RouteFerryNotice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryNotice.Builder#build()} is called
         * immediately and its result is passed to {@link #notices(List<RouteFerryNotice>)}.
         * 
         * @param notices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteFerryNotice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notices(java.util.Collection<RouteFerryNotice>)
         */
        Builder notices(Consumer<RouteFerryNotice.Builder>... notices);

        /**
         * <p>
         * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
         * PassThrough option.
         * </p>
         * 
         * @param passThroughWaypoints
         *        Waypoints that were passed through during the leg. This includes the waypoints that were configured
         *        with the PassThrough option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passThroughWaypoints(Collection<RoutePassThroughWaypoint> passThroughWaypoints);

        /**
         * <p>
         * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
         * PassThrough option.
         * </p>
         * 
         * @param passThroughWaypoints
         *        Waypoints that were passed through during the leg. This includes the waypoints that were configured
         *        with the PassThrough option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passThroughWaypoints(RoutePassThroughWaypoint... passThroughWaypoints);

        /**
         * <p>
         * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
         * PassThrough option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint.Builder#build()} is called
         * immediately and its result is passed to {@link #passThroughWaypoints(List<RoutePassThroughWaypoint>)}.
         * 
         * @param passThroughWaypoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passThroughWaypoints(java.util.Collection<RoutePassThroughWaypoint>)
         */
        Builder passThroughWaypoints(Consumer<RoutePassThroughWaypoint.Builder>... passThroughWaypoints);

        /**
         * <p>
         * Route name of the ferry line.
         * </p>
         * 
         * @param routeName
         *        Route name of the ferry line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeName(String routeName);

        /**
         * <p>
         * Spans that were computed for the requested SpanAdditionalFeatures.
         * </p>
         * 
         * @param spans
         *        Spans that were computed for the requested SpanAdditionalFeatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spans(Collection<RouteFerrySpan> spans);

        /**
         * <p>
         * Spans that were computed for the requested SpanAdditionalFeatures.
         * </p>
         * 
         * @param spans
         *        Spans that were computed for the requested SpanAdditionalFeatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spans(RouteFerrySpan... spans);

        /**
         * <p>
         * Spans that were computed for the requested SpanAdditionalFeatures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerrySpan.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.RouteFerrySpan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerrySpan.Builder#build()} is called immediately
         * and its result is passed to {@link #spans(List<RouteFerrySpan>)}.
         * 
         * @param spans
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteFerrySpan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spans(java.util.Collection<RouteFerrySpan>)
         */
        Builder spans(Consumer<RouteFerrySpan.Builder>... spans);

        /**
         * <p>
         * Summarized details of the leg.
         * </p>
         * 
         * @param summary
         *        Summarized details of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(RouteFerrySummary summary);

        /**
         * <p>
         * Summarized details of the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteFerrySummary.Builder} avoiding the
         * need to create one manually via {@link RouteFerrySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteFerrySummary.Builder#build()} is called immediately and its
         * result is passed to {@link #summary(RouteFerrySummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link RouteFerrySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(RouteFerrySummary)
         */
        default Builder summary(Consumer<RouteFerrySummary.Builder> summary) {
            return summary(RouteFerrySummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * 
         * @param travelSteps
         *        Steps of a leg that must be performed before the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelSteps(Collection<RouteFerryTravelStep> travelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * 
         * @param travelSteps
         *        Steps of a leg that must be performed before the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelSteps(RouteFerryTravelStep... travelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryTravelStep.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryTravelStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteFerryTravelStep.Builder#build()} is called
         * immediately and its result is passed to {@link #travelSteps(List<RouteFerryTravelStep>)}.
         * 
         * @param travelSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteFerryTravelStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #travelSteps(java.util.Collection<RouteFerryTravelStep>)
         */
        Builder travelSteps(Consumer<RouteFerryTravelStep.Builder>... travelSteps);
    }

    static final class BuilderImpl implements Builder {
        private List<RouteFerryAfterTravelStep> afterTravelSteps = DefaultSdkAutoConstructList.getInstance();

        private RouteFerryArrival arrival;

        private List<RouteFerryBeforeTravelStep> beforeTravelSteps = DefaultSdkAutoConstructList.getInstance();

        private RouteFerryDeparture departure;

        private List<RouteFerryNotice> notices = DefaultSdkAutoConstructList.getInstance();

        private List<RoutePassThroughWaypoint> passThroughWaypoints = DefaultSdkAutoConstructList.getInstance();

        private String routeName;

        private List<RouteFerrySpan> spans = DefaultSdkAutoConstructList.getInstance();

        private RouteFerrySummary summary;

        private List<RouteFerryTravelStep> travelSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteFerryLegDetails model) {
            afterTravelSteps(model.afterTravelSteps);
            arrival(model.arrival);
            beforeTravelSteps(model.beforeTravelSteps);
            departure(model.departure);
            notices(model.notices);
            passThroughWaypoints(model.passThroughWaypoints);
            routeName(model.routeName);
            spans(model.spans);
            summary(model.summary);
            travelSteps(model.travelSteps);
        }

        public final List<RouteFerryAfterTravelStep.Builder> getAfterTravelSteps() {
            List<RouteFerryAfterTravelStep.Builder> result = RouteFerryAfterTravelStepListCopier
                    .copyToBuilder(this.afterTravelSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAfterTravelSteps(Collection<RouteFerryAfterTravelStep.BuilderImpl> afterTravelSteps) {
            this.afterTravelSteps = RouteFerryAfterTravelStepListCopier.copyFromBuilder(afterTravelSteps);
        }

        @Override
        public final Builder afterTravelSteps(Collection<RouteFerryAfterTravelStep> afterTravelSteps) {
            this.afterTravelSteps = RouteFerryAfterTravelStepListCopier.copy(afterTravelSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterTravelSteps(RouteFerryAfterTravelStep... afterTravelSteps) {
            afterTravelSteps(Arrays.asList(afterTravelSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterTravelSteps(Consumer<RouteFerryAfterTravelStep.Builder>... afterTravelSteps) {
            afterTravelSteps(Stream.of(afterTravelSteps).map(c -> RouteFerryAfterTravelStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RouteFerryArrival.Builder getArrival() {
            return arrival != null ? arrival.toBuilder() : null;
        }

        public final void setArrival(RouteFerryArrival.BuilderImpl arrival) {
            this.arrival = arrival != null ? arrival.build() : null;
        }

        @Override
        public final Builder arrival(RouteFerryArrival arrival) {
            this.arrival = arrival;
            return this;
        }

        public final List<RouteFerryBeforeTravelStep.Builder> getBeforeTravelSteps() {
            List<RouteFerryBeforeTravelStep.Builder> result = RouteFerryBeforeTravelStepListCopier
                    .copyToBuilder(this.beforeTravelSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBeforeTravelSteps(Collection<RouteFerryBeforeTravelStep.BuilderImpl> beforeTravelSteps) {
            this.beforeTravelSteps = RouteFerryBeforeTravelStepListCopier.copyFromBuilder(beforeTravelSteps);
        }

        @Override
        public final Builder beforeTravelSteps(Collection<RouteFerryBeforeTravelStep> beforeTravelSteps) {
            this.beforeTravelSteps = RouteFerryBeforeTravelStepListCopier.copy(beforeTravelSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeTravelSteps(RouteFerryBeforeTravelStep... beforeTravelSteps) {
            beforeTravelSteps(Arrays.asList(beforeTravelSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeTravelSteps(Consumer<RouteFerryBeforeTravelStep.Builder>... beforeTravelSteps) {
            beforeTravelSteps(Stream.of(beforeTravelSteps)
                    .map(c -> RouteFerryBeforeTravelStep.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RouteFerryDeparture.Builder getDeparture() {
            return departure != null ? departure.toBuilder() : null;
        }

        public final void setDeparture(RouteFerryDeparture.BuilderImpl departure) {
            this.departure = departure != null ? departure.build() : null;
        }

        @Override
        public final Builder departure(RouteFerryDeparture departure) {
            this.departure = departure;
            return this;
        }

        public final List<RouteFerryNotice.Builder> getNotices() {
            List<RouteFerryNotice.Builder> result = RouteFerryNoticeListCopier.copyToBuilder(this.notices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotices(Collection<RouteFerryNotice.BuilderImpl> notices) {
            this.notices = RouteFerryNoticeListCopier.copyFromBuilder(notices);
        }

        @Override
        public final Builder notices(Collection<RouteFerryNotice> notices) {
            this.notices = RouteFerryNoticeListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(RouteFerryNotice... notices) {
            notices(Arrays.asList(notices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Consumer<RouteFerryNotice.Builder>... notices) {
            notices(Stream.of(notices).map(c -> RouteFerryNotice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RoutePassThroughWaypoint.Builder> getPassThroughWaypoints() {
            List<RoutePassThroughWaypoint.Builder> result = RoutePassThroughWaypointListCopier
                    .copyToBuilder(this.passThroughWaypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPassThroughWaypoints(Collection<RoutePassThroughWaypoint.BuilderImpl> passThroughWaypoints) {
            this.passThroughWaypoints = RoutePassThroughWaypointListCopier.copyFromBuilder(passThroughWaypoints);
        }

        @Override
        public final Builder passThroughWaypoints(Collection<RoutePassThroughWaypoint> passThroughWaypoints) {
            this.passThroughWaypoints = RoutePassThroughWaypointListCopier.copy(passThroughWaypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passThroughWaypoints(RoutePassThroughWaypoint... passThroughWaypoints) {
            passThroughWaypoints(Arrays.asList(passThroughWaypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passThroughWaypoints(Consumer<RoutePassThroughWaypoint.Builder>... passThroughWaypoints) {
            passThroughWaypoints(Stream.of(passThroughWaypoints)
                    .map(c -> RoutePassThroughWaypoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRouteName() {
            return routeName;
        }

        public final void setRouteName(String routeName) {
            this.routeName = routeName;
        }

        @Override
        public final Builder routeName(String routeName) {
            this.routeName = routeName;
            return this;
        }

        public final List<RouteFerrySpan.Builder> getSpans() {
            List<RouteFerrySpan.Builder> result = RouteFerrySpanListCopier.copyToBuilder(this.spans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpans(Collection<RouteFerrySpan.BuilderImpl> spans) {
            this.spans = RouteFerrySpanListCopier.copyFromBuilder(spans);
        }

        @Override
        public final Builder spans(Collection<RouteFerrySpan> spans) {
            this.spans = RouteFerrySpanListCopier.copy(spans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(RouteFerrySpan... spans) {
            spans(Arrays.asList(spans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(Consumer<RouteFerrySpan.Builder>... spans) {
            spans(Stream.of(spans).map(c -> RouteFerrySpan.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RouteFerrySummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(RouteFerrySummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(RouteFerrySummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<RouteFerryTravelStep.Builder> getTravelSteps() {
            List<RouteFerryTravelStep.Builder> result = RouteFerryTravelStepListCopier.copyToBuilder(this.travelSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTravelSteps(Collection<RouteFerryTravelStep.BuilderImpl> travelSteps) {
            this.travelSteps = RouteFerryTravelStepListCopier.copyFromBuilder(travelSteps);
        }

        @Override
        public final Builder travelSteps(Collection<RouteFerryTravelStep> travelSteps) {
            this.travelSteps = RouteFerryTravelStepListCopier.copy(travelSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelSteps(RouteFerryTravelStep... travelSteps) {
            travelSteps(Arrays.asList(travelSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelSteps(Consumer<RouteFerryTravelStep.Builder>... travelSteps) {
            travelSteps(Stream.of(travelSteps).map(c -> RouteFerryTravelStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RouteFerryLegDetails build() {
            return new RouteFerryLegDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
