/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Span computed for the requested SpanAdditionalFeatures.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteFerrySpan implements SdkPojo, Serializable, ToCopyableBuilder<RouteFerrySpan.Builder, RouteFerrySpan> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(RouteFerrySpan::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<Long> DISTANCE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Distance")
            .getter(getter(RouteFerrySpan::distance)).setter(setter(Builder::distance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(RouteFerrySpan::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GeometryOffset").getter(getter(RouteFerrySpan::geometryOffset)).setter(setter(Builder::geometryOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()).build();

    private static final SdkField<List<LocalizedString>> NAMES_FIELD = SdkField
            .<List<LocalizedString>> builder(MarshallingType.LIST)
            .memberName("Names")
            .getter(getter(RouteFerrySpan::names))
            .setter(setter(Builder::names))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalizedString> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalizedString::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(RouteFerrySpan::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, DISTANCE_FIELD,
            DURATION_FIELD, GEOMETRY_OFFSET_FIELD, NAMES_FIELD, REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String country;

    private final Long distance;

    private final Long duration;

    private final Integer geometryOffset;

    private final List<LocalizedString> names;

    private final String region;

    private RouteFerrySpan(BuilderImpl builder) {
        this.country = builder.country;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.geometryOffset = builder.geometryOffset;
        this.names = builder.names;
        this.region = builder.region;
    }

    /**
     * <p>
     * 3 letter Country code corresponding to the Span.
     * </p>
     * 
     * @return 3 letter Country code corresponding to the Span.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * Distance of the computed span. This feature doesn't split a span, but is always computed on a span split by other
     * properties.
     * </p>
     * <p>
     * <b>Unit</b>: <code>meters</code>
     * </p>
     * 
     * @return Distance of the computed span. This feature doesn't split a span, but is always computed on a span split
     *         by other properties.</p>
     *         <p>
     *         <b>Unit</b>: <code>meters</code>
     */
    public final Long distance() {
        return distance;
    }

    /**
     * <p>
     * Duration of the computed span. This feature doesn't split a span, but is always computed on a span split by other
     * properties.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of the computed span. This feature doesn't split a span, but is always computed on a span split
     *         by other properties.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * Offset in the leg geometry corresponding to the start of this span.
     * </p>
     * 
     * @return Offset in the leg geometry corresponding to the start of this span.
     */
    public final Integer geometryOffset() {
        return geometryOffset;
    }

    /**
     * For responses, this returns true if the service returned a value for the Names property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNames() {
        return names != null && !(names instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides an array of names of the ferry span in available languages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNames} method.
     * </p>
     * 
     * @return Provides an array of names of the ferry span in available languages.
     */
    public final List<LocalizedString> names() {
        return names;
    }

    /**
     * <p>
     * 2-3 letter Region code corresponding to the Span. This is either a province or a state.
     * </p>
     * 
     * @return 2-3 letter Region code corresponding to the Span. This is either a province or a state.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(distance());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(hasNames() ? names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteFerrySpan)) {
            return false;
        }
        RouteFerrySpan other = (RouteFerrySpan) obj;
        return Objects.equals(country(), other.country()) && Objects.equals(distance(), other.distance())
                && Objects.equals(duration(), other.duration()) && Objects.equals(geometryOffset(), other.geometryOffset())
                && hasNames() == other.hasNames() && Objects.equals(names(), other.names())
                && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteFerrySpan").add("Country", country() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Distance", distance() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Duration", duration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GeometryOffset", geometryOffset()).add("Names", hasNames() ? names() : null)
                .add("Region", region() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Distance":
            return Optional.ofNullable(clazz.cast(distance()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "GeometryOffset":
            return Optional.ofNullable(clazz.cast(geometryOffset()));
        case "Names":
            return Optional.ofNullable(clazz.cast(names()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Country", COUNTRY_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        map.put("Names", NAMES_FIELD);
        map.put("Region", REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteFerrySpan, T> g) {
        return obj -> g.apply((RouteFerrySpan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteFerrySpan> {
        /**
         * <p>
         * 3 letter Country code corresponding to the Span.
         * </p>
         * 
         * @param country
         *        3 letter Country code corresponding to the Span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * Distance of the computed span. This feature doesn't split a span, but is always computed on a span split by
         * other properties.
         * </p>
         * <p>
         * <b>Unit</b>: <code>meters</code>
         * </p>
         * 
         * @param distance
         *        Distance of the computed span. This feature doesn't split a span, but is always computed on a span
         *        split by other properties.</p>
         *        <p>
         *        <b>Unit</b>: <code>meters</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distance(Long distance);

        /**
         * <p>
         * Duration of the computed span. This feature doesn't split a span, but is always computed on a span split by
         * other properties.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param duration
         *        Duration of the computed span. This feature doesn't split a span, but is always computed on a span
         *        split by other properties.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * Offset in the leg geometry corresponding to the start of this span.
         * </p>
         * 
         * @param geometryOffset
         *        Offset in the leg geometry corresponding to the start of this span.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometryOffset(Integer geometryOffset);

        /**
         * <p>
         * Provides an array of names of the ferry span in available languages.
         * </p>
         * 
         * @param names
         *        Provides an array of names of the ferry span in available languages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(Collection<LocalizedString> names);

        /**
         * <p>
         * Provides an array of names of the ferry span in available languages.
         * </p>
         * 
         * @param names
         *        Provides an array of names of the ferry span in available languages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder names(LocalizedString... names);

        /**
         * <p>
         * Provides an array of names of the ferry span in available languages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.LocalizedString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder#build()} is called immediately
         * and its result is passed to {@link #names(List<LocalizedString>)}.
         * 
         * @param names
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #names(java.util.Collection<LocalizedString>)
         */
        Builder names(Consumer<LocalizedString.Builder>... names);

        /**
         * <p>
         * 2-3 letter Region code corresponding to the Span. This is either a province or a state.
         * </p>
         * 
         * @param region
         *        2-3 letter Region code corresponding to the Span. This is either a province or a state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private String country;

        private Long distance;

        private Long duration;

        private Integer geometryOffset;

        private List<LocalizedString> names = DefaultSdkAutoConstructList.getInstance();

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteFerrySpan model) {
            country(model.country);
            distance(model.distance);
            duration(model.duration);
            geometryOffset(model.geometryOffset);
            names(model.names);
            region(model.region);
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final Long getDistance() {
            return distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getGeometryOffset() {
            return geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final List<LocalizedString.Builder> getNames() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.names);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNames(Collection<LocalizedString.BuilderImpl> names) {
            this.names = LocalizedStringListCopier.copyFromBuilder(names);
        }

        @Override
        public final Builder names(Collection<LocalizedString> names) {
            this.names = LocalizedStringListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(LocalizedString... names) {
            names(Arrays.asList(names));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(Consumer<LocalizedString.Builder>... names) {
            names(Stream.of(names).map(c -> LocalizedString.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public RouteFerrySpan build() {
            return new RouteFerrySpan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
