/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Important labels including names and route numbers that differentiate the current route from the alternatives
 * presented.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMajorRoadLabel implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMajorRoadLabel.Builder, RouteMajorRoadLabel> {
    private static final SdkField<LocalizedString> ROAD_NAME_FIELD = SdkField.<LocalizedString> builder(MarshallingType.SDK_POJO)
            .memberName("RoadName").getter(getter(RouteMajorRoadLabel::roadName)).setter(setter(Builder::roadName))
            .constructor(LocalizedString::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoadName").build()).build();

    private static final SdkField<RouteNumber> ROUTE_NUMBER_FIELD = SdkField.<RouteNumber> builder(MarshallingType.SDK_POJO)
            .memberName("RouteNumber").getter(getter(RouteMajorRoadLabel::routeNumber)).setter(setter(Builder::routeNumber))
            .constructor(RouteNumber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROAD_NAME_FIELD,
            ROUTE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LocalizedString roadName;

    private final RouteNumber routeNumber;

    private RouteMajorRoadLabel(BuilderImpl builder) {
        this.roadName = builder.roadName;
        this.routeNumber = builder.routeNumber;
    }

    /**
     * <p>
     * Name of the road (localized).
     * </p>
     * 
     * @return Name of the road (localized).
     */
    public final LocalizedString roadName() {
        return roadName;
    }

    /**
     * <p>
     * Route number of the road.
     * </p>
     * 
     * @return Route number of the road.
     */
    public final RouteNumber routeNumber() {
        return routeNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roadName());
        hashCode = 31 * hashCode + Objects.hashCode(routeNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMajorRoadLabel)) {
            return false;
        }
        RouteMajorRoadLabel other = (RouteMajorRoadLabel) obj;
        return Objects.equals(roadName(), other.roadName()) && Objects.equals(routeNumber(), other.routeNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMajorRoadLabel").add("RoadName", roadName()).add("RouteNumber", routeNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoadName":
            return Optional.ofNullable(clazz.cast(roadName()));
        case "RouteNumber":
            return Optional.ofNullable(clazz.cast(routeNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoadName", ROAD_NAME_FIELD);
        map.put("RouteNumber", ROUTE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMajorRoadLabel, T> g) {
        return obj -> g.apply((RouteMajorRoadLabel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMajorRoadLabel> {
        /**
         * <p>
         * Name of the road (localized).
         * </p>
         * 
         * @param roadName
         *        Name of the road (localized).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roadName(LocalizedString roadName);

        /**
         * <p>
         * Name of the road (localized).
         * </p>
         * This is a convenience method that creates an instance of the {@link LocalizedString.Builder} avoiding the
         * need to create one manually via {@link LocalizedString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LocalizedString.Builder#build()} is called immediately and its
         * result is passed to {@link #roadName(LocalizedString)}.
         * 
         * @param roadName
         *        a consumer that will call methods on {@link LocalizedString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roadName(LocalizedString)
         */
        default Builder roadName(Consumer<LocalizedString.Builder> roadName) {
            return roadName(LocalizedString.builder().applyMutation(roadName).build());
        }

        /**
         * <p>
         * Route number of the road.
         * </p>
         * 
         * @param routeNumber
         *        Route number of the road.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeNumber(RouteNumber routeNumber);

        /**
         * <p>
         * Route number of the road.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteNumber.Builder} avoiding the need to
         * create one manually via {@link RouteNumber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteNumber.Builder#build()} is called immediately and its result
         * is passed to {@link #routeNumber(RouteNumber)}.
         * 
         * @param routeNumber
         *        a consumer that will call methods on {@link RouteNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeNumber(RouteNumber)
         */
        default Builder routeNumber(Consumer<RouteNumber.Builder> routeNumber) {
            return routeNumber(RouteNumber.builder().applyMutation(routeNumber).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LocalizedString roadName;

        private RouteNumber routeNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMajorRoadLabel model) {
            roadName(model.roadName);
            routeNumber(model.routeNumber);
        }

        public final LocalizedString.Builder getRoadName() {
            return roadName != null ? roadName.toBuilder() : null;
        }

        public final void setRoadName(LocalizedString.BuilderImpl roadName) {
            this.roadName = roadName != null ? roadName.build() : null;
        }

        @Override
        public final Builder roadName(LocalizedString roadName) {
            this.roadName = roadName;
            return this;
        }

        public final RouteNumber.Builder getRouteNumber() {
            return routeNumber != null ? routeNumber.toBuilder() : null;
        }

        public final void setRouteNumber(RouteNumber.BuilderImpl routeNumber) {
            this.routeNumber = routeNumber != null ? routeNumber.build() : null;
        }

        @Override
        public final Builder routeNumber(RouteNumber routeNumber) {
            this.routeNumber = routeNumber;
            return this;
        }

        @Override
        public RouteMajorRoadLabel build() {
            return new RouteMajorRoadLabel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
