/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the circle that was used while calculating the route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixAutoCircle implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixAutoCircle.Builder, RouteMatrixAutoCircle> {
    private static final SdkField<Long> MARGIN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Margin")
            .getter(getter(RouteMatrixAutoCircle::margin)).setter(setter(Builder::margin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Margin").build()).build();

    private static final SdkField<Long> MAX_RADIUS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("MaxRadius")
            .getter(getter(RouteMatrixAutoCircle::maxRadius)).setter(setter(Builder::maxRadius))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRadius").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MARGIN_FIELD, MAX_RADIUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long margin;

    private final Long maxRadius;

    private RouteMatrixAutoCircle(BuilderImpl builder) {
        this.margin = builder.margin;
        this.maxRadius = builder.maxRadius;
    }

    /**
     * <p>
     * The margin provided for the calculation.
     * </p>
     * 
     * @return The margin provided for the calculation.
     */
    public final Long margin() {
        return margin;
    }

    /**
     * <p>
     * The maximum size of the radius provided for the calculation.
     * </p>
     * 
     * @return The maximum size of the radius provided for the calculation.
     */
    public final Long maxRadius() {
        return maxRadius;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(margin());
        hashCode = 31 * hashCode + Objects.hashCode(maxRadius());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixAutoCircle)) {
            return false;
        }
        RouteMatrixAutoCircle other = (RouteMatrixAutoCircle) obj;
        return Objects.equals(margin(), other.margin()) && Objects.equals(maxRadius(), other.maxRadius());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixAutoCircle")
                .add("Margin", margin() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MaxRadius", maxRadius() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Margin":
            return Optional.ofNullable(clazz.cast(margin()));
        case "MaxRadius":
            return Optional.ofNullable(clazz.cast(maxRadius()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Margin", MARGIN_FIELD);
        map.put("MaxRadius", MAX_RADIUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixAutoCircle, T> g) {
        return obj -> g.apply((RouteMatrixAutoCircle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixAutoCircle> {
        /**
         * <p>
         * The margin provided for the calculation.
         * </p>
         * 
         * @param margin
         *        The margin provided for the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder margin(Long margin);

        /**
         * <p>
         * The maximum size of the radius provided for the calculation.
         * </p>
         * 
         * @param maxRadius
         *        The maximum size of the radius provided for the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRadius(Long maxRadius);
    }

    static final class BuilderImpl implements Builder {
        private Long margin;

        private Long maxRadius;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixAutoCircle model) {
            margin(model.margin);
            maxRadius(model.maxRadius);
        }

        public final Long getMargin() {
            return margin;
        }

        public final void setMargin(Long margin) {
            this.margin = margin;
        }

        @Override
        public final Builder margin(Long margin) {
            this.margin = margin;
            return this;
        }

        public final Long getMaxRadius() {
            return maxRadius;
        }

        public final void setMaxRadius(Long maxRadius) {
            this.maxRadius = maxRadius;
        }

        @Override
        public final Builder maxRadius(Long maxRadius) {
            this.maxRadius = maxRadius;
            return this;
        }

        @Override
        public RouteMatrixAutoCircle build() {
            return new RouteMatrixAutoCircle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
