/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Travel mode related options for the provided travel mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteMatrixTravelModeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteMatrixTravelModeOptions.Builder, RouteMatrixTravelModeOptions> {
    private static final SdkField<RouteMatrixCarOptions> CAR_FIELD = SdkField
            .<RouteMatrixCarOptions> builder(MarshallingType.SDK_POJO).memberName("Car")
            .getter(getter(RouteMatrixTravelModeOptions::car)).setter(setter(Builder::car))
            .constructor(RouteMatrixCarOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Car").build()).build();

    private static final SdkField<RouteMatrixScooterOptions> SCOOTER_FIELD = SdkField
            .<RouteMatrixScooterOptions> builder(MarshallingType.SDK_POJO).memberName("Scooter")
            .getter(getter(RouteMatrixTravelModeOptions::scooter)).setter(setter(Builder::scooter))
            .constructor(RouteMatrixScooterOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scooter").build()).build();

    private static final SdkField<RouteMatrixTruckOptions> TRUCK_FIELD = SdkField
            .<RouteMatrixTruckOptions> builder(MarshallingType.SDK_POJO).memberName("Truck")
            .getter(getter(RouteMatrixTravelModeOptions::truck)).setter(setter(Builder::truck))
            .constructor(RouteMatrixTruckOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAR_FIELD, SCOOTER_FIELD,
            TRUCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteMatrixCarOptions car;

    private final RouteMatrixScooterOptions scooter;

    private final RouteMatrixTruckOptions truck;

    private RouteMatrixTravelModeOptions(BuilderImpl builder) {
        this.car = builder.car;
        this.scooter = builder.scooter;
        this.truck = builder.truck;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Car"
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Car"
     */
    public final RouteMatrixCarOptions car() {
        return car;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is <code>Scooter</code>
     * </p>
     * <note>
     * <p>
     * When travel mode is set to <code>Scooter</code>, then the avoidance option <code>ControlledAccessHighways</code>
     * defaults to <code>true</code>.
     * </p>
     * </note>
     * 
     * @return Travel mode options when the provided travel mode is <code>Scooter</code> </p> <note>
     *         <p>
     *         When travel mode is set to <code>Scooter</code>, then the avoidance option
     *         <code>ControlledAccessHighways</code> defaults to <code>true</code>.
     *         </p>
     */
    public final RouteMatrixScooterOptions scooter() {
        return scooter;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Truck"
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Truck"
     */
    public final RouteMatrixTruckOptions truck() {
        return truck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(car());
        hashCode = 31 * hashCode + Objects.hashCode(scooter());
        hashCode = 31 * hashCode + Objects.hashCode(truck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteMatrixTravelModeOptions)) {
            return false;
        }
        RouteMatrixTravelModeOptions other = (RouteMatrixTravelModeOptions) obj;
        return Objects.equals(car(), other.car()) && Objects.equals(scooter(), other.scooter())
                && Objects.equals(truck(), other.truck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteMatrixTravelModeOptions").add("Car", car()).add("Scooter", scooter()).add("Truck", truck())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Car":
            return Optional.ofNullable(clazz.cast(car()));
        case "Scooter":
            return Optional.ofNullable(clazz.cast(scooter()));
        case "Truck":
            return Optional.ofNullable(clazz.cast(truck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Car", CAR_FIELD);
        map.put("Scooter", SCOOTER_FIELD);
        map.put("Truck", TRUCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteMatrixTravelModeOptions, T> g) {
        return obj -> g.apply((RouteMatrixTravelModeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteMatrixTravelModeOptions> {
        /**
         * <p>
         * Travel mode options when the provided travel mode is "Car"
         * </p>
         * 
         * @param car
         *        Travel mode options when the provided travel mode is "Car"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder car(RouteMatrixCarOptions car);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Car"
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteMatrixCarOptions.Builder} avoiding
         * the need to create one manually via {@link RouteMatrixCarOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatrixCarOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #car(RouteMatrixCarOptions)}.
         * 
         * @param car
         *        a consumer that will call methods on {@link RouteMatrixCarOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #car(RouteMatrixCarOptions)
         */
        default Builder car(Consumer<RouteMatrixCarOptions.Builder> car) {
            return car(RouteMatrixCarOptions.builder().applyMutation(car).build());
        }

        /**
         * <p>
         * Travel mode options when the provided travel mode is <code>Scooter</code>
         * </p>
         * <note>
         * <p>
         * When travel mode is set to <code>Scooter</code>, then the avoidance option
         * <code>ControlledAccessHighways</code> defaults to <code>true</code>.
         * </p>
         * </note>
         * 
         * @param scooter
         *        Travel mode options when the provided travel mode is <code>Scooter</code> </p> <note>
         *        <p>
         *        When travel mode is set to <code>Scooter</code>, then the avoidance option
         *        <code>ControlledAccessHighways</code> defaults to <code>true</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scooter(RouteMatrixScooterOptions scooter);

        /**
         * <p>
         * Travel mode options when the provided travel mode is <code>Scooter</code>
         * </p>
         * <note>
         * <p>
         * When travel mode is set to <code>Scooter</code>, then the avoidance option
         * <code>ControlledAccessHighways</code> defaults to <code>true</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link RouteMatrixScooterOptions.Builder} avoiding the need to create one manually via
         * {@link RouteMatrixScooterOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatrixScooterOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #scooter(RouteMatrixScooterOptions)}.
         * 
         * @param scooter
         *        a consumer that will call methods on {@link RouteMatrixScooterOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scooter(RouteMatrixScooterOptions)
         */
        default Builder scooter(Consumer<RouteMatrixScooterOptions.Builder> scooter) {
            return scooter(RouteMatrixScooterOptions.builder().applyMutation(scooter).build());
        }

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck"
         * </p>
         * 
         * @param truck
         *        Travel mode options when the provided travel mode is "Truck"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truck(RouteMatrixTruckOptions truck);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck"
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteMatrixTruckOptions.Builder} avoiding
         * the need to create one manually via {@link RouteMatrixTruckOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteMatrixTruckOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #truck(RouteMatrixTruckOptions)}.
         * 
         * @param truck
         *        a consumer that will call methods on {@link RouteMatrixTruckOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #truck(RouteMatrixTruckOptions)
         */
        default Builder truck(Consumer<RouteMatrixTruckOptions.Builder> truck) {
            return truck(RouteMatrixTruckOptions.builder().applyMutation(truck).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RouteMatrixCarOptions car;

        private RouteMatrixScooterOptions scooter;

        private RouteMatrixTruckOptions truck;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteMatrixTravelModeOptions model) {
            car(model.car);
            scooter(model.scooter);
            truck(model.truck);
        }

        public final RouteMatrixCarOptions.Builder getCar() {
            return car != null ? car.toBuilder() : null;
        }

        public final void setCar(RouteMatrixCarOptions.BuilderImpl car) {
            this.car = car != null ? car.build() : null;
        }

        @Override
        public final Builder car(RouteMatrixCarOptions car) {
            this.car = car;
            return this;
        }

        public final RouteMatrixScooterOptions.Builder getScooter() {
            return scooter != null ? scooter.toBuilder() : null;
        }

        public final void setScooter(RouteMatrixScooterOptions.BuilderImpl scooter) {
            this.scooter = scooter != null ? scooter.build() : null;
        }

        @Override
        public final Builder scooter(RouteMatrixScooterOptions scooter) {
            this.scooter = scooter;
            return this;
        }

        public final RouteMatrixTruckOptions.Builder getTruck() {
            return truck != null ? truck.toBuilder() : null;
        }

        public final void setTruck(RouteMatrixTruckOptions.BuilderImpl truck) {
            this.truck = truck != null ? truck.build() : null;
        }

        @Override
        public final Builder truck(RouteMatrixTruckOptions truck) {
            this.truck = truck;
            return this;
        }

        @Override
        public RouteMatrixTravelModeOptions build() {
            return new RouteMatrixTravelModeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
