/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The route number.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteNumber implements SdkPojo, Serializable, ToCopyableBuilder<RouteNumber.Builder, RouteNumber> {
    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(RouteNumber::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(RouteNumber::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(RouteNumber::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTION_FIELD,
            LANGUAGE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String direction;

    private final String language;

    private final String value;

    private RouteNumber(BuilderImpl builder) {
        this.direction = builder.direction;
        this.language = builder.language;
        this.value = builder.value;
    }

    /**
     * <p>
     * Directional identifier of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link RouteDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return Directional identifier of the route.
     * @see RouteDirection
     */
    public final RouteDirection direction() {
        return RouteDirection.fromValue(direction);
    }

    /**
     * <p>
     * Directional identifier of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link RouteDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #directionAsString}.
     * </p>
     * 
     * @return Directional identifier of the route.
     * @see RouteDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * <p>
     * List of languages for instructions corresponding to the route number.
     * </p>
     * 
     * @return List of languages for instructions corresponding to the route number.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The route number.
     * </p>
     * 
     * @return The route number.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteNumber)) {
            return false;
        }
        RouteNumber other = (RouteNumber) obj;
        return Objects.equals(directionAsString(), other.directionAsString()) && Objects.equals(language(), other.language())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteNumber")
                .add("Direction", directionAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Language", language()).add("Value", value() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Direction", DIRECTION_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteNumber, T> g) {
        return obj -> g.apply((RouteNumber) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteNumber> {
        /**
         * <p>
         * Directional identifier of the route.
         * </p>
         * 
         * @param direction
         *        Directional identifier of the route.
         * @see RouteDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * Directional identifier of the route.
         * </p>
         * 
         * @param direction
         *        Directional identifier of the route.
         * @see RouteDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteDirection
         */
        Builder direction(RouteDirection direction);

        /**
         * <p>
         * List of languages for instructions corresponding to the route number.
         * </p>
         * 
         * @param language
         *        List of languages for instructions corresponding to the route number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The route number.
         * </p>
         * 
         * @param value
         *        The route number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String direction;

        private String language;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteNumber model) {
            direction(model.direction);
            language(model.language);
            value(model.value);
        }

        public final String getDirection() {
            return direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(RouteDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public RouteNumber build() {
            return new RouteNumber(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
