/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If the waypoint should be treated as a stop. If yes, the route is split up into different legs around the stop.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutePassThroughWaypoint implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutePassThroughWaypoint.Builder, RoutePassThroughWaypoint> {
    private static final SdkField<Integer> GEOMETRY_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GeometryOffset").getter(getter(RoutePassThroughWaypoint::geometryOffset))
            .setter(setter(Builder::geometryOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeometryOffset").build()).build();

    private static final SdkField<RoutePassThroughPlace> PLACE_FIELD = SdkField
            .<RoutePassThroughPlace> builder(MarshallingType.SDK_POJO).memberName("Place")
            .getter(getter(RoutePassThroughWaypoint::place)).setter(setter(Builder::place))
            .constructor(RoutePassThroughPlace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Place").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEOMETRY_OFFSET_FIELD,
            PLACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer geometryOffset;

    private final RoutePassThroughPlace place;

    private RoutePassThroughWaypoint(BuilderImpl builder) {
        this.geometryOffset = builder.geometryOffset;
        this.place = builder.place;
    }

    /**
     * <p>
     * Offset in the leg geometry corresponding to the start of this step.
     * </p>
     * 
     * @return Offset in the leg geometry corresponding to the start of this step.
     */
    public final Integer geometryOffset() {
        return geometryOffset;
    }

    /**
     * <p>
     * The place details.
     * </p>
     * 
     * @return The place details.
     */
    public final RoutePassThroughPlace place() {
        return place;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(geometryOffset());
        hashCode = 31 * hashCode + Objects.hashCode(place());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutePassThroughWaypoint)) {
            return false;
        }
        RoutePassThroughWaypoint other = (RoutePassThroughWaypoint) obj;
        return Objects.equals(geometryOffset(), other.geometryOffset()) && Objects.equals(place(), other.place());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutePassThroughWaypoint").add("GeometryOffset", geometryOffset()).add("Place", place()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeometryOffset":
            return Optional.ofNullable(clazz.cast(geometryOffset()));
        case "Place":
            return Optional.ofNullable(clazz.cast(place()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GeometryOffset", GEOMETRY_OFFSET_FIELD);
        map.put("Place", PLACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutePassThroughWaypoint, T> g) {
        return obj -> g.apply((RoutePassThroughWaypoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutePassThroughWaypoint> {
        /**
         * <p>
         * Offset in the leg geometry corresponding to the start of this step.
         * </p>
         * 
         * @param geometryOffset
         *        Offset in the leg geometry corresponding to the start of this step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometryOffset(Integer geometryOffset);

        /**
         * <p>
         * The place details.
         * </p>
         * 
         * @param place
         *        The place details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder place(RoutePassThroughPlace place);

        /**
         * <p>
         * The place details.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutePassThroughPlace.Builder} avoiding
         * the need to create one manually via {@link RoutePassThroughPlace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutePassThroughPlace.Builder#build()} is called immediately and
         * its result is passed to {@link #place(RoutePassThroughPlace)}.
         * 
         * @param place
         *        a consumer that will call methods on {@link RoutePassThroughPlace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #place(RoutePassThroughPlace)
         */
        default Builder place(Consumer<RoutePassThroughPlace.Builder> place) {
            return place(RoutePassThroughPlace.builder().applyMutation(place).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer geometryOffset;

        private RoutePassThroughPlace place;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutePassThroughWaypoint model) {
            geometryOffset(model.geometryOffset);
            place(model.place);
        }

        public final Integer getGeometryOffset() {
            return geometryOffset;
        }

        public final void setGeometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
        }

        @Override
        public final Builder geometryOffset(Integer geometryOffset) {
            this.geometryOffset = geometryOffset;
            return this;
        }

        public final RoutePassThroughPlace.Builder getPlace() {
            return place != null ? place.toBuilder() : null;
        }

        public final void setPlace(RoutePassThroughPlace.BuilderImpl place) {
            this.place = place != null ? place.build() : null;
        }

        @Override
        public final Builder place(RoutePassThroughPlace place) {
            this.place = place;
            return this;
        }

        @Override
        public RoutePassThroughWaypoint build() {
            return new RoutePassThroughWaypoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
