/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details that are specific to a pedestrian leg.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutePedestrianLegDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutePedestrianLegDetails.Builder, RoutePedestrianLegDetails> {
    private static final SdkField<RoutePedestrianArrival> ARRIVAL_FIELD = SdkField
            .<RoutePedestrianArrival> builder(MarshallingType.SDK_POJO).memberName("Arrival")
            .getter(getter(RoutePedestrianLegDetails::arrival)).setter(setter(Builder::arrival))
            .constructor(RoutePedestrianArrival::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arrival").build()).build();

    private static final SdkField<RoutePedestrianDeparture> DEPARTURE_FIELD = SdkField
            .<RoutePedestrianDeparture> builder(MarshallingType.SDK_POJO).memberName("Departure")
            .getter(getter(RoutePedestrianLegDetails::departure)).setter(setter(Builder::departure))
            .constructor(RoutePedestrianDeparture::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Departure").build()).build();

    private static final SdkField<List<RoutePedestrianNotice>> NOTICES_FIELD = SdkField
            .<List<RoutePedestrianNotice>> builder(MarshallingType.LIST)
            .memberName("Notices")
            .getter(getter(RoutePedestrianLegDetails::notices))
            .setter(setter(Builder::notices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutePedestrianNotice> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutePedestrianNotice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RoutePassThroughWaypoint>> PASS_THROUGH_WAYPOINTS_FIELD = SdkField
            .<List<RoutePassThroughWaypoint>> builder(MarshallingType.LIST)
            .memberName("PassThroughWaypoints")
            .getter(getter(RoutePedestrianLegDetails::passThroughWaypoints))
            .setter(setter(Builder::passThroughWaypoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PassThroughWaypoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutePassThroughWaypoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutePassThroughWaypoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RoutePedestrianSpan>> SPANS_FIELD = SdkField
            .<List<RoutePedestrianSpan>> builder(MarshallingType.LIST)
            .memberName("Spans")
            .getter(getter(RoutePedestrianLegDetails::spans))
            .setter(setter(Builder::spans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutePedestrianSpan> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutePedestrianSpan::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RoutePedestrianSummary> SUMMARY_FIELD = SdkField
            .<RoutePedestrianSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(RoutePedestrianLegDetails::summary)).setter(setter(Builder::summary))
            .constructor(RoutePedestrianSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final SdkField<List<RoutePedestrianTravelStep>> TRAVEL_STEPS_FIELD = SdkField
            .<List<RoutePedestrianTravelStep>> builder(MarshallingType.LIST)
            .memberName("TravelSteps")
            .getter(getter(RoutePedestrianLegDetails::travelSteps))
            .setter(setter(Builder::travelSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutePedestrianTravelStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutePedestrianTravelStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRIVAL_FIELD,
            DEPARTURE_FIELD, NOTICES_FIELD, PASS_THROUGH_WAYPOINTS_FIELD, SPANS_FIELD, SUMMARY_FIELD, TRAVEL_STEPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RoutePedestrianArrival arrival;

    private final RoutePedestrianDeparture departure;

    private final List<RoutePedestrianNotice> notices;

    private final List<RoutePassThroughWaypoint> passThroughWaypoints;

    private final List<RoutePedestrianSpan> spans;

    private final RoutePedestrianSummary summary;

    private final List<RoutePedestrianTravelStep> travelSteps;

    private RoutePedestrianLegDetails(BuilderImpl builder) {
        this.arrival = builder.arrival;
        this.departure = builder.departure;
        this.notices = builder.notices;
        this.passThroughWaypoints = builder.passThroughWaypoints;
        this.spans = builder.spans;
        this.summary = builder.summary;
        this.travelSteps = builder.travelSteps;
    }

    /**
     * <p>
     * Details corresponding to the arrival for the leg.
     * </p>
     * 
     * @return Details corresponding to the arrival for the leg.
     */
    public final RoutePedestrianArrival arrival() {
        return arrival;
    }

    /**
     * <p>
     * Details corresponding to the departure for the leg.
     * </p>
     * 
     * @return Details corresponding to the departure for the leg.
     */
    public final RoutePedestrianDeparture departure() {
        return departure;
    }

    /**
     * For responses, this returns true if the service returned a value for the Notices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotices() {
        return notices != null && !(notices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Notices are additional information returned that indicate issues that occurred during route calculation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotices} method.
     * </p>
     * 
     * @return Notices are additional information returned that indicate issues that occurred during route calculation.
     */
    public final List<RoutePedestrianNotice> notices() {
        return notices;
    }

    /**
     * For responses, this returns true if the service returned a value for the PassThroughWaypoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPassThroughWaypoints() {
        return passThroughWaypoints != null && !(passThroughWaypoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
     * PassThrough option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPassThroughWaypoints} method.
     * </p>
     * 
     * @return Waypoints that were passed through during the leg. This includes the waypoints that were configured with
     *         the PassThrough option.
     */
    public final List<RoutePassThroughWaypoint> passThroughWaypoints() {
        return passThroughWaypoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the Spans property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSpans() {
        return spans != null && !(spans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Spans that were computed for the requested SpanAdditionalFeatures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpans} method.
     * </p>
     * 
     * @return Spans that were computed for the requested SpanAdditionalFeatures.
     */
    public final List<RoutePedestrianSpan> spans() {
        return spans;
    }

    /**
     * <p>
     * Summarized details of the leg.
     * </p>
     * 
     * @return Summarized details of the leg.
     */
    public final RoutePedestrianSummary summary() {
        return summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the TravelSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTravelSteps() {
        return travelSteps != null && !(travelSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Steps of a leg that must be performed before the travel portion of the leg.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTravelSteps} method.
     * </p>
     * 
     * @return Steps of a leg that must be performed before the travel portion of the leg.
     */
    public final List<RoutePedestrianTravelStep> travelSteps() {
        return travelSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arrival());
        hashCode = 31 * hashCode + Objects.hashCode(departure());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotices() ? notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPassThroughWaypoints() ? passThroughWaypoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSpans() ? spans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(hasTravelSteps() ? travelSteps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutePedestrianLegDetails)) {
            return false;
        }
        RoutePedestrianLegDetails other = (RoutePedestrianLegDetails) obj;
        return Objects.equals(arrival(), other.arrival()) && Objects.equals(departure(), other.departure())
                && hasNotices() == other.hasNotices() && Objects.equals(notices(), other.notices())
                && hasPassThroughWaypoints() == other.hasPassThroughWaypoints()
                && Objects.equals(passThroughWaypoints(), other.passThroughWaypoints()) && hasSpans() == other.hasSpans()
                && Objects.equals(spans(), other.spans()) && Objects.equals(summary(), other.summary())
                && hasTravelSteps() == other.hasTravelSteps() && Objects.equals(travelSteps(), other.travelSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutePedestrianLegDetails").add("Arrival", arrival()).add("Departure", departure())
                .add("Notices", hasNotices() ? notices() : null)
                .add("PassThroughWaypoints", hasPassThroughWaypoints() ? passThroughWaypoints() : null)
                .add("Spans", hasSpans() ? spans() : null).add("Summary", summary())
                .add("TravelSteps", hasTravelSteps() ? travelSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arrival":
            return Optional.ofNullable(clazz.cast(arrival()));
        case "Departure":
            return Optional.ofNullable(clazz.cast(departure()));
        case "Notices":
            return Optional.ofNullable(clazz.cast(notices()));
        case "PassThroughWaypoints":
            return Optional.ofNullable(clazz.cast(passThroughWaypoints()));
        case "Spans":
            return Optional.ofNullable(clazz.cast(spans()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "TravelSteps":
            return Optional.ofNullable(clazz.cast(travelSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arrival", ARRIVAL_FIELD);
        map.put("Departure", DEPARTURE_FIELD);
        map.put("Notices", NOTICES_FIELD);
        map.put("PassThroughWaypoints", PASS_THROUGH_WAYPOINTS_FIELD);
        map.put("Spans", SPANS_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        map.put("TravelSteps", TRAVEL_STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutePedestrianLegDetails, T> g) {
        return obj -> g.apply((RoutePedestrianLegDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutePedestrianLegDetails> {
        /**
         * <p>
         * Details corresponding to the arrival for the leg.
         * </p>
         * 
         * @param arrival
         *        Details corresponding to the arrival for the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrival(RoutePedestrianArrival arrival);

        /**
         * <p>
         * Details corresponding to the arrival for the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutePedestrianArrival.Builder} avoiding
         * the need to create one manually via {@link RoutePedestrianArrival#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutePedestrianArrival.Builder#build()} is called immediately and
         * its result is passed to {@link #arrival(RoutePedestrianArrival)}.
         * 
         * @param arrival
         *        a consumer that will call methods on {@link RoutePedestrianArrival.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrival(RoutePedestrianArrival)
         */
        default Builder arrival(Consumer<RoutePedestrianArrival.Builder> arrival) {
            return arrival(RoutePedestrianArrival.builder().applyMutation(arrival).build());
        }

        /**
         * <p>
         * Details corresponding to the departure for the leg.
         * </p>
         * 
         * @param departure
         *        Details corresponding to the departure for the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder departure(RoutePedestrianDeparture departure);

        /**
         * <p>
         * Details corresponding to the departure for the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutePedestrianDeparture.Builder}
         * avoiding the need to create one manually via {@link RoutePedestrianDeparture#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutePedestrianDeparture.Builder#build()} is called immediately
         * and its result is passed to {@link #departure(RoutePedestrianDeparture)}.
         * 
         * @param departure
         *        a consumer that will call methods on {@link RoutePedestrianDeparture.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #departure(RoutePedestrianDeparture)
         */
        default Builder departure(Consumer<RoutePedestrianDeparture.Builder> departure) {
            return departure(RoutePedestrianDeparture.builder().applyMutation(departure).build());
        }

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(Collection<RoutePedestrianNotice> notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(RoutePedestrianNotice... notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianNotice.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianNotice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianNotice.Builder#build()} is called
         * immediately and its result is passed to {@link #notices(List<RoutePedestrianNotice>)}.
         * 
         * @param notices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianNotice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notices(java.util.Collection<RoutePedestrianNotice>)
         */
        Builder notices(Consumer<RoutePedestrianNotice.Builder>... notices);

        /**
         * <p>
         * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
         * PassThrough option.
         * </p>
         * 
         * @param passThroughWaypoints
         *        Waypoints that were passed through during the leg. This includes the waypoints that were configured
         *        with the PassThrough option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passThroughWaypoints(Collection<RoutePassThroughWaypoint> passThroughWaypoints);

        /**
         * <p>
         * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
         * PassThrough option.
         * </p>
         * 
         * @param passThroughWaypoints
         *        Waypoints that were passed through during the leg. This includes the waypoints that were configured
         *        with the PassThrough option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passThroughWaypoints(RoutePassThroughWaypoint... passThroughWaypoints);

        /**
         * <p>
         * Waypoints that were passed through during the leg. This includes the waypoints that were configured with the
         * PassThrough option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint.Builder#build()} is called
         * immediately and its result is passed to {@link #passThroughWaypoints(List<RoutePassThroughWaypoint>)}.
         * 
         * @param passThroughWaypoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RoutePassThroughWaypoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passThroughWaypoints(java.util.Collection<RoutePassThroughWaypoint>)
         */
        Builder passThroughWaypoints(Consumer<RoutePassThroughWaypoint.Builder>... passThroughWaypoints);

        /**
         * <p>
         * Spans that were computed for the requested SpanAdditionalFeatures.
         * </p>
         * 
         * @param spans
         *        Spans that were computed for the requested SpanAdditionalFeatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spans(Collection<RoutePedestrianSpan> spans);

        /**
         * <p>
         * Spans that were computed for the requested SpanAdditionalFeatures.
         * </p>
         * 
         * @param spans
         *        Spans that were computed for the requested SpanAdditionalFeatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spans(RoutePedestrianSpan... spans);

        /**
         * <p>
         * Spans that were computed for the requested SpanAdditionalFeatures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianSpan.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianSpan#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianSpan.Builder#build()} is called
         * immediately and its result is passed to {@link #spans(List<RoutePedestrianSpan>)}.
         * 
         * @param spans
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianSpan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spans(java.util.Collection<RoutePedestrianSpan>)
         */
        Builder spans(Consumer<RoutePedestrianSpan.Builder>... spans);

        /**
         * <p>
         * Summarized details of the leg.
         * </p>
         * 
         * @param summary
         *        Summarized details of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(RoutePedestrianSummary summary);

        /**
         * <p>
         * Summarized details of the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutePedestrianSummary.Builder} avoiding
         * the need to create one manually via {@link RoutePedestrianSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutePedestrianSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #summary(RoutePedestrianSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link RoutePedestrianSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(RoutePedestrianSummary)
         */
        default Builder summary(Consumer<RoutePedestrianSummary.Builder> summary) {
            return summary(RoutePedestrianSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * 
         * @param travelSteps
         *        Steps of a leg that must be performed before the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelSteps(Collection<RoutePedestrianTravelStep> travelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * 
         * @param travelSteps
         *        Steps of a leg that must be performed before the travel portion of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelSteps(RoutePedestrianTravelStep... travelSteps);

        /**
         * <p>
         * Steps of a leg that must be performed before the travel portion of the leg.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianTravelStep.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianTravelStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianTravelStep.Builder#build()} is called
         * immediately and its result is passed to {@link #travelSteps(List<RoutePedestrianTravelStep>)}.
         * 
         * @param travelSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RoutePedestrianTravelStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #travelSteps(java.util.Collection<RoutePedestrianTravelStep>)
         */
        Builder travelSteps(Consumer<RoutePedestrianTravelStep.Builder>... travelSteps);
    }

    static final class BuilderImpl implements Builder {
        private RoutePedestrianArrival arrival;

        private RoutePedestrianDeparture departure;

        private List<RoutePedestrianNotice> notices = DefaultSdkAutoConstructList.getInstance();

        private List<RoutePassThroughWaypoint> passThroughWaypoints = DefaultSdkAutoConstructList.getInstance();

        private List<RoutePedestrianSpan> spans = DefaultSdkAutoConstructList.getInstance();

        private RoutePedestrianSummary summary;

        private List<RoutePedestrianTravelStep> travelSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoutePedestrianLegDetails model) {
            arrival(model.arrival);
            departure(model.departure);
            notices(model.notices);
            passThroughWaypoints(model.passThroughWaypoints);
            spans(model.spans);
            summary(model.summary);
            travelSteps(model.travelSteps);
        }

        public final RoutePedestrianArrival.Builder getArrival() {
            return arrival != null ? arrival.toBuilder() : null;
        }

        public final void setArrival(RoutePedestrianArrival.BuilderImpl arrival) {
            this.arrival = arrival != null ? arrival.build() : null;
        }

        @Override
        public final Builder arrival(RoutePedestrianArrival arrival) {
            this.arrival = arrival;
            return this;
        }

        public final RoutePedestrianDeparture.Builder getDeparture() {
            return departure != null ? departure.toBuilder() : null;
        }

        public final void setDeparture(RoutePedestrianDeparture.BuilderImpl departure) {
            this.departure = departure != null ? departure.build() : null;
        }

        @Override
        public final Builder departure(RoutePedestrianDeparture departure) {
            this.departure = departure;
            return this;
        }

        public final List<RoutePedestrianNotice.Builder> getNotices() {
            List<RoutePedestrianNotice.Builder> result = RoutePedestrianNoticeListCopier.copyToBuilder(this.notices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotices(Collection<RoutePedestrianNotice.BuilderImpl> notices) {
            this.notices = RoutePedestrianNoticeListCopier.copyFromBuilder(notices);
        }

        @Override
        public final Builder notices(Collection<RoutePedestrianNotice> notices) {
            this.notices = RoutePedestrianNoticeListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(RoutePedestrianNotice... notices) {
            notices(Arrays.asList(notices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Consumer<RoutePedestrianNotice.Builder>... notices) {
            notices(Stream.of(notices).map(c -> RoutePedestrianNotice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RoutePassThroughWaypoint.Builder> getPassThroughWaypoints() {
            List<RoutePassThroughWaypoint.Builder> result = RoutePassThroughWaypointListCopier
                    .copyToBuilder(this.passThroughWaypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPassThroughWaypoints(Collection<RoutePassThroughWaypoint.BuilderImpl> passThroughWaypoints) {
            this.passThroughWaypoints = RoutePassThroughWaypointListCopier.copyFromBuilder(passThroughWaypoints);
        }

        @Override
        public final Builder passThroughWaypoints(Collection<RoutePassThroughWaypoint> passThroughWaypoints) {
            this.passThroughWaypoints = RoutePassThroughWaypointListCopier.copy(passThroughWaypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passThroughWaypoints(RoutePassThroughWaypoint... passThroughWaypoints) {
            passThroughWaypoints(Arrays.asList(passThroughWaypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passThroughWaypoints(Consumer<RoutePassThroughWaypoint.Builder>... passThroughWaypoints) {
            passThroughWaypoints(Stream.of(passThroughWaypoints)
                    .map(c -> RoutePassThroughWaypoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RoutePedestrianSpan.Builder> getSpans() {
            List<RoutePedestrianSpan.Builder> result = RoutePedestrianSpanListCopier.copyToBuilder(this.spans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpans(Collection<RoutePedestrianSpan.BuilderImpl> spans) {
            this.spans = RoutePedestrianSpanListCopier.copyFromBuilder(spans);
        }

        @Override
        public final Builder spans(Collection<RoutePedestrianSpan> spans) {
            this.spans = RoutePedestrianSpanListCopier.copy(spans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(RoutePedestrianSpan... spans) {
            spans(Arrays.asList(spans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spans(Consumer<RoutePedestrianSpan.Builder>... spans) {
            spans(Stream.of(spans).map(c -> RoutePedestrianSpan.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RoutePedestrianSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(RoutePedestrianSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(RoutePedestrianSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<RoutePedestrianTravelStep.Builder> getTravelSteps() {
            List<RoutePedestrianTravelStep.Builder> result = RoutePedestrianTravelStepListCopier.copyToBuilder(this.travelSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTravelSteps(Collection<RoutePedestrianTravelStep.BuilderImpl> travelSteps) {
            this.travelSteps = RoutePedestrianTravelStepListCopier.copyFromBuilder(travelSteps);
        }

        @Override
        public final Builder travelSteps(Collection<RoutePedestrianTravelStep> travelSteps) {
            this.travelSteps = RoutePedestrianTravelStepListCopier.copy(travelSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelSteps(RoutePedestrianTravelStep... travelSteps) {
            travelSteps(Arrays.asList(travelSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder travelSteps(Consumer<RoutePedestrianTravelStep.Builder>... travelSteps) {
            travelSteps(Stream.of(travelSteps).map(c -> RoutePedestrianTravelStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RoutePedestrianLegDetails build() {
            return new RoutePedestrianLegDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
