/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarized details for the leg including before travel, travel and after travel steps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutePedestrianSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutePedestrianSummary.Builder, RoutePedestrianSummary> {
    private static final SdkField<RoutePedestrianOverviewSummary> OVERVIEW_FIELD = SdkField
            .<RoutePedestrianOverviewSummary> builder(MarshallingType.SDK_POJO).memberName("Overview")
            .getter(getter(RoutePedestrianSummary::overview)).setter(setter(Builder::overview))
            .constructor(RoutePedestrianOverviewSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overview").build()).build();

    private static final SdkField<RoutePedestrianTravelOnlySummary> TRAVEL_ONLY_FIELD = SdkField
            .<RoutePedestrianTravelOnlySummary> builder(MarshallingType.SDK_POJO).memberName("TravelOnly")
            .getter(getter(RoutePedestrianSummary::travelOnly)).setter(setter(Builder::travelOnly))
            .constructor(RoutePedestrianTravelOnlySummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TravelOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERVIEW_FIELD,
            TRAVEL_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RoutePedestrianOverviewSummary overview;

    private final RoutePedestrianTravelOnlySummary travelOnly;

    private RoutePedestrianSummary(BuilderImpl builder) {
        this.overview = builder.overview;
        this.travelOnly = builder.travelOnly;
    }

    /**
     * <p>
     * Summarized details for the leg including before travel, travel and after travel steps.
     * </p>
     * 
     * @return Summarized details for the leg including before travel, travel and after travel steps.
     */
    public final RoutePedestrianOverviewSummary overview() {
        return overview;
    }

    /**
     * <p>
     * Summarized details for the leg including travel steps only. The Distance for the travel only portion of the
     * journey is in meters
     * </p>
     * 
     * @return Summarized details for the leg including travel steps only. The Distance for the travel only portion of
     *         the journey is in meters
     */
    public final RoutePedestrianTravelOnlySummary travelOnly() {
        return travelOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(overview());
        hashCode = 31 * hashCode + Objects.hashCode(travelOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutePedestrianSummary)) {
            return false;
        }
        RoutePedestrianSummary other = (RoutePedestrianSummary) obj;
        return Objects.equals(overview(), other.overview()) && Objects.equals(travelOnly(), other.travelOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutePedestrianSummary").add("Overview", overview()).add("TravelOnly", travelOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Overview":
            return Optional.ofNullable(clazz.cast(overview()));
        case "TravelOnly":
            return Optional.ofNullable(clazz.cast(travelOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Overview", OVERVIEW_FIELD);
        map.put("TravelOnly", TRAVEL_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutePedestrianSummary, T> g) {
        return obj -> g.apply((RoutePedestrianSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutePedestrianSummary> {
        /**
         * <p>
         * Summarized details for the leg including before travel, travel and after travel steps.
         * </p>
         * 
         * @param overview
         *        Summarized details for the leg including before travel, travel and after travel steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overview(RoutePedestrianOverviewSummary overview);

        /**
         * <p>
         * Summarized details for the leg including before travel, travel and after travel steps.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutePedestrianOverviewSummary.Builder}
         * avoiding the need to create one manually via {@link RoutePedestrianOverviewSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutePedestrianOverviewSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #overview(RoutePedestrianOverviewSummary)}.
         * 
         * @param overview
         *        a consumer that will call methods on {@link RoutePedestrianOverviewSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overview(RoutePedestrianOverviewSummary)
         */
        default Builder overview(Consumer<RoutePedestrianOverviewSummary.Builder> overview) {
            return overview(RoutePedestrianOverviewSummary.builder().applyMutation(overview).build());
        }

        /**
         * <p>
         * Summarized details for the leg including travel steps only. The Distance for the travel only portion of the
         * journey is in meters
         * </p>
         * 
         * @param travelOnly
         *        Summarized details for the leg including travel steps only. The Distance for the travel only portion
         *        of the journey is in meters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder travelOnly(RoutePedestrianTravelOnlySummary travelOnly);

        /**
         * <p>
         * Summarized details for the leg including travel steps only. The Distance for the travel only portion of the
         * journey is in meters
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutePedestrianTravelOnlySummary.Builder}
         * avoiding the need to create one manually via {@link RoutePedestrianTravelOnlySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutePedestrianTravelOnlySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #travelOnly(RoutePedestrianTravelOnlySummary)}.
         * 
         * @param travelOnly
         *        a consumer that will call methods on {@link RoutePedestrianTravelOnlySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #travelOnly(RoutePedestrianTravelOnlySummary)
         */
        default Builder travelOnly(Consumer<RoutePedestrianTravelOnlySummary.Builder> travelOnly) {
            return travelOnly(RoutePedestrianTravelOnlySummary.builder().applyMutation(travelOnly).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RoutePedestrianOverviewSummary overview;

        private RoutePedestrianTravelOnlySummary travelOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutePedestrianSummary model) {
            overview(model.overview);
            travelOnly(model.travelOnly);
        }

        public final RoutePedestrianOverviewSummary.Builder getOverview() {
            return overview != null ? overview.toBuilder() : null;
        }

        public final void setOverview(RoutePedestrianOverviewSummary.BuilderImpl overview) {
            this.overview = overview != null ? overview.build() : null;
        }

        @Override
        public final Builder overview(RoutePedestrianOverviewSummary overview) {
            this.overview = overview;
            return this;
        }

        public final RoutePedestrianTravelOnlySummary.Builder getTravelOnly() {
            return travelOnly != null ? travelOnly.toBuilder() : null;
        }

        public final void setTravelOnly(RoutePedestrianTravelOnlySummary.BuilderImpl travelOnly) {
            this.travelOnly = travelOnly != null ? travelOnly.build() : null;
        }

        @Override
        public final Builder travelOnly(RoutePedestrianTravelOnlySummary travelOnly) {
            this.travelOnly = travelOnly;
            return this;
        }

        @Override
        public RoutePedestrianSummary build() {
            return new RoutePedestrianSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
