/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The road on the route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteRoad implements SdkPojo, Serializable, ToCopyableBuilder<RouteRoad.Builder, RouteRoad> {
    private static final SdkField<List<LocalizedString>> ROAD_NAME_FIELD = SdkField
            .<List<LocalizedString>> builder(MarshallingType.LIST)
            .memberName("RoadName")
            .getter(getter(RouteRoad::roadName))
            .setter(setter(Builder::roadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoadName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalizedString> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalizedString::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteNumber>> ROUTE_NUMBER_FIELD = SdkField
            .<List<RouteNumber>> builder(MarshallingType.LIST)
            .memberName("RouteNumber")
            .getter(getter(RouteRoad::routeNumber))
            .setter(setter(Builder::routeNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteNumber").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteNumber> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteNumber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LocalizedString>> TOWARDS_FIELD = SdkField
            .<List<LocalizedString>> builder(MarshallingType.LIST)
            .memberName("Towards")
            .getter(getter(RouteRoad::towards))
            .setter(setter(Builder::towards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Towards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocalizedString> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalizedString::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RouteRoad::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROAD_NAME_FIELD,
            ROUTE_NUMBER_FIELD, TOWARDS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LocalizedString> roadName;

    private final List<RouteNumber> routeNumber;

    private final List<LocalizedString> towards;

    private final String type;

    private RouteRoad(BuilderImpl builder) {
        this.roadName = builder.roadName;
        this.routeNumber = builder.routeNumber;
        this.towards = builder.towards;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoadName property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoadName() {
        return roadName != null && !(roadName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Name of the road (localized).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoadName} method.
     * </p>
     * 
     * @return Name of the road (localized).
     */
    public final List<LocalizedString> roadName() {
        return roadName;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteNumber property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteNumber() {
        return routeNumber != null && !(routeNumber instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Route number of the road.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteNumber} method.
     * </p>
     * 
     * @return Route number of the road.
     */
    public final List<RouteNumber> routeNumber() {
        return routeNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the Towards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTowards() {
        return towards != null && !(towards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Names of destinations that can be reached when traveling on the road.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTowards} method.
     * </p>
     * 
     * @return Names of destinations that can be reached when traveling on the road.
     */
    public final List<LocalizedString> towards() {
        return towards;
    }

    /**
     * <p>
     * The type of road.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteRoadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of road.
     * @see RouteRoadType
     */
    public final RouteRoadType type() {
        return RouteRoadType.fromValue(type);
    }

    /**
     * <p>
     * The type of road.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RouteRoadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of road.
     * @see RouteRoadType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRoadName() ? roadName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteNumber() ? routeNumber() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTowards() ? towards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteRoad)) {
            return false;
        }
        RouteRoad other = (RouteRoad) obj;
        return hasRoadName() == other.hasRoadName() && Objects.equals(roadName(), other.roadName())
                && hasRouteNumber() == other.hasRouteNumber() && Objects.equals(routeNumber(), other.routeNumber())
                && hasTowards() == other.hasTowards() && Objects.equals(towards(), other.towards())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteRoad").add("RoadName", hasRoadName() ? roadName() : null)
                .add("RouteNumber", hasRouteNumber() ? routeNumber() : null).add("Towards", hasTowards() ? towards() : null)
                .add("Type", typeAsString() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoadName":
            return Optional.ofNullable(clazz.cast(roadName()));
        case "RouteNumber":
            return Optional.ofNullable(clazz.cast(routeNumber()));
        case "Towards":
            return Optional.ofNullable(clazz.cast(towards()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoadName", ROAD_NAME_FIELD);
        map.put("RouteNumber", ROUTE_NUMBER_FIELD);
        map.put("Towards", TOWARDS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteRoad, T> g) {
        return obj -> g.apply((RouteRoad) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteRoad> {
        /**
         * <p>
         * Name of the road (localized).
         * </p>
         * 
         * @param roadName
         *        Name of the road (localized).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roadName(Collection<LocalizedString> roadName);

        /**
         * <p>
         * Name of the road (localized).
         * </p>
         * 
         * @param roadName
         *        Name of the road (localized).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roadName(LocalizedString... roadName);

        /**
         * <p>
         * Name of the road (localized).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.LocalizedString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder#build()} is called immediately
         * and its result is passed to {@link #roadName(List<LocalizedString>)}.
         * 
         * @param roadName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roadName(java.util.Collection<LocalizedString>)
         */
        Builder roadName(Consumer<LocalizedString.Builder>... roadName);

        /**
         * <p>
         * Route number of the road.
         * </p>
         * 
         * @param routeNumber
         *        Route number of the road.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeNumber(Collection<RouteNumber> routeNumber);

        /**
         * <p>
         * Route number of the road.
         * </p>
         * 
         * @param routeNumber
         *        Route number of the road.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeNumber(RouteNumber... routeNumber);

        /**
         * <p>
         * Route number of the road.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteNumber.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.georoutes.model.RouteNumber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteNumber.Builder#build()} is called immediately and
         * its result is passed to {@link #routeNumber(List<RouteNumber>)}.
         * 
         * @param routeNumber
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeNumber(java.util.Collection<RouteNumber>)
         */
        Builder routeNumber(Consumer<RouteNumber.Builder>... routeNumber);

        /**
         * <p>
         * Names of destinations that can be reached when traveling on the road.
         * </p>
         * 
         * @param towards
         *        Names of destinations that can be reached when traveling on the road.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder towards(Collection<LocalizedString> towards);

        /**
         * <p>
         * Names of destinations that can be reached when traveling on the road.
         * </p>
         * 
         * @param towards
         *        Names of destinations that can be reached when traveling on the road.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder towards(LocalizedString... towards);

        /**
         * <p>
         * Names of destinations that can be reached when traveling on the road.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.LocalizedString#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder#build()} is called immediately
         * and its result is passed to {@link #towards(List<LocalizedString>)}.
         * 
         * @param towards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.LocalizedString.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #towards(java.util.Collection<LocalizedString>)
         */
        Builder towards(Consumer<LocalizedString.Builder>... towards);

        /**
         * <p>
         * The type of road.
         * </p>
         * 
         * @param type
         *        The type of road.
         * @see RouteRoadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteRoadType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of road.
         * </p>
         * 
         * @param type
         *        The type of road.
         * @see RouteRoadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteRoadType
         */
        Builder type(RouteRoadType type);
    }

    static final class BuilderImpl implements Builder {
        private List<LocalizedString> roadName = DefaultSdkAutoConstructList.getInstance();

        private List<RouteNumber> routeNumber = DefaultSdkAutoConstructList.getInstance();

        private List<LocalizedString> towards = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteRoad model) {
            roadName(model.roadName);
            routeNumber(model.routeNumber);
            towards(model.towards);
            type(model.type);
        }

        public final List<LocalizedString.Builder> getRoadName() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.roadName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoadName(Collection<LocalizedString.BuilderImpl> roadName) {
            this.roadName = LocalizedStringListCopier.copyFromBuilder(roadName);
        }

        @Override
        public final Builder roadName(Collection<LocalizedString> roadName) {
            this.roadName = LocalizedStringListCopier.copy(roadName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadName(LocalizedString... roadName) {
            roadName(Arrays.asList(roadName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roadName(Consumer<LocalizedString.Builder>... roadName) {
            roadName(Stream.of(roadName).map(c -> LocalizedString.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RouteNumber.Builder> getRouteNumber() {
            List<RouteNumber.Builder> result = RouteNumberListCopier.copyToBuilder(this.routeNumber);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteNumber(Collection<RouteNumber.BuilderImpl> routeNumber) {
            this.routeNumber = RouteNumberListCopier.copyFromBuilder(routeNumber);
        }

        @Override
        public final Builder routeNumber(Collection<RouteNumber> routeNumber) {
            this.routeNumber = RouteNumberListCopier.copy(routeNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumber(RouteNumber... routeNumber) {
            routeNumber(Arrays.asList(routeNumber));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeNumber(Consumer<RouteNumber.Builder>... routeNumber) {
            routeNumber(Stream.of(routeNumber).map(c -> RouteNumber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LocalizedString.Builder> getTowards() {
            List<LocalizedString.Builder> result = LocalizedStringListCopier.copyToBuilder(this.towards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTowards(Collection<LocalizedString.BuilderImpl> towards) {
            this.towards = LocalizedStringListCopier.copyFromBuilder(towards);
        }

        @Override
        public final Builder towards(Collection<LocalizedString> towards) {
            this.towards = LocalizedStringListCopier.copy(towards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder towards(LocalizedString... towards) {
            towards(Arrays.asList(towards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder towards(Consumer<LocalizedString.Builder>... towards) {
            towards(Stream.of(towards).map(c -> LocalizedString.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RouteRoadType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RouteRoad build() {
            return new RouteRoad(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
