/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the speed limit corresponding to the span.
 * </p>
 * <p>
 * <b>Unit</b>: <code>KilometersPerHour</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteSpanSpeedLimitDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteSpanSpeedLimitDetails.Builder, RouteSpanSpeedLimitDetails> {
    private static final SdkField<Double> MAX_SPEED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxSpeed").getter(getter(RouteSpanSpeedLimitDetails::maxSpeed)).setter(setter(Builder::maxSpeed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSpeed").build()).build();

    private static final SdkField<Boolean> UNLIMITED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Unlimited").getter(getter(RouteSpanSpeedLimitDetails::unlimited)).setter(setter(Builder::unlimited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unlimited").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_SPEED_FIELD,
            UNLIMITED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double maxSpeed;

    private final Boolean unlimited;

    private RouteSpanSpeedLimitDetails(BuilderImpl builder) {
        this.maxSpeed = builder.maxSpeed;
        this.unlimited = builder.unlimited;
    }

    /**
     * <p>
     * Maximum speed.
     * </p>
     * <p>
     * <b>Unit</b>: <code>KilometersPerHour</code>
     * </p>
     * 
     * @return Maximum speed.</p>
     *         <p>
     *         <b>Unit</b>: <code>KilometersPerHour</code>
     */
    public final Double maxSpeed() {
        return maxSpeed;
    }

    /**
     * <p>
     * If the span doesn't have a speed limit like the Autobahn.
     * </p>
     * 
     * @return If the span doesn't have a speed limit like the Autobahn.
     */
    public final Boolean unlimited() {
        return unlimited;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxSpeed());
        hashCode = 31 * hashCode + Objects.hashCode(unlimited());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSpanSpeedLimitDetails)) {
            return false;
        }
        RouteSpanSpeedLimitDetails other = (RouteSpanSpeedLimitDetails) obj;
        return Objects.equals(maxSpeed(), other.maxSpeed()) && Objects.equals(unlimited(), other.unlimited());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteSpanSpeedLimitDetails")
                .add("MaxSpeed", maxSpeed() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Unlimited", unlimited() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxSpeed":
            return Optional.ofNullable(clazz.cast(maxSpeed()));
        case "Unlimited":
            return Optional.ofNullable(clazz.cast(unlimited()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxSpeed", MAX_SPEED_FIELD);
        map.put("Unlimited", UNLIMITED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteSpanSpeedLimitDetails, T> g) {
        return obj -> g.apply((RouteSpanSpeedLimitDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteSpanSpeedLimitDetails> {
        /**
         * <p>
         * Maximum speed.
         * </p>
         * <p>
         * <b>Unit</b>: <code>KilometersPerHour</code>
         * </p>
         * 
         * @param maxSpeed
         *        Maximum speed.</p>
         *        <p>
         *        <b>Unit</b>: <code>KilometersPerHour</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSpeed(Double maxSpeed);

        /**
         * <p>
         * If the span doesn't have a speed limit like the Autobahn.
         * </p>
         * 
         * @param unlimited
         *        If the span doesn't have a speed limit like the Autobahn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlimited(Boolean unlimited);
    }

    static final class BuilderImpl implements Builder {
        private Double maxSpeed;

        private Boolean unlimited;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSpanSpeedLimitDetails model) {
            maxSpeed(model.maxSpeed);
            unlimited(model.unlimited);
        }

        public final Double getMaxSpeed() {
            return maxSpeed;
        }

        public final void setMaxSpeed(Double maxSpeed) {
            this.maxSpeed = maxSpeed;
        }

        @Override
        public final Builder maxSpeed(Double maxSpeed) {
            this.maxSpeed = maxSpeed;
            return this;
        }

        public final Boolean getUnlimited() {
            return unlimited;
        }

        public final void setUnlimited(Boolean unlimited) {
            this.unlimited = unlimited;
        }

        @Override
        public final Builder unlimited(Boolean unlimited) {
            this.unlimited = unlimited;
            return this;
        }

        @Override
        public RouteSpanSpeedLimitDetails build() {
            return new RouteSpanSpeedLimitDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
