/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details if the toll rate can be a pass that supports multiple trips.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTollPass implements SdkPojo, Serializable, ToCopyableBuilder<RouteTollPass.Builder, RouteTollPass> {
    private static final SdkField<Boolean> INCLUDES_RETURN_TRIP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludesReturnTrip").getter(getter(RouteTollPass::includesReturnTrip))
            .setter(setter(Builder::includesReturnTrip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludesReturnTrip").build())
            .build();

    private static final SdkField<Boolean> SENIOR_PASS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SeniorPass").getter(getter(RouteTollPass::seniorPass)).setter(setter(Builder::seniorPass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeniorPass").build()).build();

    private static final SdkField<Integer> TRANSFER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TransferCount").getter(getter(RouteTollPass::transferCount)).setter(setter(Builder::transferCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferCount").build()).build();

    private static final SdkField<Integer> TRIP_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TripCount").getter(getter(RouteTollPass::tripCount)).setter(setter(Builder::tripCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TripCount").build()).build();

    private static final SdkField<RouteTollPassValidityPeriod> VALIDITY_PERIOD_FIELD = SdkField
            .<RouteTollPassValidityPeriod> builder(MarshallingType.SDK_POJO).memberName("ValidityPeriod")
            .getter(getter(RouteTollPass::validityPeriod)).setter(setter(Builder::validityPeriod))
            .constructor(RouteTollPassValidityPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidityPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDES_RETURN_TRIP_FIELD,
            SENIOR_PASS_FIELD, TRANSFER_COUNT_FIELD, TRIP_COUNT_FIELD, VALIDITY_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean includesReturnTrip;

    private final Boolean seniorPass;

    private final Integer transferCount;

    private final Integer tripCount;

    private final RouteTollPassValidityPeriod validityPeriod;

    private RouteTollPass(BuilderImpl builder) {
        this.includesReturnTrip = builder.includesReturnTrip;
        this.seniorPass = builder.seniorPass;
        this.transferCount = builder.transferCount;
        this.tripCount = builder.tripCount;
        this.validityPeriod = builder.validityPeriod;
    }

    /**
     * <p>
     * If the pass includes the rate for the return leg of the trip.
     * </p>
     * 
     * @return If the pass includes the rate for the return leg of the trip.
     */
    public final Boolean includesReturnTrip() {
        return includesReturnTrip;
    }

    /**
     * <p>
     * If the pass is only valid for senior persons.
     * </p>
     * 
     * @return If the pass is only valid for senior persons.
     */
    public final Boolean seniorPass() {
        return seniorPass;
    }

    /**
     * <p>
     * If the toll pass can be transferred, and how many times.
     * </p>
     * 
     * @return If the toll pass can be transferred, and how many times.
     */
    public final Integer transferCount() {
        return transferCount;
    }

    /**
     * <p>
     * Number of trips the pass is valid for.
     * </p>
     * 
     * @return Number of trips the pass is valid for.
     */
    public final Integer tripCount() {
        return tripCount;
    }

    /**
     * <p>
     * Period for which the pass is valid.
     * </p>
     * 
     * @return Period for which the pass is valid.
     */
    public final RouteTollPassValidityPeriod validityPeriod() {
        return validityPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includesReturnTrip());
        hashCode = 31 * hashCode + Objects.hashCode(seniorPass());
        hashCode = 31 * hashCode + Objects.hashCode(transferCount());
        hashCode = 31 * hashCode + Objects.hashCode(tripCount());
        hashCode = 31 * hashCode + Objects.hashCode(validityPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTollPass)) {
            return false;
        }
        RouteTollPass other = (RouteTollPass) obj;
        return Objects.equals(includesReturnTrip(), other.includesReturnTrip())
                && Objects.equals(seniorPass(), other.seniorPass()) && Objects.equals(transferCount(), other.transferCount())
                && Objects.equals(tripCount(), other.tripCount()) && Objects.equals(validityPeriod(), other.validityPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTollPass")
                .add("IncludesReturnTrip", includesReturnTrip() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SeniorPass", seniorPass() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TransferCount", transferCount() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TripCount", tripCount() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ValidityPeriod", validityPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncludesReturnTrip":
            return Optional.ofNullable(clazz.cast(includesReturnTrip()));
        case "SeniorPass":
            return Optional.ofNullable(clazz.cast(seniorPass()));
        case "TransferCount":
            return Optional.ofNullable(clazz.cast(transferCount()));
        case "TripCount":
            return Optional.ofNullable(clazz.cast(tripCount()));
        case "ValidityPeriod":
            return Optional.ofNullable(clazz.cast(validityPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IncludesReturnTrip", INCLUDES_RETURN_TRIP_FIELD);
        map.put("SeniorPass", SENIOR_PASS_FIELD);
        map.put("TransferCount", TRANSFER_COUNT_FIELD);
        map.put("TripCount", TRIP_COUNT_FIELD);
        map.put("ValidityPeriod", VALIDITY_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTollPass, T> g) {
        return obj -> g.apply((RouteTollPass) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTollPass> {
        /**
         * <p>
         * If the pass includes the rate for the return leg of the trip.
         * </p>
         * 
         * @param includesReturnTrip
         *        If the pass includes the rate for the return leg of the trip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includesReturnTrip(Boolean includesReturnTrip);

        /**
         * <p>
         * If the pass is only valid for senior persons.
         * </p>
         * 
         * @param seniorPass
         *        If the pass is only valid for senior persons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seniorPass(Boolean seniorPass);

        /**
         * <p>
         * If the toll pass can be transferred, and how many times.
         * </p>
         * 
         * @param transferCount
         *        If the toll pass can be transferred, and how many times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferCount(Integer transferCount);

        /**
         * <p>
         * Number of trips the pass is valid for.
         * </p>
         * 
         * @param tripCount
         *        Number of trips the pass is valid for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tripCount(Integer tripCount);

        /**
         * <p>
         * Period for which the pass is valid.
         * </p>
         * 
         * @param validityPeriod
         *        Period for which the pass is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validityPeriod(RouteTollPassValidityPeriod validityPeriod);

        /**
         * <p>
         * Period for which the pass is valid.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTollPassValidityPeriod.Builder}
         * avoiding the need to create one manually via {@link RouteTollPassValidityPeriod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTollPassValidityPeriod.Builder#build()} is called
         * immediately and its result is passed to {@link #validityPeriod(RouteTollPassValidityPeriod)}.
         * 
         * @param validityPeriod
         *        a consumer that will call methods on {@link RouteTollPassValidityPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validityPeriod(RouteTollPassValidityPeriod)
         */
        default Builder validityPeriod(Consumer<RouteTollPassValidityPeriod.Builder> validityPeriod) {
            return validityPeriod(RouteTollPassValidityPeriod.builder().applyMutation(validityPeriod).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean includesReturnTrip;

        private Boolean seniorPass;

        private Integer transferCount;

        private Integer tripCount;

        private RouteTollPassValidityPeriod validityPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTollPass model) {
            includesReturnTrip(model.includesReturnTrip);
            seniorPass(model.seniorPass);
            transferCount(model.transferCount);
            tripCount(model.tripCount);
            validityPeriod(model.validityPeriod);
        }

        public final Boolean getIncludesReturnTrip() {
            return includesReturnTrip;
        }

        public final void setIncludesReturnTrip(Boolean includesReturnTrip) {
            this.includesReturnTrip = includesReturnTrip;
        }

        @Override
        public final Builder includesReturnTrip(Boolean includesReturnTrip) {
            this.includesReturnTrip = includesReturnTrip;
            return this;
        }

        public final Boolean getSeniorPass() {
            return seniorPass;
        }

        public final void setSeniorPass(Boolean seniorPass) {
            this.seniorPass = seniorPass;
        }

        @Override
        public final Builder seniorPass(Boolean seniorPass) {
            this.seniorPass = seniorPass;
            return this;
        }

        public final Integer getTransferCount() {
            return transferCount;
        }

        public final void setTransferCount(Integer transferCount) {
            this.transferCount = transferCount;
        }

        @Override
        public final Builder transferCount(Integer transferCount) {
            this.transferCount = transferCount;
            return this;
        }

        public final Integer getTripCount() {
            return tripCount;
        }

        public final void setTripCount(Integer tripCount) {
            this.tripCount = tripCount;
        }

        @Override
        public final Builder tripCount(Integer tripCount) {
            this.tripCount = tripCount;
            return this;
        }

        public final RouteTollPassValidityPeriod.Builder getValidityPeriod() {
            return validityPeriod != null ? validityPeriod.toBuilder() : null;
        }

        public final void setValidityPeriod(RouteTollPassValidityPeriod.BuilderImpl validityPeriod) {
            this.validityPeriod = validityPeriod != null ? validityPeriod.build() : null;
        }

        @Override
        public final Builder validityPeriod(RouteTollPassValidityPeriod validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        @Override
        public RouteTollPass build() {
            return new RouteTollPass(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
