/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Period for which the pass is valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTollPassValidityPeriod implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteTollPassValidityPeriod.Builder, RouteTollPassValidityPeriod> {
    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Period")
            .getter(getter(RouteTollPassValidityPeriod::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<Integer> PERIOD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodCount").getter(getter(RouteTollPassValidityPeriod::periodCount))
            .setter(setter(Builder::periodCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIOD_FIELD,
            PERIOD_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String period;

    private final Integer periodCount;

    private RouteTollPassValidityPeriod(BuilderImpl builder) {
        this.period = builder.period;
        this.periodCount = builder.periodCount;
    }

    /**
     * <p>
     * Validity period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link RouteTollPassValidityPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #periodAsString}.
     * </p>
     * 
     * @return Validity period.
     * @see RouteTollPassValidityPeriodType
     */
    public final RouteTollPassValidityPeriodType period() {
        return RouteTollPassValidityPeriodType.fromValue(period);
    }

    /**
     * <p>
     * Validity period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link RouteTollPassValidityPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #periodAsString}.
     * </p>
     * 
     * @return Validity period.
     * @see RouteTollPassValidityPeriodType
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * <p>
     * Counts for the validity period.
     * </p>
     * 
     * @return Counts for the validity period.
     */
    public final Integer periodCount() {
        return periodCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(periodCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTollPassValidityPeriod)) {
            return false;
        }
        RouteTollPassValidityPeriod other = (RouteTollPassValidityPeriod) obj;
        return Objects.equals(periodAsString(), other.periodAsString()) && Objects.equals(periodCount(), other.periodCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTollPassValidityPeriod")
                .add("Period", periodAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PeriodCount", periodCount() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "PeriodCount":
            return Optional.ofNullable(clazz.cast(periodCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Period", PERIOD_FIELD);
        map.put("PeriodCount", PERIOD_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTollPassValidityPeriod, T> g) {
        return obj -> g.apply((RouteTollPassValidityPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTollPassValidityPeriod> {
        /**
         * <p>
         * Validity period.
         * </p>
         * 
         * @param period
         *        Validity period.
         * @see RouteTollPassValidityPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTollPassValidityPeriodType
         */
        Builder period(String period);

        /**
         * <p>
         * Validity period.
         * </p>
         * 
         * @param period
         *        Validity period.
         * @see RouteTollPassValidityPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteTollPassValidityPeriodType
         */
        Builder period(RouteTollPassValidityPeriodType period);

        /**
         * <p>
         * Counts for the validity period.
         * </p>
         * 
         * @param periodCount
         *        Counts for the validity period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodCount(Integer periodCount);
    }

    static final class BuilderImpl implements Builder {
        private String period;

        private Integer periodCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTollPassValidityPeriod model) {
            period(model.period);
            periodCount(model.periodCount);
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(RouteTollPassValidityPeriodType period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final Integer getPeriodCount() {
            return periodCount;
        }

        public final void setPeriodCount(Integer periodCount) {
            this.periodCount = periodCount;
        }

        @Override
        public final Builder periodCount(Integer periodCount) {
            this.periodCount = periodCount;
            return this;
        }

        @Override
        public RouteTollPassValidityPeriod build() {
            return new RouteTollPassValidityPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
