/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The toll rate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTollRate implements SdkPojo, Serializable, ToCopyableBuilder<RouteTollRate.Builder, RouteTollRate> {
    private static final SdkField<String> APPLICABLE_TIMES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicableTimes").getter(getter(RouteTollRate::applicableTimes))
            .setter(setter(Builder::applicableTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicableTimes").build()).build();

    private static final SdkField<RouteTollPrice> CONVERTED_PRICE_FIELD = SdkField
            .<RouteTollPrice> builder(MarshallingType.SDK_POJO).memberName("ConvertedPrice")
            .getter(getter(RouteTollRate::convertedPrice)).setter(setter(Builder::convertedPrice))
            .constructor(RouteTollPrice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConvertedPrice").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RouteTollRate::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<RouteTollPrice> LOCAL_PRICE_FIELD = SdkField.<RouteTollPrice> builder(MarshallingType.SDK_POJO)
            .memberName("LocalPrice").getter(getter(RouteTollRate::localPrice)).setter(setter(Builder::localPrice))
            .constructor(RouteTollPrice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPrice").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RouteTollRate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<RouteTollPass> PASS_FIELD = SdkField.<RouteTollPass> builder(MarshallingType.SDK_POJO)
            .memberName("Pass").getter(getter(RouteTollRate::pass)).setter(setter(Builder::pass))
            .constructor(RouteTollPass::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pass").build()).build();

    private static final SdkField<List<String>> PAYMENT_METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PaymentMethods")
            .getter(getter(RouteTollRate::paymentMethodsAsStrings))
            .setter(setter(Builder::paymentMethodsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteTransponder>> TRANSPONDERS_FIELD = SdkField
            .<List<RouteTransponder>> builder(MarshallingType.LIST)
            .memberName("Transponders")
            .getter(getter(RouteTollRate::transponders))
            .setter(setter(Builder::transponders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transponders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteTransponder> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteTransponder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICABLE_TIMES_FIELD, CONVERTED_PRICE_FIELD, ID_FIELD, LOCAL_PRICE_FIELD, NAME_FIELD, PASS_FIELD,
                    PAYMENT_METHODS_FIELD, TRANSPONDERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicableTimes;

    private final RouteTollPrice convertedPrice;

    private final String id;

    private final RouteTollPrice localPrice;

    private final String name;

    private final RouteTollPass pass;

    private final List<String> paymentMethods;

    private final List<RouteTransponder> transponders;

    private RouteTollRate(BuilderImpl builder) {
        this.applicableTimes = builder.applicableTimes;
        this.convertedPrice = builder.convertedPrice;
        this.id = builder.id;
        this.localPrice = builder.localPrice;
        this.name = builder.name;
        this.pass = builder.pass;
        this.paymentMethods = builder.paymentMethods;
        this.transponders = builder.transponders;
    }

    /**
     * <p>
     * Time when the rate is valid.
     * </p>
     * 
     * @return Time when the rate is valid.
     */
    public final String applicableTimes() {
        return applicableTimes;
    }

    /**
     * <p>
     * Price in the converted currency as specified in the request.
     * </p>
     * 
     * @return Price in the converted currency as specified in the request.
     */
    public final RouteTollPrice convertedPrice() {
        return convertedPrice;
    }

    /**
     * <p>
     * The Toll rate Id.
     * </p>
     * 
     * @return The Toll rate Id.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Price in the local regional currency.
     * </p>
     * 
     * @return Price in the local regional currency.
     */
    public final RouteTollPrice localPrice() {
        return localPrice;
    }

    /**
     * <p>
     * The name of the toll.
     * </p>
     * 
     * @return The name of the toll.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Details if the toll rate can be a pass that supports multiple trips.
     * </p>
     * 
     * @return Details if the toll rate can be a pass that supports multiple trips.
     */
    public final RouteTollPass pass() {
        return pass;
    }

    /**
     * <p>
     * Accepted payment methods at the toll.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPaymentMethods} method.
     * </p>
     * 
     * @return Accepted payment methods at the toll.
     */
    public final List<RouteTollPaymentMethod> paymentMethods() {
        return RouteTollPaymentMethodListCopier.copyStringToEnum(paymentMethods);
    }

    /**
     * For responses, this returns true if the service returned a value for the PaymentMethods property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPaymentMethods() {
        return paymentMethods != null && !(paymentMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Accepted payment methods at the toll.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPaymentMethods} method.
     * </p>
     * 
     * @return Accepted payment methods at the toll.
     */
    public final List<String> paymentMethodsAsStrings() {
        return paymentMethods;
    }

    /**
     * For responses, this returns true if the service returned a value for the Transponders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransponders() {
        return transponders != null && !(transponders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Transponders for which this toll can be applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransponders} method.
     * </p>
     * 
     * @return Transponders for which this toll can be applied.
     */
    public final List<RouteTransponder> transponders() {
        return transponders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicableTimes());
        hashCode = 31 * hashCode + Objects.hashCode(convertedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(localPrice());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pass());
        hashCode = 31 * hashCode + Objects.hashCode(hasPaymentMethods() ? paymentMethodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTransponders() ? transponders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTollRate)) {
            return false;
        }
        RouteTollRate other = (RouteTollRate) obj;
        return Objects.equals(applicableTimes(), other.applicableTimes())
                && Objects.equals(convertedPrice(), other.convertedPrice()) && Objects.equals(id(), other.id())
                && Objects.equals(localPrice(), other.localPrice()) && Objects.equals(name(), other.name())
                && Objects.equals(pass(), other.pass()) && hasPaymentMethods() == other.hasPaymentMethods()
                && Objects.equals(paymentMethodsAsStrings(), other.paymentMethodsAsStrings())
                && hasTransponders() == other.hasTransponders() && Objects.equals(transponders(), other.transponders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTollRate")
                .add("ApplicableTimes", applicableTimes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConvertedPrice", convertedPrice()).add("Id", id() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LocalPrice", localPrice()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Pass", pass())
                .add("PaymentMethods", paymentMethodsAsStrings() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Transponders", hasTransponders() ? transponders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicableTimes":
            return Optional.ofNullable(clazz.cast(applicableTimes()));
        case "ConvertedPrice":
            return Optional.ofNullable(clazz.cast(convertedPrice()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LocalPrice":
            return Optional.ofNullable(clazz.cast(localPrice()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Pass":
            return Optional.ofNullable(clazz.cast(pass()));
        case "PaymentMethods":
            return Optional.ofNullable(clazz.cast(paymentMethodsAsStrings()));
        case "Transponders":
            return Optional.ofNullable(clazz.cast(transponders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicableTimes", APPLICABLE_TIMES_FIELD);
        map.put("ConvertedPrice", CONVERTED_PRICE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LocalPrice", LOCAL_PRICE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Pass", PASS_FIELD);
        map.put("PaymentMethods", PAYMENT_METHODS_FIELD);
        map.put("Transponders", TRANSPONDERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTollRate, T> g) {
        return obj -> g.apply((RouteTollRate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTollRate> {
        /**
         * <p>
         * Time when the rate is valid.
         * </p>
         * 
         * @param applicableTimes
         *        Time when the rate is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableTimes(String applicableTimes);

        /**
         * <p>
         * Price in the converted currency as specified in the request.
         * </p>
         * 
         * @param convertedPrice
         *        Price in the converted currency as specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder convertedPrice(RouteTollPrice convertedPrice);

        /**
         * <p>
         * Price in the converted currency as specified in the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTollPrice.Builder} avoiding the need
         * to create one manually via {@link RouteTollPrice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTollPrice.Builder#build()} is called immediately and its
         * result is passed to {@link #convertedPrice(RouteTollPrice)}.
         * 
         * @param convertedPrice
         *        a consumer that will call methods on {@link RouteTollPrice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #convertedPrice(RouteTollPrice)
         */
        default Builder convertedPrice(Consumer<RouteTollPrice.Builder> convertedPrice) {
            return convertedPrice(RouteTollPrice.builder().applyMutation(convertedPrice).build());
        }

        /**
         * <p>
         * The Toll rate Id.
         * </p>
         * 
         * @param id
         *        The Toll rate Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Price in the local regional currency.
         * </p>
         * 
         * @param localPrice
         *        Price in the local regional currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPrice(RouteTollPrice localPrice);

        /**
         * <p>
         * Price in the local regional currency.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTollPrice.Builder} avoiding the need
         * to create one manually via {@link RouteTollPrice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTollPrice.Builder#build()} is called immediately and its
         * result is passed to {@link #localPrice(RouteTollPrice)}.
         * 
         * @param localPrice
         *        a consumer that will call methods on {@link RouteTollPrice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localPrice(RouteTollPrice)
         */
        default Builder localPrice(Consumer<RouteTollPrice.Builder> localPrice) {
            return localPrice(RouteTollPrice.builder().applyMutation(localPrice).build());
        }

        /**
         * <p>
         * The name of the toll.
         * </p>
         * 
         * @param name
         *        The name of the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Details if the toll rate can be a pass that supports multiple trips.
         * </p>
         * 
         * @param pass
         *        Details if the toll rate can be a pass that supports multiple trips.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pass(RouteTollPass pass);

        /**
         * <p>
         * Details if the toll rate can be a pass that supports multiple trips.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTollPass.Builder} avoiding the need
         * to create one manually via {@link RouteTollPass#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTollPass.Builder#build()} is called immediately and its
         * result is passed to {@link #pass(RouteTollPass)}.
         * 
         * @param pass
         *        a consumer that will call methods on {@link RouteTollPass.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pass(RouteTollPass)
         */
        default Builder pass(Consumer<RouteTollPass.Builder> pass) {
            return pass(RouteTollPass.builder().applyMutation(pass).build());
        }

        /**
         * <p>
         * Accepted payment methods at the toll.
         * </p>
         * 
         * @param paymentMethods
         *        Accepted payment methods at the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentMethodsWithStrings(Collection<String> paymentMethods);

        /**
         * <p>
         * Accepted payment methods at the toll.
         * </p>
         * 
         * @param paymentMethods
         *        Accepted payment methods at the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentMethodsWithStrings(String... paymentMethods);

        /**
         * <p>
         * Accepted payment methods at the toll.
         * </p>
         * 
         * @param paymentMethods
         *        Accepted payment methods at the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentMethods(Collection<RouteTollPaymentMethod> paymentMethods);

        /**
         * <p>
         * Accepted payment methods at the toll.
         * </p>
         * 
         * @param paymentMethods
         *        Accepted payment methods at the toll.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentMethods(RouteTollPaymentMethod... paymentMethods);

        /**
         * <p>
         * Transponders for which this toll can be applied.
         * </p>
         * 
         * @param transponders
         *        Transponders for which this toll can be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transponders(Collection<RouteTransponder> transponders);

        /**
         * <p>
         * Transponders for which this toll can be applied.
         * </p>
         * 
         * @param transponders
         *        Transponders for which this toll can be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transponders(RouteTransponder... transponders);

        /**
         * <p>
         * Transponders for which this toll can be applied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteTransponder.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.RouteTransponder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteTransponder.Builder#build()} is called
         * immediately and its result is passed to {@link #transponders(List<RouteTransponder>)}.
         * 
         * @param transponders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteTransponder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transponders(java.util.Collection<RouteTransponder>)
         */
        Builder transponders(Consumer<RouteTransponder.Builder>... transponders);
    }

    static final class BuilderImpl implements Builder {
        private String applicableTimes;

        private RouteTollPrice convertedPrice;

        private String id;

        private RouteTollPrice localPrice;

        private String name;

        private RouteTollPass pass;

        private List<String> paymentMethods = DefaultSdkAutoConstructList.getInstance();

        private List<RouteTransponder> transponders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTollRate model) {
            applicableTimes(model.applicableTimes);
            convertedPrice(model.convertedPrice);
            id(model.id);
            localPrice(model.localPrice);
            name(model.name);
            pass(model.pass);
            paymentMethodsWithStrings(model.paymentMethods);
            transponders(model.transponders);
        }

        public final String getApplicableTimes() {
            return applicableTimes;
        }

        public final void setApplicableTimes(String applicableTimes) {
            this.applicableTimes = applicableTimes;
        }

        @Override
        public final Builder applicableTimes(String applicableTimes) {
            this.applicableTimes = applicableTimes;
            return this;
        }

        public final RouteTollPrice.Builder getConvertedPrice() {
            return convertedPrice != null ? convertedPrice.toBuilder() : null;
        }

        public final void setConvertedPrice(RouteTollPrice.BuilderImpl convertedPrice) {
            this.convertedPrice = convertedPrice != null ? convertedPrice.build() : null;
        }

        @Override
        public final Builder convertedPrice(RouteTollPrice convertedPrice) {
            this.convertedPrice = convertedPrice;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final RouteTollPrice.Builder getLocalPrice() {
            return localPrice != null ? localPrice.toBuilder() : null;
        }

        public final void setLocalPrice(RouteTollPrice.BuilderImpl localPrice) {
            this.localPrice = localPrice != null ? localPrice.build() : null;
        }

        @Override
        public final Builder localPrice(RouteTollPrice localPrice) {
            this.localPrice = localPrice;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RouteTollPass.Builder getPass() {
            return pass != null ? pass.toBuilder() : null;
        }

        public final void setPass(RouteTollPass.BuilderImpl pass) {
            this.pass = pass != null ? pass.build() : null;
        }

        @Override
        public final Builder pass(RouteTollPass pass) {
            this.pass = pass;
            return this;
        }

        public final Collection<String> getPaymentMethods() {
            if (paymentMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return paymentMethods;
        }

        public final void setPaymentMethods(Collection<String> paymentMethods) {
            this.paymentMethods = RouteTollPaymentMethodListCopier.copy(paymentMethods);
        }

        @Override
        public final Builder paymentMethodsWithStrings(Collection<String> paymentMethods) {
            this.paymentMethods = RouteTollPaymentMethodListCopier.copy(paymentMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentMethodsWithStrings(String... paymentMethods) {
            paymentMethodsWithStrings(Arrays.asList(paymentMethods));
            return this;
        }

        @Override
        public final Builder paymentMethods(Collection<RouteTollPaymentMethod> paymentMethods) {
            this.paymentMethods = RouteTollPaymentMethodListCopier.copyEnumToString(paymentMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentMethods(RouteTollPaymentMethod... paymentMethods) {
            paymentMethods(Arrays.asList(paymentMethods));
            return this;
        }

        public final List<RouteTransponder.Builder> getTransponders() {
            List<RouteTransponder.Builder> result = RouteTransponderListCopier.copyToBuilder(this.transponders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransponders(Collection<RouteTransponder.BuilderImpl> transponders) {
            this.transponders = RouteTransponderListCopier.copyFromBuilder(transponders);
        }

        @Override
        public final Builder transponders(Collection<RouteTransponder> transponders) {
            this.transponders = RouteTransponderListCopier.copy(transponders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transponders(RouteTransponder... transponders) {
            transponders(Arrays.asList(transponders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transponders(Consumer<RouteTransponder.Builder>... transponders) {
            transponders(Stream.of(transponders).map(c -> RouteTransponder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RouteTollRate build() {
            return new RouteTollRate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
