/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Travel mode related options for the provided travel mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTravelModeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteTravelModeOptions.Builder, RouteTravelModeOptions> {
    private static final SdkField<RouteCarOptions> CAR_FIELD = SdkField.<RouteCarOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Car").getter(getter(RouteTravelModeOptions::car)).setter(setter(Builder::car))
            .constructor(RouteCarOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Car").build()).build();

    private static final SdkField<RoutePedestrianOptions> PEDESTRIAN_FIELD = SdkField
            .<RoutePedestrianOptions> builder(MarshallingType.SDK_POJO).memberName("Pedestrian")
            .getter(getter(RouteTravelModeOptions::pedestrian)).setter(setter(Builder::pedestrian))
            .constructor(RoutePedestrianOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pedestrian").build()).build();

    private static final SdkField<RouteScooterOptions> SCOOTER_FIELD = SdkField
            .<RouteScooterOptions> builder(MarshallingType.SDK_POJO).memberName("Scooter")
            .getter(getter(RouteTravelModeOptions::scooter)).setter(setter(Builder::scooter))
            .constructor(RouteScooterOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scooter").build()).build();

    private static final SdkField<RouteTruckOptions> TRUCK_FIELD = SdkField.<RouteTruckOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Truck").getter(getter(RouteTravelModeOptions::truck)).setter(setter(Builder::truck))
            .constructor(RouteTruckOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAR_FIELD, PEDESTRIAN_FIELD,
            SCOOTER_FIELD, TRUCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RouteCarOptions car;

    private final RoutePedestrianOptions pedestrian;

    private final RouteScooterOptions scooter;

    private final RouteTruckOptions truck;

    private RouteTravelModeOptions(BuilderImpl builder) {
        this.car = builder.car;
        this.pedestrian = builder.pedestrian;
        this.scooter = builder.scooter;
        this.truck = builder.truck;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Car"
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Car"
     */
    public final RouteCarOptions car() {
        return car;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Pedestrian"
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Pedestrian"
     */
    public final RoutePedestrianOptions pedestrian() {
        return pedestrian;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is <code>Scooter</code>
     * </p>
     * <note>
     * <p>
     * When travel mode is set to <code>Scooter</code>, then the avoidance option <code>ControlledAccessHighways</code>
     * defaults to <code>true</code>.
     * </p>
     * </note>
     * 
     * @return Travel mode options when the provided travel mode is <code>Scooter</code> </p> <note>
     *         <p>
     *         When travel mode is set to <code>Scooter</code>, then the avoidance option
     *         <code>ControlledAccessHighways</code> defaults to <code>true</code>.
     *         </p>
     */
    public final RouteScooterOptions scooter() {
        return scooter;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Truck"
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Truck"
     */
    public final RouteTruckOptions truck() {
        return truck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(car());
        hashCode = 31 * hashCode + Objects.hashCode(pedestrian());
        hashCode = 31 * hashCode + Objects.hashCode(scooter());
        hashCode = 31 * hashCode + Objects.hashCode(truck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTravelModeOptions)) {
            return false;
        }
        RouteTravelModeOptions other = (RouteTravelModeOptions) obj;
        return Objects.equals(car(), other.car()) && Objects.equals(pedestrian(), other.pedestrian())
                && Objects.equals(scooter(), other.scooter()) && Objects.equals(truck(), other.truck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTravelModeOptions").add("Car", car()).add("Pedestrian", pedestrian())
                .add("Scooter", scooter()).add("Truck", truck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Car":
            return Optional.ofNullable(clazz.cast(car()));
        case "Pedestrian":
            return Optional.ofNullable(clazz.cast(pedestrian()));
        case "Scooter":
            return Optional.ofNullable(clazz.cast(scooter()));
        case "Truck":
            return Optional.ofNullable(clazz.cast(truck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Car", CAR_FIELD);
        map.put("Pedestrian", PEDESTRIAN_FIELD);
        map.put("Scooter", SCOOTER_FIELD);
        map.put("Truck", TRUCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTravelModeOptions, T> g) {
        return obj -> g.apply((RouteTravelModeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTravelModeOptions> {
        /**
         * <p>
         * Travel mode options when the provided travel mode is "Car"
         * </p>
         * 
         * @param car
         *        Travel mode options when the provided travel mode is "Car"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder car(RouteCarOptions car);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Car"
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteCarOptions.Builder} avoiding the
         * need to create one manually via {@link RouteCarOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteCarOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #car(RouteCarOptions)}.
         * 
         * @param car
         *        a consumer that will call methods on {@link RouteCarOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #car(RouteCarOptions)
         */
        default Builder car(Consumer<RouteCarOptions.Builder> car) {
            return car(RouteCarOptions.builder().applyMutation(car).build());
        }

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Pedestrian"
         * </p>
         * 
         * @param pedestrian
         *        Travel mode options when the provided travel mode is "Pedestrian"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pedestrian(RoutePedestrianOptions pedestrian);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Pedestrian"
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutePedestrianOptions.Builder} avoiding
         * the need to create one manually via {@link RoutePedestrianOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutePedestrianOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #pedestrian(RoutePedestrianOptions)}.
         * 
         * @param pedestrian
         *        a consumer that will call methods on {@link RoutePedestrianOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pedestrian(RoutePedestrianOptions)
         */
        default Builder pedestrian(Consumer<RoutePedestrianOptions.Builder> pedestrian) {
            return pedestrian(RoutePedestrianOptions.builder().applyMutation(pedestrian).build());
        }

        /**
         * <p>
         * Travel mode options when the provided travel mode is <code>Scooter</code>
         * </p>
         * <note>
         * <p>
         * When travel mode is set to <code>Scooter</code>, then the avoidance option
         * <code>ControlledAccessHighways</code> defaults to <code>true</code>.
         * </p>
         * </note>
         * 
         * @param scooter
         *        Travel mode options when the provided travel mode is <code>Scooter</code> </p> <note>
         *        <p>
         *        When travel mode is set to <code>Scooter</code>, then the avoidance option
         *        <code>ControlledAccessHighways</code> defaults to <code>true</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scooter(RouteScooterOptions scooter);

        /**
         * <p>
         * Travel mode options when the provided travel mode is <code>Scooter</code>
         * </p>
         * <note>
         * <p>
         * When travel mode is set to <code>Scooter</code>, then the avoidance option
         * <code>ControlledAccessHighways</code> defaults to <code>true</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link RouteScooterOptions.Builder}
         * avoiding the need to create one manually via {@link RouteScooterOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteScooterOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #scooter(RouteScooterOptions)}.
         * 
         * @param scooter
         *        a consumer that will call methods on {@link RouteScooterOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scooter(RouteScooterOptions)
         */
        default Builder scooter(Consumer<RouteScooterOptions.Builder> scooter) {
            return scooter(RouteScooterOptions.builder().applyMutation(scooter).build());
        }

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck"
         * </p>
         * 
         * @param truck
         *        Travel mode options when the provided travel mode is "Truck"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truck(RouteTruckOptions truck);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck"
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteTruckOptions.Builder} avoiding the
         * need to create one manually via {@link RouteTruckOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteTruckOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #truck(RouteTruckOptions)}.
         * 
         * @param truck
         *        a consumer that will call methods on {@link RouteTruckOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #truck(RouteTruckOptions)
         */
        default Builder truck(Consumer<RouteTruckOptions.Builder> truck) {
            return truck(RouteTruckOptions.builder().applyMutation(truck).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RouteCarOptions car;

        private RoutePedestrianOptions pedestrian;

        private RouteScooterOptions scooter;

        private RouteTruckOptions truck;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTravelModeOptions model) {
            car(model.car);
            pedestrian(model.pedestrian);
            scooter(model.scooter);
            truck(model.truck);
        }

        public final RouteCarOptions.Builder getCar() {
            return car != null ? car.toBuilder() : null;
        }

        public final void setCar(RouteCarOptions.BuilderImpl car) {
            this.car = car != null ? car.build() : null;
        }

        @Override
        public final Builder car(RouteCarOptions car) {
            this.car = car;
            return this;
        }

        public final RoutePedestrianOptions.Builder getPedestrian() {
            return pedestrian != null ? pedestrian.toBuilder() : null;
        }

        public final void setPedestrian(RoutePedestrianOptions.BuilderImpl pedestrian) {
            this.pedestrian = pedestrian != null ? pedestrian.build() : null;
        }

        @Override
        public final Builder pedestrian(RoutePedestrianOptions pedestrian) {
            this.pedestrian = pedestrian;
            return this;
        }

        public final RouteScooterOptions.Builder getScooter() {
            return scooter != null ? scooter.toBuilder() : null;
        }

        public final void setScooter(RouteScooterOptions.BuilderImpl scooter) {
            this.scooter = scooter != null ? scooter.build() : null;
        }

        @Override
        public final Builder scooter(RouteScooterOptions scooter) {
            this.scooter = scooter;
            return this;
        }

        public final RouteTruckOptions.Builder getTruck() {
            return truck != null ? truck.toBuilder() : null;
        }

        public final void setTruck(RouteTruckOptions.BuilderImpl truck) {
            this.truck = truck != null ? truck.build() : null;
        }

        @Override
        public final Builder truck(RouteTruckOptions truck) {
            this.truck = truck;
            return this;
        }

        @Override
        public RouteTravelModeOptions build() {
            return new RouteTravelModeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
