/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarized details of the route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteVehicleTravelOnlySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteVehicleTravelOnlySummary.Builder, RouteVehicleTravelOnlySummary> {
    private static final SdkField<Long> BEST_CASE_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BestCaseDuration").getter(getter(RouteVehicleTravelOnlySummary::bestCaseDuration))
            .setter(setter(Builder::bestCaseDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestCaseDuration").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(RouteVehicleTravelOnlySummary::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Long> TYPICAL_DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TypicalDuration").getter(getter(RouteVehicleTravelOnlySummary::typicalDuration))
            .setter(setter(Builder::typicalDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypicalDuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEST_CASE_DURATION_FIELD,
            DURATION_FIELD, TYPICAL_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long bestCaseDuration;

    private final Long duration;

    private final Long typicalDuration;

    private RouteVehicleTravelOnlySummary(BuilderImpl builder) {
        this.bestCaseDuration = builder.bestCaseDuration;
        this.duration = builder.duration;
        this.typicalDuration = builder.typicalDuration;
    }

    /**
     * <p>
     * Total duration in free flowing traffic, which is the best case or shortest duration possible to cover the leg.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Total duration in free flowing traffic, which is the best case or shortest duration possible to cover the
     *         leg.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long bestCaseDuration() {
        return bestCaseDuration;
    }

    /**
     * <p>
     * Duration of the step.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of the step.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * Duration of the computed span under typical traffic congestion.
     * </p>
     * <p>
     * <b>Unit</b>: <code>seconds</code>
     * </p>
     * 
     * @return Duration of the computed span under typical traffic congestion.</p>
     *         <p>
     *         <b>Unit</b>: <code>seconds</code>
     */
    public final Long typicalDuration() {
        return typicalDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bestCaseDuration());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(typicalDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteVehicleTravelOnlySummary)) {
            return false;
        }
        RouteVehicleTravelOnlySummary other = (RouteVehicleTravelOnlySummary) obj;
        return Objects.equals(bestCaseDuration(), other.bestCaseDuration()) && Objects.equals(duration(), other.duration())
                && Objects.equals(typicalDuration(), other.typicalDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteVehicleTravelOnlySummary")
                .add("BestCaseDuration", bestCaseDuration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Duration", duration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TypicalDuration", typicalDuration() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BestCaseDuration":
            return Optional.ofNullable(clazz.cast(bestCaseDuration()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "TypicalDuration":
            return Optional.ofNullable(clazz.cast(typicalDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BestCaseDuration", BEST_CASE_DURATION_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("TypicalDuration", TYPICAL_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteVehicleTravelOnlySummary, T> g) {
        return obj -> g.apply((RouteVehicleTravelOnlySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteVehicleTravelOnlySummary> {
        /**
         * <p>
         * Total duration in free flowing traffic, which is the best case or shortest duration possible to cover the
         * leg.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param bestCaseDuration
         *        Total duration in free flowing traffic, which is the best case or shortest duration possible to cover
         *        the leg.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestCaseDuration(Long bestCaseDuration);

        /**
         * <p>
         * Duration of the step.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param duration
         *        Duration of the step.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * Duration of the computed span under typical traffic congestion.
         * </p>
         * <p>
         * <b>Unit</b>: <code>seconds</code>
         * </p>
         * 
         * @param typicalDuration
         *        Duration of the computed span under typical traffic congestion.</p>
         *        <p>
         *        <b>Unit</b>: <code>seconds</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typicalDuration(Long typicalDuration);
    }

    static final class BuilderImpl implements Builder {
        private Long bestCaseDuration;

        private Long duration;

        private Long typicalDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteVehicleTravelOnlySummary model) {
            bestCaseDuration(model.bestCaseDuration);
            duration(model.duration);
            typicalDuration(model.typicalDuration);
        }

        public final Long getBestCaseDuration() {
            return bestCaseDuration;
        }

        public final void setBestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
        }

        @Override
        public final Builder bestCaseDuration(Long bestCaseDuration) {
            this.bestCaseDuration = bestCaseDuration;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final Long getTypicalDuration() {
            return typicalDuration;
        }

        public final void setTypicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
        }

        @Override
        public final Builder typicalDuration(Long typicalDuration) {
            this.typicalDuration = typicalDuration;
            return this;
        }

        @Override
        public RouteVehicleTravelOnlySummary build() {
            return new RouteVehicleTravelOnlySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
